/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A run group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RunGroupListItem implements SdkPojo, Serializable,
        ToCopyableBuilder<RunGroupListItem.Builder, RunGroupListItem> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(RunGroupListItem::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(RunGroupListItem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(RunGroupListItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Integer> MAX_CPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxCpus").getter(getter(RunGroupListItem::maxCpus)).setter(setter(Builder::maxCpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCpus").build()).build();

    private static final SdkField<Integer> MAX_RUNS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxRuns").getter(getter(RunGroupListItem::maxRuns)).setter(setter(Builder::maxRuns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRuns").build()).build();

    private static final SdkField<Integer> MAX_DURATION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxDuration").getter(getter(RunGroupListItem::maxDuration)).setter(setter(Builder::maxDuration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxDuration").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(RunGroupListItem::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Integer> MAX_GPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxGpus").getter(getter(RunGroupListItem::maxGpus)).setter(setter(Builder::maxGpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxGpus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            NAME_FIELD, MAX_CPUS_FIELD, MAX_RUNS_FIELD, MAX_DURATION_FIELD, CREATION_TIME_FIELD, MAX_GPUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String id;

    private final String name;

    private final Integer maxCpus;

    private final Integer maxRuns;

    private final Integer maxDuration;

    private final Instant creationTime;

    private final Integer maxGpus;

    private RunGroupListItem(BuilderImpl builder) {
        this.arn = builder.arn;
        this.id = builder.id;
        this.name = builder.name;
        this.maxCpus = builder.maxCpus;
        this.maxRuns = builder.maxRuns;
        this.maxDuration = builder.maxDuration;
        this.creationTime = builder.creationTime;
        this.maxGpus = builder.maxGpus;
    }

    /**
     * <p>
     * The group's ARN.
     * </p>
     * 
     * @return The group's ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The group's ID.
     * </p>
     * 
     * @return The group's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The group's name.
     * </p>
     * 
     * @return The group's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The group's maximum CPU count setting.
     * </p>
     * 
     * @return The group's maximum CPU count setting.
     */
    public final Integer maxCpus() {
        return maxCpus;
    }

    /**
     * <p>
     * The group's maximum concurrent run setting.
     * </p>
     * 
     * @return The group's maximum concurrent run setting.
     */
    public final Integer maxRuns() {
        return maxRuns;
    }

    /**
     * <p>
     * The group's maximum duration setting in minutes.
     * </p>
     * 
     * @return The group's maximum duration setting in minutes.
     */
    public final Integer maxDuration() {
        return maxDuration;
    }

    /**
     * <p>
     * When the group was created.
     * </p>
     * 
     * @return When the group was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The maximum GPUs that can be used by a run group.
     * </p>
     * 
     * @return The maximum GPUs that can be used by a run group.
     */
    public final Integer maxGpus() {
        return maxGpus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(maxCpus());
        hashCode = 31 * hashCode + Objects.hashCode(maxRuns());
        hashCode = 31 * hashCode + Objects.hashCode(maxDuration());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(maxGpus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunGroupListItem)) {
            return false;
        }
        RunGroupListItem other = (RunGroupListItem) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(maxCpus(), other.maxCpus()) && Objects.equals(maxRuns(), other.maxRuns())
                && Objects.equals(maxDuration(), other.maxDuration()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(maxGpus(), other.maxGpus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RunGroupListItem").add("Arn", arn()).add("Id", id()).add("Name", name())
                .add("MaxCpus", maxCpus()).add("MaxRuns", maxRuns()).add("MaxDuration", maxDuration())
                .add("CreationTime", creationTime()).add("MaxGpus", maxGpus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "maxCpus":
            return Optional.ofNullable(clazz.cast(maxCpus()));
        case "maxRuns":
            return Optional.ofNullable(clazz.cast(maxRuns()));
        case "maxDuration":
            return Optional.ofNullable(clazz.cast(maxDuration()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "maxGpus":
            return Optional.ofNullable(clazz.cast(maxGpus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("maxCpus", MAX_CPUS_FIELD);
        map.put("maxRuns", MAX_RUNS_FIELD);
        map.put("maxDuration", MAX_DURATION_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("maxGpus", MAX_GPUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RunGroupListItem, T> g) {
        return obj -> g.apply((RunGroupListItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RunGroupListItem> {
        /**
         * <p>
         * The group's ARN.
         * </p>
         * 
         * @param arn
         *        The group's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The group's ID.
         * </p>
         * 
         * @param id
         *        The group's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The group's name.
         * </p>
         * 
         * @param name
         *        The group's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The group's maximum CPU count setting.
         * </p>
         * 
         * @param maxCpus
         *        The group's maximum CPU count setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCpus(Integer maxCpus);

        /**
         * <p>
         * The group's maximum concurrent run setting.
         * </p>
         * 
         * @param maxRuns
         *        The group's maximum concurrent run setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRuns(Integer maxRuns);

        /**
         * <p>
         * The group's maximum duration setting in minutes.
         * </p>
         * 
         * @param maxDuration
         *        The group's maximum duration setting in minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxDuration(Integer maxDuration);

        /**
         * <p>
         * When the group was created.
         * </p>
         * 
         * @param creationTime
         *        When the group was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The maximum GPUs that can be used by a run group.
         * </p>
         * 
         * @param maxGpus
         *        The maximum GPUs that can be used by a run group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxGpus(Integer maxGpus);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String name;

        private Integer maxCpus;

        private Integer maxRuns;

        private Integer maxDuration;

        private Instant creationTime;

        private Integer maxGpus;

        private BuilderImpl() {
        }

        private BuilderImpl(RunGroupListItem model) {
            arn(model.arn);
            id(model.id);
            name(model.name);
            maxCpus(model.maxCpus);
            maxRuns(model.maxRuns);
            maxDuration(model.maxDuration);
            creationTime(model.creationTime);
            maxGpus(model.maxGpus);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getMaxCpus() {
            return maxCpus;
        }

        public final void setMaxCpus(Integer maxCpus) {
            this.maxCpus = maxCpus;
        }

        @Override
        public final Builder maxCpus(Integer maxCpus) {
            this.maxCpus = maxCpus;
            return this;
        }

        public final Integer getMaxRuns() {
            return maxRuns;
        }

        public final void setMaxRuns(Integer maxRuns) {
            this.maxRuns = maxRuns;
        }

        @Override
        public final Builder maxRuns(Integer maxRuns) {
            this.maxRuns = maxRuns;
            return this;
        }

        public final Integer getMaxDuration() {
            return maxDuration;
        }

        public final void setMaxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
        }

        @Override
        public final Builder maxDuration(Integer maxDuration) {
            this.maxDuration = maxDuration;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Integer getMaxGpus() {
            return maxGpus;
        }

        public final void setMaxGpus(Integer maxGpus) {
            this.maxGpus = maxGpus;
        }

        @Override
        public final Builder maxGpus(Integer maxGpus) {
            this.maxGpus = maxGpus;
            return this;
        }

        @Override
        public RunGroupListItem build() {
            return new RunGroupListItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
