/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * S3 access configuration parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3AccessConfig implements SdkPojo, Serializable, ToCopyableBuilder<S3AccessConfig.Builder, S3AccessConfig> {
    private static final SdkField<String> ACCESS_LOG_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accessLogLocation").getter(getter(S3AccessConfig::accessLogLocation))
            .setter(setter(Builder::accessLogLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessLogLocation").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_LOG_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String accessLogLocation;

    private S3AccessConfig(BuilderImpl builder) {
        this.accessLogLocation = builder.accessLogLocation;
    }

    /**
     * <p>
     * Location of the access logs.
     * </p>
     * 
     * @return Location of the access logs.
     */
    public final String accessLogLocation() {
        return accessLogLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accessLogLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3AccessConfig)) {
            return false;
        }
        S3AccessConfig other = (S3AccessConfig) obj;
        return Objects.equals(accessLogLocation(), other.accessLogLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3AccessConfig").add("AccessLogLocation", accessLogLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accessLogLocation":
            return Optional.ofNullable(clazz.cast(accessLogLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accessLogLocation", ACCESS_LOG_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<S3AccessConfig, T> g) {
        return obj -> g.apply((S3AccessConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3AccessConfig> {
        /**
         * <p>
         * Location of the access logs.
         * </p>
         * 
         * @param accessLogLocation
         *        Location of the access logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessLogLocation(String accessLogLocation);
    }

    static final class BuilderImpl implements Builder {
        private String accessLogLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(S3AccessConfig model) {
            accessLogLocation(model.accessLogLocation);
        }

        public final String getAccessLogLocation() {
            return accessLogLocation;
        }

        public final void setAccessLogLocation(String accessLogLocation) {
            this.accessLogLocation = accessLogLocation;
        }

        @Override
        public final Builder accessLogLocation(String accessLogLocation) {
            this.accessLogLocation = accessLogLocation;
            return this;
        }

        @Override
        public S3AccessConfig build() {
            return new S3AccessConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
