/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about a sequence.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SequenceInformation implements SdkPojo, Serializable,
        ToCopyableBuilder<SequenceInformation.Builder, SequenceInformation> {
    private static final SdkField<Long> TOTAL_READ_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalReadCount").getter(getter(SequenceInformation::totalReadCount))
            .setter(setter(Builder::totalReadCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalReadCount").build()).build();

    private static final SdkField<Long> TOTAL_BASE_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("totalBaseCount").getter(getter(SequenceInformation::totalBaseCount))
            .setter(setter(Builder::totalBaseCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalBaseCount").build()).build();

    private static final SdkField<String> GENERATED_FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("generatedFrom").getter(getter(SequenceInformation::generatedFrom))
            .setter(setter(Builder::generatedFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generatedFrom").build()).build();

    private static final SdkField<String> ALIGNMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("alignment").getter(getter(SequenceInformation::alignment)).setter(setter(Builder::alignment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alignment").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOTAL_READ_COUNT_FIELD,
            TOTAL_BASE_COUNT_FIELD, GENERATED_FROM_FIELD, ALIGNMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long totalReadCount;

    private final Long totalBaseCount;

    private final String generatedFrom;

    private final String alignment;

    private SequenceInformation(BuilderImpl builder) {
        this.totalReadCount = builder.totalReadCount;
        this.totalBaseCount = builder.totalBaseCount;
        this.generatedFrom = builder.generatedFrom;
        this.alignment = builder.alignment;
    }

    /**
     * <p>
     * The sequence's total read count.
     * </p>
     * 
     * @return The sequence's total read count.
     */
    public final Long totalReadCount() {
        return totalReadCount;
    }

    /**
     * <p>
     * The sequence's total base count.
     * </p>
     * 
     * @return The sequence's total base count.
     */
    public final Long totalBaseCount() {
        return totalBaseCount;
    }

    /**
     * <p>
     * Where the sequence originated.
     * </p>
     * 
     * @return Where the sequence originated.
     */
    public final String generatedFrom() {
        return generatedFrom;
    }

    /**
     * <p>
     * The sequence's alignment setting.
     * </p>
     * 
     * @return The sequence's alignment setting.
     */
    public final String alignment() {
        return alignment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(totalReadCount());
        hashCode = 31 * hashCode + Objects.hashCode(totalBaseCount());
        hashCode = 31 * hashCode + Objects.hashCode(generatedFrom());
        hashCode = 31 * hashCode + Objects.hashCode(alignment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SequenceInformation)) {
            return false;
        }
        SequenceInformation other = (SequenceInformation) obj;
        return Objects.equals(totalReadCount(), other.totalReadCount())
                && Objects.equals(totalBaseCount(), other.totalBaseCount())
                && Objects.equals(generatedFrom(), other.generatedFrom()) && Objects.equals(alignment(), other.alignment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SequenceInformation").add("TotalReadCount", totalReadCount())
                .add("TotalBaseCount", totalBaseCount()).add("GeneratedFrom", generatedFrom()).add("Alignment", alignment())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "totalReadCount":
            return Optional.ofNullable(clazz.cast(totalReadCount()));
        case "totalBaseCount":
            return Optional.ofNullable(clazz.cast(totalBaseCount()));
        case "generatedFrom":
            return Optional.ofNullable(clazz.cast(generatedFrom()));
        case "alignment":
            return Optional.ofNullable(clazz.cast(alignment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("totalReadCount", TOTAL_READ_COUNT_FIELD);
        map.put("totalBaseCount", TOTAL_BASE_COUNT_FIELD);
        map.put("generatedFrom", GENERATED_FROM_FIELD);
        map.put("alignment", ALIGNMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SequenceInformation, T> g) {
        return obj -> g.apply((SequenceInformation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SequenceInformation> {
        /**
         * <p>
         * The sequence's total read count.
         * </p>
         * 
         * @param totalReadCount
         *        The sequence's total read count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalReadCount(Long totalReadCount);

        /**
         * <p>
         * The sequence's total base count.
         * </p>
         * 
         * @param totalBaseCount
         *        The sequence's total base count.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalBaseCount(Long totalBaseCount);

        /**
         * <p>
         * Where the sequence originated.
         * </p>
         * 
         * @param generatedFrom
         *        Where the sequence originated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder generatedFrom(String generatedFrom);

        /**
         * <p>
         * The sequence's alignment setting.
         * </p>
         * 
         * @param alignment
         *        The sequence's alignment setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder alignment(String alignment);
    }

    static final class BuilderImpl implements Builder {
        private Long totalReadCount;

        private Long totalBaseCount;

        private String generatedFrom;

        private String alignment;

        private BuilderImpl() {
        }

        private BuilderImpl(SequenceInformation model) {
            totalReadCount(model.totalReadCount);
            totalBaseCount(model.totalBaseCount);
            generatedFrom(model.generatedFrom);
            alignment(model.alignment);
        }

        public final Long getTotalReadCount() {
            return totalReadCount;
        }

        public final void setTotalReadCount(Long totalReadCount) {
            this.totalReadCount = totalReadCount;
        }

        @Override
        public final Builder totalReadCount(Long totalReadCount) {
            this.totalReadCount = totalReadCount;
            return this;
        }

        public final Long getTotalBaseCount() {
            return totalBaseCount;
        }

        public final void setTotalBaseCount(Long totalBaseCount) {
            this.totalBaseCount = totalBaseCount;
        }

        @Override
        public final Builder totalBaseCount(Long totalBaseCount) {
            this.totalBaseCount = totalBaseCount;
            return this;
        }

        public final String getGeneratedFrom() {
            return generatedFrom;
        }

        public final void setGeneratedFrom(String generatedFrom) {
            this.generatedFrom = generatedFrom;
        }

        @Override
        public final Builder generatedFrom(String generatedFrom) {
            this.generatedFrom = generatedFrom;
            return this;
        }

        public final String getAlignment() {
            return alignment;
        }

        public final void setAlignment(String alignment) {
            this.alignment = alignment;
        }

        @Override
        public final Builder alignment(String alignment) {
            this.alignment = alignment;
            return this;
        }

        @Override
        public SequenceInformation build() {
            return new SequenceInformation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
