/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Source files for a sequence.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceFiles implements SdkPojo, Serializable, ToCopyableBuilder<SourceFiles.Builder, SourceFiles> {
    private static final SdkField<String> SOURCE1_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source1")
            .getter(getter(SourceFiles::source1)).setter(setter(Builder::source1))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source1").build()).build();

    private static final SdkField<String> SOURCE2_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("source2")
            .getter(getter(SourceFiles::source2)).setter(setter(Builder::source2))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("source2").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE1_FIELD, SOURCE2_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String source1;

    private final String source2;

    private SourceFiles(BuilderImpl builder) {
        this.source1 = builder.source1;
        this.source2 = builder.source2;
    }

    /**
     * <p>
     * The location of the first file in Amazon S3.
     * </p>
     * 
     * @return The location of the first file in Amazon S3.
     */
    public final String source1() {
        return source1;
    }

    /**
     * <p>
     * The location of the second file in Amazon S3.
     * </p>
     * 
     * @return The location of the second file in Amazon S3.
     */
    public final String source2() {
        return source2;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(source1());
        hashCode = 31 * hashCode + Objects.hashCode(source2());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceFiles)) {
            return false;
        }
        SourceFiles other = (SourceFiles) obj;
        return Objects.equals(source1(), other.source1()) && Objects.equals(source2(), other.source2());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceFiles").add("Source1", source1()).add("Source2", source2()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "source1":
            return Optional.ofNullable(clazz.cast(source1()));
        case "source2":
            return Optional.ofNullable(clazz.cast(source2()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("source1", SOURCE1_FIELD);
        map.put("source2", SOURCE2_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceFiles, T> g) {
        return obj -> g.apply((SourceFiles) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceFiles> {
        /**
         * <p>
         * The location of the first file in Amazon S3.
         * </p>
         * 
         * @param source1
         *        The location of the first file in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source1(String source1);

        /**
         * <p>
         * The location of the second file in Amazon S3.
         * </p>
         * 
         * @param source2
         *        The location of the second file in Amazon S3.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder source2(String source2);
    }

    static final class BuilderImpl implements Builder {
        private String source1;

        private String source2;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceFiles model) {
            source1(model.source1);
            source2(model.source2);
        }

        public final String getSource1() {
            return source1;
        }

        public final void setSource1(String source1) {
            this.source1 = source1;
        }

        @Override
        public final Builder source1(String source1) {
            this.source1 = source1;
            return this;
        }

        public final String getSource2() {
            return source2;
        }

        public final void setSource2(String source2) {
            this.source2 = source2;
        }

        @Override
        public final Builder source2(String source2) {
            this.source2 = source2;
            return this;
        }

        @Override
        public SourceFiles build() {
            return new SourceFiles(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
