/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A source for a read set activation job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartReadSetActivationJobSourceItem implements SdkPojo, Serializable,
        ToCopyableBuilder<StartReadSetActivationJobSourceItem.Builder, StartReadSetActivationJobSourceItem> {
    private static final SdkField<String> READ_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("readSetId").getter(getter(StartReadSetActivationJobSourceItem::readSetId))
            .setter(setter(Builder::readSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readSetId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(READ_SET_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String readSetId;

    private StartReadSetActivationJobSourceItem(BuilderImpl builder) {
        this.readSetId = builder.readSetId;
    }

    /**
     * <p>
     * The source's read set ID.
     * </p>
     * 
     * @return The source's read set ID.
     */
    public final String readSetId() {
        return readSetId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(readSetId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartReadSetActivationJobSourceItem)) {
            return false;
        }
        StartReadSetActivationJobSourceItem other = (StartReadSetActivationJobSourceItem) obj;
        return Objects.equals(readSetId(), other.readSetId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartReadSetActivationJobSourceItem").add("ReadSetId", readSetId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "readSetId":
            return Optional.ofNullable(clazz.cast(readSetId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("readSetId", READ_SET_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartReadSetActivationJobSourceItem, T> g) {
        return obj -> g.apply((StartReadSetActivationJobSourceItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StartReadSetActivationJobSourceItem> {
        /**
         * <p>
         * The source's read set ID.
         * </p>
         * 
         * @param readSetId
         *        The source's read set ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readSetId(String readSetId);
    }

    static final class BuilderImpl implements Builder {
        private String readSetId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartReadSetActivationJobSourceItem model) {
            readSetId(model.readSetId);
        }

        public final String getReadSetId() {
            return readSetId;
        }

        public final void setReadSetId(String readSetId) {
            this.readSetId = readSetId;
        }

        @Override
        public final Builder readSetId(String readSetId) {
            this.readSetId = readSetId;
            return this;
        }

        @Override
        public StartReadSetActivationJobSourceItem build() {
            return new StartReadSetActivationJobSourceItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
