/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartRunRequest extends OmicsRequest implements ToCopyableBuilder<StartRunRequest.Builder, StartRunRequest> {
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowId").getter(getter(StartRunRequest::workflowId)).setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()).build();

    private static final SdkField<String> WORKFLOW_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowType").getter(getter(StartRunRequest::workflowTypeAsString))
            .setter(setter(Builder::workflowType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowType").build()).build();

    private static final SdkField<String> RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("runId")
            .getter(getter(StartRunRequest::runId)).setter(setter(Builder::runId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()).build();

    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("roleArn").getter(getter(StartRunRequest::roleArn)).setter(setter(Builder::roleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(StartRunRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CACHE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cacheId").getter(getter(StartRunRequest::cacheId)).setter(setter(Builder::cacheId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheId").build()).build();

    private static final SdkField<String> CACHE_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cacheBehavior").getter(getter(StartRunRequest::cacheBehaviorAsString))
            .setter(setter(Builder::cacheBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBehavior").build()).build();

    private static final SdkField<String> RUN_GROUP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runGroupId").getter(getter(StartRunRequest::runGroupId)).setter(setter(Builder::runGroupId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runGroupId").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("priority").getter(getter(StartRunRequest::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<Document> PARAMETERS_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("parameters").getter(getter(StartRunRequest::parameters)).setter(setter(Builder::parameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build()).build();

    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("storageCapacity").getter(getter(StartRunRequest::storageCapacity))
            .setter(setter(Builder::storageCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCapacity").build()).build();

    private static final SdkField<String> OUTPUT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputUri").getter(getter(StartRunRequest::outputUri)).setter(setter(Builder::outputUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputUri").build()).build();

    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("logLevel").getter(getter(StartRunRequest::logLevelAsString)).setter(setter(Builder::logLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logLevel").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(StartRunRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("requestId")
            .getter(getter(StartRunRequest::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> RETENTION_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("retentionMode").getter(getter(StartRunRequest::retentionModeAsString))
            .setter(setter(Builder::retentionMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retentionMode").build()).build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageType").getter(getter(StartRunRequest::storageTypeAsString)).setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()).build();

    private static final SdkField<String> WORKFLOW_OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowOwnerId").getter(getter(StartRunRequest::workflowOwnerId))
            .setter(setter(Builder::workflowOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowOwnerId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ID_FIELD,
            WORKFLOW_TYPE_FIELD, RUN_ID_FIELD, ROLE_ARN_FIELD, NAME_FIELD, CACHE_ID_FIELD, CACHE_BEHAVIOR_FIELD,
            RUN_GROUP_ID_FIELD, PRIORITY_FIELD, PARAMETERS_FIELD, STORAGE_CAPACITY_FIELD, OUTPUT_URI_FIELD, LOG_LEVEL_FIELD,
            TAGS_FIELD, REQUEST_ID_FIELD, RETENTION_MODE_FIELD, STORAGE_TYPE_FIELD, WORKFLOW_OWNER_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workflowId;

    private final String workflowType;

    private final String runId;

    private final String roleArn;

    private final String name;

    private final String cacheId;

    private final String cacheBehavior;

    private final String runGroupId;

    private final Integer priority;

    private final Document parameters;

    private final Integer storageCapacity;

    private final String outputUri;

    private final String logLevel;

    private final Map<String, String> tags;

    private final String requestIdValue;

    private final String retentionMode;

    private final String storageType;

    private final String workflowOwnerId;

    private StartRunRequest(BuilderImpl builder) {
        super(builder);
        this.workflowId = builder.workflowId;
        this.workflowType = builder.workflowType;
        this.runId = builder.runId;
        this.roleArn = builder.roleArn;
        this.name = builder.name;
        this.cacheId = builder.cacheId;
        this.cacheBehavior = builder.cacheBehavior;
        this.runGroupId = builder.runGroupId;
        this.priority = builder.priority;
        this.parameters = builder.parameters;
        this.storageCapacity = builder.storageCapacity;
        this.outputUri = builder.outputUri;
        this.logLevel = builder.logLevel;
        this.tags = builder.tags;
        this.requestIdValue = builder.requestIdValue;
        this.retentionMode = builder.retentionMode;
        this.storageType = builder.storageType;
        this.workflowOwnerId = builder.workflowOwnerId;
    }

    /**
     * <p>
     * The run's workflow ID.
     * </p>
     * 
     * @return The run's workflow ID.
     */
    public final String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * The run's workflow type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowType} will
     * return {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workflowTypeAsString}.
     * </p>
     * 
     * @return The run's workflow type.
     * @see WorkflowType
     */
    public final WorkflowType workflowType() {
        return WorkflowType.fromValue(workflowType);
    }

    /**
     * <p>
     * The run's workflow type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #workflowType} will
     * return {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #workflowTypeAsString}.
     * </p>
     * 
     * @return The run's workflow type.
     * @see WorkflowType
     */
    public final String workflowTypeAsString() {
        return workflowType;
    }

    /**
     * <p>
     * The ID of a run to duplicate.
     * </p>
     * 
     * @return The ID of a run to duplicate.
     */
    public final String runId() {
        return runId;
    }

    /**
     * <p>
     * A service role for the run.
     * </p>
     * 
     * @return A service role for the run.
     */
    public final String roleArn() {
        return roleArn;
    }

    /**
     * <p>
     * A name for the run.
     * </p>
     * 
     * @return A name for the run.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Identifier of the cache associated with this run. If you don't specify a cache ID, no task outputs are cached for
     * this run.
     * </p>
     * 
     * @return Identifier of the cache associated with this run. If you don't specify a cache ID, no task outputs are
     *         cached for this run.
     */
    public final String cacheId() {
        return cacheId;
    }

    /**
     * <p>
     * The cache behavior for the run. You specify this value if you want to override the default behavior for the
     * cache. You had set the default value when you created the cache. For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/how-run-cache.html#run-cache-behavior">Run cache behavior</a>
     * in the AWS HealthOmics User Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cacheBehavior}
     * will return {@link CacheBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cacheBehaviorAsString}.
     * </p>
     * 
     * @return The cache behavior for the run. You specify this value if you want to override the default behavior for
     *         the cache. You had set the default value when you created the cache. For more information, see <a
     *         href="https://docs.aws.amazon.com/omics/latest/dev/how-run-cache.html#run-cache-behavior">Run cache
     *         behavior</a> in the AWS HealthOmics User Guide.
     * @see CacheBehavior
     */
    public final CacheBehavior cacheBehavior() {
        return CacheBehavior.fromValue(cacheBehavior);
    }

    /**
     * <p>
     * The cache behavior for the run. You specify this value if you want to override the default behavior for the
     * cache. You had set the default value when you created the cache. For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/how-run-cache.html#run-cache-behavior">Run cache behavior</a>
     * in the AWS HealthOmics User Guide.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cacheBehavior}
     * will return {@link CacheBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cacheBehaviorAsString}.
     * </p>
     * 
     * @return The cache behavior for the run. You specify this value if you want to override the default behavior for
     *         the cache. You had set the default value when you created the cache. For more information, see <a
     *         href="https://docs.aws.amazon.com/omics/latest/dev/how-run-cache.html#run-cache-behavior">Run cache
     *         behavior</a> in the AWS HealthOmics User Guide.
     * @see CacheBehavior
     */
    public final String cacheBehaviorAsString() {
        return cacheBehavior;
    }

    /**
     * <p>
     * The run's group ID.
     * </p>
     * 
     * @return The run's group ID.
     */
    public final String runGroupId() {
        return runGroupId;
    }

    /**
     * <p>
     * A priority for the run.
     * </p>
     * 
     * @return A priority for the run.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * Parameters for the run.
     * </p>
     * 
     * @return Parameters for the run.
     */
    public final Document parameters() {
        return parameters;
    }

    /**
     * <p>
     * A storage capacity for the run in gibibytes. This field is not required if the storage type is dynamic (the
     * system ignores any value that you enter).
     * </p>
     * 
     * @return A storage capacity for the run in gibibytes. This field is not required if the storage type is dynamic
     *         (the system ignores any value that you enter).
     */
    public final Integer storageCapacity() {
        return storageCapacity;
    }

    /**
     * <p>
     * An output URI for the run.
     * </p>
     * 
     * @return An output URI for the run.
     */
    public final String outputUri() {
        return outputUri;
    }

    /**
     * <p>
     * A log level for the run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link RunLogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return A log level for the run.
     * @see RunLogLevel
     */
    public final RunLogLevel logLevel() {
        return RunLogLevel.fromValue(logLevel);
    }

    /**
     * <p>
     * A log level for the run.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #logLevel} will
     * return {@link RunLogLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #logLevelAsString}.
     * </p>
     * 
     * @return A log level for the run.
     * @see RunLogLevel
     */
    public final String logLevelAsString() {
        return logLevel;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags for the run.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags for the run.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * To ensure that requests don't run multiple times, specify a unique ID for each request.
     * </p>
     * 
     * @return To ensure that requests don't run multiple times, specify a unique ID for each request.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * <p>
     * The retention mode for the run. The default value is RETAIN.
     * </p>
     * <p>
     * HealthOmics stores a fixed number of runs that are available to the console and API. In the default mode
     * (RETAIN), you need to remove runs manually when the number of run exceeds the maximum. If you set the retention
     * mode to <code>REMOVE</code>, HealthOmics automatically removes runs (that have mode set to REMOVE) when the
     * number of run exceeds the maximum. All run logs are available in CloudWatch logs, if you need information about a
     * run that is no longer available to the API.
     * </p>
     * <p>
     * For more information about retention mode, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/starting-a-run.html">Specifying run retention mode</a> in the
     * <i>AWS HealthOmics User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retentionMode}
     * will return {@link RunRetentionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #retentionModeAsString}.
     * </p>
     * 
     * @return The retention mode for the run. The default value is RETAIN. </p>
     *         <p>
     *         HealthOmics stores a fixed number of runs that are available to the console and API. In the default mode
     *         (RETAIN), you need to remove runs manually when the number of run exceeds the maximum. If you set the
     *         retention mode to <code>REMOVE</code>, HealthOmics automatically removes runs (that have mode set to
     *         REMOVE) when the number of run exceeds the maximum. All run logs are available in CloudWatch logs, if you
     *         need information about a run that is no longer available to the API.
     *         </p>
     *         <p>
     *         For more information about retention mode, see <a
     *         href="https://docs.aws.amazon.com/omics/latest/dev/starting-a-run.html">Specifying run retention mode</a>
     *         in the <i>AWS HealthOmics User Guide</i>.
     * @see RunRetentionMode
     */
    public final RunRetentionMode retentionMode() {
        return RunRetentionMode.fromValue(retentionMode);
    }

    /**
     * <p>
     * The retention mode for the run. The default value is RETAIN.
     * </p>
     * <p>
     * HealthOmics stores a fixed number of runs that are available to the console and API. In the default mode
     * (RETAIN), you need to remove runs manually when the number of run exceeds the maximum. If you set the retention
     * mode to <code>REMOVE</code>, HealthOmics automatically removes runs (that have mode set to REMOVE) when the
     * number of run exceeds the maximum. All run logs are available in CloudWatch logs, if you need information about a
     * run that is no longer available to the API.
     * </p>
     * <p>
     * For more information about retention mode, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/starting-a-run.html">Specifying run retention mode</a> in the
     * <i>AWS HealthOmics User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #retentionMode}
     * will return {@link RunRetentionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #retentionModeAsString}.
     * </p>
     * 
     * @return The retention mode for the run. The default value is RETAIN. </p>
     *         <p>
     *         HealthOmics stores a fixed number of runs that are available to the console and API. In the default mode
     *         (RETAIN), you need to remove runs manually when the number of run exceeds the maximum. If you set the
     *         retention mode to <code>REMOVE</code>, HealthOmics automatically removes runs (that have mode set to
     *         REMOVE) when the number of run exceeds the maximum. All run logs are available in CloudWatch logs, if you
     *         need information about a run that is no longer available to the API.
     *         </p>
     *         <p>
     *         For more information about retention mode, see <a
     *         href="https://docs.aws.amazon.com/omics/latest/dev/starting-a-run.html">Specifying run retention mode</a>
     *         in the <i>AWS HealthOmics User Guide</i>.
     * @see RunRetentionMode
     */
    public final String retentionModeAsString() {
        return retentionMode;
    }

    /**
     * <p>
     * The run's storage type. By default, the run uses STATIC storage type, which allocates a fixed amount of storage.
     * If you set the storage type to DYNAMIC, HealthOmics dynamically scales the storage up or down, based on file
     * system utilization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The run's storage type. By default, the run uses STATIC storage type, which allocates a fixed amount of
     *         storage. If you set the storage type to DYNAMIC, HealthOmics dynamically scales the storage up or down,
     *         based on file system utilization.
     * @see StorageType
     */
    public final StorageType storageType() {
        return StorageType.fromValue(storageType);
    }

    /**
     * <p>
     * The run's storage type. By default, the run uses STATIC storage type, which allocates a fixed amount of storage.
     * If you set the storage type to DYNAMIC, HealthOmics dynamically scales the storage up or down, based on file
     * system utilization.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The run's storage type. By default, the run uses STATIC storage type, which allocates a fixed amount of
     *         storage. If you set the storage type to DYNAMIC, HealthOmics dynamically scales the storage up or down,
     *         based on file system utilization.
     * @see StorageType
     */
    public final String storageTypeAsString() {
        return storageType;
    }

    /**
     * <p>
     * The ID of the workflow owner.
     * </p>
     * 
     * @return The ID of the workflow owner.
     */
    public final String workflowOwnerId() {
        return workflowOwnerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(workflowTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(runId());
        hashCode = 31 * hashCode + Objects.hashCode(roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(cacheId());
        hashCode = 31 * hashCode + Objects.hashCode(cacheBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(runGroupId());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(outputUri());
        hashCode = 31 * hashCode + Objects.hashCode(logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(retentionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workflowOwnerId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartRunRequest)) {
            return false;
        }
        StartRunRequest other = (StartRunRequest) obj;
        return Objects.equals(workflowId(), other.workflowId())
                && Objects.equals(workflowTypeAsString(), other.workflowTypeAsString()) && Objects.equals(runId(), other.runId())
                && Objects.equals(roleArn(), other.roleArn()) && Objects.equals(name(), other.name())
                && Objects.equals(cacheId(), other.cacheId())
                && Objects.equals(cacheBehaviorAsString(), other.cacheBehaviorAsString())
                && Objects.equals(runGroupId(), other.runGroupId()) && Objects.equals(priority(), other.priority())
                && Objects.equals(parameters(), other.parameters()) && Objects.equals(storageCapacity(), other.storageCapacity())
                && Objects.equals(outputUri(), other.outputUri()) && Objects.equals(logLevelAsString(), other.logLevelAsString())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(requestId(), other.requestId())
                && Objects.equals(retentionModeAsString(), other.retentionModeAsString())
                && Objects.equals(storageTypeAsString(), other.storageTypeAsString())
                && Objects.equals(workflowOwnerId(), other.workflowOwnerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartRunRequest").add("WorkflowId", workflowId()).add("WorkflowType", workflowTypeAsString())
                .add("RunId", runId()).add("RoleArn", roleArn()).add("Name", name()).add("CacheId", cacheId())
                .add("CacheBehavior", cacheBehaviorAsString()).add("RunGroupId", runGroupId()).add("Priority", priority())
                .add("Parameters", parameters()).add("StorageCapacity", storageCapacity()).add("OutputUri", outputUri())
                .add("LogLevel", logLevelAsString()).add("Tags", hasTags() ? tags() : null).add("RequestId", requestId())
                .add("RetentionMode", retentionModeAsString()).add("StorageType", storageTypeAsString())
                .add("WorkflowOwnerId", workflowOwnerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        case "workflowType":
            return Optional.ofNullable(clazz.cast(workflowTypeAsString()));
        case "runId":
            return Optional.ofNullable(clazz.cast(runId()));
        case "roleArn":
            return Optional.ofNullable(clazz.cast(roleArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "cacheId":
            return Optional.ofNullable(clazz.cast(cacheId()));
        case "cacheBehavior":
            return Optional.ofNullable(clazz.cast(cacheBehaviorAsString()));
        case "runGroupId":
            return Optional.ofNullable(clazz.cast(runGroupId()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "storageCapacity":
            return Optional.ofNullable(clazz.cast(storageCapacity()));
        case "outputUri":
            return Optional.ofNullable(clazz.cast(outputUri()));
        case "logLevel":
            return Optional.ofNullable(clazz.cast(logLevelAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "retentionMode":
            return Optional.ofNullable(clazz.cast(retentionModeAsString()));
        case "storageType":
            return Optional.ofNullable(clazz.cast(storageTypeAsString()));
        case "workflowOwnerId":
            return Optional.ofNullable(clazz.cast(workflowOwnerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workflowId", WORKFLOW_ID_FIELD);
        map.put("workflowType", WORKFLOW_TYPE_FIELD);
        map.put("runId", RUN_ID_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("cacheId", CACHE_ID_FIELD);
        map.put("cacheBehavior", CACHE_BEHAVIOR_FIELD);
        map.put("runGroupId", RUN_GROUP_ID_FIELD);
        map.put("priority", PRIORITY_FIELD);
        map.put("parameters", PARAMETERS_FIELD);
        map.put("storageCapacity", STORAGE_CAPACITY_FIELD);
        map.put("outputUri", OUTPUT_URI_FIELD);
        map.put("logLevel", LOG_LEVEL_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("retentionMode", RETENTION_MODE_FIELD);
        map.put("storageType", STORAGE_TYPE_FIELD);
        map.put("workflowOwnerId", WORKFLOW_OWNER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartRunRequest, T> g) {
        return obj -> g.apply((StartRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartRunRequest> {
        /**
         * <p>
         * The run's workflow ID.
         * </p>
         * 
         * @param workflowId
         *        The run's workflow ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * The run's workflow type.
         * </p>
         * 
         * @param workflowType
         *        The run's workflow type.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder workflowType(String workflowType);

        /**
         * <p>
         * The run's workflow type.
         * </p>
         * 
         * @param workflowType
         *        The run's workflow type.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder workflowType(WorkflowType workflowType);

        /**
         * <p>
         * The ID of a run to duplicate.
         * </p>
         * 
         * @param runId
         *        The ID of a run to duplicate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runId(String runId);

        /**
         * <p>
         * A service role for the run.
         * </p>
         * 
         * @param roleArn
         *        A service role for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder roleArn(String roleArn);

        /**
         * <p>
         * A name for the run.
         * </p>
         * 
         * @param name
         *        A name for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Identifier of the cache associated with this run. If you don't specify a cache ID, no task outputs are cached
         * for this run.
         * </p>
         * 
         * @param cacheId
         *        Identifier of the cache associated with this run. If you don't specify a cache ID, no task outputs are
         *        cached for this run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheId(String cacheId);

        /**
         * <p>
         * The cache behavior for the run. You specify this value if you want to override the default behavior for the
         * cache. You had set the default value when you created the cache. For more information, see <a
         * href="https://docs.aws.amazon.com/omics/latest/dev/how-run-cache.html#run-cache-behavior">Run cache
         * behavior</a> in the AWS HealthOmics User Guide.
         * </p>
         * 
         * @param cacheBehavior
         *        The cache behavior for the run. You specify this value if you want to override the default behavior
         *        for the cache. You had set the default value when you created the cache. For more information, see <a
         *        href="https://docs.aws.amazon.com/omics/latest/dev/how-run-cache.html#run-cache-behavior">Run cache
         *        behavior</a> in the AWS HealthOmics User Guide.
         * @see CacheBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CacheBehavior
         */
        Builder cacheBehavior(String cacheBehavior);

        /**
         * <p>
         * The cache behavior for the run. You specify this value if you want to override the default behavior for the
         * cache. You had set the default value when you created the cache. For more information, see <a
         * href="https://docs.aws.amazon.com/omics/latest/dev/how-run-cache.html#run-cache-behavior">Run cache
         * behavior</a> in the AWS HealthOmics User Guide.
         * </p>
         * 
         * @param cacheBehavior
         *        The cache behavior for the run. You specify this value if you want to override the default behavior
         *        for the cache. You had set the default value when you created the cache. For more information, see <a
         *        href="https://docs.aws.amazon.com/omics/latest/dev/how-run-cache.html#run-cache-behavior">Run cache
         *        behavior</a> in the AWS HealthOmics User Guide.
         * @see CacheBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CacheBehavior
         */
        Builder cacheBehavior(CacheBehavior cacheBehavior);

        /**
         * <p>
         * The run's group ID.
         * </p>
         * 
         * @param runGroupId
         *        The run's group ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runGroupId(String runGroupId);

        /**
         * <p>
         * A priority for the run.
         * </p>
         * 
         * @param priority
         *        A priority for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * Parameters for the run.
         * </p>
         * 
         * @param parameters
         *        Parameters for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Document parameters);

        /**
         * <p>
         * A storage capacity for the run in gibibytes. This field is not required if the storage type is dynamic (the
         * system ignores any value that you enter).
         * </p>
         * 
         * @param storageCapacity
         *        A storage capacity for the run in gibibytes. This field is not required if the storage type is dynamic
         *        (the system ignores any value that you enter).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCapacity(Integer storageCapacity);

        /**
         * <p>
         * An output URI for the run.
         * </p>
         * 
         * @param outputUri
         *        An output URI for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputUri(String outputUri);

        /**
         * <p>
         * A log level for the run.
         * </p>
         * 
         * @param logLevel
         *        A log level for the run.
         * @see RunLogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunLogLevel
         */
        Builder logLevel(String logLevel);

        /**
         * <p>
         * A log level for the run.
         * </p>
         * 
         * @param logLevel
         *        A log level for the run.
         * @see RunLogLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunLogLevel
         */
        Builder logLevel(RunLogLevel logLevel);

        /**
         * <p>
         * Tags for the run.
         * </p>
         * 
         * @param tags
         *        Tags for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * To ensure that requests don't run multiple times, specify a unique ID for each request.
         * </p>
         * 
         * @param requestIdValue
         *        To ensure that requests don't run multiple times, specify a unique ID for each request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * The retention mode for the run. The default value is RETAIN.
         * </p>
         * <p>
         * HealthOmics stores a fixed number of runs that are available to the console and API. In the default mode
         * (RETAIN), you need to remove runs manually when the number of run exceeds the maximum. If you set the
         * retention mode to <code>REMOVE</code>, HealthOmics automatically removes runs (that have mode set to REMOVE)
         * when the number of run exceeds the maximum. All run logs are available in CloudWatch logs, if you need
         * information about a run that is no longer available to the API.
         * </p>
         * <p>
         * For more information about retention mode, see <a
         * href="https://docs.aws.amazon.com/omics/latest/dev/starting-a-run.html">Specifying run retention mode</a> in
         * the <i>AWS HealthOmics User Guide</i>.
         * </p>
         * 
         * @param retentionMode
         *        The retention mode for the run. The default value is RETAIN. </p>
         *        <p>
         *        HealthOmics stores a fixed number of runs that are available to the console and API. In the default
         *        mode (RETAIN), you need to remove runs manually when the number of run exceeds the maximum. If you set
         *        the retention mode to <code>REMOVE</code>, HealthOmics automatically removes runs (that have mode set
         *        to REMOVE) when the number of run exceeds the maximum. All run logs are available in CloudWatch logs,
         *        if you need information about a run that is no longer available to the API.
         *        </p>
         *        <p>
         *        For more information about retention mode, see <a
         *        href="https://docs.aws.amazon.com/omics/latest/dev/starting-a-run.html">Specifying run retention
         *        mode</a> in the <i>AWS HealthOmics User Guide</i>.
         * @see RunRetentionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunRetentionMode
         */
        Builder retentionMode(String retentionMode);

        /**
         * <p>
         * The retention mode for the run. The default value is RETAIN.
         * </p>
         * <p>
         * HealthOmics stores a fixed number of runs that are available to the console and API. In the default mode
         * (RETAIN), you need to remove runs manually when the number of run exceeds the maximum. If you set the
         * retention mode to <code>REMOVE</code>, HealthOmics automatically removes runs (that have mode set to REMOVE)
         * when the number of run exceeds the maximum. All run logs are available in CloudWatch logs, if you need
         * information about a run that is no longer available to the API.
         * </p>
         * <p>
         * For more information about retention mode, see <a
         * href="https://docs.aws.amazon.com/omics/latest/dev/starting-a-run.html">Specifying run retention mode</a> in
         * the <i>AWS HealthOmics User Guide</i>.
         * </p>
         * 
         * @param retentionMode
         *        The retention mode for the run. The default value is RETAIN. </p>
         *        <p>
         *        HealthOmics stores a fixed number of runs that are available to the console and API. In the default
         *        mode (RETAIN), you need to remove runs manually when the number of run exceeds the maximum. If you set
         *        the retention mode to <code>REMOVE</code>, HealthOmics automatically removes runs (that have mode set
         *        to REMOVE) when the number of run exceeds the maximum. All run logs are available in CloudWatch logs,
         *        if you need information about a run that is no longer available to the API.
         *        </p>
         *        <p>
         *        For more information about retention mode, see <a
         *        href="https://docs.aws.amazon.com/omics/latest/dev/starting-a-run.html">Specifying run retention
         *        mode</a> in the <i>AWS HealthOmics User Guide</i>.
         * @see RunRetentionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunRetentionMode
         */
        Builder retentionMode(RunRetentionMode retentionMode);

        /**
         * <p>
         * The run's storage type. By default, the run uses STATIC storage type, which allocates a fixed amount of
         * storage. If you set the storage type to DYNAMIC, HealthOmics dynamically scales the storage up or down, based
         * on file system utilization.
         * </p>
         * 
         * @param storageType
         *        The run's storage type. By default, the run uses STATIC storage type, which allocates a fixed amount
         *        of storage. If you set the storage type to DYNAMIC, HealthOmics dynamically scales the storage up or
         *        down, based on file system utilization.
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The run's storage type. By default, the run uses STATIC storage type, which allocates a fixed amount of
         * storage. If you set the storage type to DYNAMIC, HealthOmics dynamically scales the storage up or down, based
         * on file system utilization.
         * </p>
         * 
         * @param storageType
         *        The run's storage type. By default, the run uses STATIC storage type, which allocates a fixed amount
         *        of storage. If you set the storage type to DYNAMIC, HealthOmics dynamically scales the storage up or
         *        down, based on file system utilization.
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(StorageType storageType);

        /**
         * <p>
         * The ID of the workflow owner.
         * </p>
         * 
         * @param workflowOwnerId
         *        The ID of the workflow owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowOwnerId(String workflowOwnerId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String workflowId;

        private String workflowType;

        private String runId;

        private String roleArn;

        private String name;

        private String cacheId;

        private String cacheBehavior;

        private String runGroupId;

        private Integer priority;

        private Document parameters;

        private Integer storageCapacity;

        private String outputUri;

        private String logLevel;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String requestIdValue;

        private String retentionMode;

        private String storageType;

        private String workflowOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartRunRequest model) {
            super(model);
            workflowId(model.workflowId);
            workflowType(model.workflowType);
            runId(model.runId);
            roleArn(model.roleArn);
            name(model.name);
            cacheId(model.cacheId);
            cacheBehavior(model.cacheBehavior);
            runGroupId(model.runGroupId);
            priority(model.priority);
            parameters(model.parameters);
            storageCapacity(model.storageCapacity);
            outputUri(model.outputUri);
            logLevel(model.logLevel);
            tags(model.tags);
            requestId(model.requestIdValue);
            retentionMode(model.retentionMode);
            storageType(model.storageType);
            workflowOwnerId(model.workflowOwnerId);
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getWorkflowType() {
            return workflowType;
        }

        public final void setWorkflowType(String workflowType) {
            this.workflowType = workflowType;
        }

        @Override
        public final Builder workflowType(String workflowType) {
            this.workflowType = workflowType;
            return this;
        }

        @Override
        public final Builder workflowType(WorkflowType workflowType) {
            this.workflowType(workflowType == null ? null : workflowType.toString());
            return this;
        }

        public final String getRunId() {
            return runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public final String getRoleArn() {
            return roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCacheId() {
            return cacheId;
        }

        public final void setCacheId(String cacheId) {
            this.cacheId = cacheId;
        }

        @Override
        public final Builder cacheId(String cacheId) {
            this.cacheId = cacheId;
            return this;
        }

        public final String getCacheBehavior() {
            return cacheBehavior;
        }

        public final void setCacheBehavior(String cacheBehavior) {
            this.cacheBehavior = cacheBehavior;
        }

        @Override
        public final Builder cacheBehavior(String cacheBehavior) {
            this.cacheBehavior = cacheBehavior;
            return this;
        }

        @Override
        public final Builder cacheBehavior(CacheBehavior cacheBehavior) {
            this.cacheBehavior(cacheBehavior == null ? null : cacheBehavior.toString());
            return this;
        }

        public final String getRunGroupId() {
            return runGroupId;
        }

        public final void setRunGroupId(String runGroupId) {
            this.runGroupId = runGroupId;
        }

        @Override
        public final Builder runGroupId(String runGroupId) {
            this.runGroupId = runGroupId;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final Document getParameters() {
            return parameters;
        }

        public final void setParameters(Document parameters) {
            this.parameters = parameters;
        }

        @Override
        public final Builder parameters(Document parameters) {
            this.parameters = parameters;
            return this;
        }

        public final Integer getStorageCapacity() {
            return storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final String getOutputUri() {
            return outputUri;
        }

        public final void setOutputUri(String outputUri) {
            this.outputUri = outputUri;
        }

        @Override
        public final Builder outputUri(String outputUri) {
            this.outputUri = outputUri;
            return this;
        }

        public final String getLogLevel() {
            return logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(RunLogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final String getRetentionMode() {
            return retentionMode;
        }

        public final void setRetentionMode(String retentionMode) {
            this.retentionMode = retentionMode;
        }

        @Override
        public final Builder retentionMode(String retentionMode) {
            this.retentionMode = retentionMode;
            return this;
        }

        @Override
        public final Builder retentionMode(RunRetentionMode retentionMode) {
            this.retentionMode(retentionMode == null ? null : retentionMode.toString());
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final String getWorkflowOwnerId() {
            return workflowOwnerId;
        }

        public final void setWorkflowOwnerId(String workflowOwnerId) {
            this.workflowOwnerId = workflowOwnerId;
        }

        @Override
        public final Builder workflowOwnerId(String workflowOwnerId) {
            this.workflowOwnerId = workflowOwnerId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartRunRequest build() {
            return new StartRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
