/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateRunCacheRequest extends OmicsRequest implements
        ToCopyableBuilder<UpdateRunCacheRequest.Builder, UpdateRunCacheRequest> {
    private static final SdkField<String> CACHE_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cacheBehavior").getter(getter(UpdateRunCacheRequest::cacheBehaviorAsString))
            .setter(setter(Builder::cacheBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBehavior").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateRunCacheRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateRunCacheRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateRunCacheRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_BEHAVIOR_FIELD,
            DESCRIPTION_FIELD, ID_FIELD, NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String cacheBehavior;

    private final String description;

    private final String id;

    private final String name;

    private UpdateRunCacheRequest(BuilderImpl builder) {
        super(builder);
        this.cacheBehavior = builder.cacheBehavior;
        this.description = builder.description;
        this.id = builder.id;
        this.name = builder.name;
    }

    /**
     * <p>
     * Update the default run cache behavior.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cacheBehavior}
     * will return {@link CacheBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cacheBehaviorAsString}.
     * </p>
     * 
     * @return Update the default run cache behavior.
     * @see CacheBehavior
     */
    public final CacheBehavior cacheBehavior() {
        return CacheBehavior.fromValue(cacheBehavior);
    }

    /**
     * <p>
     * Update the default run cache behavior.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cacheBehavior}
     * will return {@link CacheBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cacheBehaviorAsString}.
     * </p>
     * 
     * @return Update the default run cache behavior.
     * @see CacheBehavior
     */
    public final String cacheBehaviorAsString() {
        return cacheBehavior;
    }

    /**
     * <p>
     * Update the run cache description.
     * </p>
     * 
     * @return Update the run cache description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The identifier of the run cache you want to update.
     * </p>
     * 
     * @return The identifier of the run cache you want to update.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Update the name of the run cache.
     * </p>
     * 
     * @return Update the name of the run cache.
     */
    public final String name() {
        return name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cacheBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRunCacheRequest)) {
            return false;
        }
        UpdateRunCacheRequest other = (UpdateRunCacheRequest) obj;
        return Objects.equals(cacheBehaviorAsString(), other.cacheBehaviorAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(id(), other.id())
                && Objects.equals(name(), other.name());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateRunCacheRequest").add("CacheBehavior", cacheBehaviorAsString())
                .add("Description", description()).add("Id", id()).add("Name", name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cacheBehavior":
            return Optional.ofNullable(clazz.cast(cacheBehaviorAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cacheBehavior", CACHE_BEHAVIOR_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateRunCacheRequest, T> g) {
        return obj -> g.apply((UpdateRunCacheRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateRunCacheRequest> {
        /**
         * <p>
         * Update the default run cache behavior.
         * </p>
         * 
         * @param cacheBehavior
         *        Update the default run cache behavior.
         * @see CacheBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CacheBehavior
         */
        Builder cacheBehavior(String cacheBehavior);

        /**
         * <p>
         * Update the default run cache behavior.
         * </p>
         * 
         * @param cacheBehavior
         *        Update the default run cache behavior.
         * @see CacheBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CacheBehavior
         */
        Builder cacheBehavior(CacheBehavior cacheBehavior);

        /**
         * <p>
         * Update the run cache description.
         * </p>
         * 
         * @param description
         *        Update the run cache description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The identifier of the run cache you want to update.
         * </p>
         * 
         * @param id
         *        The identifier of the run cache you want to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Update the name of the run cache.
         * </p>
         * 
         * @param name
         *        Update the name of the run cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String cacheBehavior;

        private String description;

        private String id;

        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateRunCacheRequest model) {
            super(model);
            cacheBehavior(model.cacheBehavior);
            description(model.description);
            id(model.id);
            name(model.name);
        }

        public final String getCacheBehavior() {
            return cacheBehavior;
        }

        public final void setCacheBehavior(String cacheBehavior) {
            this.cacheBehavior = cacheBehavior;
        }

        @Override
        public final Builder cacheBehavior(String cacheBehavior) {
            this.cacheBehavior = cacheBehavior;
            return this;
        }

        @Override
        public final Builder cacheBehavior(CacheBehavior cacheBehavior) {
            this.cacheBehavior(cacheBehavior == null ? null : cacheBehavior.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateRunCacheRequest build() {
            return new UpdateRunCacheRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
