/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSequenceStoreRequest extends OmicsRequest implements
        ToCopyableBuilder<UpdateSequenceStoreRequest.Builder, UpdateSequenceStoreRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateSequenceStoreRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateSequenceStoreRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateSequenceStoreRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateSequenceStoreRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> FALLBACK_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fallbackLocation").getter(getter(UpdateSequenceStoreRequest::fallbackLocation))
            .setter(setter(Builder::fallbackLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fallbackLocation").build()).build();

    private static final SdkField<List<String>> PROPAGATED_SET_LEVEL_TAGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("propagatedSetLevelTags")
            .getter(getter(UpdateSequenceStoreRequest::propagatedSetLevelTags))
            .setter(setter(Builder::propagatedSetLevelTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagatedSetLevelTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<S3AccessConfig> S3_ACCESS_CONFIG_FIELD = SdkField
            .<S3AccessConfig> builder(MarshallingType.SDK_POJO).memberName("s3AccessConfig")
            .getter(getter(UpdateSequenceStoreRequest::s3AccessConfig)).setter(setter(Builder::s3AccessConfig))
            .constructor(S3AccessConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3AccessConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, CLIENT_TOKEN_FIELD, FALLBACK_LOCATION_FIELD, PROPAGATED_SET_LEVEL_TAGS_FIELD,
            S3_ACCESS_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String name;

    private final String description;

    private final String clientToken;

    private final String fallbackLocation;

    private final List<String> propagatedSetLevelTags;

    private final S3AccessConfig s3AccessConfig;

    private UpdateSequenceStoreRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.clientToken = builder.clientToken;
        this.fallbackLocation = builder.fallbackLocation;
        this.propagatedSetLevelTags = builder.propagatedSetLevelTags;
        this.s3AccessConfig = builder.s3AccessConfig;
    }

    /**
     * <p>
     * The ID of the sequence store.
     * </p>
     * 
     * @return The ID of the sequence store.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A name for the sequence store.
     * </p>
     * 
     * @return A name for the sequence store.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description for the sequence store.
     * </p>
     * 
     * @return A description for the sequence store.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * To ensure that requests don't run multiple times, specify a unique token for each request.
     * </p>
     * 
     * @return To ensure that requests don't run multiple times, specify a unique token for each request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The S3 URI of a bucket and folder to store Read Sets that fail to upload.
     * </p>
     * 
     * @return The S3 URI of a bucket and folder to store Read Sets that fail to upload.
     */
    public final String fallbackLocation() {
        return fallbackLocation;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropagatedSetLevelTags property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPropagatedSetLevelTags() {
        return propagatedSetLevelTags != null && !(propagatedSetLevelTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags keys to propagate to the S3 objects associated with read sets in the sequence store.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropagatedSetLevelTags} method.
     * </p>
     * 
     * @return The tags keys to propagate to the S3 objects associated with read sets in the sequence store.
     */
    public final List<String> propagatedSetLevelTags() {
        return propagatedSetLevelTags;
    }

    /**
     * <p>
     * S3 access configuration parameters.
     * </p>
     * 
     * @return S3 access configuration parameters.
     */
    public final S3AccessConfig s3AccessConfig() {
        return s3AccessConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(fallbackLocation());
        hashCode = 31 * hashCode + Objects.hashCode(hasPropagatedSetLevelTags() ? propagatedSetLevelTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(s3AccessConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSequenceStoreRequest)) {
            return false;
        }
        UpdateSequenceStoreRequest other = (UpdateSequenceStoreRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(fallbackLocation(), other.fallbackLocation())
                && hasPropagatedSetLevelTags() == other.hasPropagatedSetLevelTags()
                && Objects.equals(propagatedSetLevelTags(), other.propagatedSetLevelTags())
                && Objects.equals(s3AccessConfig(), other.s3AccessConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSequenceStoreRequest").add("Id", id()).add("Name", name())
                .add("Description", description()).add("ClientToken", clientToken()).add("FallbackLocation", fallbackLocation())
                .add("PropagatedSetLevelTags", hasPropagatedSetLevelTags() ? propagatedSetLevelTags() : null)
                .add("S3AccessConfig", s3AccessConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "fallbackLocation":
            return Optional.ofNullable(clazz.cast(fallbackLocation()));
        case "propagatedSetLevelTags":
            return Optional.ofNullable(clazz.cast(propagatedSetLevelTags()));
        case "s3AccessConfig":
            return Optional.ofNullable(clazz.cast(s3AccessConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("fallbackLocation", FALLBACK_LOCATION_FIELD);
        map.put("propagatedSetLevelTags", PROPAGATED_SET_LEVEL_TAGS_FIELD);
        map.put("s3AccessConfig", S3_ACCESS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSequenceStoreRequest, T> g) {
        return obj -> g.apply((UpdateSequenceStoreRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSequenceStoreRequest> {
        /**
         * <p>
         * The ID of the sequence store.
         * </p>
         * 
         * @param id
         *        The ID of the sequence store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A name for the sequence store.
         * </p>
         * 
         * @param name
         *        A name for the sequence store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description for the sequence store.
         * </p>
         * 
         * @param description
         *        A description for the sequence store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * To ensure that requests don't run multiple times, specify a unique token for each request.
         * </p>
         * 
         * @param clientToken
         *        To ensure that requests don't run multiple times, specify a unique token for each request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The S3 URI of a bucket and folder to store Read Sets that fail to upload.
         * </p>
         * 
         * @param fallbackLocation
         *        The S3 URI of a bucket and folder to store Read Sets that fail to upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fallbackLocation(String fallbackLocation);

        /**
         * <p>
         * The tags keys to propagate to the S3 objects associated with read sets in the sequence store.
         * </p>
         * 
         * @param propagatedSetLevelTags
         *        The tags keys to propagate to the S3 objects associated with read sets in the sequence store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagatedSetLevelTags(Collection<String> propagatedSetLevelTags);

        /**
         * <p>
         * The tags keys to propagate to the S3 objects associated with read sets in the sequence store.
         * </p>
         * 
         * @param propagatedSetLevelTags
         *        The tags keys to propagate to the S3 objects associated with read sets in the sequence store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagatedSetLevelTags(String... propagatedSetLevelTags);

        /**
         * <p>
         * S3 access configuration parameters.
         * </p>
         * 
         * @param s3AccessConfig
         *        S3 access configuration parameters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3AccessConfig(S3AccessConfig s3AccessConfig);

        /**
         * <p>
         * S3 access configuration parameters.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3AccessConfig.Builder} avoiding the need
         * to create one manually via {@link S3AccessConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3AccessConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #s3AccessConfig(S3AccessConfig)}.
         * 
         * @param s3AccessConfig
         *        a consumer that will call methods on {@link S3AccessConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3AccessConfig(S3AccessConfig)
         */
        default Builder s3AccessConfig(Consumer<S3AccessConfig.Builder> s3AccessConfig) {
            return s3AccessConfig(S3AccessConfig.builder().applyMutation(s3AccessConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private String clientToken;

        private String fallbackLocation;

        private List<String> propagatedSetLevelTags = DefaultSdkAutoConstructList.getInstance();

        private S3AccessConfig s3AccessConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSequenceStoreRequest model) {
            super(model);
            id(model.id);
            name(model.name);
            description(model.description);
            clientToken(model.clientToken);
            fallbackLocation(model.fallbackLocation);
            propagatedSetLevelTags(model.propagatedSetLevelTags);
            s3AccessConfig(model.s3AccessConfig);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFallbackLocation() {
            return fallbackLocation;
        }

        public final void setFallbackLocation(String fallbackLocation) {
            this.fallbackLocation = fallbackLocation;
        }

        @Override
        public final Builder fallbackLocation(String fallbackLocation) {
            this.fallbackLocation = fallbackLocation;
            return this;
        }

        public final Collection<String> getPropagatedSetLevelTags() {
            if (propagatedSetLevelTags instanceof SdkAutoConstructList) {
                return null;
            }
            return propagatedSetLevelTags;
        }

        public final void setPropagatedSetLevelTags(Collection<String> propagatedSetLevelTags) {
            this.propagatedSetLevelTags = PropagatedSetLevelTagsCopier.copy(propagatedSetLevelTags);
        }

        @Override
        public final Builder propagatedSetLevelTags(Collection<String> propagatedSetLevelTags) {
            this.propagatedSetLevelTags = PropagatedSetLevelTagsCopier.copy(propagatedSetLevelTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propagatedSetLevelTags(String... propagatedSetLevelTags) {
            propagatedSetLevelTags(Arrays.asList(propagatedSetLevelTags));
            return this;
        }

        public final S3AccessConfig.Builder getS3AccessConfig() {
            return s3AccessConfig != null ? s3AccessConfig.toBuilder() : null;
        }

        public final void setS3AccessConfig(S3AccessConfig.BuilderImpl s3AccessConfig) {
            this.s3AccessConfig = s3AccessConfig != null ? s3AccessConfig.build() : null;
        }

        @Override
        public final Builder s3AccessConfig(S3AccessConfig s3AccessConfig) {
            this.s3AccessConfig = s3AccessConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSequenceStoreRequest build() {
            return new UpdateSequenceStoreRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
