/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UploadReadSetPartRequest extends OmicsRequest implements
        ToCopyableBuilder<UploadReadSetPartRequest.Builder, UploadReadSetPartRequest> {
    private static final SdkField<String> SEQUENCE_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sequenceStoreId").getter(getter(UploadReadSetPartRequest::sequenceStoreId))
            .setter(setter(Builder::sequenceStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sequenceStoreId").build()).build();

    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("uploadId").getter(getter(UploadReadSetPartRequest::uploadId)).setter(setter(Builder::uploadId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("uploadId").build()).build();

    private static final SdkField<String> PART_SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("partSource").getter(getter(UploadReadSetPartRequest::partSourceAsString))
            .setter(setter(Builder::partSource))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("partSource").build()).build();

    private static final SdkField<Integer> PART_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("partNumber").getter(getter(UploadReadSetPartRequest::partNumber)).setter(setter(Builder::partNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("partNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SEQUENCE_STORE_ID_FIELD,
            UPLOAD_ID_FIELD, PART_SOURCE_FIELD, PART_NUMBER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sequenceStoreId;

    private final String uploadId;

    private final String partSource;

    private final Integer partNumber;

    private UploadReadSetPartRequest(BuilderImpl builder) {
        super(builder);
        this.sequenceStoreId = builder.sequenceStoreId;
        this.uploadId = builder.uploadId;
        this.partSource = builder.partSource;
        this.partNumber = builder.partNumber;
    }

    /**
     * <p>
     * The Sequence Store ID used for the multipart upload.
     * </p>
     * 
     * @return The Sequence Store ID used for the multipart upload.
     */
    public final String sequenceStoreId() {
        return sequenceStoreId;
    }

    /**
     * <p>
     * The ID for the initiated multipart upload.
     * </p>
     * 
     * @return The ID for the initiated multipart upload.
     */
    public final String uploadId() {
        return uploadId;
    }

    /**
     * <p>
     * The source file for an upload part.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #partSource} will
     * return {@link ReadSetPartSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #partSourceAsString}.
     * </p>
     * 
     * @return The source file for an upload part.
     * @see ReadSetPartSource
     */
    public final ReadSetPartSource partSource() {
        return ReadSetPartSource.fromValue(partSource);
    }

    /**
     * <p>
     * The source file for an upload part.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #partSource} will
     * return {@link ReadSetPartSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #partSourceAsString}.
     * </p>
     * 
     * @return The source file for an upload part.
     * @see ReadSetPartSource
     */
    public final String partSourceAsString() {
        return partSource;
    }

    /**
     * <p>
     * The number of the part being uploaded.
     * </p>
     * 
     * @return The number of the part being uploaded.
     */
    public final Integer partNumber() {
        return partNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sequenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(partSourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(partNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadReadSetPartRequest)) {
            return false;
        }
        UploadReadSetPartRequest other = (UploadReadSetPartRequest) obj;
        return Objects.equals(sequenceStoreId(), other.sequenceStoreId()) && Objects.equals(uploadId(), other.uploadId())
                && Objects.equals(partSourceAsString(), other.partSourceAsString())
                && Objects.equals(partNumber(), other.partNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UploadReadSetPartRequest").add("SequenceStoreId", sequenceStoreId()).add("UploadId", uploadId())
                .add("PartSource", partSourceAsString()).add("PartNumber", partNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sequenceStoreId":
            return Optional.ofNullable(clazz.cast(sequenceStoreId()));
        case "uploadId":
            return Optional.ofNullable(clazz.cast(uploadId()));
        case "partSource":
            return Optional.ofNullable(clazz.cast(partSourceAsString()));
        case "partNumber":
            return Optional.ofNullable(clazz.cast(partNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sequenceStoreId", SEQUENCE_STORE_ID_FIELD);
        map.put("uploadId", UPLOAD_ID_FIELD);
        map.put("partSource", PART_SOURCE_FIELD);
        map.put("partNumber", PART_NUMBER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UploadReadSetPartRequest, T> g) {
        return obj -> g.apply((UploadReadSetPartRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UploadReadSetPartRequest> {
        /**
         * <p>
         * The Sequence Store ID used for the multipart upload.
         * </p>
         * 
         * @param sequenceStoreId
         *        The Sequence Store ID used for the multipart upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceStoreId(String sequenceStoreId);

        /**
         * <p>
         * The ID for the initiated multipart upload.
         * </p>
         * 
         * @param uploadId
         *        The ID for the initiated multipart upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uploadId(String uploadId);

        /**
         * <p>
         * The source file for an upload part.
         * </p>
         * 
         * @param partSource
         *        The source file for an upload part.
         * @see ReadSetPartSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReadSetPartSource
         */
        Builder partSource(String partSource);

        /**
         * <p>
         * The source file for an upload part.
         * </p>
         * 
         * @param partSource
         *        The source file for an upload part.
         * @see ReadSetPartSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReadSetPartSource
         */
        Builder partSource(ReadSetPartSource partSource);

        /**
         * <p>
         * The number of the part being uploaded.
         * </p>
         * 
         * @param partNumber
         *        The number of the part being uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partNumber(Integer partNumber);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String sequenceStoreId;

        private String uploadId;

        private String partSource;

        private Integer partNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadReadSetPartRequest model) {
            super(model);
            sequenceStoreId(model.sequenceStoreId);
            uploadId(model.uploadId);
            partSource(model.partSource);
            partNumber(model.partNumber);
        }

        public final String getSequenceStoreId() {
            return sequenceStoreId;
        }

        public final void setSequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
        }

        @Override
        public final Builder sequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
            return this;
        }

        public final String getUploadId() {
            return uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final String getPartSource() {
            return partSource;
        }

        public final void setPartSource(String partSource) {
            this.partSource = partSource;
        }

        @Override
        public final Builder partSource(String partSource) {
            this.partSource = partSource;
            return this;
        }

        @Override
        public final Builder partSource(ReadSetPartSource partSource) {
            this.partSource(partSource == null ? null : partSource.toString());
            return this;
        }

        public final Integer getPartNumber() {
            return partNumber;
        }

        public final void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        @Override
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UploadReadSetPartRequest build() {
            return new UploadReadSetPartRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
