/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Formatting options for a VCF file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VcfOptions implements SdkPojo, Serializable, ToCopyableBuilder<VcfOptions.Builder, VcfOptions> {
    private static final SdkField<Boolean> IGNORE_QUAL_FIELD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ignoreQualField").getter(getter(VcfOptions::ignoreQualField)).setter(setter(Builder::ignoreQualField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignoreQualField").build()).build();

    private static final SdkField<Boolean> IGNORE_FILTER_FIELD_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ignoreFilterField").getter(getter(VcfOptions::ignoreFilterField))
            .setter(setter(Builder::ignoreFilterField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ignoreFilterField").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IGNORE_QUAL_FIELD_FIELD,
            IGNORE_FILTER_FIELD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean ignoreQualField;

    private final Boolean ignoreFilterField;

    private VcfOptions(BuilderImpl builder) {
        this.ignoreQualField = builder.ignoreQualField;
        this.ignoreFilterField = builder.ignoreFilterField;
    }

    /**
     * <p>
     * The file's ignore qual field setting.
     * </p>
     * 
     * @return The file's ignore qual field setting.
     */
    public final Boolean ignoreQualField() {
        return ignoreQualField;
    }

    /**
     * <p>
     * The file's ignore filter field setting.
     * </p>
     * 
     * @return The file's ignore filter field setting.
     */
    public final Boolean ignoreFilterField() {
        return ignoreFilterField;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ignoreQualField());
        hashCode = 31 * hashCode + Objects.hashCode(ignoreFilterField());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VcfOptions)) {
            return false;
        }
        VcfOptions other = (VcfOptions) obj;
        return Objects.equals(ignoreQualField(), other.ignoreQualField())
                && Objects.equals(ignoreFilterField(), other.ignoreFilterField());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VcfOptions").add("IgnoreQualField", ignoreQualField())
                .add("IgnoreFilterField", ignoreFilterField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ignoreQualField":
            return Optional.ofNullable(clazz.cast(ignoreQualField()));
        case "ignoreFilterField":
            return Optional.ofNullable(clazz.cast(ignoreFilterField()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ignoreQualField", IGNORE_QUAL_FIELD_FIELD);
        map.put("ignoreFilterField", IGNORE_FILTER_FIELD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VcfOptions, T> g) {
        return obj -> g.apply((VcfOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VcfOptions> {
        /**
         * <p>
         * The file's ignore qual field setting.
         * </p>
         * 
         * @param ignoreQualField
         *        The file's ignore qual field setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreQualField(Boolean ignoreQualField);

        /**
         * <p>
         * The file's ignore filter field setting.
         * </p>
         * 
         * @param ignoreFilterField
         *        The file's ignore filter field setting.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ignoreFilterField(Boolean ignoreFilterField);
    }

    static final class BuilderImpl implements Builder {
        private Boolean ignoreQualField;

        private Boolean ignoreFilterField;

        private BuilderImpl() {
        }

        private BuilderImpl(VcfOptions model) {
            ignoreQualField(model.ignoreQualField);
            ignoreFilterField(model.ignoreFilterField);
        }

        public final Boolean getIgnoreQualField() {
            return ignoreQualField;
        }

        public final void setIgnoreQualField(Boolean ignoreQualField) {
            this.ignoreQualField = ignoreQualField;
        }

        @Override
        public final Builder ignoreQualField(Boolean ignoreQualField) {
            this.ignoreQualField = ignoreQualField;
            return this;
        }

        public final Boolean getIgnoreFilterField() {
            return ignoreFilterField;
        }

        public final void setIgnoreFilterField(Boolean ignoreFilterField) {
            this.ignoreFilterField = ignoreFilterField;
        }

        @Override
        public final Builder ignoreFilterField(Boolean ignoreFilterField) {
            this.ignoreFilterField = ignoreFilterField;
            return this;
        }

        @Override
        public VcfOptions build() {
            return new VcfOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
