/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options for an annotation store version.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VersionOptions implements SdkPojo, Serializable, ToCopyableBuilder<VersionOptions.Builder, VersionOptions> {
    private static final SdkField<TsvVersionOptions> TSV_VERSION_OPTIONS_FIELD = SdkField
            .<TsvVersionOptions> builder(MarshallingType.SDK_POJO).memberName("tsvVersionOptions")
            .getter(getter(VersionOptions::tsvVersionOptions)).setter(setter(Builder::tsvVersionOptions))
            .constructor(TsvVersionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tsvVersionOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TSV_VERSION_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TsvVersionOptions tsvVersionOptions;

    private final Type type;

    private VersionOptions(BuilderImpl builder) {
        this.tsvVersionOptions = builder.tsvVersionOptions;
        this.type = builder.type;
    }

    /**
     * <p>
     * File settings for a version of a TSV store.
     * </p>
     * 
     * @return File settings for a version of a TSV store.
     */
    public final TsvVersionOptions tsvVersionOptions() {
        return tsvVersionOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tsvVersionOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VersionOptions)) {
            return false;
        }
        VersionOptions other = (VersionOptions) obj;
        return Objects.equals(tsvVersionOptions(), other.tsvVersionOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VersionOptions").add("TsvVersionOptions", tsvVersionOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tsvVersionOptions":
            return Optional.ofNullable(clazz.cast(tsvVersionOptions()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #tsvVersionOptions()} initialized to the given value.
     *
     * <p>
     * File settings for a version of a TSV store.
     * </p>
     * 
     * @param tsvVersionOptions
     *        File settings for a version of a TSV store.
     */
    public static VersionOptions fromTsvVersionOptions(TsvVersionOptions tsvVersionOptions) {
        return builder().tsvVersionOptions(tsvVersionOptions).build();
    }

    /**
     * Create an instance of this class with {@link #tsvVersionOptions()} initialized to the given value.
     *
     * <p>
     * File settings for a version of a TSV store.
     * </p>
     * 
     * @param tsvVersionOptions
     *        File settings for a version of a TSV store.
     */
    public static VersionOptions fromTsvVersionOptions(Consumer<TsvVersionOptions.Builder> tsvVersionOptions) {
        TsvVersionOptions.Builder builder = TsvVersionOptions.builder();
        tsvVersionOptions.accept(builder);
        return fromTsvVersionOptions(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tsvVersionOptions", TSV_VERSION_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VersionOptions, T> g) {
        return obj -> g.apply((VersionOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VersionOptions> {
        /**
         * <p>
         * File settings for a version of a TSV store.
         * </p>
         * 
         * @param tsvVersionOptions
         *        File settings for a version of a TSV store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tsvVersionOptions(TsvVersionOptions tsvVersionOptions);

        /**
         * <p>
         * File settings for a version of a TSV store.
         * </p>
         * This is a convenience method that creates an instance of the {@link TsvVersionOptions.Builder} avoiding the
         * need to create one manually via {@link TsvVersionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TsvVersionOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #tsvVersionOptions(TsvVersionOptions)}.
         * 
         * @param tsvVersionOptions
         *        a consumer that will call methods on {@link TsvVersionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tsvVersionOptions(TsvVersionOptions)
         */
        default Builder tsvVersionOptions(Consumer<TsvVersionOptions.Builder> tsvVersionOptions) {
            return tsvVersionOptions(TsvVersionOptions.builder().applyMutation(tsvVersionOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TsvVersionOptions tsvVersionOptions;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(VersionOptions model) {
            tsvVersionOptions(model.tsvVersionOptions);
        }

        public final TsvVersionOptions.Builder getTsvVersionOptions() {
            return tsvVersionOptions != null ? tsvVersionOptions.toBuilder() : null;
        }

        public final void setTsvVersionOptions(TsvVersionOptions.BuilderImpl tsvVersionOptions) {
            Object oldValue = this.tsvVersionOptions;
            this.tsvVersionOptions = tsvVersionOptions != null ? tsvVersionOptions.build() : null;
            handleUnionValueChange(Type.TSV_VERSION_OPTIONS, oldValue, this.tsvVersionOptions);
        }

        @Override
        public final Builder tsvVersionOptions(TsvVersionOptions tsvVersionOptions) {
            Object oldValue = this.tsvVersionOptions;
            this.tsvVersionOptions = tsvVersionOptions;
            handleUnionValueChange(Type.TSV_VERSION_OPTIONS, oldValue, this.tsvVersionOptions);
            return this;
        }

        @Override
        public VersionOptions build() {
            return new VersionOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see VersionOptions#type()
     */
    public enum Type {
        TSV_VERSION_OPTIONS,

        UNKNOWN_TO_SDK_VERSION
    }
}
