/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.omics.model.SequenceStoreStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SequenceStoreFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SequenceStoreFilter> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(SequenceStoreFilter.getter(SequenceStoreFilter::name)).setter(SequenceStoreFilter.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAfter").getter(SequenceStoreFilter.getter(SequenceStoreFilter::createdAfter)).setter(SequenceStoreFilter.setter(Builder::createdAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAfter").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdBefore").getter(SequenceStoreFilter.getter(SequenceStoreFilter::createdBefore)).setter(SequenceStoreFilter.setter(Builder::createdBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBefore").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(SequenceStoreFilter.getter(SequenceStoreFilter::statusAsString)).setter(SequenceStoreFilter.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<Instant> UPDATED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAfter").getter(SequenceStoreFilter.getter(SequenceStoreFilter::updatedAfter)).setter(SequenceStoreFilter.setter(Builder::updatedAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAfter").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> UPDATED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedBefore").getter(SequenceStoreFilter.getter(SequenceStoreFilter::updatedBefore)).setter(SequenceStoreFilter.setter(Builder::updatedBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBefore").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, CREATED_AFTER_FIELD, CREATED_BEFORE_FIELD, STATUS_FIELD, UPDATED_AFTER_FIELD, UPDATED_BEFORE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SequenceStoreFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final Instant createdAfter;
    private final Instant createdBefore;
    private final String status;
    private final Instant updatedAfter;
    private final Instant updatedBefore;

    private SequenceStoreFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.status = builder.status;
        this.updatedAfter = builder.updatedAfter;
        this.updatedBefore = builder.updatedBefore;
    }

    public final String name() {
        return this.name;
    }

    public final Instant createdAfter() {
        return this.createdAfter;
    }

    public final Instant createdBefore() {
        return this.createdBefore;
    }

    public final SequenceStoreStatus status() {
        return SequenceStoreStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant updatedAfter() {
        return this.updatedAfter;
    }

    public final Instant updatedBefore() {
        return this.updatedBefore;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBefore());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SequenceStoreFilter)) {
            return false;
        }
        SequenceStoreFilter other = (SequenceStoreFilter)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.createdAfter(), other.createdAfter()) && Objects.equals(this.createdBefore(), other.createdBefore()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.updatedAfter(), other.updatedAfter()) && Objects.equals(this.updatedBefore(), other.updatedBefore());
    }

    public final String toString() {
        return ToString.builder((String)"SequenceStoreFilter").add("Name", (Object)this.name()).add("CreatedAfter", (Object)this.createdAfter()).add("CreatedBefore", (Object)this.createdBefore()).add("Status", (Object)this.statusAsString()).add("UpdatedAfter", (Object)this.updatedAfter()).add("UpdatedBefore", (Object)this.updatedBefore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "createdAfter": {
                return Optional.ofNullable(clazz.cast(this.createdAfter()));
            }
            case "createdBefore": {
                return Optional.ofNullable(clazz.cast(this.createdBefore()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "updatedAfter": {
                return Optional.ofNullable(clazz.cast(this.updatedAfter()));
            }
            case "updatedBefore": {
                return Optional.ofNullable(clazz.cast(this.updatedBefore()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("createdAfter", CREATED_AFTER_FIELD);
        map.put("createdBefore", CREATED_BEFORE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("updatedAfter", UPDATED_AFTER_FIELD);
        map.put("updatedBefore", UPDATED_BEFORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SequenceStoreFilter, T> g) {
        return obj -> g.apply((SequenceStoreFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private Instant createdAfter;
        private Instant createdBefore;
        private String status;
        private Instant updatedAfter;
        private Instant updatedBefore;

        private BuilderImpl() {
        }

        private BuilderImpl(SequenceStoreFilter model) {
            this.name(model.name);
            this.createdAfter(model.createdAfter);
            this.createdBefore(model.createdBefore);
            this.status(model.status);
            this.updatedAfter(model.updatedAfter);
            this.updatedBefore(model.updatedBefore);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreatedAfter() {
            return this.createdAfter;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final Instant getCreatedBefore() {
            return this.createdBefore;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SequenceStoreStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAfter() {
            return this.updatedAfter;
        }

        public final void setUpdatedAfter(Instant updatedAfter) {
            this.updatedAfter = updatedAfter;
        }

        @Override
        public final Builder updatedAfter(Instant updatedAfter) {
            this.updatedAfter = updatedAfter;
            return this;
        }

        public final Instant getUpdatedBefore() {
            return this.updatedBefore;
        }

        public final void setUpdatedBefore(Instant updatedBefore) {
            this.updatedBefore = updatedBefore;
        }

        @Override
        public final Builder updatedBefore(Instant updatedBefore) {
            this.updatedBefore = updatedBefore;
            return this;
        }

        public SequenceStoreFilter build() {
            return new SequenceStoreFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SequenceStoreFilter> {
        public Builder name(String var1);

        public Builder createdAfter(Instant var1);

        public Builder createdBefore(Instant var1);

        public Builder status(String var1);

        public Builder status(SequenceStoreStatus var1);

        public Builder updatedAfter(Instant var1);

        public Builder updatedBefore(Instant var1);
    }
}

