/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.internal.UserAgentUtils;
import software.amazon.awssdk.services.omics.model.ListWorkflowVersionsRequest;
import software.amazon.awssdk.services.omics.model.ListWorkflowVersionsResponse;
import software.amazon.awssdk.services.omics.model.WorkflowVersionListItem;

public class ListWorkflowVersionsIterable
implements SdkIterable<ListWorkflowVersionsResponse> {
    private final OmicsClient client;
    private final ListWorkflowVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListWorkflowVersionsIterable(OmicsClient client, ListWorkflowVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListWorkflowVersionsResponseFetcher();
    }

    public Iterator<ListWorkflowVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<WorkflowVersionListItem> items() {
        Function<ListWorkflowVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListWorkflowVersionsResponseFetcher
    implements SyncPageFetcher<ListWorkflowVersionsResponse> {
        private ListWorkflowVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListWorkflowVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListWorkflowVersionsResponse nextPage(ListWorkflowVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListWorkflowVersionsIterable.this.client.listWorkflowVersions(ListWorkflowVersionsIterable.this.firstRequest);
            }
            return ListWorkflowVersionsIterable.this.client.listWorkflowVersions((ListWorkflowVersionsRequest)((Object)ListWorkflowVersionsIterable.this.firstRequest.toBuilder().startingToken(previousPage.nextToken()).build()));
        }
    }
}

