/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.omics.OmicsAsyncClient;
import software.amazon.awssdk.services.omics.internal.UserAgentUtils;
import software.amazon.awssdk.services.omics.model.ListRunTasksRequest;
import software.amazon.awssdk.services.omics.model.ListRunTasksResponse;
import software.amazon.awssdk.services.omics.model.TaskListItem;

public class ListRunTasksPublisher
implements SdkPublisher<ListRunTasksResponse> {
    private final OmicsAsyncClient client;
    private final ListRunTasksRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRunTasksPublisher(OmicsAsyncClient client, ListRunTasksRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRunTasksPublisher(OmicsAsyncClient client, ListRunTasksRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRunTasksResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRunTasksResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TaskListItem> items() {
        Function<ListRunTasksResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRunTasksResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRunTasksResponseFetcher
    implements AsyncPageFetcher<ListRunTasksResponse> {
        private ListRunTasksResponseFetcher() {
        }

        public boolean hasNextPage(ListRunTasksResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRunTasksResponse> nextPage(ListRunTasksResponse previousPage) {
            if (previousPage == null) {
                return ListRunTasksPublisher.this.client.listRunTasks(ListRunTasksPublisher.this.firstRequest);
            }
            return ListRunTasksPublisher.this.client.listRunTasks((ListRunTasksRequest)((Object)ListRunTasksPublisher.this.firstRequest.toBuilder().startingToken(previousPage.nextToken()).build()));
        }
    }
}

