/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.omics.model.Accelerators;
import software.amazon.awssdk.services.omics.model.DefinitionRepositoryDetails;
import software.amazon.awssdk.services.omics.model.OmicsResponse;
import software.amazon.awssdk.services.omics.model.StorageType;
import software.amazon.awssdk.services.omics.model.TagMapCopier;
import software.amazon.awssdk.services.omics.model.WorkflowEngine;
import software.amazon.awssdk.services.omics.model.WorkflowMetadataCopier;
import software.amazon.awssdk.services.omics.model.WorkflowParameter;
import software.amazon.awssdk.services.omics.model.WorkflowParameterTemplateCopier;
import software.amazon.awssdk.services.omics.model.WorkflowStatus;
import software.amazon.awssdk.services.omics.model.WorkflowType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetWorkflowVersionResponse
extends OmicsResponse
implements ToCopyableBuilder<Builder, GetWorkflowVersionResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(GetWorkflowVersionResponse.getter(GetWorkflowVersionResponse::arn)).setter(GetWorkflowVersionResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowId").getter(GetWorkflowVersionResponse.getter(GetWorkflowVersionResponse::workflowId)).setter(GetWorkflowVersionResponse.setter(Builder::workflowId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowId").build()}).build();
    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("versionName").getter(GetWorkflowVersionResponse.getter(GetWorkflowVersionResponse::versionName)).setter(GetWorkflowVersionResponse.setter(Builder::versionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()}).build();
    private static final SdkField<String> ACCELERATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accelerators").getter(GetWorkflowVersionResponse.getter(GetWorkflowVersionResponse::acceleratorsAsString)).setter(GetWorkflowVersionResponse.setter(Builder::accelerators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accelerators").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(GetWorkflowVersionResponse.getter(GetWorkflowVersionResponse::creationTime)).setter(GetWorkflowVersionResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetWorkflowVersionResponse.getter(GetWorkflowVersionResponse::description)).setter(GetWorkflowVersionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DEFINITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("definition").getter(GetWorkflowVersionResponse.getter(GetWorkflowVersionResponse::definition)).setter(GetWorkflowVersionResponse.setter(Builder::definition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()}).build();
    private static final SdkField<String> DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("digest").getter(GetWorkflowVersionResponse.getter(GetWorkflowVersionResponse::digest)).setter(GetWorkflowVersionResponse.setter(Builder::digest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("digest").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("engine").getter(GetWorkflowVersionResponse.getter(GetWorkflowVersionResponse::engineAsString)).setter(GetWorkflowVersionResponse.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engine").build()}).build();
    private static final SdkField<String> MAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("main").getter(GetWorkflowVersionResponse.getter(GetWorkflowVersionResponse::main)).setter(GetWorkflowVersionResponse.setter(Builder::main)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("main").build()}).build();
    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("metadata").getter(GetWorkflowVersionResponse.getter(GetWorkflowVersionResponse::metadata)).setter(GetWorkflowVersionResponse.setter(Builder::metadata)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, WorkflowParameter>> PARAMETER_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameterTemplate").getter(GetWorkflowVersionResponse.getter(GetWorkflowVersionResponse::parameterTemplate)).setter(GetWorkflowVersionResponse.setter(Builder::parameterTemplate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterTemplate").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(WorkflowParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetWorkflowVersionResponse.getter(GetWorkflowVersionResponse::statusAsString)).setter(GetWorkflowVersionResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("statusMessage").getter(GetWorkflowVersionResponse.getter(GetWorkflowVersionResponse::statusMessage)).setter(GetWorkflowVersionResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()}).build();
    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("storageType").getter(GetWorkflowVersionResponse.getter(GetWorkflowVersionResponse::storageTypeAsString)).setter(GetWorkflowVersionResponse.setter(Builder::storageType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()}).build();
    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("storageCapacity").getter(GetWorkflowVersionResponse.getter(GetWorkflowVersionResponse::storageCapacity)).setter(GetWorkflowVersionResponse.setter(Builder::storageCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCapacity").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(GetWorkflowVersionResponse.getter(GetWorkflowVersionResponse::typeAsString)).setter(GetWorkflowVersionResponse.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(GetWorkflowVersionResponse.getter(GetWorkflowVersionResponse::tags)).setter(GetWorkflowVersionResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> UUID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uuid").getter(GetWorkflowVersionResponse.getter(GetWorkflowVersionResponse::uuid)).setter(GetWorkflowVersionResponse.setter(Builder::uuid)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uuid").build()}).build();
    private static final SdkField<String> WORKFLOW_BUCKET_OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowBucketOwnerId").getter(GetWorkflowVersionResponse.getter(GetWorkflowVersionResponse::workflowBucketOwnerId)).setter(GetWorkflowVersionResponse.setter(Builder::workflowBucketOwnerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowBucketOwnerId").build()}).build();
    private static final SdkField<String> README_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("readme").getter(GetWorkflowVersionResponse.getter(GetWorkflowVersionResponse::readme)).setter(GetWorkflowVersionResponse.setter(Builder::readme)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readme").build()}).build();
    private static final SdkField<DefinitionRepositoryDetails> DEFINITION_REPOSITORY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("definitionRepositoryDetails").getter(GetWorkflowVersionResponse.getter(GetWorkflowVersionResponse::definitionRepositoryDetails)).setter(GetWorkflowVersionResponse.setter(Builder::definitionRepositoryDetails)).constructor(DefinitionRepositoryDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definitionRepositoryDetails").build()}).build();
    private static final SdkField<String> README_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("readmePath").getter(GetWorkflowVersionResponse.getter(GetWorkflowVersionResponse::readmePath)).setter(GetWorkflowVersionResponse.setter(Builder::readmePath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readmePath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, WORKFLOW_ID_FIELD, VERSION_NAME_FIELD, ACCELERATORS_FIELD, CREATION_TIME_FIELD, DESCRIPTION_FIELD, DEFINITION_FIELD, DIGEST_FIELD, ENGINE_FIELD, MAIN_FIELD, METADATA_FIELD, PARAMETER_TEMPLATE_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, STORAGE_TYPE_FIELD, STORAGE_CAPACITY_FIELD, TYPE_FIELD, TAGS_FIELD, UUID_FIELD, WORKFLOW_BUCKET_OWNER_ID_FIELD, README_FIELD, DEFINITION_REPOSITORY_DETAILS_FIELD, README_PATH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetWorkflowVersionResponse.memberNameToFieldInitializer();
    private final String arn;
    private final String workflowId;
    private final String versionName;
    private final String accelerators;
    private final Instant creationTime;
    private final String description;
    private final String definition;
    private final String digest;
    private final String engine;
    private final String main;
    private final Map<String, String> metadata;
    private final Map<String, WorkflowParameter> parameterTemplate;
    private final String status;
    private final String statusMessage;
    private final String storageType;
    private final Integer storageCapacity;
    private final String type;
    private final Map<String, String> tags;
    private final String uuid;
    private final String workflowBucketOwnerId;
    private final String readme;
    private final DefinitionRepositoryDetails definitionRepositoryDetails;
    private final String readmePath;

    private GetWorkflowVersionResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.workflowId = builder.workflowId;
        this.versionName = builder.versionName;
        this.accelerators = builder.accelerators;
        this.creationTime = builder.creationTime;
        this.description = builder.description;
        this.definition = builder.definition;
        this.digest = builder.digest;
        this.engine = builder.engine;
        this.main = builder.main;
        this.metadata = builder.metadata;
        this.parameterTemplate = builder.parameterTemplate;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.storageType = builder.storageType;
        this.storageCapacity = builder.storageCapacity;
        this.type = builder.type;
        this.tags = builder.tags;
        this.uuid = builder.uuid;
        this.workflowBucketOwnerId = builder.workflowBucketOwnerId;
        this.readme = builder.readme;
        this.definitionRepositoryDetails = builder.definitionRepositoryDetails;
        this.readmePath = builder.readmePath;
    }

    public final String arn() {
        return this.arn;
    }

    public final String workflowId() {
        return this.workflowId;
    }

    public final String versionName() {
        return this.versionName;
    }

    public final Accelerators accelerators() {
        return Accelerators.fromValue(this.accelerators);
    }

    public final String acceleratorsAsString() {
        return this.accelerators;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final String description() {
        return this.description;
    }

    public final String definition() {
        return this.definition;
    }

    public final String digest() {
        return this.digest;
    }

    public final WorkflowEngine engine() {
        return WorkflowEngine.fromValue(this.engine);
    }

    public final String engineAsString() {
        return this.engine;
    }

    public final String main() {
        return this.main;
    }

    public final boolean hasMetadata() {
        return this.metadata != null && !(this.metadata instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> metadata() {
        return this.metadata;
    }

    public final boolean hasParameterTemplate() {
        return this.parameterTemplate != null && !(this.parameterTemplate instanceof SdkAutoConstructMap);
    }

    public final Map<String, WorkflowParameter> parameterTemplate() {
        return this.parameterTemplate;
    }

    public final WorkflowStatus status() {
        return WorkflowStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final StorageType storageType() {
        return StorageType.fromValue(this.storageType);
    }

    public final String storageTypeAsString() {
        return this.storageType;
    }

    public final Integer storageCapacity() {
        return this.storageCapacity;
    }

    public final WorkflowType type() {
        return WorkflowType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String uuid() {
        return this.uuid;
    }

    public final String workflowBucketOwnerId() {
        return this.workflowBucketOwnerId;
    }

    public final String readme() {
        return this.readme;
    }

    public final DefinitionRepositoryDetails definitionRepositoryDetails() {
        return this.definitionRepositoryDetails;
    }

    public final String readmePath() {
        return this.readmePath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.definition());
        hashCode = 31 * hashCode + Objects.hashCode(this.digest());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.main());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMetadata() ? this.metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameterTemplate() ? this.parameterTemplate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.uuid());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowBucketOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.readme());
        hashCode = 31 * hashCode + Objects.hashCode(this.definitionRepositoryDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.readmePath());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowVersionResponse)) {
            return false;
        }
        GetWorkflowVersionResponse other = (GetWorkflowVersionResponse)((Object)obj);
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.workflowId(), other.workflowId()) && Objects.equals(this.versionName(), other.versionName()) && Objects.equals(this.acceleratorsAsString(), other.acceleratorsAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.definition(), other.definition()) && Objects.equals(this.digest(), other.digest()) && Objects.equals(this.engineAsString(), other.engineAsString()) && Objects.equals(this.main(), other.main()) && this.hasMetadata() == other.hasMetadata() && Objects.equals(this.metadata(), other.metadata()) && this.hasParameterTemplate() == other.hasParameterTemplate() && Objects.equals(this.parameterTemplate(), other.parameterTemplate()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.storageTypeAsString(), other.storageTypeAsString()) && Objects.equals(this.storageCapacity(), other.storageCapacity()) && Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.uuid(), other.uuid()) && Objects.equals(this.workflowBucketOwnerId(), other.workflowBucketOwnerId()) && Objects.equals(this.readme(), other.readme()) && Objects.equals(this.definitionRepositoryDetails(), other.definitionRepositoryDetails()) && Objects.equals(this.readmePath(), other.readmePath());
    }

    public final String toString() {
        return ToString.builder((String)"GetWorkflowVersionResponse").add("Arn", (Object)this.arn()).add("WorkflowId", (Object)this.workflowId()).add("VersionName", (Object)this.versionName()).add("Accelerators", (Object)this.acceleratorsAsString()).add("CreationTime", (Object)this.creationTime()).add("Description", (Object)this.description()).add("Definition", (Object)this.definition()).add("Digest", (Object)this.digest()).add("Engine", (Object)this.engineAsString()).add("Main", (Object)this.main()).add("Metadata", this.hasMetadata() ? this.metadata() : null).add("ParameterTemplate", this.hasParameterTemplate() ? this.parameterTemplate() : null).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("StorageType", (Object)this.storageTypeAsString()).add("StorageCapacity", (Object)this.storageCapacity()).add("Type", (Object)this.typeAsString()).add("Tags", this.hasTags() ? this.tags() : null).add("Uuid", (Object)this.uuid()).add("WorkflowBucketOwnerId", (Object)this.workflowBucketOwnerId()).add("Readme", (Object)this.readme()).add("DefinitionRepositoryDetails", (Object)this.definitionRepositoryDetails()).add("ReadmePath", (Object)this.readmePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "workflowId": {
                return Optional.ofNullable(clazz.cast(this.workflowId()));
            }
            case "versionName": {
                return Optional.ofNullable(clazz.cast(this.versionName()));
            }
            case "accelerators": {
                return Optional.ofNullable(clazz.cast(this.acceleratorsAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "definition": {
                return Optional.ofNullable(clazz.cast(this.definition()));
            }
            case "digest": {
                return Optional.ofNullable(clazz.cast(this.digest()));
            }
            case "engine": {
                return Optional.ofNullable(clazz.cast(this.engineAsString()));
            }
            case "main": {
                return Optional.ofNullable(clazz.cast(this.main()));
            }
            case "metadata": {
                return Optional.ofNullable(clazz.cast(this.metadata()));
            }
            case "parameterTemplate": {
                return Optional.ofNullable(clazz.cast(this.parameterTemplate()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "statusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "storageType": {
                return Optional.ofNullable(clazz.cast(this.storageTypeAsString()));
            }
            case "storageCapacity": {
                return Optional.ofNullable(clazz.cast(this.storageCapacity()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "uuid": {
                return Optional.ofNullable(clazz.cast(this.uuid()));
            }
            case "workflowBucketOwnerId": {
                return Optional.ofNullable(clazz.cast(this.workflowBucketOwnerId()));
            }
            case "readme": {
                return Optional.ofNullable(clazz.cast(this.readme()));
            }
            case "definitionRepositoryDetails": {
                return Optional.ofNullable(clazz.cast(this.definitionRepositoryDetails()));
            }
            case "readmePath": {
                return Optional.ofNullable(clazz.cast(this.readmePath()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("workflowId", WORKFLOW_ID_FIELD);
        map.put("versionName", VERSION_NAME_FIELD);
        map.put("accelerators", ACCELERATORS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("definition", DEFINITION_FIELD);
        map.put("digest", DIGEST_FIELD);
        map.put("engine", ENGINE_FIELD);
        map.put("main", MAIN_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("parameterTemplate", PARAMETER_TEMPLATE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("storageType", STORAGE_TYPE_FIELD);
        map.put("storageCapacity", STORAGE_CAPACITY_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("uuid", UUID_FIELD);
        map.put("workflowBucketOwnerId", WORKFLOW_BUCKET_OWNER_ID_FIELD);
        map.put("readme", README_FIELD);
        map.put("definitionRepositoryDetails", DEFINITION_REPOSITORY_DETAILS_FIELD);
        map.put("readmePath", README_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowVersionResponse, T> g) {
        return obj -> g.apply((GetWorkflowVersionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OmicsResponse.BuilderImpl
    implements Builder {
        private String arn;
        private String workflowId;
        private String versionName;
        private String accelerators;
        private Instant creationTime;
        private String description;
        private String definition;
        private String digest;
        private String engine;
        private String main;
        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, WorkflowParameter> parameterTemplate = DefaultSdkAutoConstructMap.getInstance();
        private String status;
        private String statusMessage;
        private String storageType;
        private Integer storageCapacity;
        private String type;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String uuid;
        private String workflowBucketOwnerId;
        private String readme;
        private DefinitionRepositoryDetails definitionRepositoryDetails;
        private String readmePath;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowVersionResponse model) {
            super(model);
            this.arn(model.arn);
            this.workflowId(model.workflowId);
            this.versionName(model.versionName);
            this.accelerators(model.accelerators);
            this.creationTime(model.creationTime);
            this.description(model.description);
            this.definition(model.definition);
            this.digest(model.digest);
            this.engine(model.engine);
            this.main(model.main);
            this.metadata(model.metadata);
            this.parameterTemplate(model.parameterTemplate);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.storageType(model.storageType);
            this.storageCapacity(model.storageCapacity);
            this.type(model.type);
            this.tags(model.tags);
            this.uuid(model.uuid);
            this.workflowBucketOwnerId(model.workflowBucketOwnerId);
            this.readme(model.readme);
            this.definitionRepositoryDetails(model.definitionRepositoryDetails);
            this.readmePath(model.readmePath);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getWorkflowId() {
            return this.workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getVersionName() {
            return this.versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getAccelerators() {
            return this.accelerators;
        }

        public final void setAccelerators(String accelerators) {
            this.accelerators = accelerators;
        }

        @Override
        public final Builder accelerators(String accelerators) {
            this.accelerators = accelerators;
            return this;
        }

        @Override
        public final Builder accelerators(Accelerators accelerators) {
            this.accelerators(accelerators == null ? null : accelerators.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDefinition() {
            return this.definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final String getDigest() {
            return this.digest;
        }

        public final void setDigest(String digest) {
            this.digest = digest;
        }

        @Override
        public final Builder digest(String digest) {
            this.digest = digest;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        @Override
        public final Builder engine(WorkflowEngine engine) {
            this.engine(engine == null ? null : engine.toString());
            return this;
        }

        public final String getMain() {
            return this.main;
        }

        public final void setMain(String main) {
            this.main = main;
        }

        @Override
        public final Builder main(String main) {
            this.main = main;
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (this.metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = WorkflowMetadataCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = WorkflowMetadataCopier.copy(metadata);
            return this;
        }

        public final Map<String, WorkflowParameter.Builder> getParameterTemplate() {
            Map<String, WorkflowParameter.Builder> result = WorkflowParameterTemplateCopier.copyToBuilder(this.parameterTemplate);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameterTemplate(Map<String, WorkflowParameter.BuilderImpl> parameterTemplate) {
            this.parameterTemplate = WorkflowParameterTemplateCopier.copyFromBuilder(parameterTemplate);
        }

        @Override
        public final Builder parameterTemplate(Map<String, WorkflowParameter> parameterTemplate) {
            this.parameterTemplate = WorkflowParameterTemplateCopier.copy(parameterTemplate);
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkflowStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getStorageType() {
            return this.storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final Integer getStorageCapacity() {
            return this.storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WorkflowType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getUuid() {
            return this.uuid;
        }

        public final void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public final String getWorkflowBucketOwnerId() {
            return this.workflowBucketOwnerId;
        }

        public final void setWorkflowBucketOwnerId(String workflowBucketOwnerId) {
            this.workflowBucketOwnerId = workflowBucketOwnerId;
        }

        @Override
        public final Builder workflowBucketOwnerId(String workflowBucketOwnerId) {
            this.workflowBucketOwnerId = workflowBucketOwnerId;
            return this;
        }

        public final String getReadme() {
            return this.readme;
        }

        public final void setReadme(String readme) {
            this.readme = readme;
        }

        @Override
        public final Builder readme(String readme) {
            this.readme = readme;
            return this;
        }

        public final DefinitionRepositoryDetails.Builder getDefinitionRepositoryDetails() {
            return this.definitionRepositoryDetails != null ? this.definitionRepositoryDetails.toBuilder() : null;
        }

        public final void setDefinitionRepositoryDetails(DefinitionRepositoryDetails.BuilderImpl definitionRepositoryDetails) {
            this.definitionRepositoryDetails = definitionRepositoryDetails != null ? definitionRepositoryDetails.build() : null;
        }

        @Override
        public final Builder definitionRepositoryDetails(DefinitionRepositoryDetails definitionRepositoryDetails) {
            this.definitionRepositoryDetails = definitionRepositoryDetails;
            return this;
        }

        public final String getReadmePath() {
            return this.readmePath;
        }

        public final void setReadmePath(String readmePath) {
            this.readmePath = readmePath;
        }

        @Override
        public final Builder readmePath(String readmePath) {
            this.readmePath = readmePath;
            return this;
        }

        @Override
        public GetWorkflowVersionResponse build() {
            return new GetWorkflowVersionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends OmicsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetWorkflowVersionResponse> {
        public Builder arn(String var1);

        public Builder workflowId(String var1);

        public Builder versionName(String var1);

        public Builder accelerators(String var1);

        public Builder accelerators(Accelerators var1);

        public Builder creationTime(Instant var1);

        public Builder description(String var1);

        public Builder definition(String var1);

        public Builder digest(String var1);

        public Builder engine(String var1);

        public Builder engine(WorkflowEngine var1);

        public Builder main(String var1);

        public Builder metadata(Map<String, String> var1);

        public Builder parameterTemplate(Map<String, WorkflowParameter> var1);

        public Builder status(String var1);

        public Builder status(WorkflowStatus var1);

        public Builder statusMessage(String var1);

        public Builder storageType(String var1);

        public Builder storageType(StorageType var1);

        public Builder storageCapacity(Integer var1);

        public Builder type(String var1);

        public Builder type(WorkflowType var1);

        public Builder tags(Map<String, String> var1);

        public Builder uuid(String var1);

        public Builder workflowBucketOwnerId(String var1);

        public Builder readme(String var1);

        public Builder definitionRepositoryDetails(DefinitionRepositoryDetails var1);

        default public Builder definitionRepositoryDetails(Consumer<DefinitionRepositoryDetails.Builder> definitionRepositoryDetails) {
            return this.definitionRepositoryDetails((DefinitionRepositoryDetails)((DefinitionRepositoryDetails.Builder)DefinitionRepositoryDetails.builder().applyMutation(definitionRepositoryDetails)).build());
        }

        public Builder readmePath(String var1);
    }
}

