/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics;

import static software.amazon.awssdk.utils.FunctionalUtils.runAndLogError;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.AsyncResponseTransformerUtils;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.AsyncStreamingRequestMarshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.omics.internal.OmicsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.omics.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.omics.model.AbortMultipartReadSetUploadRequest;
import software.amazon.awssdk.services.omics.model.AbortMultipartReadSetUploadResponse;
import software.amazon.awssdk.services.omics.model.AcceptShareRequest;
import software.amazon.awssdk.services.omics.model.AcceptShareResponse;
import software.amazon.awssdk.services.omics.model.AccessDeniedException;
import software.amazon.awssdk.services.omics.model.BatchDeleteReadSetRequest;
import software.amazon.awssdk.services.omics.model.BatchDeleteReadSetResponse;
import software.amazon.awssdk.services.omics.model.CancelAnnotationImportJobRequest;
import software.amazon.awssdk.services.omics.model.CancelAnnotationImportJobResponse;
import software.amazon.awssdk.services.omics.model.CancelRunRequest;
import software.amazon.awssdk.services.omics.model.CancelRunResponse;
import software.amazon.awssdk.services.omics.model.CancelVariantImportJobRequest;
import software.amazon.awssdk.services.omics.model.CancelVariantImportJobResponse;
import software.amazon.awssdk.services.omics.model.CompleteMultipartReadSetUploadRequest;
import software.amazon.awssdk.services.omics.model.CompleteMultipartReadSetUploadResponse;
import software.amazon.awssdk.services.omics.model.ConflictException;
import software.amazon.awssdk.services.omics.model.CreateAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateAnnotationStoreVersionRequest;
import software.amazon.awssdk.services.omics.model.CreateAnnotationStoreVersionResponse;
import software.amazon.awssdk.services.omics.model.CreateMultipartReadSetUploadRequest;
import software.amazon.awssdk.services.omics.model.CreateMultipartReadSetUploadResponse;
import software.amazon.awssdk.services.omics.model.CreateReferenceStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateReferenceStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateRunCacheRequest;
import software.amazon.awssdk.services.omics.model.CreateRunCacheResponse;
import software.amazon.awssdk.services.omics.model.CreateRunGroupRequest;
import software.amazon.awssdk.services.omics.model.CreateRunGroupResponse;
import software.amazon.awssdk.services.omics.model.CreateSequenceStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateSequenceStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateShareRequest;
import software.amazon.awssdk.services.omics.model.CreateShareResponse;
import software.amazon.awssdk.services.omics.model.CreateVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateWorkflowRequest;
import software.amazon.awssdk.services.omics.model.CreateWorkflowResponse;
import software.amazon.awssdk.services.omics.model.CreateWorkflowVersionRequest;
import software.amazon.awssdk.services.omics.model.CreateWorkflowVersionResponse;
import software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreVersionsRequest;
import software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreVersionsResponse;
import software.amazon.awssdk.services.omics.model.DeleteReferenceRequest;
import software.amazon.awssdk.services.omics.model.DeleteReferenceResponse;
import software.amazon.awssdk.services.omics.model.DeleteReferenceStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteReferenceStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteRunCacheRequest;
import software.amazon.awssdk.services.omics.model.DeleteRunCacheResponse;
import software.amazon.awssdk.services.omics.model.DeleteRunGroupRequest;
import software.amazon.awssdk.services.omics.model.DeleteRunGroupResponse;
import software.amazon.awssdk.services.omics.model.DeleteRunRequest;
import software.amazon.awssdk.services.omics.model.DeleteRunResponse;
import software.amazon.awssdk.services.omics.model.DeleteS3AccessPolicyRequest;
import software.amazon.awssdk.services.omics.model.DeleteS3AccessPolicyResponse;
import software.amazon.awssdk.services.omics.model.DeleteSequenceStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteSequenceStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteShareRequest;
import software.amazon.awssdk.services.omics.model.DeleteShareResponse;
import software.amazon.awssdk.services.omics.model.DeleteVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteWorkflowRequest;
import software.amazon.awssdk.services.omics.model.DeleteWorkflowResponse;
import software.amazon.awssdk.services.omics.model.DeleteWorkflowVersionRequest;
import software.amazon.awssdk.services.omics.model.DeleteWorkflowVersionResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreVersionRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreVersionResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetActivationJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetActivationJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetExportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetExportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetMetadataRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetMetadataResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceMetadataRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceMetadataResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceStoreRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceStoreResponse;
import software.amazon.awssdk.services.omics.model.GetRunCacheRequest;
import software.amazon.awssdk.services.omics.model.GetRunCacheResponse;
import software.amazon.awssdk.services.omics.model.GetRunGroupRequest;
import software.amazon.awssdk.services.omics.model.GetRunGroupResponse;
import software.amazon.awssdk.services.omics.model.GetRunRequest;
import software.amazon.awssdk.services.omics.model.GetRunResponse;
import software.amazon.awssdk.services.omics.model.GetRunTaskRequest;
import software.amazon.awssdk.services.omics.model.GetRunTaskResponse;
import software.amazon.awssdk.services.omics.model.GetS3AccessPolicyRequest;
import software.amazon.awssdk.services.omics.model.GetS3AccessPolicyResponse;
import software.amazon.awssdk.services.omics.model.GetSequenceStoreRequest;
import software.amazon.awssdk.services.omics.model.GetSequenceStoreResponse;
import software.amazon.awssdk.services.omics.model.GetShareRequest;
import software.amazon.awssdk.services.omics.model.GetShareResponse;
import software.amazon.awssdk.services.omics.model.GetVariantImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetVariantImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.GetVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.GetWorkflowRequest;
import software.amazon.awssdk.services.omics.model.GetWorkflowResponse;
import software.amazon.awssdk.services.omics.model.GetWorkflowVersionRequest;
import software.amazon.awssdk.services.omics.model.GetWorkflowVersionResponse;
import software.amazon.awssdk.services.omics.model.InternalServerException;
import software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoreVersionsRequest;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoreVersionsResponse;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoresResponse;
import software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsRequest;
import software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetExportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetsResponse;
import software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReferenceImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest;
import software.amazon.awssdk.services.omics.model.ListReferenceStoresResponse;
import software.amazon.awssdk.services.omics.model.ListReferencesRequest;
import software.amazon.awssdk.services.omics.model.ListReferencesResponse;
import software.amazon.awssdk.services.omics.model.ListRunCachesRequest;
import software.amazon.awssdk.services.omics.model.ListRunCachesResponse;
import software.amazon.awssdk.services.omics.model.ListRunGroupsRequest;
import software.amazon.awssdk.services.omics.model.ListRunGroupsResponse;
import software.amazon.awssdk.services.omics.model.ListRunTasksRequest;
import software.amazon.awssdk.services.omics.model.ListRunTasksResponse;
import software.amazon.awssdk.services.omics.model.ListRunsRequest;
import software.amazon.awssdk.services.omics.model.ListRunsResponse;
import software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest;
import software.amazon.awssdk.services.omics.model.ListSequenceStoresResponse;
import software.amazon.awssdk.services.omics.model.ListSharesRequest;
import software.amazon.awssdk.services.omics.model.ListSharesResponse;
import software.amazon.awssdk.services.omics.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.omics.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListVariantImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListVariantStoresRequest;
import software.amazon.awssdk.services.omics.model.ListVariantStoresResponse;
import software.amazon.awssdk.services.omics.model.ListWorkflowVersionsRequest;
import software.amazon.awssdk.services.omics.model.ListWorkflowVersionsResponse;
import software.amazon.awssdk.services.omics.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.omics.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.omics.model.NotSupportedOperationException;
import software.amazon.awssdk.services.omics.model.OmicsException;
import software.amazon.awssdk.services.omics.model.PutS3AccessPolicyRequest;
import software.amazon.awssdk.services.omics.model.PutS3AccessPolicyResponse;
import software.amazon.awssdk.services.omics.model.RangeNotSatisfiableException;
import software.amazon.awssdk.services.omics.model.RequestTimeoutException;
import software.amazon.awssdk.services.omics.model.ResourceNotFoundException;
import software.amazon.awssdk.services.omics.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.omics.model.StartAnnotationImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartAnnotationImportJobResponse;
import software.amazon.awssdk.services.omics.model.StartReadSetActivationJobRequest;
import software.amazon.awssdk.services.omics.model.StartReadSetActivationJobResponse;
import software.amazon.awssdk.services.omics.model.StartReadSetExportJobRequest;
import software.amazon.awssdk.services.omics.model.StartReadSetExportJobResponse;
import software.amazon.awssdk.services.omics.model.StartReadSetImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartReadSetImportJobResponse;
import software.amazon.awssdk.services.omics.model.StartReferenceImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartReferenceImportJobResponse;
import software.amazon.awssdk.services.omics.model.StartRunRequest;
import software.amazon.awssdk.services.omics.model.StartRunResponse;
import software.amazon.awssdk.services.omics.model.StartVariantImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartVariantImportJobResponse;
import software.amazon.awssdk.services.omics.model.TagResourceRequest;
import software.amazon.awssdk.services.omics.model.TagResourceResponse;
import software.amazon.awssdk.services.omics.model.ThrottlingException;
import software.amazon.awssdk.services.omics.model.UntagResourceRequest;
import software.amazon.awssdk.services.omics.model.UntagResourceResponse;
import software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreVersionRequest;
import software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreVersionResponse;
import software.amazon.awssdk.services.omics.model.UpdateRunCacheRequest;
import software.amazon.awssdk.services.omics.model.UpdateRunCacheResponse;
import software.amazon.awssdk.services.omics.model.UpdateRunGroupRequest;
import software.amazon.awssdk.services.omics.model.UpdateRunGroupResponse;
import software.amazon.awssdk.services.omics.model.UpdateSequenceStoreRequest;
import software.amazon.awssdk.services.omics.model.UpdateSequenceStoreResponse;
import software.amazon.awssdk.services.omics.model.UpdateVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.UpdateVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.UpdateWorkflowRequest;
import software.amazon.awssdk.services.omics.model.UpdateWorkflowResponse;
import software.amazon.awssdk.services.omics.model.UpdateWorkflowVersionRequest;
import software.amazon.awssdk.services.omics.model.UpdateWorkflowVersionResponse;
import software.amazon.awssdk.services.omics.model.UploadReadSetPartRequest;
import software.amazon.awssdk.services.omics.model.UploadReadSetPartResponse;
import software.amazon.awssdk.services.omics.model.ValidationException;
import software.amazon.awssdk.services.omics.transform.AbortMultipartReadSetUploadRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.AcceptShareRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.BatchDeleteReadSetRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CancelAnnotationImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CancelRunRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CancelVariantImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CompleteMultipartReadSetUploadRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateAnnotationStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateAnnotationStoreVersionRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateMultipartReadSetUploadRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateReferenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateRunCacheRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateRunGroupRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateSequenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateShareRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateVariantStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateWorkflowRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateWorkflowVersionRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteAnnotationStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteAnnotationStoreVersionsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteReferenceRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteReferenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteRunCacheRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteRunGroupRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteRunRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteS3AccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteSequenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteShareRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteVariantStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteWorkflowRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteWorkflowVersionRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetAnnotationImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetAnnotationStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetAnnotationStoreVersionRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReadSetActivationJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReadSetExportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReadSetImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReadSetMetadataRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReadSetRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReferenceImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReferenceMetadataRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReferenceRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReferenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetRunCacheRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetRunGroupRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetRunRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetRunTaskRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetS3AccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetSequenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetShareRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetVariantImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetVariantStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetWorkflowRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetWorkflowVersionRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListAnnotationImportJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListAnnotationStoreVersionsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListAnnotationStoresRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListMultipartReadSetUploadsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReadSetActivationJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReadSetExportJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReadSetImportJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReadSetUploadPartsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReadSetsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReferenceImportJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReferenceStoresRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReferencesRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListRunCachesRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListRunGroupsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListRunTasksRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListRunsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListSequenceStoresRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListSharesRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListVariantImportJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListVariantStoresRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListWorkflowVersionsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListWorkflowsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.PutS3AccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartAnnotationImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartReadSetActivationJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartReadSetExportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartReadSetImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartReferenceImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartRunRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartVariantImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateAnnotationStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateAnnotationStoreVersionRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateRunCacheRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateRunGroupRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateSequenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateVariantStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateWorkflowRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateWorkflowVersionRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UploadReadSetPartRequestMarshaller;
import software.amazon.awssdk.services.omics.waiters.OmicsAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Pair;

/**
 * Internal implementation of {@link OmicsAsyncClient}.
 *
 * @see OmicsAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultOmicsAsyncClient implements OmicsAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultOmicsAsyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    private final ScheduledExecutorService executorService;

    protected DefaultOmicsAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "Omics" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
        this.executorService = clientConfiguration.option(SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    /**
     * <p>
     * Stops a multipart read set upload into a sequence store and returns a response with no body if the operation is
     * successful. To confirm that a multipart read set upload has been stopped, use the
     * <code>ListMultipartReadSetUploads</code> API operation to view all active multipart read set uploads.
     * </p>
     *
     * @param abortMultipartReadSetUploadRequest
     * @return A Java Future containing the result of the AbortMultipartReadSetUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.AbortMultipartReadSetUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/AbortMultipartReadSetUpload"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<AbortMultipartReadSetUploadResponse> abortMultipartReadSetUpload(
            AbortMultipartReadSetUploadRequest abortMultipartReadSetUploadRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(abortMultipartReadSetUploadRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, abortMultipartReadSetUploadRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AbortMultipartReadSetUpload");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AbortMultipartReadSetUploadResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, AbortMultipartReadSetUploadResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<AbortMultipartReadSetUploadResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AbortMultipartReadSetUploadRequest, AbortMultipartReadSetUploadResponse>()
                            .withOperationName("AbortMultipartReadSetUpload").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AbortMultipartReadSetUploadRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(abortMultipartReadSetUploadRequest));
            CompletableFuture<AbortMultipartReadSetUploadResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Accept a resource share request.
     * </p>
     *
     * @param acceptShareRequest
     * @return A Java Future containing the result of the AcceptShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.AcceptShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/AcceptShare" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<AcceptShareResponse> acceptShare(AcceptShareRequest acceptShareRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<AcceptShareResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    AcceptShareResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<AcceptShareResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<AcceptShareRequest, AcceptShareResponse>()
                            .withOperationName("AcceptShare").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new AcceptShareRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(acceptShareRequest));
            CompletableFuture<AcceptShareResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes one or more read sets. If the operation is successful, it returns a response with no body. If there is an
     * error with deleting one of the read sets, the operation returns an error list. If the operation successfully
     * deletes only a subset of files, it will return an error list for the remaining files that fail to be deleted.
     * There is a limit of 100 read sets that can be deleted in each <code>BatchDeleteReadSet</code> API call.
     * </p>
     *
     * @param batchDeleteReadSetRequest
     * @return A Java Future containing the result of the BatchDeleteReadSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.BatchDeleteReadSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/BatchDeleteReadSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<BatchDeleteReadSetResponse> batchDeleteReadSet(BatchDeleteReadSetRequest batchDeleteReadSetRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteReadSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDeleteReadSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteReadSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<BatchDeleteReadSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, BatchDeleteReadSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<BatchDeleteReadSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<BatchDeleteReadSetRequest, BatchDeleteReadSetResponse>()
                            .withOperationName("BatchDeleteReadSet").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new BatchDeleteReadSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(batchDeleteReadSetRequest));
            CompletableFuture<BatchDeleteReadSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels an annotation import job.
     * </p>
     *
     * @param cancelAnnotationImportJobRequest
     * @return A Java Future containing the result of the CancelAnnotationImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CancelAnnotationImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelAnnotationImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelAnnotationImportJobResponse> cancelAnnotationImportJob(
            CancelAnnotationImportJobRequest cancelAnnotationImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelAnnotationImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelAnnotationImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelAnnotationImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelAnnotationImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelAnnotationImportJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<CancelAnnotationImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelAnnotationImportJobRequest, CancelAnnotationImportJobResponse>()
                            .withOperationName("CancelAnnotationImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelAnnotationImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(cancelAnnotationImportJobRequest));
            CompletableFuture<CancelAnnotationImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a run using its ID and returns a response with no body if the operation is successful. To confirm that
     * the run has been cancelled, use the <code>ListRuns</code> API operation to check that it is no longer listed.
     * </p>
     *
     * @param cancelRunRequest
     * @return A Java Future containing the result of the CancelRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CancelRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CancelRunResponse> cancelRun(CancelRunRequest cancelRunRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelRunRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CancelRunResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<CancelRunResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelRunRequest, CancelRunResponse>().withOperationName("CancelRun")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelRunRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression)
                            .withInput(cancelRunRequest));
            CompletableFuture<CancelRunResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Cancels a variant import job.
     * </p>
     *
     * @param cancelVariantImportJobRequest
     * @return A Java Future containing the result of the CancelVariantImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CancelVariantImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelVariantImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelVariantImportJobResponse> cancelVariantImportJob(
            CancelVariantImportJobRequest cancelVariantImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelVariantImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelVariantImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelVariantImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelVariantImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelVariantImportJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<CancelVariantImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelVariantImportJobRequest, CancelVariantImportJobResponse>()
                            .withOperationName("CancelVariantImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CancelVariantImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(cancelVariantImportJobRequest));
            CompletableFuture<CancelVariantImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Completes a multipart read set upload into a sequence store after you have initiated the upload process with
     * <code>CreateMultipartReadSetUpload</code> and uploaded all read set parts using <code>UploadReadSetPart</code>.
     * You must specify the parts you uploaded using the parts parameter. If the operation is successful, it returns the
     * read set ID(s) of the uploaded read set(s).
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/synchronous-uploads.html">Direct
     * upload to a sequence store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param completeMultipartReadSetUploadRequest
     * @return A Java Future containing the result of the CompleteMultipartReadSetUpload operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CompleteMultipartReadSetUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CompleteMultipartReadSetUpload"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CompleteMultipartReadSetUploadResponse> completeMultipartReadSetUpload(
            CompleteMultipartReadSetUploadRequest completeMultipartReadSetUploadRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(completeMultipartReadSetUploadRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                completeMultipartReadSetUploadRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CompleteMultipartReadSetUpload");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CompleteMultipartReadSetUploadResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CompleteMultipartReadSetUploadResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "storage-";
            String resolvedHostExpression = "storage-";

            CompletableFuture<CompleteMultipartReadSetUploadResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CompleteMultipartReadSetUploadRequest, CompleteMultipartReadSetUploadResponse>()
                            .withOperationName("CompleteMultipartReadSetUpload").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CompleteMultipartReadSetUploadRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(completeMultipartReadSetUploadRequest));
            CompletableFuture<CompleteMultipartReadSetUploadResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an annotation store.
     * </p>
     *
     * @param createAnnotationStoreRequest
     * @return A Java Future containing the result of the CreateAnnotationStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateAnnotationStore" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAnnotationStoreResponse> createAnnotationStore(
            CreateAnnotationStoreRequest createAnnotationStoreRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAnnotationStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAnnotationStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAnnotationStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAnnotationStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAnnotationStoreResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<CreateAnnotationStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAnnotationStoreRequest, CreateAnnotationStoreResponse>()
                            .withOperationName("CreateAnnotationStore").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAnnotationStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createAnnotationStoreRequest));
            CompletableFuture<CreateAnnotationStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new version of an annotation store.
     * </p>
     *
     * @param createAnnotationStoreVersionRequest
     * @return A Java Future containing the result of the CreateAnnotationStoreVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateAnnotationStoreVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateAnnotationStoreVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAnnotationStoreVersionResponse> createAnnotationStoreVersion(
            CreateAnnotationStoreVersionRequest createAnnotationStoreVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAnnotationStoreVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAnnotationStoreVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAnnotationStoreVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAnnotationStoreVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAnnotationStoreVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<CreateAnnotationStoreVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAnnotationStoreVersionRequest, CreateAnnotationStoreVersionResponse>()
                            .withOperationName("CreateAnnotationStoreVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateAnnotationStoreVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createAnnotationStoreVersionRequest));
            CompletableFuture<CreateAnnotationStoreVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Initiates a multipart read set upload for uploading partitioned source files into a sequence store. You can
     * directly import source files from an EC2 instance and other local compute, or from an S3 bucket. To separate
     * these source files into parts, use the <code>split</code> operation. Each part cannot be larger than 100 MB. If
     * the operation is successful, it provides an <code>uploadId</code> which is required by the
     * <code>UploadReadSetPart</code> API operation to upload parts into a sequence store.
     * </p>
     * <p>
     * To continue uploading a multipart read set into your sequence store, you must use the
     * <code>UploadReadSetPart</code> API operation to upload each part individually following the steps below:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify the <code>uploadId</code> obtained from the previous call to <code>CreateMultipartReadSetUpload</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Upload parts for that <code>uploadId</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you have finished uploading parts, use the <code>CompleteMultipartReadSetUpload</code> API to complete the
     * multipart read set upload and to retrieve the final read set IDs in the response.
     * </p>
     * <p>
     * To learn more about creating parts and the <code>split</code> operation, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/synchronous-uploads.html">Direct upload to a sequence
     * store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param createMultipartReadSetUploadRequest
     * @return A Java Future containing the result of the CreateMultipartReadSetUpload operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateMultipartReadSetUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateMultipartReadSetUpload"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateMultipartReadSetUploadResponse> createMultipartReadSetUpload(
            CreateMultipartReadSetUploadRequest createMultipartReadSetUploadRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMultipartReadSetUploadRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMultipartReadSetUploadRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMultipartReadSetUpload");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateMultipartReadSetUploadResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateMultipartReadSetUploadResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<CreateMultipartReadSetUploadResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateMultipartReadSetUploadRequest, CreateMultipartReadSetUploadResponse>()
                            .withOperationName("CreateMultipartReadSetUpload").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateMultipartReadSetUploadRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createMultipartReadSetUploadRequest));
            CompletableFuture<CreateMultipartReadSetUploadResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a reference store and returns metadata in JSON format. Reference stores are used to store reference
     * genomes in FASTA format. A reference store is created when the first reference genome is imported. To import
     * additional reference genomes from an Amazon S3 bucket, use the <code>StartReferenceImportJob</code> API
     * operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-reference-store.html">Creating a HealthOmics reference
     * store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param createReferenceStoreRequest
     * @return A Java Future containing the result of the CreateReferenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateReferenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateReferenceStore" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateReferenceStoreResponse> createReferenceStore(
            CreateReferenceStoreRequest createReferenceStoreRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createReferenceStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createReferenceStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateReferenceStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateReferenceStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateReferenceStoreResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<CreateReferenceStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateReferenceStoreRequest, CreateReferenceStoreResponse>()
                            .withOperationName("CreateReferenceStore").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateReferenceStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createReferenceStoreRequest));
            CompletableFuture<CreateReferenceStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a run cache to store and reference task outputs from completed private runs. Specify an Amazon S3
     * location where Amazon Web Services HealthOmics saves the cached data. This data must be immediately accessible
     * and not in an archived state. You can save intermediate task files to a run cache if they are declared as task
     * outputs in the workflow definition file.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflows-call-caching.html">Call
     * caching</a> and <a href="https://docs.aws.amazon.com/omics/latest/dev/workflow-cache-create.html">Creating a run
     * cache</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param createRunCacheRequest
     * @return A Java Future containing the result of the CreateRunCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateRunCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateRunCache" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRunCacheResponse> createRunCache(CreateRunCacheRequest createRunCacheRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRunCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRunCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRunCache");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRunCacheResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRunCacheResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<CreateRunCacheResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRunCacheRequest, CreateRunCacheResponse>()
                            .withOperationName("CreateRunCache").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRunCacheRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createRunCacheRequest));
            CompletableFuture<CreateRunCacheResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a run group to limit the compute resources for the runs that are added to the group. Returns an ARN, ID,
     * and tags for the run group.
     * </p>
     *
     * @param createRunGroupRequest
     * @return A Java Future containing the result of the CreateRunGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateRunGroupResponse> createRunGroup(CreateRunGroupRequest createRunGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRunGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRunGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRunGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateRunGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateRunGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<CreateRunGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateRunGroupRequest, CreateRunGroupResponse>()
                            .withOperationName("CreateRunGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateRunGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createRunGroupRequest));
            CompletableFuture<CreateRunGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a sequence store and returns its metadata. Sequence stores are used to store sequence data files called
     * read sets that are saved in FASTQ, BAM, uBAM, or CRAM formats. For aligned formats (BAM and CRAM), a sequence
     * store can only use one reference genome. For unaligned formats (FASTQ and uBAM), a reference genome is not
     * required. You can create multiple sequence stores per region per account.
     * </p>
     * <p>
     * The following are optional parameters you can specify for your sequence store:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>s3AccessConfig</code> to configure your sequence store with S3 access logs (recommended).
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>sseConfig</code> to define your own KMS key for encryption.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>eTagAlgorithmFamily</code> to define which algorithm to use for the HealthOmics eTag on objects.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>fallbackLocation</code> to define a backup location for storing files that have failed a direct upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>propagatedSetLevelTags</code> to configure tags that propagate to all objects in your store.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-sequence-store.html">Creating a HealthOmics sequence
     * store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param createSequenceStoreRequest
     * @return A Java Future containing the result of the CreateSequenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateSequenceStoreResponse> createSequenceStore(
            CreateSequenceStoreRequest createSequenceStoreRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSequenceStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSequenceStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSequenceStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateSequenceStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateSequenceStoreResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<CreateSequenceStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateSequenceStoreRequest, CreateSequenceStoreResponse>()
                            .withOperationName("CreateSequenceStore").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateSequenceStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createSequenceStoreRequest));
            CompletableFuture<CreateSequenceStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a cross-account shared resource. The resource owner makes an offer to share the resource with the
     * principal subscriber (an AWS user with a different account than the resource owner).
     * </p>
     * <p>
     * The following resources support cross-account sharing:
     * </p>
     * <ul>
     * <li>
     * <p>
     * HealthOmics variant stores
     * </p>
     * </li>
     * <li>
     * <p>
     * HealthOmics annotation stores
     * </p>
     * </li>
     * <li>
     * <p>
     * Private workflows
     * </p>
     * </li>
     * </ul>
     *
     * @param createShareRequest
     * @return A Java Future containing the result of the CreateShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateShare" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateShareResponse> createShare(CreateShareRequest createShareRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateShareResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateShareResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<CreateShareResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateShareRequest, CreateShareResponse>()
                            .withOperationName("CreateShare").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateShareRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createShareRequest));
            CompletableFuture<CreateShareResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a variant store.
     * </p>
     *
     * @param createVariantStoreRequest
     * @return A Java Future containing the result of the CreateVariantStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateVariantStoreResponse> createVariantStore(CreateVariantStoreRequest createVariantStoreRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVariantStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVariantStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVariantStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateVariantStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateVariantStoreResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<CreateVariantStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateVariantStoreRequest, CreateVariantStoreResponse>()
                            .withOperationName("CreateVariantStore").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateVariantStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createVariantStoreRequest));
            CompletableFuture<CreateVariantStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a private workflow. Before you create a private workflow, you must create and configure these required
     * resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Workflow definition files</i>: Define your workflow in one or more workflow definition files, written in WDL,
     * Nextflow, or CWL. The workflow definition specifies the inputs and outputs for runs that use the workflow. It
     * also includes specifications for the runs and run tasks for your workflow, including compute and memory
     * requirements. The workflow definition file must be in .zip format.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) <i>Parameter template</i>: You can create a parameter template file that defines the run parameters,
     * or Amazon Web Services HealthOmics can generate the parameter template for you.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>ECR container images</i>: Create container images for the workflow in a private ECR repository, or synchronize
     * images from a supported upstream registry with your Amazon ECR private repository.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) <i>Sentieon licenses</i>: Request a Sentieon license if using the Sentieon software in a private
     * workflow.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/creating-private-workflows.html">Creating or updating a
     * private workflow in Amazon Web Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param createWorkflowRequest
     * @return A Java Future containing the result of the CreateWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWorkflowResponse> createWorkflow(CreateWorkflowRequest createWorkflowRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkflowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkflow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateWorkflowResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<CreateWorkflowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWorkflowRequest, CreateWorkflowResponse>()
                            .withOperationName("CreateWorkflow").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateWorkflowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createWorkflowRequest));
            CompletableFuture<CreateWorkflowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a new workflow version for the workflow that you specify with the <code>workflowId</code> parameter.
     * </p>
     * <p>
     * When you create a new version of a workflow, you need to specify the configuration for the new version. It
     * doesn't inherit any configuration values from the workflow.
     * </p>
     * <p>
     * Provide a version name that is unique for this workflow. You cannot change the name after HealthOmics creates the
     * version.
     * </p>
     * <note>
     * <p>
     * Don't include any personally identifiable information (PII) in the version name. Version names appear in the
     * workflow version ARN.
     * </p>
     * </note>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html">Workflow
     * versioning in Amazon Web Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param createWorkflowVersionRequest
     * @return A Java Future containing the result of the CreateWorkflowVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateWorkflowVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateWorkflowVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateWorkflowVersionResponse> createWorkflowVersion(
            CreateWorkflowVersionRequest createWorkflowVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkflowVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkflowVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkflowVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateWorkflowVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateWorkflowVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<CreateWorkflowVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateWorkflowVersionRequest, CreateWorkflowVersionResponse>()
                            .withOperationName("CreateWorkflowVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new CreateWorkflowVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(createWorkflowVersionRequest));
            CompletableFuture<CreateWorkflowVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an annotation store.
     * </p>
     *
     * @param deleteAnnotationStoreRequest
     * @return A Java Future containing the result of the DeleteAnnotationStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteAnnotationStore" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAnnotationStoreResponse> deleteAnnotationStore(
            DeleteAnnotationStoreRequest deleteAnnotationStoreRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAnnotationStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAnnotationStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAnnotationStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAnnotationStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAnnotationStoreResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<DeleteAnnotationStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAnnotationStoreRequest, DeleteAnnotationStoreResponse>()
                            .withOperationName("DeleteAnnotationStore").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAnnotationStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteAnnotationStoreRequest));
            CompletableFuture<DeleteAnnotationStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes one or multiple versions of an annotation store.
     * </p>
     *
     * @param deleteAnnotationStoreVersionsRequest
     * @return A Java Future containing the result of the DeleteAnnotationStoreVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteAnnotationStoreVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteAnnotationStoreVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAnnotationStoreVersionsResponse> deleteAnnotationStoreVersions(
            DeleteAnnotationStoreVersionsRequest deleteAnnotationStoreVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAnnotationStoreVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteAnnotationStoreVersionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAnnotationStoreVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAnnotationStoreVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAnnotationStoreVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<DeleteAnnotationStoreVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAnnotationStoreVersionsRequest, DeleteAnnotationStoreVersionsResponse>()
                            .withOperationName("DeleteAnnotationStoreVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteAnnotationStoreVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteAnnotationStoreVersionsRequest));
            CompletableFuture<DeleteAnnotationStoreVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a reference genome and returns a response with no body if the operation is successful. The read set
     * associated with the reference genome must first be deleted before deleting the reference genome. After the
     * reference genome is deleted, you can delete the reference store using the <code>DeleteReferenceStore</code> API
     * operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/deleting-reference-and-sequence-stores.html">Deleting
     * HealthOmics reference and sequence stores</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param deleteReferenceRequest
     * @return A Java Future containing the result of the DeleteReference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteReference" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteReferenceResponse> deleteReference(DeleteReferenceRequest deleteReferenceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteReferenceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteReferenceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReference");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteReferenceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteReferenceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<DeleteReferenceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteReferenceRequest, DeleteReferenceResponse>()
                            .withOperationName("DeleteReference").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteReferenceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteReferenceRequest));
            CompletableFuture<DeleteReferenceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a reference store and returns a response with no body if the operation is successful. You can only delete
     * a reference store when it does not contain any reference genomes. To empty a reference store, use
     * <code>DeleteReference</code>.
     * </p>
     * <p>
     * For more information about your workflow status, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/deleting-reference-and-sequence-stores.html">Deleting
     * HealthOmics reference and sequence stores</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param deleteReferenceStoreRequest
     * @return A Java Future containing the result of the DeleteReferenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteReferenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteReferenceStore" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteReferenceStoreResponse> deleteReferenceStore(
            DeleteReferenceStoreRequest deleteReferenceStoreRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteReferenceStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteReferenceStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReferenceStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteReferenceStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteReferenceStoreResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<DeleteReferenceStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteReferenceStoreRequest, DeleteReferenceStoreResponse>()
                            .withOperationName("DeleteReferenceStore").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteReferenceStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteReferenceStoreRequest));
            CompletableFuture<DeleteReferenceStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a run and returns a response with no body if the operation is successful. You can only delete a run that
     * has reached a <code>COMPLETED</code>, <code>FAILED</code>, or <code>CANCELLED</code> stage. A completed run has
     * delivered an output, or was cancelled and resulted in no output. When you delete a run, only the metadata
     * associated with the run is deleted. The run outputs remain in Amazon S3 and logs remain in CloudWatch.
     * </p>
     * <p>
     * To verify that the workflow is deleted:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>ListRuns</code> to confirm the workflow no longer appears in the list.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>GetRun</code> to verify the workflow cannot be found.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteRunRequest
     * @return A Java Future containing the result of the DeleteRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRunResponse> deleteRun(DeleteRunRequest deleteRunRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRunRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteRunResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<DeleteRunResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRunRequest, DeleteRunResponse>().withOperationName("DeleteRun")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRunRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression)
                            .withInput(deleteRunRequest));
            CompletableFuture<DeleteRunResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a run cache and returns a response with no body if the operation is successful. This action removes the
     * cache metadata stored in the service account, but does not delete the data in Amazon S3. You can access the cache
     * data in Amazon S3, for inspection or to troubleshoot issues. You can remove old cache data using standard S3
     * <code>Delete</code> operations.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/workflow-cache-delete.html">Deleting a run cache</a> in the
     * <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param deleteRunCacheRequest
     * @return A Java Future containing the result of the DeleteRunCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteRunCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteRunCache" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRunCacheResponse> deleteRunCache(DeleteRunCacheRequest deleteRunCacheRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRunCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRunCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRunCache");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRunCacheResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRunCacheResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<DeleteRunCacheResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRunCacheRequest, DeleteRunCacheResponse>()
                            .withOperationName("DeleteRunCache").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRunCacheRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteRunCacheRequest));
            CompletableFuture<DeleteRunCacheResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a run group and returns a response with no body if the operation is successful.
     * </p>
     * <p>
     * To verify that the run group is deleted:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>ListRunGroups</code> to confirm the workflow no longer appears in the list.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>GetRunGroup</code> to verify the workflow cannot be found.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteRunGroupRequest
     * @return A Java Future containing the result of the DeleteRunGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteRunGroupResponse> deleteRunGroup(DeleteRunGroupRequest deleteRunGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRunGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRunGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRunGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteRunGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteRunGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<DeleteRunGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteRunGroupRequest, DeleteRunGroupResponse>()
                            .withOperationName("DeleteRunGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteRunGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteRunGroupRequest));
            CompletableFuture<DeleteRunGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an access policy for the specified store.
     * </p>
     *
     * @param deleteS3AccessPolicyRequest
     * @return A Java Future containing the result of the DeleteS3AccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteS3AccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteS3AccessPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteS3AccessPolicyResponse> deleteS3AccessPolicy(
            DeleteS3AccessPolicyRequest deleteS3AccessPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteS3AccessPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteS3AccessPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteS3AccessPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteS3AccessPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteS3AccessPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<DeleteS3AccessPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteS3AccessPolicyRequest, DeleteS3AccessPolicyResponse>()
                            .withOperationName("DeleteS3AccessPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteS3AccessPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteS3AccessPolicyRequest));
            CompletableFuture<DeleteS3AccessPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a sequence store and returns a response with no body if the operation is successful. You can only delete
     * a sequence store when it does not contain any read sets.
     * </p>
     * <p>
     * Use the <code>BatchDeleteReadSet</code> API operation to ensure that all read sets in the sequence store are
     * deleted. When a sequence store is deleted, all tags associated with the store are also deleted.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/deleting-reference-and-sequence-stores.html">Deleting
     * HealthOmics reference and sequence stores</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param deleteSequenceStoreRequest
     * @return A Java Future containing the result of the DeleteSequenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteSequenceStoreResponse> deleteSequenceStore(
            DeleteSequenceStoreRequest deleteSequenceStoreRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSequenceStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSequenceStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSequenceStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteSequenceStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteSequenceStoreResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<DeleteSequenceStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteSequenceStoreRequest, DeleteSequenceStoreResponse>()
                            .withOperationName("DeleteSequenceStore").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteSequenceStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteSequenceStoreRequest));
            CompletableFuture<DeleteSequenceStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a resource share. If you are the resource owner, the subscriber will no longer have access to the shared
     * resource. If you are the subscriber, this operation deletes your access to the share.
     * </p>
     *
     * @param deleteShareRequest
     * @return A Java Future containing the result of the DeleteShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteShare" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteShareResponse> deleteShare(DeleteShareRequest deleteShareRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteShareResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteShareResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<DeleteShareResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteShareRequest, DeleteShareResponse>()
                            .withOperationName("DeleteShare").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteShareRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteShareRequest));
            CompletableFuture<DeleteShareResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a variant store.
     * </p>
     *
     * @param deleteVariantStoreRequest
     * @return A Java Future containing the result of the DeleteVariantStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteVariantStoreResponse> deleteVariantStore(DeleteVariantStoreRequest deleteVariantStoreRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVariantStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVariantStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVariantStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteVariantStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteVariantStoreResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<DeleteVariantStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteVariantStoreRequest, DeleteVariantStoreResponse>()
                            .withOperationName("DeleteVariantStore").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteVariantStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteVariantStoreRequest));
            CompletableFuture<DeleteVariantStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a workflow by specifying its ID. This operation returns a response with no body if the deletion is
     * successful.
     * </p>
     * <p>
     * To verify that the workflow is deleted:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>ListWorkflows</code> to confirm the workflow no longer appears in the list.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>GetWorkflow</code> to verify the workflow cannot be found.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteWorkflowRequest
     * @return A Java Future containing the result of the DeleteWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWorkflowResponse> deleteWorkflow(DeleteWorkflowRequest deleteWorkflowRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWorkflowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkflow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteWorkflowResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<DeleteWorkflowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWorkflowRequest, DeleteWorkflowResponse>()
                            .withOperationName("DeleteWorkflow").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteWorkflowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteWorkflowRequest));
            CompletableFuture<DeleteWorkflowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a workflow version. Deleting a workflow version doesn't affect any ongoing runs that are using the
     * workflow version.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html">Workflow
     * versioning in Amazon Web Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param deleteWorkflowVersionRequest
     * @return A Java Future containing the result of the DeleteWorkflowVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteWorkflowVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteWorkflowVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteWorkflowVersionResponse> deleteWorkflowVersion(
            DeleteWorkflowVersionRequest deleteWorkflowVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWorkflowVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkflowVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkflowVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteWorkflowVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteWorkflowVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<DeleteWorkflowVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteWorkflowVersionRequest, DeleteWorkflowVersionResponse>()
                            .withOperationName("DeleteWorkflowVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new DeleteWorkflowVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(deleteWorkflowVersionRequest));
            CompletableFuture<DeleteWorkflowVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an annotation import job.
     * </p>
     *
     * @param getAnnotationImportJobRequest
     * @return A Java Future containing the result of the GetAnnotationImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetAnnotationImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAnnotationImportJobResponse> getAnnotationImportJob(
            GetAnnotationImportJobRequest getAnnotationImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAnnotationImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAnnotationImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAnnotationImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAnnotationImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAnnotationImportJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<GetAnnotationImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAnnotationImportJobRequest, GetAnnotationImportJobResponse>()
                            .withOperationName("GetAnnotationImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAnnotationImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getAnnotationImportJobRequest));
            CompletableFuture<GetAnnotationImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about an annotation store.
     * </p>
     *
     * @param getAnnotationStoreRequest
     * @return A Java Future containing the result of the GetAnnotationStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetAnnotationStoreResponse> getAnnotationStore(GetAnnotationStoreRequest getAnnotationStoreRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAnnotationStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAnnotationStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAnnotationStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAnnotationStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAnnotationStoreResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<GetAnnotationStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAnnotationStoreRequest, GetAnnotationStoreResponse>()
                            .withOperationName("GetAnnotationStore").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAnnotationStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getAnnotationStoreRequest));
            CompletableFuture<GetAnnotationStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the metadata for an annotation store version.
     * </p>
     *
     * @param getAnnotationStoreVersionRequest
     * @return A Java Future containing the result of the GetAnnotationStoreVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetAnnotationStoreVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationStoreVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetAnnotationStoreVersionResponse> getAnnotationStoreVersion(
            GetAnnotationStoreVersionRequest getAnnotationStoreVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAnnotationStoreVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAnnotationStoreVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAnnotationStoreVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetAnnotationStoreVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetAnnotationStoreVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<GetAnnotationStoreVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetAnnotationStoreVersionRequest, GetAnnotationStoreVersionResponse>()
                            .withOperationName("GetAnnotationStoreVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetAnnotationStoreVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getAnnotationStoreVersionRequest));
            CompletableFuture<GetAnnotationStoreVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves detailed information from parts of a read set and returns the read set in the same format that it was
     * uploaded. You must have read sets uploaded to your sequence store in order to run this operation.
     * </p>
     *
     * @param getReadSetRequest
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows '
     *        <p>
     *        The read set file payload.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>RangeNotSatisfiableException The ranges specified in the request are not valid.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public <ReturnT> CompletableFuture<ReturnT> getReadSet(GetReadSetRequest getReadSetRequest,
            AsyncResponseTransformer<GetReadSetResponse, ReturnT> asyncResponseTransformer) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReadSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReadSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReadSet");
            Pair<AsyncResponseTransformer<GetReadSetResponse, ReturnT>, CompletableFuture<Void>> pair = AsyncResponseTransformerUtils
                    .wrapWithEndOfStreamFuture(asyncResponseTransformer);
            asyncResponseTransformer = pair.left();
            CompletableFuture<Void> endOfStreamFuture = pair.right();
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true)
                    .isPayloadJson(false).build();

            HttpResponseHandler<GetReadSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetReadSetResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "storage-";
            String resolvedHostExpression = "storage-";

            CompletableFuture<ReturnT> executeFuture = clientHandler.execute(
                    new ClientExecutionParams<GetReadSetRequest, GetReadSetResponse>().withOperationName("GetReadSet")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetReadSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withAsyncResponseTransformer(asyncResponseTransformer)
                            .withInput(getReadSetRequest), asyncResponseTransformer);
            AsyncResponseTransformer<GetReadSetResponse, ReturnT> finalAsyncResponseTransformer = asyncResponseTransformer;
            CompletableFuture<ReturnT> whenCompleted = executeFuture.whenComplete((r, e) -> {
                if (e != null) {
                    runAndLogError(log, "Exception thrown in exceptionOccurred callback, ignoring",
                            () -> finalAsyncResponseTransformer.exceptionOccurred(e));
                }
                endOfStreamFuture.whenComplete((r2, e2) -> {
                    metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                });
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            AsyncResponseTransformer<GetReadSetResponse, ReturnT> finalAsyncResponseTransformer = asyncResponseTransformer;
            runAndLogError(log, "Exception thrown in exceptionOccurred callback, ignoring",
                    () -> finalAsyncResponseTransformer.exceptionOccurred(t));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns detailed information about the status of a read set activation job in JSON format.
     * </p>
     *
     * @param getReadSetActivationJobRequest
     * @return A Java Future containing the result of the GetReadSetActivationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSetActivationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetActivationJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetReadSetActivationJobResponse> getReadSetActivationJob(
            GetReadSetActivationJobRequest getReadSetActivationJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReadSetActivationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReadSetActivationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReadSetActivationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetReadSetActivationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetReadSetActivationJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<GetReadSetActivationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetReadSetActivationJobRequest, GetReadSetActivationJobResponse>()
                            .withOperationName("GetReadSetActivationJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetReadSetActivationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getReadSetActivationJobRequest));
            CompletableFuture<GetReadSetActivationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves status information about a read set export job and returns the data in JSON format. Use this operation
     * to actively monitor the progress of an export job.
     * </p>
     *
     * @param getReadSetExportJobRequest
     * @return A Java Future containing the result of the GetReadSetExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetReadSetExportJobResponse> getReadSetExportJob(
            GetReadSetExportJobRequest getReadSetExportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReadSetExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReadSetExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReadSetExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetReadSetExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetReadSetExportJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<GetReadSetExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetReadSetExportJobRequest, GetReadSetExportJobResponse>()
                            .withOperationName("GetReadSetExportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetReadSetExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getReadSetExportJobRequest));
            CompletableFuture<GetReadSetExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets detailed and status information about a read set import job and returns the data in JSON format.
     * </p>
     *
     * @param getReadSetImportJobRequest
     * @return A Java Future containing the result of the GetReadSetImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetReadSetImportJobResponse> getReadSetImportJob(
            GetReadSetImportJobRequest getReadSetImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReadSetImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReadSetImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReadSetImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetReadSetImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetReadSetImportJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<GetReadSetImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetReadSetImportJobRequest, GetReadSetImportJobResponse>()
                            .withOperationName("GetReadSetImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetReadSetImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getReadSetImportJobRequest));
            CompletableFuture<GetReadSetImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the metadata for a read set from a sequence store in JSON format. This operation does not return tags.
     * To retrieve the list of tags for a read set, use the <code>ListTagsForResource</code> API operation.
     * </p>
     *
     * @param getReadSetMetadataRequest
     * @return A Java Future containing the result of the GetReadSetMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSetMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetReadSetMetadataResponse> getReadSetMetadata(GetReadSetMetadataRequest getReadSetMetadataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReadSetMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReadSetMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReadSetMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetReadSetMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetReadSetMetadataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<GetReadSetMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetReadSetMetadataRequest, GetReadSetMetadataResponse>()
                            .withOperationName("GetReadSetMetadata").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetReadSetMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getReadSetMetadataRequest));
            CompletableFuture<GetReadSetMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Downloads parts of data from a reference genome and returns the reference file in the same format that it was
     * uploaded.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-reference-store.html">Creating a HealthOmics reference
     * store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param getReferenceRequest
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows '
     *        <p>
     *        The reference file payload.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>RangeNotSatisfiableException The ranges specified in the request are not valid.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReference" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public <ReturnT> CompletableFuture<ReturnT> getReference(GetReferenceRequest getReferenceRequest,
            AsyncResponseTransformer<GetReferenceResponse, ReturnT> asyncResponseTransformer) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReferenceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReferenceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReference");
            Pair<AsyncResponseTransformer<GetReferenceResponse, ReturnT>, CompletableFuture<Void>> pair = AsyncResponseTransformerUtils
                    .wrapWithEndOfStreamFuture(asyncResponseTransformer);
            asyncResponseTransformer = pair.left();
            CompletableFuture<Void> endOfStreamFuture = pair.right();
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true)
                    .isPayloadJson(false).build();

            HttpResponseHandler<GetReferenceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetReferenceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "storage-";
            String resolvedHostExpression = "storage-";

            CompletableFuture<ReturnT> executeFuture = clientHandler.execute(
                    new ClientExecutionParams<GetReferenceRequest, GetReferenceResponse>().withOperationName("GetReference")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetReferenceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withAsyncResponseTransformer(asyncResponseTransformer)
                            .withInput(getReferenceRequest), asyncResponseTransformer);
            AsyncResponseTransformer<GetReferenceResponse, ReturnT> finalAsyncResponseTransformer = asyncResponseTransformer;
            CompletableFuture<ReturnT> whenCompleted = executeFuture.whenComplete((r, e) -> {
                if (e != null) {
                    runAndLogError(log, "Exception thrown in exceptionOccurred callback, ignoring",
                            () -> finalAsyncResponseTransformer.exceptionOccurred(e));
                }
                endOfStreamFuture.whenComplete((r2, e2) -> {
                    metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
                });
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            AsyncResponseTransformer<GetReferenceResponse, ReturnT> finalAsyncResponseTransformer = asyncResponseTransformer;
            runAndLogError(log, "Exception thrown in exceptionOccurred callback, ignoring",
                    () -> finalAsyncResponseTransformer.exceptionOccurred(t));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Monitors the status of a reference import job. This operation can be called after calling the
     * <code>StartReferenceImportJob</code> operation.
     * </p>
     *
     * @param getReferenceImportJobRequest
     * @return A Java Future containing the result of the GetReferenceImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReferenceImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetReferenceImportJobResponse> getReferenceImportJob(
            GetReferenceImportJobRequest getReferenceImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReferenceImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReferenceImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReferenceImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetReferenceImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetReferenceImportJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<GetReferenceImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetReferenceImportJobRequest, GetReferenceImportJobResponse>()
                            .withOperationName("GetReferenceImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetReferenceImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getReferenceImportJobRequest));
            CompletableFuture<GetReferenceImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves metadata for a reference genome. This operation returns the number of parts, part size, and MD5 of an
     * entire file. This operation does not return tags. To retrieve the list of tags for a read set, use the
     * <code>ListTagsForResource</code> API operation.
     * </p>
     *
     * @param getReferenceMetadataRequest
     * @return A Java Future containing the result of the GetReferenceMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReferenceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetReferenceMetadataResponse> getReferenceMetadata(
            GetReferenceMetadataRequest getReferenceMetadataRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReferenceMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReferenceMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReferenceMetadata");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetReferenceMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetReferenceMetadataResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<GetReferenceMetadataResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetReferenceMetadataRequest, GetReferenceMetadataResponse>()
                            .withOperationName("GetReferenceMetadata").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetReferenceMetadataRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getReferenceMetadataRequest));
            CompletableFuture<GetReferenceMetadataResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a reference store.
     * </p>
     *
     * @param getReferenceStoreRequest
     * @return A Java Future containing the result of the GetReferenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReferenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetReferenceStoreResponse> getReferenceStore(GetReferenceStoreRequest getReferenceStoreRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReferenceStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReferenceStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReferenceStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetReferenceStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetReferenceStoreResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<GetReferenceStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetReferenceStoreRequest, GetReferenceStoreResponse>()
                            .withOperationName("GetReferenceStore").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetReferenceStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getReferenceStoreRequest));
            CompletableFuture<GetReferenceStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets detailed information about a specific run using its ID.
     * </p>
     * <p>
     * Amazon Web Services HealthOmics stores a configurable number of runs, as determined by service limits, that are
     * available to the console and API. If <code>GetRun</code> does not return the requested run, you can find all run
     * logs in the CloudWatch logs. For more information about viewing the run logs, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/monitoring-cloudwatch-logs.html">CloudWatch logs</a> in the
     * <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param getRunRequest
     * @return A Java Future containing the result of the GetRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetRunResponse> getRun(GetRunRequest getRunRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRunRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetRunResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<GetRunResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRunRequest, GetRunResponse>().withOperationName("GetRun")
                            .withProtocolMetadata(protocolMetadata).withMarshaller(new GetRunRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getRunRequest));
            CompletableFuture<GetRunResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves detailed information about the specified run cache using its ID.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflows-call-caching.html">Call
     * caching for Amazon Web Services HealthOmics runs</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param getRunCacheRequest
     * @return A Java Future containing the result of the GetRunCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetRunCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRunCache" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetRunCacheResponse> getRunCache(GetRunCacheRequest getRunCacheRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRunCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRunCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRunCache");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRunCacheResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetRunCacheResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<GetRunCacheResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRunCacheRequest, GetRunCacheResponse>()
                            .withOperationName("GetRunCache").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRunCacheRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getRunCacheRequest));
            CompletableFuture<GetRunCacheResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a run group and returns its metadata.
     * </p>
     *
     * @param getRunGroupRequest
     * @return A Java Future containing the result of the GetRunGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetRunGroupResponse> getRunGroup(GetRunGroupRequest getRunGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRunGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRunGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRunGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRunGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetRunGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<GetRunGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRunGroupRequest, GetRunGroupResponse>()
                            .withOperationName("GetRunGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRunGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getRunGroupRequest));
            CompletableFuture<GetRunGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets detailed information about a run task using its ID.
     * </p>
     *
     * @param getRunTaskRequest
     * @return A Java Future containing the result of the GetRunTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetRunTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRunTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetRunTaskResponse> getRunTask(GetRunTaskRequest getRunTaskRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRunTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRunTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRunTask");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetRunTaskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetRunTaskResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<GetRunTaskResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetRunTaskRequest, GetRunTaskResponse>().withOperationName("GetRunTask")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetRunTaskRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getRunTaskRequest));
            CompletableFuture<GetRunTaskResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves details about an access policy on a given store.
     * </p>
     *
     * @param getS3AccessPolicyRequest
     * @return A Java Future containing the result of the GetS3AccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetS3AccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetS3AccessPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetS3AccessPolicyResponse> getS3AccessPolicy(GetS3AccessPolicyRequest getS3AccessPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getS3AccessPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getS3AccessPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetS3AccessPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetS3AccessPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetS3AccessPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<GetS3AccessPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetS3AccessPolicyRequest, GetS3AccessPolicyResponse>()
                            .withOperationName("GetS3AccessPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetS3AccessPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getS3AccessPolicyRequest));
            CompletableFuture<GetS3AccessPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves metadata for a sequence store using its ID and returns it in JSON format.
     * </p>
     *
     * @param getSequenceStoreRequest
     * @return A Java Future containing the result of the GetSequenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetSequenceStoreResponse> getSequenceStore(GetSequenceStoreRequest getSequenceStoreRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSequenceStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSequenceStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSequenceStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSequenceStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSequenceStoreResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<GetSequenceStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSequenceStoreRequest, GetSequenceStoreResponse>()
                            .withOperationName("GetSequenceStore").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetSequenceStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getSequenceStoreRequest));
            CompletableFuture<GetSequenceStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the metadata for the specified resource share.
     * </p>
     *
     * @param getShareRequest
     * @return A Java Future containing the result of the GetShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetShare" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetShareResponse> getShare(GetShareRequest getShareRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetShare");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetShareResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetShareResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<GetShareResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetShareRequest, GetShareResponse>().withOperationName("GetShare")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetShareRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression)
                            .withInput(getShareRequest));
            CompletableFuture<GetShareResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a variant import job.
     * </p>
     *
     * @param getVariantImportJobRequest
     * @return A Java Future containing the result of the GetVariantImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetVariantImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetVariantImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetVariantImportJobResponse> getVariantImportJob(
            GetVariantImportJobRequest getVariantImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getVariantImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVariantImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVariantImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVariantImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetVariantImportJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<GetVariantImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVariantImportJobRequest, GetVariantImportJobResponse>()
                            .withOperationName("GetVariantImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetVariantImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getVariantImportJobRequest));
            CompletableFuture<GetVariantImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a variant store.
     * </p>
     *
     * @param getVariantStoreRequest
     * @return A Java Future containing the result of the GetVariantStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetVariantStoreResponse> getVariantStore(GetVariantStoreRequest getVariantStoreRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getVariantStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVariantStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVariantStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetVariantStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetVariantStoreResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<GetVariantStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetVariantStoreRequest, GetVariantStoreResponse>()
                            .withOperationName("GetVariantStore").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetVariantStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getVariantStoreRequest));
            CompletableFuture<GetVariantStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets all information about a workflow using its ID.
     * </p>
     * <p>
     * If a workflow is shared with you, you cannot export the workflow.
     * </p>
     * <p>
     * For more information about your workflow status, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/using-get-workflow.html">Verify the workflow status</a> in the
     * <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param getWorkflowRequest
     * @return A Java Future containing the result of the GetWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetWorkflowResponse> getWorkflow(GetWorkflowRequest getWorkflowRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWorkflowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkflow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    GetWorkflowResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<GetWorkflowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWorkflowRequest, GetWorkflowResponse>()
                            .withOperationName("GetWorkflow").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetWorkflowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getWorkflowRequest));
            CompletableFuture<GetWorkflowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Gets information about a workflow version. For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html">Workflow versioning in Amazon Web
     * Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param getWorkflowVersionRequest
     * @return A Java Future containing the result of the GetWorkflowVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetWorkflowVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetWorkflowVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<GetWorkflowVersionResponse> getWorkflowVersion(GetWorkflowVersionRequest getWorkflowVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWorkflowVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWorkflowVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkflowVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetWorkflowVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetWorkflowVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<GetWorkflowVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetWorkflowVersionRequest, GetWorkflowVersionResponse>()
                            .withOperationName("GetWorkflowVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new GetWorkflowVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(getWorkflowVersionRequest));
            CompletableFuture<GetWorkflowVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of annotation import jobs.
     * </p>
     *
     * @param listAnnotationImportJobsRequest
     * @return A Java Future containing the result of the ListAnnotationImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListAnnotationImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAnnotationImportJobsResponse> listAnnotationImportJobs(
            ListAnnotationImportJobsRequest listAnnotationImportJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAnnotationImportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAnnotationImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAnnotationImportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAnnotationImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAnnotationImportJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<ListAnnotationImportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAnnotationImportJobsRequest, ListAnnotationImportJobsResponse>()
                            .withOperationName("ListAnnotationImportJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAnnotationImportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listAnnotationImportJobsRequest));
            CompletableFuture<ListAnnotationImportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the versions of an annotation store.
     * </p>
     *
     * @param listAnnotationStoreVersionsRequest
     * @return A Java Future containing the result of the ListAnnotationStoreVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListAnnotationStoreVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationStoreVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAnnotationStoreVersionsResponse> listAnnotationStoreVersions(
            ListAnnotationStoreVersionsRequest listAnnotationStoreVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAnnotationStoreVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAnnotationStoreVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAnnotationStoreVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAnnotationStoreVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAnnotationStoreVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<ListAnnotationStoreVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAnnotationStoreVersionsRequest, ListAnnotationStoreVersionsResponse>()
                            .withOperationName("ListAnnotationStoreVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAnnotationStoreVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listAnnotationStoreVersionsRequest));
            CompletableFuture<ListAnnotationStoreVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of annotation stores.
     * </p>
     *
     * @param listAnnotationStoresRequest
     * @return A Java Future containing the result of the ListAnnotationStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListAnnotationStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationStores" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListAnnotationStoresResponse> listAnnotationStores(
            ListAnnotationStoresRequest listAnnotationStoresRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAnnotationStoresRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAnnotationStoresRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAnnotationStores");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAnnotationStoresResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListAnnotationStoresResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<ListAnnotationStoresResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAnnotationStoresRequest, ListAnnotationStoresResponse>()
                            .withOperationName("ListAnnotationStores").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListAnnotationStoresRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listAnnotationStoresRequest));
            CompletableFuture<ListAnnotationStoresResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists in-progress multipart read set uploads for a sequence store and returns it in a JSON formatted output.
     * Multipart read set uploads are initiated by the <code>CreateMultipartReadSetUploads</code> API operation. This
     * operation returns a response with no body when the upload is complete.
     * </p>
     *
     * @param listMultipartReadSetUploadsRequest
     * @return A Java Future containing the result of the ListMultipartReadSetUploads operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListMultipartReadSetUploads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListMultipartReadSetUploads"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListMultipartReadSetUploadsResponse> listMultipartReadSetUploads(
            ListMultipartReadSetUploadsRequest listMultipartReadSetUploadsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMultipartReadSetUploadsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMultipartReadSetUploadsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMultipartReadSetUploads");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListMultipartReadSetUploadsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListMultipartReadSetUploadsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<ListMultipartReadSetUploadsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListMultipartReadSetUploadsRequest, ListMultipartReadSetUploadsResponse>()
                            .withOperationName("ListMultipartReadSetUploads").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListMultipartReadSetUploadsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listMultipartReadSetUploadsRequest));
            CompletableFuture<ListMultipartReadSetUploadsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of read set activation jobs and returns the metadata in a JSON formatted output. To extract
     * metadata from a read set activation job, use the <code>GetReadSetActivationJob</code> API operation.
     * </p>
     *
     * @param listReadSetActivationJobsRequest
     * @return A Java Future containing the result of the ListReadSetActivationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetActivationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetActivationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListReadSetActivationJobsResponse> listReadSetActivationJobs(
            ListReadSetActivationJobsRequest listReadSetActivationJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReadSetActivationJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReadSetActivationJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReadSetActivationJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListReadSetActivationJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListReadSetActivationJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<ListReadSetActivationJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListReadSetActivationJobsRequest, ListReadSetActivationJobsResponse>()
                            .withOperationName("ListReadSetActivationJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListReadSetActivationJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listReadSetActivationJobsRequest));
            CompletableFuture<ListReadSetActivationJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of read set export jobs in a JSON formatted response. This API operation is used to check the
     * status of a read set export job initiated by the <code>StartReadSetExportJob</code> API operation.
     * </p>
     *
     * @param listReadSetExportJobsRequest
     * @return A Java Future containing the result of the ListReadSetExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListReadSetExportJobsResponse> listReadSetExportJobs(
            ListReadSetExportJobsRequest listReadSetExportJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReadSetExportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReadSetExportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReadSetExportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListReadSetExportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListReadSetExportJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<ListReadSetExportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListReadSetExportJobsRequest, ListReadSetExportJobsResponse>()
                            .withOperationName("ListReadSetExportJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListReadSetExportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listReadSetExportJobsRequest));
            CompletableFuture<ListReadSetExportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of read set import jobs and returns the data in JSON format.
     * </p>
     *
     * @param listReadSetImportJobsRequest
     * @return A Java Future containing the result of the ListReadSetImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListReadSetImportJobsResponse> listReadSetImportJobs(
            ListReadSetImportJobsRequest listReadSetImportJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReadSetImportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReadSetImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReadSetImportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListReadSetImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListReadSetImportJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<ListReadSetImportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListReadSetImportJobsRequest, ListReadSetImportJobsResponse>()
                            .withOperationName("ListReadSetImportJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListReadSetImportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listReadSetImportJobsRequest));
            CompletableFuture<ListReadSetImportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all parts in a multipart read set upload for a sequence store and returns the metadata in a JSON formatted
     * output.
     * </p>
     *
     * @param listReadSetUploadPartsRequest
     * @return A Java Future containing the result of the ListReadSetUploadParts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetUploadParts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetUploadParts" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListReadSetUploadPartsResponse> listReadSetUploadParts(
            ListReadSetUploadPartsRequest listReadSetUploadPartsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReadSetUploadPartsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReadSetUploadPartsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReadSetUploadParts");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListReadSetUploadPartsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListReadSetUploadPartsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<ListReadSetUploadPartsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListReadSetUploadPartsRequest, ListReadSetUploadPartsResponse>()
                            .withOperationName("ListReadSetUploadParts").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListReadSetUploadPartsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listReadSetUploadPartsRequest));
            CompletableFuture<ListReadSetUploadPartsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of read sets from a sequence store ID and returns the metadata in JSON format.
     * </p>
     *
     * @param listReadSetsRequest
     * @return A Java Future containing the result of the ListReadSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListReadSetsResponse> listReadSets(ListReadSetsRequest listReadSetsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReadSetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReadSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReadSets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListReadSetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListReadSetsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<ListReadSetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListReadSetsRequest, ListReadSetsResponse>()
                            .withOperationName("ListReadSets").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListReadSetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listReadSetsRequest));
            CompletableFuture<ListReadSetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the metadata of one or more reference import jobs for a reference store.
     * </p>
     *
     * @param listReferenceImportJobsRequest
     * @return A Java Future containing the result of the ListReferenceImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferenceImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListReferenceImportJobsResponse> listReferenceImportJobs(
            ListReferenceImportJobsRequest listReferenceImportJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReferenceImportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReferenceImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReferenceImportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListReferenceImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListReferenceImportJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<ListReferenceImportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListReferenceImportJobsRequest, ListReferenceImportJobsResponse>()
                            .withOperationName("ListReferenceImportJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListReferenceImportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listReferenceImportJobsRequest));
            CompletableFuture<ListReferenceImportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of reference stores linked to your account and returns their metadata in JSON format.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-reference-store.html">Creating a reference store</a> in
     * the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param listReferenceStoresRequest
     * @return A Java Future containing the result of the ListReferenceStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferenceStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceStores" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListReferenceStoresResponse> listReferenceStores(
            ListReferenceStoresRequest listReferenceStoresRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReferenceStoresRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReferenceStoresRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReferenceStores");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListReferenceStoresResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListReferenceStoresResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<ListReferenceStoresResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListReferenceStoresRequest, ListReferenceStoresResponse>()
                            .withOperationName("ListReferenceStores").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListReferenceStoresRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listReferenceStoresRequest));
            CompletableFuture<ListReferenceStoresResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the metadata of one or more reference genomes in a reference store.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-reference-store.html">Creating a reference store</a> in
     * the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param listReferencesRequest
     * @return A Java Future containing the result of the ListReferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferences" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListReferencesResponse> listReferences(ListReferencesRequest listReferencesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReferencesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReferencesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReferences");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListReferencesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListReferencesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<ListReferencesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListReferencesRequest, ListReferencesResponse>()
                            .withOperationName("ListReferences").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListReferencesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listReferencesRequest));
            CompletableFuture<ListReferencesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of your run caches and the metadata for each cache.
     * </p>
     *
     * @param listRunCachesRequest
     * @return A Java Future containing the result of the ListRunCaches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRunCaches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunCaches" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListRunCachesResponse> listRunCaches(ListRunCachesRequest listRunCachesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRunCachesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRunCachesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRunCaches");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRunCachesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListRunCachesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<ListRunCachesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRunCachesRequest, ListRunCachesResponse>()
                            .withOperationName("ListRunCaches").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRunCachesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listRunCachesRequest));
            CompletableFuture<ListRunCachesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of all run groups and returns the metadata for each run group.
     * </p>
     *
     * @param listRunGroupsRequest
     * @return A Java Future containing the result of the ListRunGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRunGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListRunGroupsResponse> listRunGroups(ListRunGroupsRequest listRunGroupsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRunGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRunGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRunGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRunGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListRunGroupsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<ListRunGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRunGroupsRequest, ListRunGroupsResponse>()
                            .withOperationName("ListRunGroups").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRunGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listRunGroupsRequest));
            CompletableFuture<ListRunGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of tasks and status information within their specified run. Use this operation to monitor runs and
     * to identify which specific tasks have failed.
     * </p>
     *
     * @param listRunTasksRequest
     * @return A Java Future containing the result of the ListRunTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRunTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunTasks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListRunTasksResponse> listRunTasks(ListRunTasksRequest listRunTasksRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRunTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRunTasksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRunTasks");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRunTasksResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListRunTasksResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<ListRunTasksResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRunTasksRequest, ListRunTasksResponse>()
                            .withOperationName("ListRunTasks").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRunTasksRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listRunTasksRequest));
            CompletableFuture<ListRunTasksResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of runs and returns each run's metadata and status.
     * </p>
     * <p>
     * Amazon Web Services HealthOmics stores a configurable number of runs, as determined by service limits, that are
     * available to the console and API. If the <code>ListRuns</code> response doesn't include specific runs that you
     * expected, you can find all run logs in the CloudWatch logs. For more information about viewing the run logs, see
     * <a href="https://docs.aws.amazon.com/omics/latest/dev/monitoring-cloudwatch-logs.html">CloudWatch logs</a> in the
     * <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param listRunsRequest
     * @return A Java Future containing the result of the ListRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRuns" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListRunsResponse> listRuns(ListRunsRequest listRunsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRunsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRunsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRuns");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListRunsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListRunsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<ListRunsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListRunsRequest, ListRunsResponse>().withOperationName("ListRuns")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListRunsRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression)
                            .withInput(listRunsRequest));
            CompletableFuture<ListRunsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of sequence stores and returns each sequence store's metadata.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-sequence-store.html">Creating a HealthOmics sequence
     * store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param listSequenceStoresRequest
     * @return A Java Future containing the result of the ListSequenceStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListSequenceStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListSequenceStores" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListSequenceStoresResponse> listSequenceStores(ListSequenceStoresRequest listSequenceStoresRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSequenceStoresRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSequenceStoresRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSequenceStores");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSequenceStoresResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListSequenceStoresResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<ListSequenceStoresResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSequenceStoresRequest, ListSequenceStoresResponse>()
                            .withOperationName("ListSequenceStores").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSequenceStoresRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listSequenceStoresRequest));
            CompletableFuture<ListSequenceStoresResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves the resource shares associated with an account. Use the filter parameter to retrieve a specific subset
     * of the shares.
     * </p>
     *
     * @param listSharesRequest
     * @return A Java Future containing the result of the ListShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListShares" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListSharesResponse> listShares(ListSharesRequest listSharesRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSharesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSharesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListShares");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListSharesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListSharesResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<ListSharesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListSharesRequest, ListSharesResponse>().withOperationName("ListShares")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListSharesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listSharesRequest));
            CompletableFuture<ListSharesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "tags-";
            String resolvedHostExpression = "tags-";

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of variant import jobs.
     * </p>
     *
     * @param listVariantImportJobsRequest
     * @return A Java Future containing the result of the ListVariantImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListVariantImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListVariantImportJobsResponse> listVariantImportJobs(
            ListVariantImportJobsRequest listVariantImportJobsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listVariantImportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVariantImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVariantImportJobs");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListVariantImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListVariantImportJobsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<ListVariantImportJobsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListVariantImportJobsRequest, ListVariantImportJobsResponse>()
                            .withOperationName("ListVariantImportJobs").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListVariantImportJobsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listVariantImportJobsRequest));
            CompletableFuture<ListVariantImportJobsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of variant stores.
     * </p>
     *
     * @param listVariantStoresRequest
     * @return A Java Future containing the result of the ListVariantStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListVariantStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantStores" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListVariantStoresResponse> listVariantStores(ListVariantStoresRequest listVariantStoresRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listVariantStoresRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVariantStoresRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVariantStores");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListVariantStoresResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListVariantStoresResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<ListVariantStoresResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListVariantStoresRequest, ListVariantStoresResponse>()
                            .withOperationName("ListVariantStores").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListVariantStoresRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listVariantStoresRequest));
            CompletableFuture<ListVariantStoresResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the workflow versions for the specified workflow. For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html">Workflow versioning in Amazon Web
     * Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param listWorkflowVersionsRequest
     * @return A Java Future containing the result of the ListWorkflowVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListWorkflowVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListWorkflowVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListWorkflowVersionsResponse> listWorkflowVersions(
            ListWorkflowVersionsRequest listWorkflowVersionsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorkflowVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkflowVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkflowVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWorkflowVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListWorkflowVersionsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<ListWorkflowVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWorkflowVersionsRequest, ListWorkflowVersionsResponse>()
                            .withOperationName("ListWorkflowVersions").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListWorkflowVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listWorkflowVersionsRequest));
            CompletableFuture<ListWorkflowVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Retrieves a list of existing workflows. You can filter for specific workflows by their name and type. Using the
     * type parameter, specify <code>PRIVATE</code> to retrieve a list of private workflows or specify
     * <code>READY2RUN</code> for a list of all Ready2Run workflows. If you do not specify the type of workflow, this
     * operation returns a list of existing workflows.
     * </p>
     *
     * @param listWorkflowsRequest
     * @return A Java Future containing the result of the ListWorkflows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListWorkflowsResponse> listWorkflows(ListWorkflowsRequest listWorkflowsRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorkflowsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkflowsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkflows");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListWorkflowsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListWorkflowsResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<ListWorkflowsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListWorkflowsRequest, ListWorkflowsResponse>()
                            .withOperationName("ListWorkflows").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new ListWorkflowsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(listWorkflowsRequest));
            CompletableFuture<ListWorkflowsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds an access policy to the specified store.
     * </p>
     *
     * @param putS3AccessPolicyRequest
     * @return A Java Future containing the result of the PutS3AccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.PutS3AccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/PutS3AccessPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<PutS3AccessPolicyResponse> putS3AccessPolicy(PutS3AccessPolicyRequest putS3AccessPolicyRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putS3AccessPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putS3AccessPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutS3AccessPolicy");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<PutS3AccessPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, PutS3AccessPolicyResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<PutS3AccessPolicyResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<PutS3AccessPolicyRequest, PutS3AccessPolicyResponse>()
                            .withOperationName("PutS3AccessPolicy").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new PutS3AccessPolicyRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(putS3AccessPolicyRequest));
            CompletableFuture<PutS3AccessPolicyResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts an annotation import job.
     * </p>
     *
     * @param startAnnotationImportJobRequest
     * @return A Java Future containing the result of the StartAnnotationImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartAnnotationImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartAnnotationImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartAnnotationImportJobResponse> startAnnotationImportJob(
            StartAnnotationImportJobRequest startAnnotationImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startAnnotationImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startAnnotationImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartAnnotationImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartAnnotationImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartAnnotationImportJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<StartAnnotationImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartAnnotationImportJobRequest, StartAnnotationImportJobResponse>()
                            .withOperationName("StartAnnotationImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartAnnotationImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(startAnnotationImportJobRequest));
            CompletableFuture<StartAnnotationImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Activates an archived read set and returns its metadata in a JSON formatted output. AWS HealthOmics automatically
     * archives unused read sets after 30 days. To monitor the status of your read set activation job, use the
     * <code>GetReadSetActivationJob</code> operation.
     * </p>
     * <p>
     * To learn more, see <a href="https://docs.aws.amazon.com/omics/latest/dev/activating-read-sets.html">Activating
     * read sets</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param startReadSetActivationJobRequest
     * @return A Java Future containing the result of the StartReadSetActivationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartReadSetActivationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetActivationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<StartReadSetActivationJobResponse> startReadSetActivationJob(
            StartReadSetActivationJobRequest startReadSetActivationJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startReadSetActivationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startReadSetActivationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartReadSetActivationJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartReadSetActivationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartReadSetActivationJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<StartReadSetActivationJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartReadSetActivationJobRequest, StartReadSetActivationJobResponse>()
                            .withOperationName("StartReadSetActivationJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartReadSetActivationJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(startReadSetActivationJobRequest));
            CompletableFuture<StartReadSetActivationJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a read set export job. When the export job is finished, the read set is exported to an Amazon S3 bucket
     * which can be retrieved using the <code>GetReadSetExportJob</code> API operation.
     * </p>
     * <p>
     * To monitor the status of the export job, use the <code>ListReadSetExportJobs</code> API operation.
     * </p>
     *
     * @param startReadSetExportJobRequest
     * @return A Java Future containing the result of the StartReadSetExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartReadSetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetExportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StartReadSetExportJobResponse> startReadSetExportJob(
            StartReadSetExportJobRequest startReadSetExportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startReadSetExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startReadSetExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartReadSetExportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartReadSetExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartReadSetExportJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<StartReadSetExportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartReadSetExportJobRequest, StartReadSetExportJobResponse>()
                            .withOperationName("StartReadSetExportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartReadSetExportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(startReadSetExportJobRequest));
            CompletableFuture<StartReadSetExportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Imports a read set from the sequence store. Read set import jobs support a maximum of 100 read sets of different
     * types. Monitor the progress of your read set import job by calling the <code>GetReadSetImportJob</code> API
     * operation.
     * </p>
     *
     * @param startReadSetImportJobRequest
     * @return A Java Future containing the result of the StartReadSetImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartReadSetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StartReadSetImportJobResponse> startReadSetImportJob(
            StartReadSetImportJobRequest startReadSetImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startReadSetImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startReadSetImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartReadSetImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartReadSetImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartReadSetImportJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<StartReadSetImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartReadSetImportJobRequest, StartReadSetImportJobResponse>()
                            .withOperationName("StartReadSetImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartReadSetImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(startReadSetImportJobRequest));
            CompletableFuture<StartReadSetImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Imports a reference genome from Amazon S3 into a specified reference store. You can have multiple reference
     * genomes in a reference store. You can only import reference genomes one at a time into each reference store.
     * Monitor the status of your reference import job by using the <code>GetReferenceImportJob</code> API operation.
     * </p>
     *
     * @param startReferenceImportJobRequest
     * @return A Java Future containing the result of the StartReferenceImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartReferenceImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReferenceImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StartReferenceImportJobResponse> startReferenceImportJob(
            StartReferenceImportJobRequest startReferenceImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startReferenceImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startReferenceImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartReferenceImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartReferenceImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartReferenceImportJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<StartReferenceImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartReferenceImportJobRequest, StartReferenceImportJobResponse>()
                            .withOperationName("StartReferenceImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartReferenceImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(startReferenceImportJobRequest));
            CompletableFuture<StartReferenceImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a new run and returns details about the run, or duplicates an existing run. A run is a single invocation
     * of a workflow. If you provide request IDs, Amazon Web Services HealthOmics identifies duplicate requests and
     * starts the run only once. Monitor the progress of the run by calling the <code>GetRun</code> API operation.
     * </p>
     * <p>
     * To start a new run, the following inputs are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A service role ARN (<code>roleArn</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * The run's workflow ID (<code>workflowId</code>, not the <code>uuid</code> or <code>runId</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * An Amazon S3 location (<code>outputUri</code>) where the run outputs will be saved.
     * </p>
     * </li>
     * <li>
     * <p>
     * All required workflow parameters (<code>parameter</code>), which can include optional parameters from the
     * parameter template. The run cannot include any parameters that are not defined in the parameter template. To see
     * all possible parameters, use the <code>GetRun</code> API operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * For runs with a <code>STATIC</code> (default) storage type, specify the required storage capacity (in gibibytes).
     * A storage capacity value is not required for runs that use <code>DYNAMIC</code> storage.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>StartRun</code> can also duplicate an existing run using the run's default values. You can modify these
     * default values and/or add other optional inputs. To duplicate a run, the following inputs are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A service role ARN (<code>roleArn</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * The ID of the run to duplicate (<code>runId</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * An Amazon S3 location where the run outputs will be saved (<code>outputUri</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * To learn more about the optional parameters for <code>StartRun</code>, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/starting-a-run.html">Starting a run</a> in the <i>Amazon Web
     * Services HealthOmics User Guide</i>.
     * </p>
     * <p>
     * Use the <code>retentionMode</code> input to control how long the metadata for each run is stored in CloudWatch.
     * There are two retention modes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify <code>REMOVE</code> to automatically remove the oldest runs when you reach the maximum service retention
     * limit for runs. It is recommended that you use the <code>REMOVE</code> mode to initiate major run requests so
     * that your runs do not fail when you reach the limit.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>retentionMode</code> is set to the <code>RETAIN</code> mode by default, which allows you to manually
     * remove runs after reaching the maximum service retention limit. Under this setting, you cannot create additional
     * runs until you remove the excess runs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To learn more about the retention modes, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/run-retention.html">Run retention mode</a> in the <i>Amazon
     * Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param startRunRequest
     * @return A Java Future containing the result of the StartRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<StartRunResponse> startRun(StartRunRequest startRunRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startRunRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartRun");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    StartRunResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<StartRunResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartRunRequest, StartRunResponse>().withOperationName("StartRun")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartRunRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                            .withMetricCollector(apiCallMetricCollector).hostPrefixExpression(resolvedHostExpression)
                            .withInput(startRunRequest));
            CompletableFuture<StartRunResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Starts a variant import job.
     * </p>
     *
     * @param startVariantImportJobRequest
     * @return A Java Future containing the result of the StartVariantImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartVariantImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartVariantImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<StartVariantImportJobResponse> startVariantImportJob(
            StartVariantImportJobRequest startVariantImportJobRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startVariantImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startVariantImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartVariantImportJob");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<StartVariantImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, StartVariantImportJobResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<StartVariantImportJobResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<StartVariantImportJobRequest, StartVariantImportJobResponse>()
                            .withOperationName("StartVariantImportJob").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new StartVariantImportJobRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(startVariantImportJobRequest));
            CompletableFuture<StartVariantImportJobResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Tags a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "tags-";
            String resolvedHostExpression = "tags-";

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "tags-";
            String resolvedHostExpression = "tags-";

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an annotation store.
     * </p>
     *
     * @param updateAnnotationStoreRequest
     * @return A Java Future containing the result of the UpdateAnnotationStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateAnnotationStore" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAnnotationStoreResponse> updateAnnotationStore(
            UpdateAnnotationStoreRequest updateAnnotationStoreRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAnnotationStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAnnotationStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAnnotationStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAnnotationStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAnnotationStoreResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<UpdateAnnotationStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAnnotationStoreRequest, UpdateAnnotationStoreResponse>()
                            .withOperationName("UpdateAnnotationStore").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAnnotationStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateAnnotationStoreRequest));
            CompletableFuture<UpdateAnnotationStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the description of an annotation store version.
     * </p>
     *
     * @param updateAnnotationStoreVersionRequest
     * @return A Java Future containing the result of the UpdateAnnotationStoreVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateAnnotationStoreVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateAnnotationStoreVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAnnotationStoreVersionResponse> updateAnnotationStoreVersion(
            UpdateAnnotationStoreVersionRequest updateAnnotationStoreVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAnnotationStoreVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAnnotationStoreVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAnnotationStoreVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAnnotationStoreVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAnnotationStoreVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<UpdateAnnotationStoreVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAnnotationStoreVersionRequest, UpdateAnnotationStoreVersionResponse>()
                            .withOperationName("UpdateAnnotationStoreVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateAnnotationStoreVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateAnnotationStoreVersionRequest));
            CompletableFuture<UpdateAnnotationStoreVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a run cache using its ID and returns a response with no body if the operation is successful. You can
     * update the run cache description, name, or the default run cache behavior with <code>CACHE_ON_FAILURE</code> or
     * <code>CACHE_ALWAYS</code>. To confirm that your run cache settings have been properly updated, use the
     * <code>GetRunCache</code> API operation.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/how-run-cache.html">How call
     * caching works</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param updateRunCacheRequest
     * @return A Java Future containing the result of the UpdateRunCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateRunCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateRunCache" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRunCacheResponse> updateRunCache(UpdateRunCacheRequest updateRunCacheRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRunCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRunCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRunCache");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRunCacheResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRunCacheResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<UpdateRunCacheResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRunCacheRequest, UpdateRunCacheResponse>()
                            .withOperationName("UpdateRunCache").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateRunCacheRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateRunCacheRequest));
            CompletableFuture<UpdateRunCacheResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the settings of a run group and returns a response with no body if the operation is successful.
     * </p>
     * <p>
     * You can update the following settings with <code>UpdateRunGroup</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of CPUs
     * </p>
     * </li>
     * <li>
     * <p>
     * Run time (measured in minutes)
     * </p>
     * </li>
     * <li>
     * <p>
     * Number of GPUs
     * </p>
     * </li>
     * <li>
     * <p>
     * Number of concurrent runs
     * </p>
     * </li>
     * <li>
     * <p>
     * Group name
     * </p>
     * </li>
     * </ul>
     * <p>
     * To confirm that the settings have been successfully updated, use the <code>ListRunGroups</code> or
     * <code>GetRunGroup</code> API operations to verify that the desired changes have been made.
     * </p>
     *
     * @param updateRunGroupRequest
     * @return A Java Future containing the result of the UpdateRunGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateRunGroupResponse> updateRunGroup(UpdateRunGroupRequest updateRunGroupRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRunGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRunGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRunGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateRunGroupResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateRunGroupResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<UpdateRunGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateRunGroupRequest, UpdateRunGroupResponse>()
                            .withOperationName("UpdateRunGroup").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateRunGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateRunGroupRequest));
            CompletableFuture<UpdateRunGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Update one or more parameters for the sequence store.
     * </p>
     *
     * @param updateSequenceStoreRequest
     * @return A Java Future containing the result of the UpdateSequenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateSequenceStoreResponse> updateSequenceStore(
            UpdateSequenceStoreRequest updateSequenceStoreRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSequenceStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSequenceStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSequenceStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateSequenceStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateSequenceStoreResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            CompletableFuture<UpdateSequenceStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateSequenceStoreRequest, UpdateSequenceStoreResponse>()
                            .withOperationName("UpdateSequenceStore").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateSequenceStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateSequenceStoreRequest));
            CompletableFuture<UpdateSequenceStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a variant store.
     * </p>
     *
     * @param updateVariantStoreRequest
     * @return A Java Future containing the result of the UpdateVariantStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateVariantStoreResponse> updateVariantStore(UpdateVariantStoreRequest updateVariantStoreRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateVariantStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVariantStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVariantStore");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateVariantStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateVariantStoreResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            CompletableFuture<UpdateVariantStoreResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateVariantStoreRequest, UpdateVariantStoreResponse>()
                            .withOperationName("UpdateVariantStore").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateVariantStoreRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateVariantStoreRequest));
            CompletableFuture<UpdateVariantStoreResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates information about a workflow.
     * </p>
     * <p>
     * You can update the following workflow information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Name
     * </p>
     * </li>
     * <li>
     * <p>
     * Description
     * </p>
     * </li>
     * <li>
     * <p>
     * Default storage type
     * </p>
     * </li>
     * <li>
     * <p>
     * Default storage capacity (with workflow ID)
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation returns a response with no body if the operation is successful. You can check the workflow updates
     * by calling the <code>GetWorkflow</code> API operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/update-private-workflow.html">Update a private workflow</a> in
     * the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param updateWorkflowRequest
     * @return A Java Future containing the result of the UpdateWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateWorkflowResponse> updateWorkflow(UpdateWorkflowRequest updateWorkflowRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWorkflowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorkflow");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateWorkflowResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<UpdateWorkflowResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateWorkflowRequest, UpdateWorkflowResponse>()
                            .withOperationName("UpdateWorkflow").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateWorkflowRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateWorkflowRequest));
            CompletableFuture<UpdateWorkflowResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates information about the workflow version. For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html">Workflow versioning in Amazon Web
     * Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param updateWorkflowVersionRequest
     * @return A Java Future containing the result of the UpdateWorkflowVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateWorkflowVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateWorkflowVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateWorkflowVersionResponse> updateWorkflowVersion(
            UpdateWorkflowVersionRequest updateWorkflowVersionRequest) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWorkflowVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWorkflowVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorkflowVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateWorkflowVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateWorkflowVersionResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            CompletableFuture<UpdateWorkflowVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateWorkflowVersionRequest, UpdateWorkflowVersionResponse>()
                            .withOperationName("UpdateWorkflowVersion").withProtocolMetadata(protocolMetadata)
                            .withMarshaller(new UpdateWorkflowVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withInput(updateWorkflowVersionRequest));
            CompletableFuture<UpdateWorkflowVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Uploads a specific part of a read set into a sequence store. When you a upload a read set part with a part number
     * that already exists, the new part replaces the existing one. This operation returns a JSON formatted response
     * containing a string identifier that is used to confirm that parts are being added to the intended upload.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/synchronous-uploads.html">Direct
     * upload to a sequence store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param uploadReadSetPartRequest
     * @param requestBody
     *        Functional interface that can be implemented to produce the request content in a non-blocking manner. The
     *        size of the content is expected to be known up front. See {@link AsyncRequestBody} for specific details on
     *        implementing this interface as well as links to precanned implementations for common scenarios like
     *        uploading from a file. The service documentation for the request content is as follows '
     *        <p>
     *        The read set data to upload for a part.
     *        </p>
     *        '
     * @return A Java Future containing the result of the UploadReadSetPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UploadReadSetPart
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UploadReadSetPart" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UploadReadSetPartResponse> uploadReadSetPart(UploadReadSetPartRequest uploadReadSetPartRequest,
            AsyncRequestBody requestBody) {
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(uploadReadSetPartRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, uploadReadSetPartRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UploadReadSetPart");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UploadReadSetPartResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UploadReadSetPartResponse::builder);
            Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
                if (errorCode == null) {
                    return Optional.empty();
                }
                switch (errorCode) {
                case "RangeNotSatisfiableException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                            .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
                case "ServiceQuotaExceededException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                            .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                case "InternalServerException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                            .exceptionBuilderSupplier(InternalServerException::builder).build());
                case "ResourceNotFoundException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                            .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                case "ValidationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                            .exceptionBuilderSupplier(ValidationException::builder).build());
                case "RequestTimeoutException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                            .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
                case "ThrottlingException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                            .exceptionBuilderSupplier(ThrottlingException::builder).build());
                case "NotSupportedOperationException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException")
                            .httpStatusCode(405).exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
                case "AccessDeniedException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                            .exceptionBuilderSupplier(AccessDeniedException::builder).build());
                case "ConflictException":
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                            .exceptionBuilderSupplier(ConflictException::builder).build());
                default:
                    return Optional.empty();
                }
            };
            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata, exceptionMetadataMapper);
            String hostPrefix = "storage-";
            String resolvedHostExpression = "storage-";

            CompletableFuture<UploadReadSetPartResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UploadReadSetPartRequest, UploadReadSetPartResponse>()
                            .withOperationName("UploadReadSetPart")
                            .withProtocolMetadata(protocolMetadata)
                            .withMarshaller(
                                    AsyncStreamingRequestMarshaller.builder()
                                            .delegateMarshaller(new UploadReadSetPartRequestMarshaller(protocolFactory))
                                            .asyncRequestBody(requestBody).requiresLength(true).transferEncoding(true).build())
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withMetricCollector(apiCallMetricCollector)
                            .hostPrefixExpression(resolvedHostExpression).withAsyncRequestBody(requestBody)
                            .withInput(uploadReadSetPartRequest));
            CompletableFuture<UploadReadSetPartResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public OmicsAsyncWaiter waiter() {
        return OmicsAsyncWaiter.builder().client(this).scheduledExecutorService(executorService).build();
    }

    @Override
    public final OmicsServiceClientConfiguration serviceClientConfiguration() {
        return new OmicsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(OmicsException::builder)
                .protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        OmicsServiceClientConfigurationBuilder serviceConfigBuilder = new OmicsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
