/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.StreamingRequestMarshaller;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.core.sync.ResponseTransformer;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.omics.internal.OmicsServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.omics.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.omics.model.AbortMultipartReadSetUploadRequest;
import software.amazon.awssdk.services.omics.model.AbortMultipartReadSetUploadResponse;
import software.amazon.awssdk.services.omics.model.AcceptShareRequest;
import software.amazon.awssdk.services.omics.model.AcceptShareResponse;
import software.amazon.awssdk.services.omics.model.AccessDeniedException;
import software.amazon.awssdk.services.omics.model.BatchDeleteReadSetRequest;
import software.amazon.awssdk.services.omics.model.BatchDeleteReadSetResponse;
import software.amazon.awssdk.services.omics.model.CancelAnnotationImportJobRequest;
import software.amazon.awssdk.services.omics.model.CancelAnnotationImportJobResponse;
import software.amazon.awssdk.services.omics.model.CancelRunRequest;
import software.amazon.awssdk.services.omics.model.CancelRunResponse;
import software.amazon.awssdk.services.omics.model.CancelVariantImportJobRequest;
import software.amazon.awssdk.services.omics.model.CancelVariantImportJobResponse;
import software.amazon.awssdk.services.omics.model.CompleteMultipartReadSetUploadRequest;
import software.amazon.awssdk.services.omics.model.CompleteMultipartReadSetUploadResponse;
import software.amazon.awssdk.services.omics.model.ConflictException;
import software.amazon.awssdk.services.omics.model.CreateAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateAnnotationStoreVersionRequest;
import software.amazon.awssdk.services.omics.model.CreateAnnotationStoreVersionResponse;
import software.amazon.awssdk.services.omics.model.CreateMultipartReadSetUploadRequest;
import software.amazon.awssdk.services.omics.model.CreateMultipartReadSetUploadResponse;
import software.amazon.awssdk.services.omics.model.CreateReferenceStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateReferenceStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateRunCacheRequest;
import software.amazon.awssdk.services.omics.model.CreateRunCacheResponse;
import software.amazon.awssdk.services.omics.model.CreateRunGroupRequest;
import software.amazon.awssdk.services.omics.model.CreateRunGroupResponse;
import software.amazon.awssdk.services.omics.model.CreateSequenceStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateSequenceStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateShareRequest;
import software.amazon.awssdk.services.omics.model.CreateShareResponse;
import software.amazon.awssdk.services.omics.model.CreateVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateWorkflowRequest;
import software.amazon.awssdk.services.omics.model.CreateWorkflowResponse;
import software.amazon.awssdk.services.omics.model.CreateWorkflowVersionRequest;
import software.amazon.awssdk.services.omics.model.CreateWorkflowVersionResponse;
import software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreVersionsRequest;
import software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreVersionsResponse;
import software.amazon.awssdk.services.omics.model.DeleteReferenceRequest;
import software.amazon.awssdk.services.omics.model.DeleteReferenceResponse;
import software.amazon.awssdk.services.omics.model.DeleteReferenceStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteReferenceStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteRunCacheRequest;
import software.amazon.awssdk.services.omics.model.DeleteRunCacheResponse;
import software.amazon.awssdk.services.omics.model.DeleteRunGroupRequest;
import software.amazon.awssdk.services.omics.model.DeleteRunGroupResponse;
import software.amazon.awssdk.services.omics.model.DeleteRunRequest;
import software.amazon.awssdk.services.omics.model.DeleteRunResponse;
import software.amazon.awssdk.services.omics.model.DeleteS3AccessPolicyRequest;
import software.amazon.awssdk.services.omics.model.DeleteS3AccessPolicyResponse;
import software.amazon.awssdk.services.omics.model.DeleteSequenceStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteSequenceStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteShareRequest;
import software.amazon.awssdk.services.omics.model.DeleteShareResponse;
import software.amazon.awssdk.services.omics.model.DeleteVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteWorkflowRequest;
import software.amazon.awssdk.services.omics.model.DeleteWorkflowResponse;
import software.amazon.awssdk.services.omics.model.DeleteWorkflowVersionRequest;
import software.amazon.awssdk.services.omics.model.DeleteWorkflowVersionResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreVersionRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreVersionResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetActivationJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetActivationJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetExportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetExportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetMetadataRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetMetadataResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceMetadataRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceMetadataResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceStoreRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceStoreResponse;
import software.amazon.awssdk.services.omics.model.GetRunCacheRequest;
import software.amazon.awssdk.services.omics.model.GetRunCacheResponse;
import software.amazon.awssdk.services.omics.model.GetRunGroupRequest;
import software.amazon.awssdk.services.omics.model.GetRunGroupResponse;
import software.amazon.awssdk.services.omics.model.GetRunRequest;
import software.amazon.awssdk.services.omics.model.GetRunResponse;
import software.amazon.awssdk.services.omics.model.GetRunTaskRequest;
import software.amazon.awssdk.services.omics.model.GetRunTaskResponse;
import software.amazon.awssdk.services.omics.model.GetS3AccessPolicyRequest;
import software.amazon.awssdk.services.omics.model.GetS3AccessPolicyResponse;
import software.amazon.awssdk.services.omics.model.GetSequenceStoreRequest;
import software.amazon.awssdk.services.omics.model.GetSequenceStoreResponse;
import software.amazon.awssdk.services.omics.model.GetShareRequest;
import software.amazon.awssdk.services.omics.model.GetShareResponse;
import software.amazon.awssdk.services.omics.model.GetVariantImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetVariantImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.GetVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.GetWorkflowRequest;
import software.amazon.awssdk.services.omics.model.GetWorkflowResponse;
import software.amazon.awssdk.services.omics.model.GetWorkflowVersionRequest;
import software.amazon.awssdk.services.omics.model.GetWorkflowVersionResponse;
import software.amazon.awssdk.services.omics.model.InternalServerException;
import software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoreVersionsRequest;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoreVersionsResponse;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoresResponse;
import software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsRequest;
import software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetExportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetsResponse;
import software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReferenceImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest;
import software.amazon.awssdk.services.omics.model.ListReferenceStoresResponse;
import software.amazon.awssdk.services.omics.model.ListReferencesRequest;
import software.amazon.awssdk.services.omics.model.ListReferencesResponse;
import software.amazon.awssdk.services.omics.model.ListRunCachesRequest;
import software.amazon.awssdk.services.omics.model.ListRunCachesResponse;
import software.amazon.awssdk.services.omics.model.ListRunGroupsRequest;
import software.amazon.awssdk.services.omics.model.ListRunGroupsResponse;
import software.amazon.awssdk.services.omics.model.ListRunTasksRequest;
import software.amazon.awssdk.services.omics.model.ListRunTasksResponse;
import software.amazon.awssdk.services.omics.model.ListRunsRequest;
import software.amazon.awssdk.services.omics.model.ListRunsResponse;
import software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest;
import software.amazon.awssdk.services.omics.model.ListSequenceStoresResponse;
import software.amazon.awssdk.services.omics.model.ListSharesRequest;
import software.amazon.awssdk.services.omics.model.ListSharesResponse;
import software.amazon.awssdk.services.omics.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.omics.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListVariantImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListVariantStoresRequest;
import software.amazon.awssdk.services.omics.model.ListVariantStoresResponse;
import software.amazon.awssdk.services.omics.model.ListWorkflowVersionsRequest;
import software.amazon.awssdk.services.omics.model.ListWorkflowVersionsResponse;
import software.amazon.awssdk.services.omics.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.omics.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.omics.model.NotSupportedOperationException;
import software.amazon.awssdk.services.omics.model.OmicsException;
import software.amazon.awssdk.services.omics.model.PutS3AccessPolicyRequest;
import software.amazon.awssdk.services.omics.model.PutS3AccessPolicyResponse;
import software.amazon.awssdk.services.omics.model.RangeNotSatisfiableException;
import software.amazon.awssdk.services.omics.model.RequestTimeoutException;
import software.amazon.awssdk.services.omics.model.ResourceNotFoundException;
import software.amazon.awssdk.services.omics.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.omics.model.StartAnnotationImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartAnnotationImportJobResponse;
import software.amazon.awssdk.services.omics.model.StartReadSetActivationJobRequest;
import software.amazon.awssdk.services.omics.model.StartReadSetActivationJobResponse;
import software.amazon.awssdk.services.omics.model.StartReadSetExportJobRequest;
import software.amazon.awssdk.services.omics.model.StartReadSetExportJobResponse;
import software.amazon.awssdk.services.omics.model.StartReadSetImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartReadSetImportJobResponse;
import software.amazon.awssdk.services.omics.model.StartReferenceImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartReferenceImportJobResponse;
import software.amazon.awssdk.services.omics.model.StartRunRequest;
import software.amazon.awssdk.services.omics.model.StartRunResponse;
import software.amazon.awssdk.services.omics.model.StartVariantImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartVariantImportJobResponse;
import software.amazon.awssdk.services.omics.model.TagResourceRequest;
import software.amazon.awssdk.services.omics.model.TagResourceResponse;
import software.amazon.awssdk.services.omics.model.ThrottlingException;
import software.amazon.awssdk.services.omics.model.UntagResourceRequest;
import software.amazon.awssdk.services.omics.model.UntagResourceResponse;
import software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreVersionRequest;
import software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreVersionResponse;
import software.amazon.awssdk.services.omics.model.UpdateRunCacheRequest;
import software.amazon.awssdk.services.omics.model.UpdateRunCacheResponse;
import software.amazon.awssdk.services.omics.model.UpdateRunGroupRequest;
import software.amazon.awssdk.services.omics.model.UpdateRunGroupResponse;
import software.amazon.awssdk.services.omics.model.UpdateSequenceStoreRequest;
import software.amazon.awssdk.services.omics.model.UpdateSequenceStoreResponse;
import software.amazon.awssdk.services.omics.model.UpdateVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.UpdateVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.UpdateWorkflowRequest;
import software.amazon.awssdk.services.omics.model.UpdateWorkflowResponse;
import software.amazon.awssdk.services.omics.model.UpdateWorkflowVersionRequest;
import software.amazon.awssdk.services.omics.model.UpdateWorkflowVersionResponse;
import software.amazon.awssdk.services.omics.model.UploadReadSetPartRequest;
import software.amazon.awssdk.services.omics.model.UploadReadSetPartResponse;
import software.amazon.awssdk.services.omics.model.ValidationException;
import software.amazon.awssdk.services.omics.transform.AbortMultipartReadSetUploadRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.AcceptShareRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.BatchDeleteReadSetRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CancelAnnotationImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CancelRunRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CancelVariantImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CompleteMultipartReadSetUploadRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateAnnotationStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateAnnotationStoreVersionRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateMultipartReadSetUploadRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateReferenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateRunCacheRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateRunGroupRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateSequenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateShareRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateVariantStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateWorkflowRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.CreateWorkflowVersionRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteAnnotationStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteAnnotationStoreVersionsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteReferenceRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteReferenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteRunCacheRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteRunGroupRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteRunRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteS3AccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteSequenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteShareRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteVariantStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteWorkflowRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.DeleteWorkflowVersionRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetAnnotationImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetAnnotationStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetAnnotationStoreVersionRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReadSetActivationJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReadSetExportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReadSetImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReadSetMetadataRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReadSetRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReferenceImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReferenceMetadataRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReferenceRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetReferenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetRunCacheRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetRunGroupRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetRunRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetRunTaskRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetS3AccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetSequenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetShareRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetVariantImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetVariantStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetWorkflowRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.GetWorkflowVersionRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListAnnotationImportJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListAnnotationStoreVersionsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListAnnotationStoresRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListMultipartReadSetUploadsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReadSetActivationJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReadSetExportJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReadSetImportJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReadSetUploadPartsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReadSetsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReferenceImportJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReferenceStoresRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListReferencesRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListRunCachesRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListRunGroupsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListRunTasksRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListRunsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListSequenceStoresRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListSharesRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListVariantImportJobsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListVariantStoresRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListWorkflowVersionsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.ListWorkflowsRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.PutS3AccessPolicyRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartAnnotationImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartReadSetActivationJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartReadSetExportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartReadSetImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartReferenceImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartRunRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.StartVariantImportJobRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateAnnotationStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateAnnotationStoreVersionRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateRunCacheRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateRunGroupRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateSequenceStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateVariantStoreRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateWorkflowRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UpdateWorkflowVersionRequestMarshaller;
import software.amazon.awssdk.services.omics.transform.UploadReadSetPartRequestMarshaller;
import software.amazon.awssdk.services.omics.waiters.OmicsWaiter;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link OmicsClient}.
 *
 * @see OmicsClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultOmicsClient implements OmicsClient {
    private static final Logger log = Logger.loggerFor(DefaultOmicsClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultOmicsClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "Omics" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Stops a multipart read set upload into a sequence store and returns a response with no body if the operation is
     * successful. To confirm that a multipart read set upload has been stopped, use the
     * <code>ListMultipartReadSetUploads</code> API operation to view all active multipart read set uploads.
     * </p>
     *
     * @param abortMultipartReadSetUploadRequest
     * @return Result of the AbortMultipartReadSetUpload operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws NotSupportedOperationException
     *         The operation is not supported by Amazon Omics, or the API does not exist.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.AbortMultipartReadSetUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/AbortMultipartReadSetUpload"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AbortMultipartReadSetUploadResponse abortMultipartReadSetUpload(
            AbortMultipartReadSetUploadRequest abortMultipartReadSetUploadRequest) throws InternalServerException,
            NotSupportedOperationException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AbortMultipartReadSetUploadResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AbortMultipartReadSetUploadResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(abortMultipartReadSetUploadRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, abortMultipartReadSetUploadRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AbortMultipartReadSetUpload");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler
                    .execute(new ClientExecutionParams<AbortMultipartReadSetUploadRequest, AbortMultipartReadSetUploadResponse>()
                            .withOperationName("AbortMultipartReadSetUpload").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(abortMultipartReadSetUploadRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AbortMultipartReadSetUploadRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Accept a resource share request.
     * </p>
     *
     * @param acceptShareRequest
     * @return Result of the AcceptShare operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.AcceptShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/AcceptShare" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AcceptShareResponse acceptShare(AcceptShareRequest acceptShareRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AcceptShareResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AcceptShareResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptShare");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<AcceptShareRequest, AcceptShareResponse>()
                    .withOperationName("AcceptShare").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(acceptShareRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AcceptShareRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes one or more read sets. If the operation is successful, it returns a response with no body. If there is an
     * error with deleting one of the read sets, the operation returns an error list. If the operation successfully
     * deletes only a subset of files, it will return an error list for the remaining files that fail to be deleted.
     * There is a limit of 100 read sets that can be deleted in each <code>BatchDeleteReadSet</code> API call.
     * </p>
     *
     * @param batchDeleteReadSetRequest
     * @return Result of the BatchDeleteReadSet operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.BatchDeleteReadSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/BatchDeleteReadSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public BatchDeleteReadSetResponse batchDeleteReadSet(BatchDeleteReadSetRequest batchDeleteReadSetRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<BatchDeleteReadSetResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, BatchDeleteReadSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(batchDeleteReadSetRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, batchDeleteReadSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "BatchDeleteReadSet");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<BatchDeleteReadSetRequest, BatchDeleteReadSetResponse>()
                    .withOperationName("BatchDeleteReadSet").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(batchDeleteReadSetRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new BatchDeleteReadSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels an annotation import job.
     * </p>
     *
     * @param cancelAnnotationImportJobRequest
     * @return Result of the CancelAnnotationImportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CancelAnnotationImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelAnnotationImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CancelAnnotationImportJobResponse cancelAnnotationImportJob(
            CancelAnnotationImportJobRequest cancelAnnotationImportJobRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelAnnotationImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelAnnotationImportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelAnnotationImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelAnnotationImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelAnnotationImportJob");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler
                    .execute(new ClientExecutionParams<CancelAnnotationImportJobRequest, CancelAnnotationImportJobResponse>()
                            .withOperationName("CancelAnnotationImportJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(cancelAnnotationImportJobRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelAnnotationImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a run using its ID and returns a response with no body if the operation is successful. To confirm that
     * the run has been cancelled, use the <code>ListRuns</code> API operation to check that it is no longer listed.
     * </p>
     *
     * @param cancelRunRequest
     * @return Result of the CancelRun operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CancelRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CancelRunResponse cancelRun(CancelRunRequest cancelRunRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CancelRunResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelRunRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelRun");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<CancelRunRequest, CancelRunResponse>()
                    .withOperationName("CancelRun").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(cancelRunRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new CancelRunRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Cancels a variant import job.
     * </p>
     *
     * @param cancelVariantImportJobRequest
     * @return Result of the CancelVariantImportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CancelVariantImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelVariantImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CancelVariantImportJobResponse cancelVariantImportJob(CancelVariantImportJobRequest cancelVariantImportJobRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelVariantImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CancelVariantImportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(cancelVariantImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelVariantImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelVariantImportJob");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler
                    .execute(new ClientExecutionParams<CancelVariantImportJobRequest, CancelVariantImportJobResponse>()
                            .withOperationName("CancelVariantImportJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(cancelVariantImportJobRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CancelVariantImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Completes a multipart read set upload into a sequence store after you have initiated the upload process with
     * <code>CreateMultipartReadSetUpload</code> and uploaded all read set parts using <code>UploadReadSetPart</code>.
     * You must specify the parts you uploaded using the parts parameter. If the operation is successful, it returns the
     * read set ID(s) of the uploaded read set(s).
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/synchronous-uploads.html">Direct
     * upload to a sequence store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param completeMultipartReadSetUploadRequest
     * @return Result of the CompleteMultipartReadSetUpload operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws NotSupportedOperationException
     *         The operation is not supported by Amazon Omics, or the API does not exist.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CompleteMultipartReadSetUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CompleteMultipartReadSetUpload"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompleteMultipartReadSetUploadResponse completeMultipartReadSetUpload(
            CompleteMultipartReadSetUploadRequest completeMultipartReadSetUploadRequest) throws InternalServerException,
            NotSupportedOperationException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CompleteMultipartReadSetUploadResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CompleteMultipartReadSetUploadResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(completeMultipartReadSetUploadRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                completeMultipartReadSetUploadRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CompleteMultipartReadSetUpload");
            String hostPrefix = "storage-";
            String resolvedHostExpression = "storage-";

            return clientHandler
                    .execute(new ClientExecutionParams<CompleteMultipartReadSetUploadRequest, CompleteMultipartReadSetUploadResponse>()
                            .withOperationName("CompleteMultipartReadSetUpload").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(completeMultipartReadSetUploadRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CompleteMultipartReadSetUploadRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an annotation store.
     * </p>
     *
     * @param createAnnotationStoreRequest
     * @return Result of the CreateAnnotationStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CreateAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateAnnotationStore" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateAnnotationStoreResponse createAnnotationStore(CreateAnnotationStoreRequest createAnnotationStoreRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ConflictException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAnnotationStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAnnotationStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAnnotationStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAnnotationStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAnnotationStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<CreateAnnotationStoreRequest, CreateAnnotationStoreResponse>()
                    .withOperationName("CreateAnnotationStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(createAnnotationStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAnnotationStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new version of an annotation store.
     * </p>
     *
     * @param createAnnotationStoreVersionRequest
     * @return Result of the CreateAnnotationStoreVersion operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CreateAnnotationStoreVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateAnnotationStoreVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAnnotationStoreVersionResponse createAnnotationStoreVersion(
            CreateAnnotationStoreVersionRequest createAnnotationStoreVersionRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAnnotationStoreVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAnnotationStoreVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createAnnotationStoreVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAnnotationStoreVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAnnotationStoreVersion");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler
                    .execute(new ClientExecutionParams<CreateAnnotationStoreVersionRequest, CreateAnnotationStoreVersionResponse>()
                            .withOperationName("CreateAnnotationStoreVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(createAnnotationStoreVersionRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateAnnotationStoreVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Initiates a multipart read set upload for uploading partitioned source files into a sequence store. You can
     * directly import source files from an EC2 instance and other local compute, or from an S3 bucket. To separate
     * these source files into parts, use the <code>split</code> operation. Each part cannot be larger than 100 MB. If
     * the operation is successful, it provides an <code>uploadId</code> which is required by the
     * <code>UploadReadSetPart</code> API operation to upload parts into a sequence store.
     * </p>
     * <p>
     * To continue uploading a multipart read set into your sequence store, you must use the
     * <code>UploadReadSetPart</code> API operation to upload each part individually following the steps below:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify the <code>uploadId</code> obtained from the previous call to <code>CreateMultipartReadSetUpload</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Upload parts for that <code>uploadId</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you have finished uploading parts, use the <code>CompleteMultipartReadSetUpload</code> API to complete the
     * multipart read set upload and to retrieve the final read set IDs in the response.
     * </p>
     * <p>
     * To learn more about creating parts and the <code>split</code> operation, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/synchronous-uploads.html">Direct upload to a sequence
     * store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param createMultipartReadSetUploadRequest
     * @return Result of the CreateMultipartReadSetUpload operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws NotSupportedOperationException
     *         The operation is not supported by Amazon Omics, or the API does not exist.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CreateMultipartReadSetUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateMultipartReadSetUpload"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateMultipartReadSetUploadResponse createMultipartReadSetUpload(
            CreateMultipartReadSetUploadRequest createMultipartReadSetUploadRequest) throws InternalServerException,
            NotSupportedOperationException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateMultipartReadSetUploadResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateMultipartReadSetUploadResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createMultipartReadSetUploadRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createMultipartReadSetUploadRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateMultipartReadSetUpload");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler
                    .execute(new ClientExecutionParams<CreateMultipartReadSetUploadRequest, CreateMultipartReadSetUploadResponse>()
                            .withOperationName("CreateMultipartReadSetUpload").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(createMultipartReadSetUploadRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateMultipartReadSetUploadRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a reference store and returns metadata in JSON format. Reference stores are used to store reference
     * genomes in FASTA format. A reference store is created when the first reference genome is imported. To import
     * additional reference genomes from an Amazon S3 bucket, use the <code>StartReferenceImportJob</code> API
     * operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-reference-store.html">Creating a HealthOmics reference
     * store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param createReferenceStoreRequest
     * @return Result of the CreateReferenceStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CreateReferenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateReferenceStore" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateReferenceStoreResponse createReferenceStore(CreateReferenceStoreRequest createReferenceStoreRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateReferenceStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateReferenceStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createReferenceStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createReferenceStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateReferenceStore");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<CreateReferenceStoreRequest, CreateReferenceStoreResponse>()
                    .withOperationName("CreateReferenceStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(createReferenceStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateReferenceStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a run cache to store and reference task outputs from completed private runs. Specify an Amazon S3
     * location where Amazon Web Services HealthOmics saves the cached data. This data must be immediately accessible
     * and not in an archived state. You can save intermediate task files to a run cache if they are declared as task
     * outputs in the workflow definition file.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflows-call-caching.html">Call
     * caching</a> and <a href="https://docs.aws.amazon.com/omics/latest/dev/workflow-cache-create.html">Creating a run
     * cache</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param createRunCacheRequest
     * @return Result of the CreateRunCache operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CreateRunCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateRunCache" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateRunCacheResponse createRunCache(CreateRunCacheRequest createRunCacheRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRunCacheResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateRunCacheResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRunCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRunCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRunCache");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<CreateRunCacheRequest, CreateRunCacheResponse>()
                    .withOperationName("CreateRunCache").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(createRunCacheRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRunCacheRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a run group to limit the compute resources for the runs that are added to the group. Returns an ARN, ID,
     * and tags for the run group.
     * </p>
     *
     * @param createRunGroupRequest
     * @return Result of the CreateRunGroup operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CreateRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateRunGroupResponse createRunGroup(CreateRunGroupRequest createRunGroupRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateRunGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateRunGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createRunGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createRunGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateRunGroup");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<CreateRunGroupRequest, CreateRunGroupResponse>()
                    .withOperationName("CreateRunGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(createRunGroupRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateRunGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a sequence store and returns its metadata. Sequence stores are used to store sequence data files called
     * read sets that are saved in FASTQ, BAM, uBAM, or CRAM formats. For aligned formats (BAM and CRAM), a sequence
     * store can only use one reference genome. For unaligned formats (FASTQ and uBAM), a reference genome is not
     * required. You can create multiple sequence stores per region per account.
     * </p>
     * <p>
     * The following are optional parameters you can specify for your sequence store:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>s3AccessConfig</code> to configure your sequence store with S3 access logs (recommended).
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>sseConfig</code> to define your own KMS key for encryption.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>eTagAlgorithmFamily</code> to define which algorithm to use for the HealthOmics eTag on objects.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>fallbackLocation</code> to define a backup location for storing files that have failed a direct upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>propagatedSetLevelTags</code> to configure tags that propagate to all objects in your store.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-sequence-store.html">Creating a HealthOmics sequence
     * store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param createSequenceStoreRequest
     * @return Result of the CreateSequenceStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CreateSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateSequenceStoreResponse createSequenceStore(CreateSequenceStoreRequest createSequenceStoreRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateSequenceStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateSequenceStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createSequenceStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createSequenceStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateSequenceStore");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<CreateSequenceStoreRequest, CreateSequenceStoreResponse>()
                    .withOperationName("CreateSequenceStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(createSequenceStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateSequenceStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a cross-account shared resource. The resource owner makes an offer to share the resource with the
     * principal subscriber (an AWS user with a different account than the resource owner).
     * </p>
     * <p>
     * The following resources support cross-account sharing:
     * </p>
     * <ul>
     * <li>
     * <p>
     * HealthOmics variant stores
     * </p>
     * </li>
     * <li>
     * <p>
     * HealthOmics annotation stores
     * </p>
     * </li>
     * <li>
     * <p>
     * Private workflows
     * </p>
     * </li>
     * </ul>
     *
     * @param createShareRequest
     * @return Result of the CreateShare operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CreateShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateShare" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateShareResponse createShare(CreateShareRequest createShareRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateShareResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateShareResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateShare");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<CreateShareRequest, CreateShareResponse>()
                    .withOperationName("CreateShare").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(createShareRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateShareRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a variant store.
     * </p>
     *
     * @param createVariantStoreRequest
     * @return Result of the CreateVariantStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CreateVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateVariantStoreResponse createVariantStore(CreateVariantStoreRequest createVariantStoreRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ConflictException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateVariantStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateVariantStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createVariantStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createVariantStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateVariantStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<CreateVariantStoreRequest, CreateVariantStoreResponse>()
                    .withOperationName("CreateVariantStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(createVariantStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateVariantStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a private workflow. Before you create a private workflow, you must create and configure these required
     * resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Workflow definition files</i>: Define your workflow in one or more workflow definition files, written in WDL,
     * Nextflow, or CWL. The workflow definition specifies the inputs and outputs for runs that use the workflow. It
     * also includes specifications for the runs and run tasks for your workflow, including compute and memory
     * requirements. The workflow definition file must be in .zip format.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) <i>Parameter template</i>: You can create a parameter template file that defines the run parameters,
     * or Amazon Web Services HealthOmics can generate the parameter template for you.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>ECR container images</i>: Create container images for the workflow in a private ECR repository, or synchronize
     * images from a supported upstream registry with your Amazon ECR private repository.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) <i>Sentieon licenses</i>: Request a Sentieon license if using the Sentieon software in a private
     * workflow.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/creating-private-workflows.html">Creating or updating a
     * private workflow in Amazon Web Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param createWorkflowRequest
     * @return Result of the CreateWorkflow operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CreateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateWorkflowResponse createWorkflow(CreateWorkflowRequest createWorkflowRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateWorkflowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkflowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkflow");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<CreateWorkflowRequest, CreateWorkflowResponse>()
                    .withOperationName("CreateWorkflow").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(createWorkflowRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWorkflowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new workflow version for the workflow that you specify with the <code>workflowId</code> parameter.
     * </p>
     * <p>
     * When you create a new version of a workflow, you need to specify the configuration for the new version. It
     * doesn't inherit any configuration values from the workflow.
     * </p>
     * <p>
     * Provide a version name that is unique for this workflow. You cannot change the name after HealthOmics creates the
     * version.
     * </p>
     * <note>
     * <p>
     * Don't include any personally identifiable information (PII) in the version name. Version names appear in the
     * workflow version ARN.
     * </p>
     * </note>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html">Workflow
     * versioning in Amazon Web Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param createWorkflowVersionRequest
     * @return Result of the CreateWorkflowVersion operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.CreateWorkflowVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateWorkflowVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateWorkflowVersionResponse createWorkflowVersion(CreateWorkflowVersionRequest createWorkflowVersionRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException,
            SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateWorkflowVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateWorkflowVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createWorkflowVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createWorkflowVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateWorkflowVersion");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<CreateWorkflowVersionRequest, CreateWorkflowVersionResponse>()
                    .withOperationName("CreateWorkflowVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(createWorkflowVersionRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateWorkflowVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an annotation store.
     * </p>
     *
     * @param deleteAnnotationStoreRequest
     * @return Result of the DeleteAnnotationStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.DeleteAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteAnnotationStore" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteAnnotationStoreResponse deleteAnnotationStore(DeleteAnnotationStoreRequest deleteAnnotationStoreRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAnnotationStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAnnotationStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAnnotationStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAnnotationStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAnnotationStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<DeleteAnnotationStoreRequest, DeleteAnnotationStoreResponse>()
                    .withOperationName("DeleteAnnotationStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteAnnotationStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAnnotationStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes one or multiple versions of an annotation store.
     * </p>
     *
     * @param deleteAnnotationStoreVersionsRequest
     * @return Result of the DeleteAnnotationStoreVersions operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.DeleteAnnotationStoreVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteAnnotationStoreVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAnnotationStoreVersionsResponse deleteAnnotationStoreVersions(
            DeleteAnnotationStoreVersionsRequest deleteAnnotationStoreVersionsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException,
            AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAnnotationStoreVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAnnotationStoreVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteAnnotationStoreVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                deleteAnnotationStoreVersionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAnnotationStoreVersions");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAnnotationStoreVersionsRequest, DeleteAnnotationStoreVersionsResponse>()
                            .withOperationName("DeleteAnnotationStoreVersions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(deleteAnnotationStoreVersionsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAnnotationStoreVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a reference genome and returns a response with no body if the operation is successful. The read set
     * associated with the reference genome must first be deleted before deleting the reference genome. After the
     * reference genome is deleted, you can delete the reference store using the <code>DeleteReferenceStore</code> API
     * operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/deleting-reference-and-sequence-stores.html">Deleting
     * HealthOmics reference and sequence stores</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param deleteReferenceRequest
     * @return Result of the DeleteReference operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.DeleteReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteReference" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteReferenceResponse deleteReference(DeleteReferenceRequest deleteReferenceRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException,
            RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteReferenceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteReferenceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteReferenceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteReferenceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReference");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<DeleteReferenceRequest, DeleteReferenceResponse>()
                    .withOperationName("DeleteReference").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteReferenceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteReferenceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a reference store and returns a response with no body if the operation is successful. You can only delete
     * a reference store when it does not contain any reference genomes. To empty a reference store, use
     * <code>DeleteReference</code>.
     * </p>
     * <p>
     * For more information about your workflow status, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/deleting-reference-and-sequence-stores.html">Deleting
     * HealthOmics reference and sequence stores</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param deleteReferenceStoreRequest
     * @return Result of the DeleteReferenceStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.DeleteReferenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteReferenceStore" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteReferenceStoreResponse deleteReferenceStore(DeleteReferenceStoreRequest deleteReferenceStoreRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteReferenceStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteReferenceStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteReferenceStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteReferenceStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteReferenceStore");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<DeleteReferenceStoreRequest, DeleteReferenceStoreResponse>()
                    .withOperationName("DeleteReferenceStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteReferenceStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteReferenceStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a run and returns a response with no body if the operation is successful. You can only delete a run that
     * has reached a <code>COMPLETED</code>, <code>FAILED</code>, or <code>CANCELLED</code> stage. A completed run has
     * delivered an output, or was cancelled and resulted in no output. When you delete a run, only the metadata
     * associated with the run is deleted. The run outputs remain in Amazon S3 and logs remain in CloudWatch.
     * </p>
     * <p>
     * To verify that the workflow is deleted:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>ListRuns</code> to confirm the workflow no longer appears in the list.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>GetRun</code> to verify the workflow cannot be found.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteRunRequest
     * @return Result of the DeleteRun operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.DeleteRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteRunResponse deleteRun(DeleteRunRequest deleteRunRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteRunResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRunRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRun");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<DeleteRunRequest, DeleteRunResponse>()
                    .withOperationName("DeleteRun").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteRunRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new DeleteRunRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a run cache and returns a response with no body if the operation is successful. This action removes the
     * cache metadata stored in the service account, but does not delete the data in Amazon S3. You can access the cache
     * data in Amazon S3, for inspection or to troubleshoot issues. You can remove old cache data using standard S3
     * <code>Delete</code> operations.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/workflow-cache-delete.html">Deleting a run cache</a> in the
     * <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param deleteRunCacheRequest
     * @return Result of the DeleteRunCache operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.DeleteRunCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteRunCache" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteRunCacheResponse deleteRunCache(DeleteRunCacheRequest deleteRunCacheRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRunCacheResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteRunCacheResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRunCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRunCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRunCache");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<DeleteRunCacheRequest, DeleteRunCacheResponse>()
                    .withOperationName("DeleteRunCache").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteRunCacheRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRunCacheRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a run group and returns a response with no body if the operation is successful.
     * </p>
     * <p>
     * To verify that the run group is deleted:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>ListRunGroups</code> to confirm the workflow no longer appears in the list.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>GetRunGroup</code> to verify the workflow cannot be found.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteRunGroupRequest
     * @return Result of the DeleteRunGroup operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.DeleteRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteRunGroupResponse deleteRunGroup(DeleteRunGroupRequest deleteRunGroupRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteRunGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteRunGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteRunGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteRunGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteRunGroup");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<DeleteRunGroupRequest, DeleteRunGroupResponse>()
                    .withOperationName("DeleteRunGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteRunGroupRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteRunGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an access policy for the specified store.
     * </p>
     *
     * @param deleteS3AccessPolicyRequest
     * @return Result of the DeleteS3AccessPolicy operation returned by the service.
     * @throws NotSupportedOperationException
     *         The operation is not supported by Amazon Omics, or the API does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.DeleteS3AccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteS3AccessPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteS3AccessPolicyResponse deleteS3AccessPolicy(DeleteS3AccessPolicyRequest deleteS3AccessPolicyRequest)
            throws NotSupportedOperationException, InternalServerException, ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteS3AccessPolicyResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteS3AccessPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteS3AccessPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteS3AccessPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteS3AccessPolicy");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<DeleteS3AccessPolicyRequest, DeleteS3AccessPolicyResponse>()
                    .withOperationName("DeleteS3AccessPolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteS3AccessPolicyRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteS3AccessPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a sequence store and returns a response with no body if the operation is successful. You can only delete
     * a sequence store when it does not contain any read sets.
     * </p>
     * <p>
     * Use the <code>BatchDeleteReadSet</code> API operation to ensure that all read sets in the sequence store are
     * deleted. When a sequence store is deleted, all tags associated with the store are also deleted.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/deleting-reference-and-sequence-stores.html">Deleting
     * HealthOmics reference and sequence stores</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param deleteSequenceStoreRequest
     * @return Result of the DeleteSequenceStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.DeleteSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteSequenceStoreResponse deleteSequenceStore(DeleteSequenceStoreRequest deleteSequenceStoreRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteSequenceStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteSequenceStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteSequenceStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteSequenceStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteSequenceStore");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<DeleteSequenceStoreRequest, DeleteSequenceStoreResponse>()
                    .withOperationName("DeleteSequenceStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteSequenceStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteSequenceStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a resource share. If you are the resource owner, the subscriber will no longer have access to the shared
     * resource. If you are the subscriber, this operation deletes your access to the share.
     * </p>
     *
     * @param deleteShareRequest
     * @return Result of the DeleteShare operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.DeleteShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteShare" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteShareResponse deleteShare(DeleteShareRequest deleteShareRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteShareResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteShareResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteShare");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<DeleteShareRequest, DeleteShareResponse>()
                    .withOperationName("DeleteShare").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteShareRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteShareRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a variant store.
     * </p>
     *
     * @param deleteVariantStoreRequest
     * @return Result of the DeleteVariantStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.DeleteVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteVariantStoreResponse deleteVariantStore(DeleteVariantStoreRequest deleteVariantStoreRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteVariantStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteVariantStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteVariantStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteVariantStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteVariantStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<DeleteVariantStoreRequest, DeleteVariantStoreResponse>()
                    .withOperationName("DeleteVariantStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteVariantStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteVariantStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a workflow by specifying its ID. This operation returns a response with no body if the deletion is
     * successful.
     * </p>
     * <p>
     * To verify that the workflow is deleted:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>ListWorkflows</code> to confirm the workflow no longer appears in the list.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>GetWorkflow</code> to verify the workflow cannot be found.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteWorkflowRequest
     * @return Result of the DeleteWorkflow operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.DeleteWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteWorkflowResponse deleteWorkflow(DeleteWorkflowRequest deleteWorkflowRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteWorkflowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWorkflowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkflow");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<DeleteWorkflowRequest, DeleteWorkflowResponse>()
                    .withOperationName("DeleteWorkflow").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteWorkflowRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteWorkflowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a workflow version. Deleting a workflow version doesn't affect any ongoing runs that are using the
     * workflow version.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html">Workflow
     * versioning in Amazon Web Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param deleteWorkflowVersionRequest
     * @return Result of the DeleteWorkflowVersion operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.DeleteWorkflowVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteWorkflowVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteWorkflowVersionResponse deleteWorkflowVersion(DeleteWorkflowVersionRequest deleteWorkflowVersionRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException,
            SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteWorkflowVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteWorkflowVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteWorkflowVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteWorkflowVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteWorkflowVersion");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<DeleteWorkflowVersionRequest, DeleteWorkflowVersionResponse>()
                    .withOperationName("DeleteWorkflowVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteWorkflowVersionRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteWorkflowVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about an annotation import job.
     * </p>
     *
     * @param getAnnotationImportJobRequest
     * @return Result of the GetAnnotationImportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetAnnotationImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetAnnotationImportJobResponse getAnnotationImportJob(GetAnnotationImportJobRequest getAnnotationImportJobRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAnnotationImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAnnotationImportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAnnotationImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAnnotationImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAnnotationImportJob");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler
                    .execute(new ClientExecutionParams<GetAnnotationImportJobRequest, GetAnnotationImportJobResponse>()
                            .withOperationName("GetAnnotationImportJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(getAnnotationImportJobRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAnnotationImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about an annotation store.
     * </p>
     *
     * @param getAnnotationStoreRequest
     * @return Result of the GetAnnotationStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetAnnotationStoreResponse getAnnotationStore(GetAnnotationStoreRequest getAnnotationStoreRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAnnotationStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAnnotationStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAnnotationStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAnnotationStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAnnotationStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<GetAnnotationStoreRequest, GetAnnotationStoreResponse>()
                    .withOperationName("GetAnnotationStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getAnnotationStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetAnnotationStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the metadata for an annotation store version.
     * </p>
     *
     * @param getAnnotationStoreVersionRequest
     * @return Result of the GetAnnotationStoreVersion operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetAnnotationStoreVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationStoreVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAnnotationStoreVersionResponse getAnnotationStoreVersion(
            GetAnnotationStoreVersionRequest getAnnotationStoreVersionRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAnnotationStoreVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAnnotationStoreVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAnnotationStoreVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAnnotationStoreVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAnnotationStoreVersion");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler
                    .execute(new ClientExecutionParams<GetAnnotationStoreVersionRequest, GetAnnotationStoreVersionResponse>()
                            .withOperationName("GetAnnotationStoreVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(getAnnotationStoreVersionRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAnnotationStoreVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves detailed information from parts of a read set and returns the read set in the same format that it was
     * uploaded. You must have read sets uploaded to your sequence store in order to run this operation.
     * </p>
     *
     * @param getReadSetRequest
     * @param responseTransformer
     *        Functional interface for processing the streamed response content. The unmarshalled GetReadSetResponse and
     *        an InputStream to the response content are provided as parameters to the callback. The callback may return
     *        a transformed type which will be the return value of this method. See
     *        {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this interface
     *        and for links to pre-canned implementations for common scenarios like downloading to a file. The service
     *        documentation for the response content is as follows '
     *        <p>
     *        The read set file payload.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws RangeNotSatisfiableException
     *         The ranges specified in the request are not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetReadSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public <ReturnT> ReturnT getReadSet(GetReadSetRequest getReadSetRequest,
            ResponseTransformer<GetReadSetResponse, ReturnT> responseTransformer) throws InternalServerException,
            RangeNotSatisfiableException, ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true)
                .isPayloadJson(false).build();

        HttpResponseHandler<GetReadSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetReadSetResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReadSetRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReadSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReadSet");
            String hostPrefix = "storage-";
            String resolvedHostExpression = "storage-";

            return clientHandler.execute(
                    new ClientExecutionParams<GetReadSetRequest, GetReadSetResponse>().withOperationName("GetReadSet")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withRequestConfiguration(clientConfiguration).withInput(getReadSetRequest)
                            .withMetricCollector(apiCallMetricCollector).withResponseTransformer(responseTransformer)
                            .withMarshaller(new GetReadSetRequestMarshaller(protocolFactory)), responseTransformer);
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns detailed information about the status of a read set activation job in JSON format.
     * </p>
     *
     * @param getReadSetActivationJobRequest
     * @return Result of the GetReadSetActivationJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetReadSetActivationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetActivationJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetReadSetActivationJobResponse getReadSetActivationJob(GetReadSetActivationJobRequest getReadSetActivationJobRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetReadSetActivationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetReadSetActivationJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReadSetActivationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReadSetActivationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReadSetActivationJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler
                    .execute(new ClientExecutionParams<GetReadSetActivationJobRequest, GetReadSetActivationJobResponse>()
                            .withOperationName("GetReadSetActivationJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(getReadSetActivationJobRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetReadSetActivationJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves status information about a read set export job and returns the data in JSON format. Use this operation
     * to actively monitor the progress of an export job.
     * </p>
     *
     * @param getReadSetExportJobRequest
     * @return Result of the GetReadSetExportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetReadSetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetReadSetExportJobResponse getReadSetExportJob(GetReadSetExportJobRequest getReadSetExportJobRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetReadSetExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetReadSetExportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReadSetExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReadSetExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReadSetExportJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<GetReadSetExportJobRequest, GetReadSetExportJobResponse>()
                    .withOperationName("GetReadSetExportJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getReadSetExportJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetReadSetExportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets detailed and status information about a read set import job and returns the data in JSON format.
     * </p>
     *
     * @param getReadSetImportJobRequest
     * @return Result of the GetReadSetImportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetReadSetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetReadSetImportJobResponse getReadSetImportJob(GetReadSetImportJobRequest getReadSetImportJobRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetReadSetImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetReadSetImportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReadSetImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReadSetImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReadSetImportJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<GetReadSetImportJobRequest, GetReadSetImportJobResponse>()
                    .withOperationName("GetReadSetImportJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getReadSetImportJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetReadSetImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the metadata for a read set from a sequence store in JSON format. This operation does not return tags.
     * To retrieve the list of tags for a read set, use the <code>ListTagsForResource</code> API operation.
     * </p>
     *
     * @param getReadSetMetadataRequest
     * @return Result of the GetReadSetMetadata operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetReadSetMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetReadSetMetadataResponse getReadSetMetadata(GetReadSetMetadataRequest getReadSetMetadataRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetReadSetMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetReadSetMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReadSetMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReadSetMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReadSetMetadata");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<GetReadSetMetadataRequest, GetReadSetMetadataResponse>()
                    .withOperationName("GetReadSetMetadata").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getReadSetMetadataRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetReadSetMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Downloads parts of data from a reference genome and returns the reference file in the same format that it was
     * uploaded.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-reference-store.html">Creating a HealthOmics reference
     * store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param getReferenceRequest
     * @param responseTransformer
     *        Functional interface for processing the streamed response content. The unmarshalled GetReferenceResponse
     *        and an InputStream to the response content are provided as parameters to the callback. The callback may
     *        return a transformed type which will be the return value of this method. See
     *        {@link software.amazon.awssdk.core.sync.ResponseTransformer} for details on implementing this interface
     *        and for links to pre-canned implementations for common scenarios like downloading to a file. The service
     *        documentation for the response content is as follows '
     *        <p>
     *        The reference file payload.
     *        </p>
     *        '.
     * @return The transformed result of the ResponseTransformer.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws RangeNotSatisfiableException
     *         The ranges specified in the request are not valid.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReference" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public <ReturnT> ReturnT getReference(GetReferenceRequest getReferenceRequest,
            ResponseTransformer<GetReferenceResponse, ReturnT> responseTransformer) throws InternalServerException,
            RangeNotSatisfiableException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(true)
                .isPayloadJson(false).build();

        HttpResponseHandler<GetReferenceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetReferenceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReferenceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReferenceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReference");
            String hostPrefix = "storage-";
            String resolvedHostExpression = "storage-";

            return clientHandler.execute(
                    new ClientExecutionParams<GetReferenceRequest, GetReferenceResponse>().withOperationName("GetReference")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withRequestConfiguration(clientConfiguration).withInput(getReferenceRequest)
                            .withMetricCollector(apiCallMetricCollector).withResponseTransformer(responseTransformer)
                            .withMarshaller(new GetReferenceRequestMarshaller(protocolFactory)), responseTransformer);
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Monitors the status of a reference import job. This operation can be called after calling the
     * <code>StartReferenceImportJob</code> operation.
     * </p>
     *
     * @param getReferenceImportJobRequest
     * @return Result of the GetReferenceImportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetReferenceImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetReferenceImportJobResponse getReferenceImportJob(GetReferenceImportJobRequest getReferenceImportJobRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetReferenceImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetReferenceImportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReferenceImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReferenceImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReferenceImportJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<GetReferenceImportJobRequest, GetReferenceImportJobResponse>()
                    .withOperationName("GetReferenceImportJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getReferenceImportJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetReferenceImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves metadata for a reference genome. This operation returns the number of parts, part size, and MD5 of an
     * entire file. This operation does not return tags. To retrieve the list of tags for a read set, use the
     * <code>ListTagsForResource</code> API operation.
     * </p>
     *
     * @param getReferenceMetadataRequest
     * @return Result of the GetReferenceMetadata operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetReferenceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetReferenceMetadataResponse getReferenceMetadata(GetReferenceMetadataRequest getReferenceMetadataRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetReferenceMetadataResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetReferenceMetadataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReferenceMetadataRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReferenceMetadataRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReferenceMetadata");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<GetReferenceMetadataRequest, GetReferenceMetadataResponse>()
                    .withOperationName("GetReferenceMetadata").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getReferenceMetadataRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetReferenceMetadataRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a reference store.
     * </p>
     *
     * @param getReferenceStoreRequest
     * @return Result of the GetReferenceStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetReferenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetReferenceStoreResponse getReferenceStore(GetReferenceStoreRequest getReferenceStoreRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetReferenceStoreResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetReferenceStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getReferenceStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getReferenceStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetReferenceStore");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<GetReferenceStoreRequest, GetReferenceStoreResponse>()
                    .withOperationName("GetReferenceStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getReferenceStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetReferenceStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets detailed information about a specific run using its ID.
     * </p>
     * <p>
     * Amazon Web Services HealthOmics stores a configurable number of runs, as determined by service limits, that are
     * available to the console and API. If <code>GetRun</code> does not return the requested run, you can find all run
     * logs in the CloudWatch logs. For more information about viewing the run logs, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/monitoring-cloudwatch-logs.html">CloudWatch logs</a> in the
     * <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param getRunRequest
     * @return Result of the GetRun operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetRunResponse getRun(GetRunRequest getRunRequest) throws InternalServerException, ServiceQuotaExceededException,
            ThrottlingException, ValidationException, ConflictException, ResourceNotFoundException, AccessDeniedException,
            RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetRunResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRunRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRun");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<GetRunRequest, GetRunResponse>().withOperationName("GetRun")
                    .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(getRunRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetRunRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves detailed information about the specified run cache using its ID.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflows-call-caching.html">Call
     * caching for Amazon Web Services HealthOmics runs</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param getRunCacheRequest
     * @return Result of the GetRunCache operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetRunCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRunCache" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetRunCacheResponse getRunCache(GetRunCacheRequest getRunCacheRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRunCacheResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetRunCacheResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRunCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRunCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRunCache");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<GetRunCacheRequest, GetRunCacheResponse>()
                    .withOperationName("GetRunCache").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(getRunCacheRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetRunCacheRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a run group and returns its metadata.
     * </p>
     *
     * @param getRunGroupRequest
     * @return Result of the GetRunGroup operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetRunGroupResponse getRunGroup(GetRunGroupRequest getRunGroupRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRunGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetRunGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRunGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRunGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRunGroup");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<GetRunGroupRequest, GetRunGroupResponse>()
                    .withOperationName("GetRunGroup").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(getRunGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetRunGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets detailed information about a run task using its ID.
     * </p>
     *
     * @param getRunTaskRequest
     * @return Result of the GetRunTask operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetRunTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRunTask" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetRunTaskResponse getRunTask(GetRunTaskRequest getRunTaskRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetRunTaskResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetRunTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getRunTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getRunTaskRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetRunTask");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler
                    .execute(new ClientExecutionParams<GetRunTaskRequest, GetRunTaskResponse>().withOperationName("GetRunTask")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withRequestConfiguration(clientConfiguration).withInput(getRunTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetRunTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves details about an access policy on a given store.
     * </p>
     *
     * @param getS3AccessPolicyRequest
     * @return Result of the GetS3AccessPolicy operation returned by the service.
     * @throws NotSupportedOperationException
     *         The operation is not supported by Amazon Omics, or the API does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetS3AccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetS3AccessPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetS3AccessPolicyResponse getS3AccessPolicy(GetS3AccessPolicyRequest getS3AccessPolicyRequest)
            throws NotSupportedOperationException, InternalServerException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException,
            SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetS3AccessPolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetS3AccessPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getS3AccessPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getS3AccessPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetS3AccessPolicy");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<GetS3AccessPolicyRequest, GetS3AccessPolicyResponse>()
                    .withOperationName("GetS3AccessPolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getS3AccessPolicyRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetS3AccessPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves metadata for a sequence store using its ID and returns it in JSON format.
     * </p>
     *
     * @param getSequenceStoreRequest
     * @return Result of the GetSequenceStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetSequenceStoreResponse getSequenceStore(GetSequenceStoreRequest getSequenceStoreRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSequenceStoreResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetSequenceStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSequenceStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSequenceStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSequenceStore");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<GetSequenceStoreRequest, GetSequenceStoreResponse>()
                    .withOperationName("GetSequenceStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getSequenceStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSequenceStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the metadata for the specified resource share.
     * </p>
     *
     * @param getShareRequest
     * @return Result of the GetShare operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetShare" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetShareResponse getShare(GetShareRequest getShareRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetShareResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetShareResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getShareRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getShareRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetShare");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<GetShareRequest, GetShareResponse>()
                    .withOperationName("GetShare").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(getShareRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetShareRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a variant import job.
     * </p>
     *
     * @param getVariantImportJobRequest
     * @return Result of the GetVariantImportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetVariantImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetVariantImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetVariantImportJobResponse getVariantImportJob(GetVariantImportJobRequest getVariantImportJobRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetVariantImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetVariantImportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getVariantImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVariantImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVariantImportJob");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<GetVariantImportJobRequest, GetVariantImportJobResponse>()
                    .withOperationName("GetVariantImportJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getVariantImportJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetVariantImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a variant store.
     * </p>
     *
     * @param getVariantStoreRequest
     * @return Result of the GetVariantStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetVariantStoreResponse getVariantStore(GetVariantStoreRequest getVariantStoreRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetVariantStoreResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetVariantStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getVariantStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getVariantStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetVariantStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<GetVariantStoreRequest, GetVariantStoreResponse>()
                    .withOperationName("GetVariantStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getVariantStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetVariantStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets all information about a workflow using its ID.
     * </p>
     * <p>
     * If a workflow is shared with you, you cannot export the workflow.
     * </p>
     * <p>
     * For more information about your workflow status, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/using-get-workflow.html">Verify the workflow status</a> in the
     * <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param getWorkflowRequest
     * @return Result of the GetWorkflow operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetWorkflowResponse getWorkflow(GetWorkflowRequest getWorkflowRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetWorkflowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWorkflowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkflow");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<GetWorkflowRequest, GetWorkflowResponse>()
                    .withOperationName("GetWorkflow").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(getWorkflowRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetWorkflowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Gets information about a workflow version. For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html">Workflow versioning in Amazon Web
     * Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param getWorkflowVersionRequest
     * @return Result of the GetWorkflowVersion operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.GetWorkflowVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetWorkflowVersion" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetWorkflowVersionResponse getWorkflowVersion(GetWorkflowVersionRequest getWorkflowVersionRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException,
            SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetWorkflowVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetWorkflowVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getWorkflowVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getWorkflowVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetWorkflowVersion");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<GetWorkflowVersionRequest, GetWorkflowVersionResponse>()
                    .withOperationName("GetWorkflowVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(getWorkflowVersionRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetWorkflowVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of annotation import jobs.
     * </p>
     *
     * @param listAnnotationImportJobsRequest
     * @return Result of the ListAnnotationImportJobs operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListAnnotationImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAnnotationImportJobsResponse listAnnotationImportJobs(
            ListAnnotationImportJobsRequest listAnnotationImportJobsRequest) throws InternalServerException, ThrottlingException,
            ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAnnotationImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAnnotationImportJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAnnotationImportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAnnotationImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAnnotationImportJobs");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler
                    .execute(new ClientExecutionParams<ListAnnotationImportJobsRequest, ListAnnotationImportJobsResponse>()
                            .withOperationName("ListAnnotationImportJobs").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(listAnnotationImportJobsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAnnotationImportJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the versions of an annotation store.
     * </p>
     *
     * @param listAnnotationStoreVersionsRequest
     * @return Result of the ListAnnotationStoreVersions operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListAnnotationStoreVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationStoreVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListAnnotationStoreVersionsResponse listAnnotationStoreVersions(
            ListAnnotationStoreVersionsRequest listAnnotationStoreVersionsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAnnotationStoreVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAnnotationStoreVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAnnotationStoreVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAnnotationStoreVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAnnotationStoreVersions");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler
                    .execute(new ClientExecutionParams<ListAnnotationStoreVersionsRequest, ListAnnotationStoreVersionsResponse>()
                            .withOperationName("ListAnnotationStoreVersions").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(listAnnotationStoreVersionsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListAnnotationStoreVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of annotation stores.
     * </p>
     *
     * @param listAnnotationStoresRequest
     * @return Result of the ListAnnotationStores operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListAnnotationStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationStores" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListAnnotationStoresResponse listAnnotationStores(ListAnnotationStoresRequest listAnnotationStoresRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAnnotationStoresResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListAnnotationStoresResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listAnnotationStoresRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAnnotationStoresRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAnnotationStores");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<ListAnnotationStoresRequest, ListAnnotationStoresResponse>()
                    .withOperationName("ListAnnotationStores").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listAnnotationStoresRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAnnotationStoresRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists in-progress multipart read set uploads for a sequence store and returns it in a JSON formatted output.
     * Multipart read set uploads are initiated by the <code>CreateMultipartReadSetUploads</code> API operation. This
     * operation returns a response with no body when the upload is complete.
     * </p>
     *
     * @param listMultipartReadSetUploadsRequest
     * @return Result of the ListMultipartReadSetUploads operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws NotSupportedOperationException
     *         The operation is not supported by Amazon Omics, or the API does not exist.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListMultipartReadSetUploads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListMultipartReadSetUploads"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListMultipartReadSetUploadsResponse listMultipartReadSetUploads(
            ListMultipartReadSetUploadsRequest listMultipartReadSetUploadsRequest) throws InternalServerException,
            NotSupportedOperationException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListMultipartReadSetUploadsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListMultipartReadSetUploadsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listMultipartReadSetUploadsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listMultipartReadSetUploadsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListMultipartReadSetUploads");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler
                    .execute(new ClientExecutionParams<ListMultipartReadSetUploadsRequest, ListMultipartReadSetUploadsResponse>()
                            .withOperationName("ListMultipartReadSetUploads").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(listMultipartReadSetUploadsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListMultipartReadSetUploadsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of read set activation jobs and returns the metadata in a JSON formatted output. To extract
     * metadata from a read set activation job, use the <code>GetReadSetActivationJob</code> API operation.
     * </p>
     *
     * @param listReadSetActivationJobsRequest
     * @return Result of the ListReadSetActivationJobs operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListReadSetActivationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetActivationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListReadSetActivationJobsResponse listReadSetActivationJobs(
            ListReadSetActivationJobsRequest listReadSetActivationJobsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException,
            AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListReadSetActivationJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListReadSetActivationJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReadSetActivationJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReadSetActivationJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReadSetActivationJobs");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler
                    .execute(new ClientExecutionParams<ListReadSetActivationJobsRequest, ListReadSetActivationJobsResponse>()
                            .withOperationName("ListReadSetActivationJobs").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(listReadSetActivationJobsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListReadSetActivationJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of read set export jobs in a JSON formatted response. This API operation is used to check the
     * status of a read set export job initiated by the <code>StartReadSetExportJob</code> API operation.
     * </p>
     *
     * @param listReadSetExportJobsRequest
     * @return Result of the ListReadSetExportJobs operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListReadSetExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListReadSetExportJobsResponse listReadSetExportJobs(ListReadSetExportJobsRequest listReadSetExportJobsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListReadSetExportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListReadSetExportJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReadSetExportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReadSetExportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReadSetExportJobs");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<ListReadSetExportJobsRequest, ListReadSetExportJobsResponse>()
                    .withOperationName("ListReadSetExportJobs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listReadSetExportJobsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListReadSetExportJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of read set import jobs and returns the data in JSON format.
     * </p>
     *
     * @param listReadSetImportJobsRequest
     * @return Result of the ListReadSetImportJobs operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListReadSetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListReadSetImportJobsResponse listReadSetImportJobs(ListReadSetImportJobsRequest listReadSetImportJobsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListReadSetImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListReadSetImportJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReadSetImportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReadSetImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReadSetImportJobs");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<ListReadSetImportJobsRequest, ListReadSetImportJobsResponse>()
                    .withOperationName("ListReadSetImportJobs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listReadSetImportJobsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListReadSetImportJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all parts in a multipart read set upload for a sequence store and returns the metadata in a JSON formatted
     * output.
     * </p>
     *
     * @param listReadSetUploadPartsRequest
     * @return Result of the ListReadSetUploadParts operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws NotSupportedOperationException
     *         The operation is not supported by Amazon Omics, or the API does not exist.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListReadSetUploadParts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetUploadParts" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListReadSetUploadPartsResponse listReadSetUploadParts(ListReadSetUploadPartsRequest listReadSetUploadPartsRequest)
            throws InternalServerException, NotSupportedOperationException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException,
            SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListReadSetUploadPartsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListReadSetUploadPartsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReadSetUploadPartsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReadSetUploadPartsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReadSetUploadParts");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler
                    .execute(new ClientExecutionParams<ListReadSetUploadPartsRequest, ListReadSetUploadPartsResponse>()
                            .withOperationName("ListReadSetUploadParts").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(listReadSetUploadPartsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListReadSetUploadPartsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of read sets from a sequence store ID and returns the metadata in JSON format.
     * </p>
     *
     * @param listReadSetsRequest
     * @return Result of the ListReadSets operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListReadSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListReadSetsResponse listReadSets(ListReadSetsRequest listReadSetsRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException,
            AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListReadSetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListReadSetsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReadSetsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReadSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReadSets");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<ListReadSetsRequest, ListReadSetsResponse>()
                    .withOperationName("ListReadSets").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listReadSetsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListReadSetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the metadata of one or more reference import jobs for a reference store.
     * </p>
     *
     * @param listReferenceImportJobsRequest
     * @return Result of the ListReferenceImportJobs operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListReferenceImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListReferenceImportJobsResponse listReferenceImportJobs(ListReferenceImportJobsRequest listReferenceImportJobsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListReferenceImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListReferenceImportJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReferenceImportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReferenceImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReferenceImportJobs");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler
                    .execute(new ClientExecutionParams<ListReferenceImportJobsRequest, ListReferenceImportJobsResponse>()
                            .withOperationName("ListReferenceImportJobs").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(listReferenceImportJobsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListReferenceImportJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of reference stores linked to your account and returns their metadata in JSON format.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-reference-store.html">Creating a reference store</a> in
     * the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param listReferenceStoresRequest
     * @return Result of the ListReferenceStores operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListReferenceStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceStores" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListReferenceStoresResponse listReferenceStores(ListReferenceStoresRequest listReferenceStoresRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException,
            RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListReferenceStoresResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListReferenceStoresResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReferenceStoresRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReferenceStoresRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReferenceStores");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<ListReferenceStoresRequest, ListReferenceStoresResponse>()
                    .withOperationName("ListReferenceStores").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listReferenceStoresRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListReferenceStoresRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the metadata of one or more reference genomes in a reference store.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-reference-store.html">Creating a reference store</a> in
     * the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param listReferencesRequest
     * @return Result of the ListReferences operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListReferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferences" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListReferencesResponse listReferences(ListReferencesRequest listReferencesRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException,
            AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListReferencesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListReferencesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listReferencesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listReferencesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListReferences");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<ListReferencesRequest, ListReferencesResponse>()
                    .withOperationName("ListReferences").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listReferencesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListReferencesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of your run caches and the metadata for each cache.
     * </p>
     *
     * @param listRunCachesRequest
     * @return Result of the ListRunCaches operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListRunCaches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunCaches" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListRunCachesResponse listRunCaches(ListRunCachesRequest listRunCachesRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRunCachesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListRunCachesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRunCachesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRunCachesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRunCaches");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<ListRunCachesRequest, ListRunCachesResponse>()
                    .withOperationName("ListRunCaches").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listRunCachesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListRunCachesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of all run groups and returns the metadata for each run group.
     * </p>
     *
     * @param listRunGroupsRequest
     * @return Result of the ListRunGroups operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListRunGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListRunGroupsResponse listRunGroups(ListRunGroupsRequest listRunGroupsRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRunGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListRunGroupsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRunGroupsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRunGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRunGroups");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<ListRunGroupsRequest, ListRunGroupsResponse>()
                    .withOperationName("ListRunGroups").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listRunGroupsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListRunGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of tasks and status information within their specified run. Use this operation to monitor runs and
     * to identify which specific tasks have failed.
     * </p>
     *
     * @param listRunTasksRequest
     * @return Result of the ListRunTasks operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListRunTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunTasks" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListRunTasksResponse listRunTasks(ListRunTasksRequest listRunTasksRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRunTasksResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListRunTasksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRunTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRunTasksRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRunTasks");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<ListRunTasksRequest, ListRunTasksResponse>()
                    .withOperationName("ListRunTasks").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listRunTasksRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListRunTasksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of runs and returns each run's metadata and status.
     * </p>
     * <p>
     * Amazon Web Services HealthOmics stores a configurable number of runs, as determined by service limits, that are
     * available to the console and API. If the <code>ListRuns</code> response doesn't include specific runs that you
     * expected, you can find all run logs in the CloudWatch logs. For more information about viewing the run logs, see
     * <a href="https://docs.aws.amazon.com/omics/latest/dev/monitoring-cloudwatch-logs.html">CloudWatch logs</a> in the
     * <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param listRunsRequest
     * @return Result of the ListRuns operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRuns" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListRunsResponse listRuns(ListRunsRequest listRunsRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListRunsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListRunsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listRunsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listRunsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListRuns");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<ListRunsRequest, ListRunsResponse>()
                    .withOperationName("ListRuns").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(listRunsRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new ListRunsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of sequence stores and returns each sequence store's metadata.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-sequence-store.html">Creating a HealthOmics sequence
     * store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param listSequenceStoresRequest
     * @return Result of the ListSequenceStores operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListSequenceStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListSequenceStores" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListSequenceStoresResponse listSequenceStores(ListSequenceStoresRequest listSequenceStoresRequest)
            throws InternalServerException, ThrottlingException, ValidationException, AccessDeniedException,
            RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSequenceStoresResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSequenceStoresResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSequenceStoresRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSequenceStoresRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSequenceStores");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<ListSequenceStoresRequest, ListSequenceStoresResponse>()
                    .withOperationName("ListSequenceStores").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listSequenceStoresRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSequenceStoresRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the resource shares associated with an account. Use the filter parameter to retrieve a specific subset
     * of the shares.
     * </p>
     *
     * @param listSharesRequest
     * @return Result of the ListShares operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListShares" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListSharesResponse listShares(ListSharesRequest listSharesRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSharesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListSharesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSharesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSharesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListShares");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler
                    .execute(new ClientExecutionParams<ListSharesRequest, ListSharesResponse>().withOperationName("ListShares")
                            .withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                            .withRequestConfiguration(clientConfiguration).withInput(listSharesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListSharesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException,
            SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            String hostPrefix = "tags-";
            String resolvedHostExpression = "tags-";

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listTagsForResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of variant import jobs.
     * </p>
     *
     * @param listVariantImportJobsRequest
     * @return Result of the ListVariantImportJobs operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListVariantImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListVariantImportJobsResponse listVariantImportJobs(ListVariantImportJobsRequest listVariantImportJobsRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListVariantImportJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListVariantImportJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listVariantImportJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVariantImportJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVariantImportJobs");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<ListVariantImportJobsRequest, ListVariantImportJobsResponse>()
                    .withOperationName("ListVariantImportJobs").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listVariantImportJobsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListVariantImportJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of variant stores.
     * </p>
     *
     * @param listVariantStoresRequest
     * @return Result of the ListVariantStores operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListVariantStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantStores" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListVariantStoresResponse listVariantStores(ListVariantStoresRequest listVariantStoresRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListVariantStoresResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListVariantStoresResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listVariantStoresRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listVariantStoresRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListVariantStores");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<ListVariantStoresRequest, ListVariantStoresResponse>()
                    .withOperationName("ListVariantStores").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listVariantStoresRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListVariantStoresRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the workflow versions for the specified workflow. For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html">Workflow versioning in Amazon Web
     * Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param listWorkflowVersionsRequest
     * @return Result of the ListWorkflowVersions operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListWorkflowVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListWorkflowVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListWorkflowVersionsResponse listWorkflowVersions(ListWorkflowVersionsRequest listWorkflowVersionsRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException,
            SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWorkflowVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListWorkflowVersionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorkflowVersionsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkflowVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkflowVersions");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<ListWorkflowVersionsRequest, ListWorkflowVersionsResponse>()
                    .withOperationName("ListWorkflowVersions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listWorkflowVersionsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListWorkflowVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of existing workflows. You can filter for specific workflows by their name and type. Using the
     * type parameter, specify <code>PRIVATE</code> to retrieve a list of private workflows or specify
     * <code>READY2RUN</code> for a list of all Ready2Run workflows. If you do not specify the type of workflow, this
     * operation returns a list of existing workflows.
     * </p>
     *
     * @param listWorkflowsRequest
     * @return Result of the ListWorkflows operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListWorkflowsResponse listWorkflows(ListWorkflowsRequest listWorkflowsRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListWorkflowsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListWorkflowsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listWorkflowsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listWorkflowsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListWorkflows");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<ListWorkflowsRequest, ListWorkflowsResponse>()
                    .withOperationName("ListWorkflows").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(listWorkflowsRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListWorkflowsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds an access policy to the specified store.
     * </p>
     *
     * @param putS3AccessPolicyRequest
     * @return Result of the PutS3AccessPolicy operation returned by the service.
     * @throws NotSupportedOperationException
     *         The operation is not supported by Amazon Omics, or the API does not exist.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.PutS3AccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/PutS3AccessPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public PutS3AccessPolicyResponse putS3AccessPolicy(PutS3AccessPolicyRequest putS3AccessPolicyRequest)
            throws NotSupportedOperationException, InternalServerException, ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutS3AccessPolicyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                PutS3AccessPolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putS3AccessPolicyRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putS3AccessPolicyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutS3AccessPolicy");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<PutS3AccessPolicyRequest, PutS3AccessPolicyResponse>()
                    .withOperationName("PutS3AccessPolicy").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(putS3AccessPolicyRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new PutS3AccessPolicyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts an annotation import job.
     * </p>
     *
     * @param startAnnotationImportJobRequest
     * @return Result of the StartAnnotationImportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.StartAnnotationImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartAnnotationImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartAnnotationImportJobResponse startAnnotationImportJob(
            StartAnnotationImportJobRequest startAnnotationImportJobRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartAnnotationImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartAnnotationImportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startAnnotationImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startAnnotationImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartAnnotationImportJob");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler
                    .execute(new ClientExecutionParams<StartAnnotationImportJobRequest, StartAnnotationImportJobResponse>()
                            .withOperationName("StartAnnotationImportJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(startAnnotationImportJobRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartAnnotationImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Activates an archived read set and returns its metadata in a JSON formatted output. AWS HealthOmics automatically
     * archives unused read sets after 30 days. To monitor the status of your read set activation job, use the
     * <code>GetReadSetActivationJob</code> operation.
     * </p>
     * <p>
     * To learn more, see <a href="https://docs.aws.amazon.com/omics/latest/dev/activating-read-sets.html">Activating
     * read sets</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param startReadSetActivationJobRequest
     * @return Result of the StartReadSetActivationJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.StartReadSetActivationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetActivationJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartReadSetActivationJobResponse startReadSetActivationJob(
            StartReadSetActivationJobRequest startReadSetActivationJobRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartReadSetActivationJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartReadSetActivationJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startReadSetActivationJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startReadSetActivationJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartReadSetActivationJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler
                    .execute(new ClientExecutionParams<StartReadSetActivationJobRequest, StartReadSetActivationJobResponse>()
                            .withOperationName("StartReadSetActivationJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(startReadSetActivationJobRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartReadSetActivationJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a read set export job. When the export job is finished, the read set is exported to an Amazon S3 bucket
     * which can be retrieved using the <code>GetReadSetExportJob</code> API operation.
     * </p>
     * <p>
     * To monitor the status of the export job, use the <code>ListReadSetExportJobs</code> API operation.
     * </p>
     *
     * @param startReadSetExportJobRequest
     * @return Result of the StartReadSetExportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.StartReadSetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetExportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartReadSetExportJobResponse startReadSetExportJob(StartReadSetExportJobRequest startReadSetExportJobRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartReadSetExportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartReadSetExportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startReadSetExportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startReadSetExportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartReadSetExportJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<StartReadSetExportJobRequest, StartReadSetExportJobResponse>()
                    .withOperationName("StartReadSetExportJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(startReadSetExportJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartReadSetExportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Imports a read set from the sequence store. Read set import jobs support a maximum of 100 read sets of different
     * types. Monitor the progress of your read set import job by calling the <code>GetReadSetImportJob</code> API
     * operation.
     * </p>
     *
     * @param startReadSetImportJobRequest
     * @return Result of the StartReadSetImportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.StartReadSetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartReadSetImportJobResponse startReadSetImportJob(StartReadSetImportJobRequest startReadSetImportJobRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartReadSetImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartReadSetImportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startReadSetImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startReadSetImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartReadSetImportJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<StartReadSetImportJobRequest, StartReadSetImportJobResponse>()
                    .withOperationName("StartReadSetImportJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(startReadSetImportJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartReadSetImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Imports a reference genome from Amazon S3 into a specified reference store. You can have multiple reference
     * genomes in a reference store. You can only import reference genomes one at a time into each reference store.
     * Monitor the status of your reference import job by using the <code>GetReferenceImportJob</code> API operation.
     * </p>
     *
     * @param startReferenceImportJobRequest
     * @return Result of the StartReferenceImportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.StartReferenceImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReferenceImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartReferenceImportJobResponse startReferenceImportJob(StartReferenceImportJobRequest startReferenceImportJobRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartReferenceImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartReferenceImportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startReferenceImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startReferenceImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartReferenceImportJob");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler
                    .execute(new ClientExecutionParams<StartReferenceImportJobRequest, StartReferenceImportJobResponse>()
                            .withOperationName("StartReferenceImportJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(startReferenceImportJobRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartReferenceImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a new run and returns details about the run, or duplicates an existing run. A run is a single invocation
     * of a workflow. If you provide request IDs, Amazon Web Services HealthOmics identifies duplicate requests and
     * starts the run only once. Monitor the progress of the run by calling the <code>GetRun</code> API operation.
     * </p>
     * <p>
     * To start a new run, the following inputs are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A service role ARN (<code>roleArn</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * The run's workflow ID (<code>workflowId</code>, not the <code>uuid</code> or <code>runId</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * An Amazon S3 location (<code>outputUri</code>) where the run outputs will be saved.
     * </p>
     * </li>
     * <li>
     * <p>
     * All required workflow parameters (<code>parameter</code>), which can include optional parameters from the
     * parameter template. The run cannot include any parameters that are not defined in the parameter template. To see
     * all possible parameters, use the <code>GetRun</code> API operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * For runs with a <code>STATIC</code> (default) storage type, specify the required storage capacity (in gibibytes).
     * A storage capacity value is not required for runs that use <code>DYNAMIC</code> storage.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>StartRun</code> can also duplicate an existing run using the run's default values. You can modify these
     * default values and/or add other optional inputs. To duplicate a run, the following inputs are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A service role ARN (<code>roleArn</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * The ID of the run to duplicate (<code>runId</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * An Amazon S3 location where the run outputs will be saved (<code>outputUri</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * To learn more about the optional parameters for <code>StartRun</code>, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/starting-a-run.html">Starting a run</a> in the <i>Amazon Web
     * Services HealthOmics User Guide</i>.
     * </p>
     * <p>
     * Use the <code>retentionMode</code> input to control how long the metadata for each run is stored in CloudWatch.
     * There are two retention modes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify <code>REMOVE</code> to automatically remove the oldest runs when you reach the maximum service retention
     * limit for runs. It is recommended that you use the <code>REMOVE</code> mode to initiate major run requests so
     * that your runs do not fail when you reach the limit.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>retentionMode</code> is set to the <code>RETAIN</code> mode by default, which allows you to manually
     * remove runs after reaching the maximum service retention limit. Under this setting, you cannot create additional
     * runs until you remove the excess runs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To learn more about the retention modes, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/run-retention.html">Run retention mode</a> in the <i>Amazon
     * Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param startRunRequest
     * @return Result of the StartRun operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.StartRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartRun" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartRunResponse startRun(StartRunRequest startRunRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartRunResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartRunResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startRunRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startRunRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartRun");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<StartRunRequest, StartRunResponse>()
                    .withOperationName("StartRun").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(startRunRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new StartRunRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a variant import job.
     * </p>
     *
     * @param startVariantImportJobRequest
     * @return Result of the StartVariantImportJob operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.StartVariantImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartVariantImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartVariantImportJobResponse startVariantImportJob(StartVariantImportJobRequest startVariantImportJobRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ResourceNotFoundException, AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartVariantImportJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartVariantImportJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startVariantImportJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startVariantImportJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartVariantImportJob");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<StartVariantImportJobRequest, StartVariantImportJobResponse>()
                    .withOperationName("StartVariantImportJob").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(startVariantImportJobRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartVariantImportJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Tags a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            String hostPrefix = "tags-";
            String resolvedHostExpression = "tags-";

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            String hostPrefix = "tags-";
            String resolvedHostExpression = "tags-";

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(untagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an annotation store.
     * </p>
     *
     * @param updateAnnotationStoreRequest
     * @return Result of the UpdateAnnotationStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.UpdateAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateAnnotationStore" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateAnnotationStoreResponse updateAnnotationStore(UpdateAnnotationStoreRequest updateAnnotationStoreRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAnnotationStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAnnotationStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAnnotationStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAnnotationStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAnnotationStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<UpdateAnnotationStoreRequest, UpdateAnnotationStoreResponse>()
                    .withOperationName("UpdateAnnotationStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(updateAnnotationStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAnnotationStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the description of an annotation store version.
     * </p>
     *
     * @param updateAnnotationStoreVersionRequest
     * @return Result of the UpdateAnnotationStoreVersion operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.UpdateAnnotationStoreVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateAnnotationStoreVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAnnotationStoreVersionResponse updateAnnotationStoreVersion(
            UpdateAnnotationStoreVersionRequest updateAnnotationStoreVersionRequest) throws InternalServerException,
            ThrottlingException, ValidationException, ResourceNotFoundException, AccessDeniedException, AwsServiceException,
            SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAnnotationStoreVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAnnotationStoreVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateAnnotationStoreVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAnnotationStoreVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAnnotationStoreVersion");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateAnnotationStoreVersionRequest, UpdateAnnotationStoreVersionResponse>()
                            .withOperationName("UpdateAnnotationStoreVersion").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                            .withInput(updateAnnotationStoreVersionRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateAnnotationStoreVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a run cache using its ID and returns a response with no body if the operation is successful. You can
     * update the run cache description, name, or the default run cache behavior with <code>CACHE_ON_FAILURE</code> or
     * <code>CACHE_ALWAYS</code>. To confirm that your run cache settings have been properly updated, use the
     * <code>GetRunCache</code> API operation.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/how-run-cache.html">How call
     * caching works</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param updateRunCacheRequest
     * @return Result of the UpdateRunCache operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.UpdateRunCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateRunCache" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateRunCacheResponse updateRunCache(UpdateRunCacheRequest updateRunCacheRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRunCacheResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateRunCacheResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRunCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRunCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRunCache");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<UpdateRunCacheRequest, UpdateRunCacheResponse>()
                    .withOperationName("UpdateRunCache").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(updateRunCacheRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateRunCacheRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the settings of a run group and returns a response with no body if the operation is successful.
     * </p>
     * <p>
     * You can update the following settings with <code>UpdateRunGroup</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of CPUs
     * </p>
     * </li>
     * <li>
     * <p>
     * Run time (measured in minutes)
     * </p>
     * </li>
     * <li>
     * <p>
     * Number of GPUs
     * </p>
     * </li>
     * <li>
     * <p>
     * Number of concurrent runs
     * </p>
     * </li>
     * <li>
     * <p>
     * Group name
     * </p>
     * </li>
     * </ul>
     * <p>
     * To confirm that the settings have been successfully updated, use the <code>ListRunGroups</code> or
     * <code>GetRunGroup</code> API operations to verify that the desired changes have been made.
     * </p>
     *
     * @param updateRunGroupRequest
     * @return Result of the UpdateRunGroup operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.UpdateRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateRunGroupResponse updateRunGroup(UpdateRunGroupRequest updateRunGroupRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateRunGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateRunGroupResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateRunGroupRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateRunGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateRunGroup");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<UpdateRunGroupRequest, UpdateRunGroupResponse>()
                    .withOperationName("UpdateRunGroup").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(updateRunGroupRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateRunGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Update one or more parameters for the sequence store.
     * </p>
     *
     * @param updateSequenceStoreRequest
     * @return Result of the UpdateSequenceStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.UpdateSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateSequenceStoreResponse updateSequenceStore(UpdateSequenceStoreRequest updateSequenceStoreRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSequenceStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateSequenceStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSequenceStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSequenceStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSequenceStore");
            String hostPrefix = "control-storage-";
            String resolvedHostExpression = "control-storage-";

            return clientHandler.execute(new ClientExecutionParams<UpdateSequenceStoreRequest, UpdateSequenceStoreResponse>()
                    .withOperationName("UpdateSequenceStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(updateSequenceStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateSequenceStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a variant store.
     * </p>
     *
     * @param updateVariantStoreRequest
     * @return Result of the UpdateVariantStore operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.UpdateVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateVariantStoreResponse updateVariantStore(UpdateVariantStoreRequest updateVariantStoreRequest)
            throws InternalServerException, ThrottlingException, ValidationException, ResourceNotFoundException,
            AccessDeniedException, AwsServiceException, SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateVariantStoreResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateVariantStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateVariantStoreRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateVariantStoreRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateVariantStore");
            String hostPrefix = "analytics-";
            String resolvedHostExpression = "analytics-";

            return clientHandler.execute(new ClientExecutionParams<UpdateVariantStoreRequest, UpdateVariantStoreResponse>()
                    .withOperationName("UpdateVariantStore").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(updateVariantStoreRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateVariantStoreRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates information about a workflow.
     * </p>
     * <p>
     * You can update the following workflow information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Name
     * </p>
     * </li>
     * <li>
     * <p>
     * Description
     * </p>
     * </li>
     * <li>
     * <p>
     * Default storage type
     * </p>
     * </li>
     * <li>
     * <p>
     * Default storage capacity (with workflow ID)
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation returns a response with no body if the operation is successful. You can check the workflow updates
     * by calling the <code>GetWorkflow</code> API operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/update-private-workflow.html">Update a private workflow</a> in
     * the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param updateWorkflowRequest
     * @return Result of the UpdateWorkflow operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.UpdateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateWorkflowResponse updateWorkflow(UpdateWorkflowRequest updateWorkflowRequest) throws InternalServerException,
            ServiceQuotaExceededException, ThrottlingException, ValidationException, ConflictException,
            ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException, SdkClientException,
            OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateWorkflowResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateWorkflowResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWorkflowRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWorkflowRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorkflow");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<UpdateWorkflowRequest, UpdateWorkflowResponse>()
                    .withOperationName("UpdateWorkflow").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(updateWorkflowRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateWorkflowRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates information about the workflow version. For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html">Workflow versioning in Amazon Web
     * Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param updateWorkflowVersionRequest
     * @return Result of the UpdateWorkflowVersion operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ConflictException
     *         The request cannot be applied to the target resource in its current state.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.UpdateWorkflowVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateWorkflowVersion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateWorkflowVersionResponse updateWorkflowVersion(UpdateWorkflowVersionRequest updateWorkflowVersionRequest)
            throws InternalServerException, ServiceQuotaExceededException, ThrottlingException, ValidationException,
            ConflictException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException,
            SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateWorkflowVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateWorkflowVersionResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateWorkflowVersionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateWorkflowVersionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateWorkflowVersion");
            String hostPrefix = "workflows-";
            String resolvedHostExpression = "workflows-";

            return clientHandler.execute(new ClientExecutionParams<UpdateWorkflowVersionRequest, UpdateWorkflowVersionResponse>()
                    .withOperationName("UpdateWorkflowVersion").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression).withRequestConfiguration(clientConfiguration)
                    .withInput(updateWorkflowVersionRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateWorkflowVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Uploads a specific part of a read set into a sequence store. When you a upload a read set part with a part number
     * that already exists, the new part replaces the existing one. This operation returns a JSON formatted response
     * containing a string identifier that is used to confirm that parts are being added to the intended upload.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/synchronous-uploads.html">Direct
     * upload to a sequence store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param uploadReadSetPartRequest
     * @param requestBody
     *        The content to send to the service. A {@link RequestBody} can be created using one of several factory
     *        methods for various sources of data. For example, to create a request body from a file you can do the
     *        following.
     * 
     *        <pre>
     * {@code RequestBody.fromFile(new File("myfile.txt"))}
     * </pre>
     * 
     *        See documentation in {@link RequestBody} for additional details and which sources of data are supported.
     *        The service documentation for the request content is as follows '
     *        <p>
     *        The read set data to upload for a part.
     *        </p>
     *        '
     * @return Result of the UploadReadSetPart operation returned by the service.
     * @throws InternalServerException
     *         An unexpected error occurred. Try the request again.
     * @throws NotSupportedOperationException
     *         The operation is not supported by Amazon Omics, or the API does not exist.
     * @throws ServiceQuotaExceededException
     *         The request exceeds a service quota.
     * @throws ThrottlingException
     *         The request was denied due to request throttling.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by an AWS service.
     * @throws ResourceNotFoundException
     *         The target resource was not found in the current Region.
     * @throws AccessDeniedException
     *         You do not have sufficient access to perform this action.
     * @throws RequestTimeoutException
     *         The request timed out.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OmicsException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OmicsClient.UploadReadSetPart
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UploadReadSetPart" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UploadReadSetPartResponse uploadReadSetPart(UploadReadSetPartRequest uploadReadSetPartRequest, RequestBody requestBody)
            throws InternalServerException, NotSupportedOperationException, ServiceQuotaExceededException, ThrottlingException,
            ValidationException, ResourceNotFoundException, AccessDeniedException, RequestTimeoutException, AwsServiceException,
            SdkClientException, OmicsException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UploadReadSetPartResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UploadReadSetPartResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "RangeNotSatisfiableException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RangeNotSatisfiableException").httpStatusCode(416)
                        .exceptionBuilderSupplier(RangeNotSatisfiableException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(402)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(404)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            case "RequestTimeoutException":
                return Optional.of(ExceptionMetadata.builder().errorCode("RequestTimeoutException").httpStatusCode(408)
                        .exceptionBuilderSupplier(RequestTimeoutException::builder).build());
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(429)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "NotSupportedOperationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("NotSupportedOperationException").httpStatusCode(405)
                        .exceptionBuilderSupplier(NotSupportedOperationException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(403)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(409)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(uploadReadSetPartRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, uploadReadSetPartRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "Omics");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UploadReadSetPart");
            String hostPrefix = "storage-";
            String resolvedHostExpression = "storage-";

            return clientHandler.execute(new ClientExecutionParams<UploadReadSetPartRequest, UploadReadSetPartResponse>()
                    .withOperationName("UploadReadSetPart")
                    .withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler)
                    .hostPrefixExpression(resolvedHostExpression)
                    .withRequestConfiguration(clientConfiguration)
                    .withInput(uploadReadSetPartRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withRequestBody(requestBody)
                    .withMarshaller(
                            StreamingRequestMarshaller.builder()
                                    .delegateMarshaller(new UploadReadSetPartRequestMarshaller(protocolFactory))
                                    .requestBody(requestBody).requiresLength(true).transferEncoding(true).build()));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * Create an instance of {@link OmicsWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link OmicsWaiter}
     */
    @Override
    public OmicsWaiter waiter() {
        return OmicsWaiter.builder().client(this).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        OmicsServiceClientConfigurationBuilder serviceConfigBuilder = new OmicsServiceClientConfigurationBuilder(configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration).defaultServiceExceptionSupplier(OmicsException::builder)
                .protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1");
    }

    @Override
    public final OmicsServiceClientConfiguration serviceClientConfiguration() {
        return new OmicsServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
