/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.services.omics.model.AbortMultipartReadSetUploadRequest;
import software.amazon.awssdk.services.omics.model.AbortMultipartReadSetUploadResponse;
import software.amazon.awssdk.services.omics.model.AcceptShareRequest;
import software.amazon.awssdk.services.omics.model.AcceptShareResponse;
import software.amazon.awssdk.services.omics.model.BatchDeleteReadSetRequest;
import software.amazon.awssdk.services.omics.model.BatchDeleteReadSetResponse;
import software.amazon.awssdk.services.omics.model.CancelAnnotationImportJobRequest;
import software.amazon.awssdk.services.omics.model.CancelAnnotationImportJobResponse;
import software.amazon.awssdk.services.omics.model.CancelRunRequest;
import software.amazon.awssdk.services.omics.model.CancelRunResponse;
import software.amazon.awssdk.services.omics.model.CancelVariantImportJobRequest;
import software.amazon.awssdk.services.omics.model.CancelVariantImportJobResponse;
import software.amazon.awssdk.services.omics.model.CompleteMultipartReadSetUploadRequest;
import software.amazon.awssdk.services.omics.model.CompleteMultipartReadSetUploadResponse;
import software.amazon.awssdk.services.omics.model.CreateAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateAnnotationStoreVersionRequest;
import software.amazon.awssdk.services.omics.model.CreateAnnotationStoreVersionResponse;
import software.amazon.awssdk.services.omics.model.CreateMultipartReadSetUploadRequest;
import software.amazon.awssdk.services.omics.model.CreateMultipartReadSetUploadResponse;
import software.amazon.awssdk.services.omics.model.CreateReferenceStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateReferenceStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateRunCacheRequest;
import software.amazon.awssdk.services.omics.model.CreateRunCacheResponse;
import software.amazon.awssdk.services.omics.model.CreateRunGroupRequest;
import software.amazon.awssdk.services.omics.model.CreateRunGroupResponse;
import software.amazon.awssdk.services.omics.model.CreateSequenceStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateSequenceStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateShareRequest;
import software.amazon.awssdk.services.omics.model.CreateShareResponse;
import software.amazon.awssdk.services.omics.model.CreateVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.CreateVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.CreateWorkflowRequest;
import software.amazon.awssdk.services.omics.model.CreateWorkflowResponse;
import software.amazon.awssdk.services.omics.model.CreateWorkflowVersionRequest;
import software.amazon.awssdk.services.omics.model.CreateWorkflowVersionResponse;
import software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreVersionsRequest;
import software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreVersionsResponse;
import software.amazon.awssdk.services.omics.model.DeleteReferenceRequest;
import software.amazon.awssdk.services.omics.model.DeleteReferenceResponse;
import software.amazon.awssdk.services.omics.model.DeleteReferenceStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteReferenceStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteRunCacheRequest;
import software.amazon.awssdk.services.omics.model.DeleteRunCacheResponse;
import software.amazon.awssdk.services.omics.model.DeleteRunGroupRequest;
import software.amazon.awssdk.services.omics.model.DeleteRunGroupResponse;
import software.amazon.awssdk.services.omics.model.DeleteRunRequest;
import software.amazon.awssdk.services.omics.model.DeleteRunResponse;
import software.amazon.awssdk.services.omics.model.DeleteS3AccessPolicyRequest;
import software.amazon.awssdk.services.omics.model.DeleteS3AccessPolicyResponse;
import software.amazon.awssdk.services.omics.model.DeleteSequenceStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteSequenceStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteShareRequest;
import software.amazon.awssdk.services.omics.model.DeleteShareResponse;
import software.amazon.awssdk.services.omics.model.DeleteVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.DeleteVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.DeleteWorkflowRequest;
import software.amazon.awssdk.services.omics.model.DeleteWorkflowResponse;
import software.amazon.awssdk.services.omics.model.DeleteWorkflowVersionRequest;
import software.amazon.awssdk.services.omics.model.DeleteWorkflowVersionResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreVersionRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreVersionResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetActivationJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetActivationJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetExportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetExportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetMetadataRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetMetadataResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceMetadataRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceMetadataResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceStoreRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceStoreResponse;
import software.amazon.awssdk.services.omics.model.GetRunCacheRequest;
import software.amazon.awssdk.services.omics.model.GetRunCacheResponse;
import software.amazon.awssdk.services.omics.model.GetRunGroupRequest;
import software.amazon.awssdk.services.omics.model.GetRunGroupResponse;
import software.amazon.awssdk.services.omics.model.GetRunRequest;
import software.amazon.awssdk.services.omics.model.GetRunResponse;
import software.amazon.awssdk.services.omics.model.GetRunTaskRequest;
import software.amazon.awssdk.services.omics.model.GetRunTaskResponse;
import software.amazon.awssdk.services.omics.model.GetS3AccessPolicyRequest;
import software.amazon.awssdk.services.omics.model.GetS3AccessPolicyResponse;
import software.amazon.awssdk.services.omics.model.GetSequenceStoreRequest;
import software.amazon.awssdk.services.omics.model.GetSequenceStoreResponse;
import software.amazon.awssdk.services.omics.model.GetShareRequest;
import software.amazon.awssdk.services.omics.model.GetShareResponse;
import software.amazon.awssdk.services.omics.model.GetVariantImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetVariantImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.GetVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.GetWorkflowRequest;
import software.amazon.awssdk.services.omics.model.GetWorkflowResponse;
import software.amazon.awssdk.services.omics.model.GetWorkflowVersionRequest;
import software.amazon.awssdk.services.omics.model.GetWorkflowVersionResponse;
import software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoreVersionsRequest;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoreVersionsResponse;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest;
import software.amazon.awssdk.services.omics.model.ListAnnotationStoresResponse;
import software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsRequest;
import software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetExportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsResponse;
import software.amazon.awssdk.services.omics.model.ListReadSetsRequest;
import software.amazon.awssdk.services.omics.model.ListReadSetsResponse;
import software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListReferenceImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest;
import software.amazon.awssdk.services.omics.model.ListReferenceStoresResponse;
import software.amazon.awssdk.services.omics.model.ListReferencesRequest;
import software.amazon.awssdk.services.omics.model.ListReferencesResponse;
import software.amazon.awssdk.services.omics.model.ListRunCachesRequest;
import software.amazon.awssdk.services.omics.model.ListRunCachesResponse;
import software.amazon.awssdk.services.omics.model.ListRunGroupsRequest;
import software.amazon.awssdk.services.omics.model.ListRunGroupsResponse;
import software.amazon.awssdk.services.omics.model.ListRunTasksRequest;
import software.amazon.awssdk.services.omics.model.ListRunTasksResponse;
import software.amazon.awssdk.services.omics.model.ListRunsRequest;
import software.amazon.awssdk.services.omics.model.ListRunsResponse;
import software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest;
import software.amazon.awssdk.services.omics.model.ListSequenceStoresResponse;
import software.amazon.awssdk.services.omics.model.ListSharesRequest;
import software.amazon.awssdk.services.omics.model.ListSharesResponse;
import software.amazon.awssdk.services.omics.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.omics.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest;
import software.amazon.awssdk.services.omics.model.ListVariantImportJobsResponse;
import software.amazon.awssdk.services.omics.model.ListVariantStoresRequest;
import software.amazon.awssdk.services.omics.model.ListVariantStoresResponse;
import software.amazon.awssdk.services.omics.model.ListWorkflowVersionsRequest;
import software.amazon.awssdk.services.omics.model.ListWorkflowVersionsResponse;
import software.amazon.awssdk.services.omics.model.ListWorkflowsRequest;
import software.amazon.awssdk.services.omics.model.ListWorkflowsResponse;
import software.amazon.awssdk.services.omics.model.PutS3AccessPolicyRequest;
import software.amazon.awssdk.services.omics.model.PutS3AccessPolicyResponse;
import software.amazon.awssdk.services.omics.model.StartAnnotationImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartAnnotationImportJobResponse;
import software.amazon.awssdk.services.omics.model.StartReadSetActivationJobRequest;
import software.amazon.awssdk.services.omics.model.StartReadSetActivationJobResponse;
import software.amazon.awssdk.services.omics.model.StartReadSetExportJobRequest;
import software.amazon.awssdk.services.omics.model.StartReadSetExportJobResponse;
import software.amazon.awssdk.services.omics.model.StartReadSetImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartReadSetImportJobResponse;
import software.amazon.awssdk.services.omics.model.StartReferenceImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartReferenceImportJobResponse;
import software.amazon.awssdk.services.omics.model.StartRunRequest;
import software.amazon.awssdk.services.omics.model.StartRunResponse;
import software.amazon.awssdk.services.omics.model.StartVariantImportJobRequest;
import software.amazon.awssdk.services.omics.model.StartVariantImportJobResponse;
import software.amazon.awssdk.services.omics.model.TagResourceRequest;
import software.amazon.awssdk.services.omics.model.TagResourceResponse;
import software.amazon.awssdk.services.omics.model.UntagResourceRequest;
import software.amazon.awssdk.services.omics.model.UntagResourceResponse;
import software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreVersionRequest;
import software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreVersionResponse;
import software.amazon.awssdk.services.omics.model.UpdateRunCacheRequest;
import software.amazon.awssdk.services.omics.model.UpdateRunCacheResponse;
import software.amazon.awssdk.services.omics.model.UpdateRunGroupRequest;
import software.amazon.awssdk.services.omics.model.UpdateRunGroupResponse;
import software.amazon.awssdk.services.omics.model.UpdateSequenceStoreRequest;
import software.amazon.awssdk.services.omics.model.UpdateSequenceStoreResponse;
import software.amazon.awssdk.services.omics.model.UpdateVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.UpdateVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.UpdateWorkflowRequest;
import software.amazon.awssdk.services.omics.model.UpdateWorkflowResponse;
import software.amazon.awssdk.services.omics.model.UpdateWorkflowVersionRequest;
import software.amazon.awssdk.services.omics.model.UpdateWorkflowVersionResponse;
import software.amazon.awssdk.services.omics.model.UploadReadSetPartRequest;
import software.amazon.awssdk.services.omics.model.UploadReadSetPartResponse;
import software.amazon.awssdk.services.omics.paginators.ListAnnotationImportJobsPublisher;
import software.amazon.awssdk.services.omics.paginators.ListAnnotationStoreVersionsPublisher;
import software.amazon.awssdk.services.omics.paginators.ListAnnotationStoresPublisher;
import software.amazon.awssdk.services.omics.paginators.ListMultipartReadSetUploadsPublisher;
import software.amazon.awssdk.services.omics.paginators.ListReadSetActivationJobsPublisher;
import software.amazon.awssdk.services.omics.paginators.ListReadSetExportJobsPublisher;
import software.amazon.awssdk.services.omics.paginators.ListReadSetImportJobsPublisher;
import software.amazon.awssdk.services.omics.paginators.ListReadSetUploadPartsPublisher;
import software.amazon.awssdk.services.omics.paginators.ListReadSetsPublisher;
import software.amazon.awssdk.services.omics.paginators.ListReferenceImportJobsPublisher;
import software.amazon.awssdk.services.omics.paginators.ListReferenceStoresPublisher;
import software.amazon.awssdk.services.omics.paginators.ListReferencesPublisher;
import software.amazon.awssdk.services.omics.paginators.ListRunCachesPublisher;
import software.amazon.awssdk.services.omics.paginators.ListRunGroupsPublisher;
import software.amazon.awssdk.services.omics.paginators.ListRunTasksPublisher;
import software.amazon.awssdk.services.omics.paginators.ListRunsPublisher;
import software.amazon.awssdk.services.omics.paginators.ListSequenceStoresPublisher;
import software.amazon.awssdk.services.omics.paginators.ListSharesPublisher;
import software.amazon.awssdk.services.omics.paginators.ListVariantImportJobsPublisher;
import software.amazon.awssdk.services.omics.paginators.ListVariantStoresPublisher;
import software.amazon.awssdk.services.omics.paginators.ListWorkflowVersionsPublisher;
import software.amazon.awssdk.services.omics.paginators.ListWorkflowsPublisher;
import software.amazon.awssdk.services.omics.waiters.OmicsAsyncWaiter;

/**
 * Service client for accessing Amazon Omics asynchronously. This can be created using the static {@link #builder()}
 * method.The asynchronous client performs non-blocking I/O when configured with any {@code SdkAsyncHttpClient}
 * supported in the SDK. However, full non-blocking is not guaranteed as the async client may perform blocking calls in
 * some cases such as credentials retrieval and endpoint discovery as part of the async API call.
 *
 * <p>
 * Amazon Web Services HealthOmics is a service that helps users such as bioinformaticians, researchers, and scientists
 * to store, query, analyze, and generate insights from genomics and other biological data. It simplifies and
 * accelerates the process of storing and analyzing genomic information for Amazon Web Services.
 * </p>
 * <p>
 * For an introduction to the service, see <a
 * href="https://docs.aws.amazon.com/omics/latest/dev/what-is-healthomics.html">What is Amazon Web Services
 * HealthOmics?</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface OmicsAsyncClient extends AwsClient {
    String SERVICE_NAME = "omics";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "omics";

    /**
     * <p>
     * Stops a multipart read set upload into a sequence store and returns a response with no body if the operation is
     * successful. To confirm that a multipart read set upload has been stopped, use the
     * <code>ListMultipartReadSetUploads</code> API operation to view all active multipart read set uploads.
     * </p>
     *
     * @param abortMultipartReadSetUploadRequest
     * @return A Java Future containing the result of the AbortMultipartReadSetUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.AbortMultipartReadSetUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/AbortMultipartReadSetUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AbortMultipartReadSetUploadResponse> abortMultipartReadSetUpload(
            AbortMultipartReadSetUploadRequest abortMultipartReadSetUploadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a multipart read set upload into a sequence store and returns a response with no body if the operation is
     * successful. To confirm that a multipart read set upload has been stopped, use the
     * <code>ListMultipartReadSetUploads</code> API operation to view all active multipart read set uploads.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AbortMultipartReadSetUploadRequest.Builder}
     * avoiding the need to create one manually via {@link AbortMultipartReadSetUploadRequest#builder()}
     * </p>
     *
     * @param abortMultipartReadSetUploadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.AbortMultipartReadSetUploadRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AbortMultipartReadSetUpload operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.AbortMultipartReadSetUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/AbortMultipartReadSetUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<AbortMultipartReadSetUploadResponse> abortMultipartReadSetUpload(
            Consumer<AbortMultipartReadSetUploadRequest.Builder> abortMultipartReadSetUploadRequest) {
        return abortMultipartReadSetUpload(AbortMultipartReadSetUploadRequest.builder()
                .applyMutation(abortMultipartReadSetUploadRequest).build());
    }

    /**
     * <p>
     * Accept a resource share request.
     * </p>
     *
     * @param acceptShareRequest
     * @return A Java Future containing the result of the AcceptShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.AcceptShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/AcceptShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AcceptShareResponse> acceptShare(AcceptShareRequest acceptShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Accept a resource share request.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptShareRequest.Builder} avoiding the need to
     * create one manually via {@link AcceptShareRequest#builder()}
     * </p>
     *
     * @param acceptShareRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.AcceptShareRequest.Builder} to create a request.
     * @return A Java Future containing the result of the AcceptShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.AcceptShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/AcceptShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AcceptShareResponse> acceptShare(Consumer<AcceptShareRequest.Builder> acceptShareRequest) {
        return acceptShare(AcceptShareRequest.builder().applyMutation(acceptShareRequest).build());
    }

    /**
     * <p>
     * Deletes one or more read sets. If the operation is successful, it returns a response with no body. If there is an
     * error with deleting one of the read sets, the operation returns an error list. If the operation successfully
     * deletes only a subset of files, it will return an error list for the remaining files that fail to be deleted.
     * There is a limit of 100 read sets that can be deleted in each <code>BatchDeleteReadSet</code> API call.
     * </p>
     *
     * @param batchDeleteReadSetRequest
     * @return A Java Future containing the result of the BatchDeleteReadSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.BatchDeleteReadSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/BatchDeleteReadSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchDeleteReadSetResponse> batchDeleteReadSet(BatchDeleteReadSetRequest batchDeleteReadSetRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or more read sets. If the operation is successful, it returns a response with no body. If there is an
     * error with deleting one of the read sets, the operation returns an error list. If the operation successfully
     * deletes only a subset of files, it will return an error list for the remaining files that fail to be deleted.
     * There is a limit of 100 read sets that can be deleted in each <code>BatchDeleteReadSet</code> API call.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDeleteReadSetRequest.Builder} avoiding the
     * need to create one manually via {@link BatchDeleteReadSetRequest#builder()}
     * </p>
     *
     * @param batchDeleteReadSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.BatchDeleteReadSetRequest.Builder} to create a request.
     * @return A Java Future containing the result of the BatchDeleteReadSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.BatchDeleteReadSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/BatchDeleteReadSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<BatchDeleteReadSetResponse> batchDeleteReadSet(
            Consumer<BatchDeleteReadSetRequest.Builder> batchDeleteReadSetRequest) {
        return batchDeleteReadSet(BatchDeleteReadSetRequest.builder().applyMutation(batchDeleteReadSetRequest).build());
    }

    /**
     * <p>
     * Cancels an annotation import job.
     * </p>
     *
     * @param cancelAnnotationImportJobRequest
     * @return A Java Future containing the result of the CancelAnnotationImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CancelAnnotationImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelAnnotationImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelAnnotationImportJobResponse> cancelAnnotationImportJob(
            CancelAnnotationImportJobRequest cancelAnnotationImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels an annotation import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelAnnotationImportJobRequest.Builder} avoiding
     * the need to create one manually via {@link CancelAnnotationImportJobRequest#builder()}
     * </p>
     *
     * @param cancelAnnotationImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.CancelAnnotationImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelAnnotationImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CancelAnnotationImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelAnnotationImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CancelAnnotationImportJobResponse> cancelAnnotationImportJob(
            Consumer<CancelAnnotationImportJobRequest.Builder> cancelAnnotationImportJobRequest) {
        return cancelAnnotationImportJob(CancelAnnotationImportJobRequest.builder()
                .applyMutation(cancelAnnotationImportJobRequest).build());
    }

    /**
     * <p>
     * Cancels a run using its ID and returns a response with no body if the operation is successful. To confirm that
     * the run has been cancelled, use the <code>ListRuns</code> API operation to check that it is no longer listed.
     * </p>
     *
     * @param cancelRunRequest
     * @return A Java Future containing the result of the CancelRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CancelRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelRunResponse> cancelRun(CancelRunRequest cancelRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a run using its ID and returns a response with no body if the operation is successful. To confirm that
     * the run has been cancelled, use the <code>ListRuns</code> API operation to check that it is no longer listed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelRunRequest.Builder} avoiding the need to
     * create one manually via {@link CancelRunRequest#builder()}
     * </p>
     *
     * @param cancelRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.CancelRunRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CancelRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CancelRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CancelRunResponse> cancelRun(Consumer<CancelRunRequest.Builder> cancelRunRequest) {
        return cancelRun(CancelRunRequest.builder().applyMutation(cancelRunRequest).build());
    }

    /**
     * <p>
     * Cancels a variant import job.
     * </p>
     *
     * @param cancelVariantImportJobRequest
     * @return A Java Future containing the result of the CancelVariantImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CancelVariantImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelVariantImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelVariantImportJobResponse> cancelVariantImportJob(
            CancelVariantImportJobRequest cancelVariantImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Cancels a variant import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CancelVariantImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link CancelVariantImportJobRequest#builder()}
     * </p>
     *
     * @param cancelVariantImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.CancelVariantImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CancelVariantImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CancelVariantImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CancelVariantImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CancelVariantImportJobResponse> cancelVariantImportJob(
            Consumer<CancelVariantImportJobRequest.Builder> cancelVariantImportJobRequest) {
        return cancelVariantImportJob(CancelVariantImportJobRequest.builder().applyMutation(cancelVariantImportJobRequest)
                .build());
    }

    /**
     * <p>
     * Completes a multipart read set upload into a sequence store after you have initiated the upload process with
     * <code>CreateMultipartReadSetUpload</code> and uploaded all read set parts using <code>UploadReadSetPart</code>.
     * You must specify the parts you uploaded using the parts parameter. If the operation is successful, it returns the
     * read set ID(s) of the uploaded read set(s).
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/synchronous-uploads.html">Direct
     * upload to a sequence store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param completeMultipartReadSetUploadRequest
     * @return A Java Future containing the result of the CompleteMultipartReadSetUpload operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CompleteMultipartReadSetUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CompleteMultipartReadSetUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CompleteMultipartReadSetUploadResponse> completeMultipartReadSetUpload(
            CompleteMultipartReadSetUploadRequest completeMultipartReadSetUploadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Completes a multipart read set upload into a sequence store after you have initiated the upload process with
     * <code>CreateMultipartReadSetUpload</code> and uploaded all read set parts using <code>UploadReadSetPart</code>.
     * You must specify the parts you uploaded using the parts parameter. If the operation is successful, it returns the
     * read set ID(s) of the uploaded read set(s).
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/synchronous-uploads.html">Direct
     * upload to a sequence store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CompleteMultipartReadSetUploadRequest.Builder}
     * avoiding the need to create one manually via {@link CompleteMultipartReadSetUploadRequest#builder()}
     * </p>
     *
     * @param completeMultipartReadSetUploadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.CompleteMultipartReadSetUploadRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CompleteMultipartReadSetUpload operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CompleteMultipartReadSetUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CompleteMultipartReadSetUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CompleteMultipartReadSetUploadResponse> completeMultipartReadSetUpload(
            Consumer<CompleteMultipartReadSetUploadRequest.Builder> completeMultipartReadSetUploadRequest) {
        return completeMultipartReadSetUpload(CompleteMultipartReadSetUploadRequest.builder()
                .applyMutation(completeMultipartReadSetUploadRequest).build());
    }

    /**
     * <p>
     * Creates an annotation store.
     * </p>
     *
     * @param createAnnotationStoreRequest
     * @return A Java Future containing the result of the CreateAnnotationStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateAnnotationStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAnnotationStoreResponse> createAnnotationStore(
            CreateAnnotationStoreRequest createAnnotationStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an annotation store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAnnotationStoreRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAnnotationStoreRequest#builder()}
     * </p>
     *
     * @param createAnnotationStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.CreateAnnotationStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateAnnotationStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateAnnotationStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateAnnotationStoreResponse> createAnnotationStore(
            Consumer<CreateAnnotationStoreRequest.Builder> createAnnotationStoreRequest) {
        return createAnnotationStore(CreateAnnotationStoreRequest.builder().applyMutation(createAnnotationStoreRequest).build());
    }

    /**
     * <p>
     * Creates a new version of an annotation store.
     * </p>
     *
     * @param createAnnotationStoreVersionRequest
     * @return A Java Future containing the result of the CreateAnnotationStoreVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateAnnotationStoreVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateAnnotationStoreVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAnnotationStoreVersionResponse> createAnnotationStoreVersion(
            CreateAnnotationStoreVersionRequest createAnnotationStoreVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new version of an annotation store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAnnotationStoreVersionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateAnnotationStoreVersionRequest#builder()}
     * </p>
     *
     * @param createAnnotationStoreVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.CreateAnnotationStoreVersionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateAnnotationStoreVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateAnnotationStoreVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateAnnotationStoreVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAnnotationStoreVersionResponse> createAnnotationStoreVersion(
            Consumer<CreateAnnotationStoreVersionRequest.Builder> createAnnotationStoreVersionRequest) {
        return createAnnotationStoreVersion(CreateAnnotationStoreVersionRequest.builder()
                .applyMutation(createAnnotationStoreVersionRequest).build());
    }

    /**
     * <p>
     * Initiates a multipart read set upload for uploading partitioned source files into a sequence store. You can
     * directly import source files from an EC2 instance and other local compute, or from an S3 bucket. To separate
     * these source files into parts, use the <code>split</code> operation. Each part cannot be larger than 100 MB. If
     * the operation is successful, it provides an <code>uploadId</code> which is required by the
     * <code>UploadReadSetPart</code> API operation to upload parts into a sequence store.
     * </p>
     * <p>
     * To continue uploading a multipart read set into your sequence store, you must use the
     * <code>UploadReadSetPart</code> API operation to upload each part individually following the steps below:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify the <code>uploadId</code> obtained from the previous call to <code>CreateMultipartReadSetUpload</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Upload parts for that <code>uploadId</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you have finished uploading parts, use the <code>CompleteMultipartReadSetUpload</code> API to complete the
     * multipart read set upload and to retrieve the final read set IDs in the response.
     * </p>
     * <p>
     * To learn more about creating parts and the <code>split</code> operation, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/synchronous-uploads.html">Direct upload to a sequence
     * store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param createMultipartReadSetUploadRequest
     * @return A Java Future containing the result of the CreateMultipartReadSetUpload operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateMultipartReadSetUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateMultipartReadSetUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMultipartReadSetUploadResponse> createMultipartReadSetUpload(
            CreateMultipartReadSetUploadRequest createMultipartReadSetUploadRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates a multipart read set upload for uploading partitioned source files into a sequence store. You can
     * directly import source files from an EC2 instance and other local compute, or from an S3 bucket. To separate
     * these source files into parts, use the <code>split</code> operation. Each part cannot be larger than 100 MB. If
     * the operation is successful, it provides an <code>uploadId</code> which is required by the
     * <code>UploadReadSetPart</code> API operation to upload parts into a sequence store.
     * </p>
     * <p>
     * To continue uploading a multipart read set into your sequence store, you must use the
     * <code>UploadReadSetPart</code> API operation to upload each part individually following the steps below:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify the <code>uploadId</code> obtained from the previous call to <code>CreateMultipartReadSetUpload</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Upload parts for that <code>uploadId</code>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When you have finished uploading parts, use the <code>CompleteMultipartReadSetUpload</code> API to complete the
     * multipart read set upload and to retrieve the final read set IDs in the response.
     * </p>
     * <p>
     * To learn more about creating parts and the <code>split</code> operation, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/synchronous-uploads.html">Direct upload to a sequence
     * store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateMultipartReadSetUploadRequest.Builder}
     * avoiding the need to create one manually via {@link CreateMultipartReadSetUploadRequest#builder()}
     * </p>
     *
     * @param createMultipartReadSetUploadRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.CreateMultipartReadSetUploadRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the CreateMultipartReadSetUpload operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateMultipartReadSetUpload
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateMultipartReadSetUpload"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateMultipartReadSetUploadResponse> createMultipartReadSetUpload(
            Consumer<CreateMultipartReadSetUploadRequest.Builder> createMultipartReadSetUploadRequest) {
        return createMultipartReadSetUpload(CreateMultipartReadSetUploadRequest.builder()
                .applyMutation(createMultipartReadSetUploadRequest).build());
    }

    /**
     * <p>
     * Creates a reference store and returns metadata in JSON format. Reference stores are used to store reference
     * genomes in FASTA format. A reference store is created when the first reference genome is imported. To import
     * additional reference genomes from an Amazon S3 bucket, use the <code>StartReferenceImportJob</code> API
     * operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-reference-store.html">Creating a HealthOmics reference
     * store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param createReferenceStoreRequest
     * @return A Java Future containing the result of the CreateReferenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateReferenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateReferenceStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateReferenceStoreResponse> createReferenceStore(
            CreateReferenceStoreRequest createReferenceStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a reference store and returns metadata in JSON format. Reference stores are used to store reference
     * genomes in FASTA format. A reference store is created when the first reference genome is imported. To import
     * additional reference genomes from an Amazon S3 bucket, use the <code>StartReferenceImportJob</code> API
     * operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-reference-store.html">Creating a HealthOmics reference
     * store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateReferenceStoreRequest.Builder} avoiding the
     * need to create one manually via {@link CreateReferenceStoreRequest#builder()}
     * </p>
     *
     * @param createReferenceStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.CreateReferenceStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateReferenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateReferenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateReferenceStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateReferenceStoreResponse> createReferenceStore(
            Consumer<CreateReferenceStoreRequest.Builder> createReferenceStoreRequest) {
        return createReferenceStore(CreateReferenceStoreRequest.builder().applyMutation(createReferenceStoreRequest).build());
    }

    /**
     * <p>
     * Creates a run cache to store and reference task outputs from completed private runs. Specify an Amazon S3
     * location where Amazon Web Services HealthOmics saves the cached data. This data must be immediately accessible
     * and not in an archived state. You can save intermediate task files to a run cache if they are declared as task
     * outputs in the workflow definition file.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflows-call-caching.html">Call
     * caching</a> and <a href="https://docs.aws.amazon.com/omics/latest/dev/workflow-cache-create.html">Creating a run
     * cache</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param createRunCacheRequest
     * @return A Java Future containing the result of the CreateRunCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateRunCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateRunCache" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRunCacheResponse> createRunCache(CreateRunCacheRequest createRunCacheRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a run cache to store and reference task outputs from completed private runs. Specify an Amazon S3
     * location where Amazon Web Services HealthOmics saves the cached data. This data must be immediately accessible
     * and not in an archived state. You can save intermediate task files to a run cache if they are declared as task
     * outputs in the workflow definition file.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflows-call-caching.html">Call
     * caching</a> and <a href="https://docs.aws.amazon.com/omics/latest/dev/workflow-cache-create.html">Creating a run
     * cache</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRunCacheRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRunCacheRequest#builder()}
     * </p>
     *
     * @param createRunCacheRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.CreateRunCacheRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRunCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateRunCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateRunCache" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRunCacheResponse> createRunCache(Consumer<CreateRunCacheRequest.Builder> createRunCacheRequest) {
        return createRunCache(CreateRunCacheRequest.builder().applyMutation(createRunCacheRequest).build());
    }

    /**
     * <p>
     * Creates a run group to limit the compute resources for the runs that are added to the group. Returns an ARN, ID,
     * and tags for the run group.
     * </p>
     *
     * @param createRunGroupRequest
     * @return A Java Future containing the result of the CreateRunGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRunGroupResponse> createRunGroup(CreateRunGroupRequest createRunGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a run group to limit the compute resources for the runs that are added to the group. Returns an ARN, ID,
     * and tags for the run group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateRunGroupRequest.Builder} avoiding the need to
     * create one manually via {@link CreateRunGroupRequest#builder()}
     * </p>
     *
     * @param createRunGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.CreateRunGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateRunGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateRunGroupResponse> createRunGroup(Consumer<CreateRunGroupRequest.Builder> createRunGroupRequest) {
        return createRunGroup(CreateRunGroupRequest.builder().applyMutation(createRunGroupRequest).build());
    }

    /**
     * <p>
     * Creates a sequence store and returns its metadata. Sequence stores are used to store sequence data files called
     * read sets that are saved in FASTQ, BAM, uBAM, or CRAM formats. For aligned formats (BAM and CRAM), a sequence
     * store can only use one reference genome. For unaligned formats (FASTQ and uBAM), a reference genome is not
     * required. You can create multiple sequence stores per region per account.
     * </p>
     * <p>
     * The following are optional parameters you can specify for your sequence store:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>s3AccessConfig</code> to configure your sequence store with S3 access logs (recommended).
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>sseConfig</code> to define your own KMS key for encryption.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>eTagAlgorithmFamily</code> to define which algorithm to use for the HealthOmics eTag on objects.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>fallbackLocation</code> to define a backup location for storing files that have failed a direct upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>propagatedSetLevelTags</code> to configure tags that propagate to all objects in your store.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-sequence-store.html">Creating a HealthOmics sequence
     * store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param createSequenceStoreRequest
     * @return A Java Future containing the result of the CreateSequenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSequenceStoreResponse> createSequenceStore(
            CreateSequenceStoreRequest createSequenceStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a sequence store and returns its metadata. Sequence stores are used to store sequence data files called
     * read sets that are saved in FASTQ, BAM, uBAM, or CRAM formats. For aligned formats (BAM and CRAM), a sequence
     * store can only use one reference genome. For unaligned formats (FASTQ and uBAM), a reference genome is not
     * required. You can create multiple sequence stores per region per account.
     * </p>
     * <p>
     * The following are optional parameters you can specify for your sequence store:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>s3AccessConfig</code> to configure your sequence store with S3 access logs (recommended).
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>sseConfig</code> to define your own KMS key for encryption.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>eTagAlgorithmFamily</code> to define which algorithm to use for the HealthOmics eTag on objects.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>fallbackLocation</code> to define a backup location for storing files that have failed a direct upload.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>propagatedSetLevelTags</code> to configure tags that propagate to all objects in your store.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-sequence-store.html">Creating a HealthOmics sequence
     * store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSequenceStoreRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSequenceStoreRequest#builder()}
     * </p>
     *
     * @param createSequenceStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.CreateSequenceStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateSequenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateSequenceStoreResponse> createSequenceStore(
            Consumer<CreateSequenceStoreRequest.Builder> createSequenceStoreRequest) {
        return createSequenceStore(CreateSequenceStoreRequest.builder().applyMutation(createSequenceStoreRequest).build());
    }

    /**
     * <p>
     * Creates a cross-account shared resource. The resource owner makes an offer to share the resource with the
     * principal subscriber (an AWS user with a different account than the resource owner).
     * </p>
     * <p>
     * The following resources support cross-account sharing:
     * </p>
     * <ul>
     * <li>
     * <p>
     * HealthOmics variant stores
     * </p>
     * </li>
     * <li>
     * <p>
     * HealthOmics annotation stores
     * </p>
     * </li>
     * <li>
     * <p>
     * Private workflows
     * </p>
     * </li>
     * </ul>
     *
     * @param createShareRequest
     * @return A Java Future containing the result of the CreateShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateShareResponse> createShare(CreateShareRequest createShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a cross-account shared resource. The resource owner makes an offer to share the resource with the
     * principal subscriber (an AWS user with a different account than the resource owner).
     * </p>
     * <p>
     * The following resources support cross-account sharing:
     * </p>
     * <ul>
     * <li>
     * <p>
     * HealthOmics variant stores
     * </p>
     * </li>
     * <li>
     * <p>
     * HealthOmics annotation stores
     * </p>
     * </li>
     * <li>
     * <p>
     * Private workflows
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateShareRequest.Builder} avoiding the need to
     * create one manually via {@link CreateShareRequest#builder()}
     * </p>
     *
     * @param createShareRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.CreateShareRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateShareResponse> createShare(Consumer<CreateShareRequest.Builder> createShareRequest) {
        return createShare(CreateShareRequest.builder().applyMutation(createShareRequest).build());
    }

    /**
     * <p>
     * Creates a variant store.
     * </p>
     *
     * @param createVariantStoreRequest
     * @return A Java Future containing the result of the CreateVariantStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateVariantStoreResponse> createVariantStore(CreateVariantStoreRequest createVariantStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a variant store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVariantStoreRequest.Builder} avoiding the
     * need to create one manually via {@link CreateVariantStoreRequest#builder()}
     * </p>
     *
     * @param createVariantStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.CreateVariantStoreRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateVariantStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateVariantStoreResponse> createVariantStore(
            Consumer<CreateVariantStoreRequest.Builder> createVariantStoreRequest) {
        return createVariantStore(CreateVariantStoreRequest.builder().applyMutation(createVariantStoreRequest).build());
    }

    /**
     * <p>
     * Creates a private workflow. Before you create a private workflow, you must create and configure these required
     * resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Workflow definition files</i>: Define your workflow in one or more workflow definition files, written in WDL,
     * Nextflow, or CWL. The workflow definition specifies the inputs and outputs for runs that use the workflow. It
     * also includes specifications for the runs and run tasks for your workflow, including compute and memory
     * requirements. The workflow definition file must be in .zip format.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) <i>Parameter template</i>: You can create a parameter template file that defines the run parameters,
     * or Amazon Web Services HealthOmics can generate the parameter template for you.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>ECR container images</i>: Create container images for the workflow in a private ECR repository, or synchronize
     * images from a supported upstream registry with your Amazon ECR private repository.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) <i>Sentieon licenses</i>: Request a Sentieon license if using the Sentieon software in a private
     * workflow.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/creating-private-workflows.html">Creating or updating a
     * private workflow in Amazon Web Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param createWorkflowRequest
     * @return A Java Future containing the result of the CreateWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWorkflowResponse> createWorkflow(CreateWorkflowRequest createWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a private workflow. Before you create a private workflow, you must create and configure these required
     * resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>Workflow definition files</i>: Define your workflow in one or more workflow definition files, written in WDL,
     * Nextflow, or CWL. The workflow definition specifies the inputs and outputs for runs that use the workflow. It
     * also includes specifications for the runs and run tasks for your workflow, including compute and memory
     * requirements. The workflow definition file must be in .zip format.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) <i>Parameter template</i>: You can create a parameter template file that defines the run parameters,
     * or Amazon Web Services HealthOmics can generate the parameter template for you.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>ECR container images</i>: Create container images for the workflow in a private ECR repository, or synchronize
     * images from a supported upstream registry with your Amazon ECR private repository.
     * </p>
     * </li>
     * <li>
     * <p>
     * (Optional) <i>Sentieon licenses</i>: Request a Sentieon license if using the Sentieon software in a private
     * workflow.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/creating-private-workflows.html">Creating or updating a
     * private workflow in Amazon Web Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link CreateWorkflowRequest#builder()}
     * </p>
     *
     * @param createWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.CreateWorkflowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWorkflowResponse> createWorkflow(Consumer<CreateWorkflowRequest.Builder> createWorkflowRequest) {
        return createWorkflow(CreateWorkflowRequest.builder().applyMutation(createWorkflowRequest).build());
    }

    /**
     * <p>
     * Creates a new workflow version for the workflow that you specify with the <code>workflowId</code> parameter.
     * </p>
     * <p>
     * When you create a new version of a workflow, you need to specify the configuration for the new version. It
     * doesn't inherit any configuration values from the workflow.
     * </p>
     * <p>
     * Provide a version name that is unique for this workflow. You cannot change the name after HealthOmics creates the
     * version.
     * </p>
     * <note>
     * <p>
     * Don't include any personally identifiable information (PII) in the version name. Version names appear in the
     * workflow version ARN.
     * </p>
     * </note>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html">Workflow
     * versioning in Amazon Web Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param createWorkflowVersionRequest
     * @return A Java Future containing the result of the CreateWorkflowVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateWorkflowVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateWorkflowVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateWorkflowVersionResponse> createWorkflowVersion(
            CreateWorkflowVersionRequest createWorkflowVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new workflow version for the workflow that you specify with the <code>workflowId</code> parameter.
     * </p>
     * <p>
     * When you create a new version of a workflow, you need to specify the configuration for the new version. It
     * doesn't inherit any configuration values from the workflow.
     * </p>
     * <p>
     * Provide a version name that is unique for this workflow. You cannot change the name after HealthOmics creates the
     * version.
     * </p>
     * <note>
     * <p>
     * Don't include any personally identifiable information (PII) in the version name. Version names appear in the
     * workflow version ARN.
     * </p>
     * </note>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html">Workflow
     * versioning in Amazon Web Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWorkflowVersionRequest.Builder} avoiding the
     * need to create one manually via {@link CreateWorkflowVersionRequest#builder()}
     * </p>
     *
     * @param createWorkflowVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.CreateWorkflowVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateWorkflowVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.CreateWorkflowVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/CreateWorkflowVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<CreateWorkflowVersionResponse> createWorkflowVersion(
            Consumer<CreateWorkflowVersionRequest.Builder> createWorkflowVersionRequest) {
        return createWorkflowVersion(CreateWorkflowVersionRequest.builder().applyMutation(createWorkflowVersionRequest).build());
    }

    /**
     * <p>
     * Deletes an annotation store.
     * </p>
     *
     * @param deleteAnnotationStoreRequest
     * @return A Java Future containing the result of the DeleteAnnotationStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteAnnotationStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAnnotationStoreResponse> deleteAnnotationStore(
            DeleteAnnotationStoreRequest deleteAnnotationStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an annotation store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAnnotationStoreRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAnnotationStoreRequest#builder()}
     * </p>
     *
     * @param deleteAnnotationStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteAnnotationStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteAnnotationStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteAnnotationStoreResponse> deleteAnnotationStore(
            Consumer<DeleteAnnotationStoreRequest.Builder> deleteAnnotationStoreRequest) {
        return deleteAnnotationStore(DeleteAnnotationStoreRequest.builder().applyMutation(deleteAnnotationStoreRequest).build());
    }

    /**
     * <p>
     * Deletes one or multiple versions of an annotation store.
     * </p>
     *
     * @param deleteAnnotationStoreVersionsRequest
     * @return A Java Future containing the result of the DeleteAnnotationStoreVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteAnnotationStoreVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteAnnotationStoreVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAnnotationStoreVersionsResponse> deleteAnnotationStoreVersions(
            DeleteAnnotationStoreVersionsRequest deleteAnnotationStoreVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes one or multiple versions of an annotation store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAnnotationStoreVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteAnnotationStoreVersionsRequest#builder()}
     * </p>
     *
     * @param deleteAnnotationStoreVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.DeleteAnnotationStoreVersionsRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the DeleteAnnotationStoreVersions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteAnnotationStoreVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteAnnotationStoreVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAnnotationStoreVersionsResponse> deleteAnnotationStoreVersions(
            Consumer<DeleteAnnotationStoreVersionsRequest.Builder> deleteAnnotationStoreVersionsRequest) {
        return deleteAnnotationStoreVersions(DeleteAnnotationStoreVersionsRequest.builder()
                .applyMutation(deleteAnnotationStoreVersionsRequest).build());
    }

    /**
     * <p>
     * Deletes a reference genome and returns a response with no body if the operation is successful. The read set
     * associated with the reference genome must first be deleted before deleting the reference genome. After the
     * reference genome is deleted, you can delete the reference store using the <code>DeleteReferenceStore</code> API
     * operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/deleting-reference-and-sequence-stores.html">Deleting
     * HealthOmics reference and sequence stores</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param deleteReferenceRequest
     * @return A Java Future containing the result of the DeleteReference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteReference" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteReferenceResponse> deleteReference(DeleteReferenceRequest deleteReferenceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a reference genome and returns a response with no body if the operation is successful. The read set
     * associated with the reference genome must first be deleted before deleting the reference genome. After the
     * reference genome is deleted, you can delete the reference store using the <code>DeleteReferenceStore</code> API
     * operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/deleting-reference-and-sequence-stores.html">Deleting
     * HealthOmics reference and sequence stores</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReferenceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteReferenceRequest#builder()}
     * </p>
     *
     * @param deleteReferenceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.DeleteReferenceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteReference operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteReference" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteReferenceResponse> deleteReference(
            Consumer<DeleteReferenceRequest.Builder> deleteReferenceRequest) {
        return deleteReference(DeleteReferenceRequest.builder().applyMutation(deleteReferenceRequest).build());
    }

    /**
     * <p>
     * Deletes a reference store and returns a response with no body if the operation is successful. You can only delete
     * a reference store when it does not contain any reference genomes. To empty a reference store, use
     * <code>DeleteReference</code>.
     * </p>
     * <p>
     * For more information about your workflow status, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/deleting-reference-and-sequence-stores.html">Deleting
     * HealthOmics reference and sequence stores</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param deleteReferenceStoreRequest
     * @return A Java Future containing the result of the DeleteReferenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteReferenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteReferenceStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteReferenceStoreResponse> deleteReferenceStore(
            DeleteReferenceStoreRequest deleteReferenceStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a reference store and returns a response with no body if the operation is successful. You can only delete
     * a reference store when it does not contain any reference genomes. To empty a reference store, use
     * <code>DeleteReference</code>.
     * </p>
     * <p>
     * For more information about your workflow status, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/deleting-reference-and-sequence-stores.html">Deleting
     * HealthOmics reference and sequence stores</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteReferenceStoreRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteReferenceStoreRequest#builder()}
     * </p>
     *
     * @param deleteReferenceStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.DeleteReferenceStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteReferenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteReferenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteReferenceStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteReferenceStoreResponse> deleteReferenceStore(
            Consumer<DeleteReferenceStoreRequest.Builder> deleteReferenceStoreRequest) {
        return deleteReferenceStore(DeleteReferenceStoreRequest.builder().applyMutation(deleteReferenceStoreRequest).build());
    }

    /**
     * <p>
     * Deletes a run and returns a response with no body if the operation is successful. You can only delete a run that
     * has reached a <code>COMPLETED</code>, <code>FAILED</code>, or <code>CANCELLED</code> stage. A completed run has
     * delivered an output, or was cancelled and resulted in no output. When you delete a run, only the metadata
     * associated with the run is deleted. The run outputs remain in Amazon S3 and logs remain in CloudWatch.
     * </p>
     * <p>
     * To verify that the workflow is deleted:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>ListRuns</code> to confirm the workflow no longer appears in the list.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>GetRun</code> to verify the workflow cannot be found.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteRunRequest
     * @return A Java Future containing the result of the DeleteRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRunResponse> deleteRun(DeleteRunRequest deleteRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a run and returns a response with no body if the operation is successful. You can only delete a run that
     * has reached a <code>COMPLETED</code>, <code>FAILED</code>, or <code>CANCELLED</code> stage. A completed run has
     * delivered an output, or was cancelled and resulted in no output. When you delete a run, only the metadata
     * associated with the run is deleted. The run outputs remain in Amazon S3 and logs remain in CloudWatch.
     * </p>
     * <p>
     * To verify that the workflow is deleted:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>ListRuns</code> to confirm the workflow no longer appears in the list.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>GetRun</code> to verify the workflow cannot be found.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRunRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRunRequest#builder()}
     * </p>
     *
     * @param deleteRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.DeleteRunRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRunResponse> deleteRun(Consumer<DeleteRunRequest.Builder> deleteRunRequest) {
        return deleteRun(DeleteRunRequest.builder().applyMutation(deleteRunRequest).build());
    }

    /**
     * <p>
     * Deletes a run cache and returns a response with no body if the operation is successful. This action removes the
     * cache metadata stored in the service account, but does not delete the data in Amazon S3. You can access the cache
     * data in Amazon S3, for inspection or to troubleshoot issues. You can remove old cache data using standard S3
     * <code>Delete</code> operations.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/workflow-cache-delete.html">Deleting a run cache</a> in the
     * <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param deleteRunCacheRequest
     * @return A Java Future containing the result of the DeleteRunCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteRunCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteRunCache" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRunCacheResponse> deleteRunCache(DeleteRunCacheRequest deleteRunCacheRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a run cache and returns a response with no body if the operation is successful. This action removes the
     * cache metadata stored in the service account, but does not delete the data in Amazon S3. You can access the cache
     * data in Amazon S3, for inspection or to troubleshoot issues. You can remove old cache data using standard S3
     * <code>Delete</code> operations.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/workflow-cache-delete.html">Deleting a run cache</a> in the
     * <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRunCacheRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRunCacheRequest#builder()}
     * </p>
     *
     * @param deleteRunCacheRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.DeleteRunCacheRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRunCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteRunCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteRunCache" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRunCacheResponse> deleteRunCache(Consumer<DeleteRunCacheRequest.Builder> deleteRunCacheRequest) {
        return deleteRunCache(DeleteRunCacheRequest.builder().applyMutation(deleteRunCacheRequest).build());
    }

    /**
     * <p>
     * Deletes a run group and returns a response with no body if the operation is successful.
     * </p>
     * <p>
     * To verify that the run group is deleted:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>ListRunGroups</code> to confirm the workflow no longer appears in the list.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>GetRunGroup</code> to verify the workflow cannot be found.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteRunGroupRequest
     * @return A Java Future containing the result of the DeleteRunGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRunGroupResponse> deleteRunGroup(DeleteRunGroupRequest deleteRunGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a run group and returns a response with no body if the operation is successful.
     * </p>
     * <p>
     * To verify that the run group is deleted:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>ListRunGroups</code> to confirm the workflow no longer appears in the list.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>GetRunGroup</code> to verify the workflow cannot be found.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteRunGroupRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteRunGroupRequest#builder()}
     * </p>
     *
     * @param deleteRunGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.DeleteRunGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteRunGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteRunGroupResponse> deleteRunGroup(Consumer<DeleteRunGroupRequest.Builder> deleteRunGroupRequest) {
        return deleteRunGroup(DeleteRunGroupRequest.builder().applyMutation(deleteRunGroupRequest).build());
    }

    /**
     * <p>
     * Deletes an access policy for the specified store.
     * </p>
     *
     * @param deleteS3AccessPolicyRequest
     * @return A Java Future containing the result of the DeleteS3AccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteS3AccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteS3AccessPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteS3AccessPolicyResponse> deleteS3AccessPolicy(
            DeleteS3AccessPolicyRequest deleteS3AccessPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an access policy for the specified store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteS3AccessPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteS3AccessPolicyRequest#builder()}
     * </p>
     *
     * @param deleteS3AccessPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.DeleteS3AccessPolicyRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteS3AccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteS3AccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteS3AccessPolicy" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteS3AccessPolicyResponse> deleteS3AccessPolicy(
            Consumer<DeleteS3AccessPolicyRequest.Builder> deleteS3AccessPolicyRequest) {
        return deleteS3AccessPolicy(DeleteS3AccessPolicyRequest.builder().applyMutation(deleteS3AccessPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a sequence store and returns a response with no body if the operation is successful. You can only delete
     * a sequence store when it does not contain any read sets.
     * </p>
     * <p>
     * Use the <code>BatchDeleteReadSet</code> API operation to ensure that all read sets in the sequence store are
     * deleted. When a sequence store is deleted, all tags associated with the store are also deleted.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/deleting-reference-and-sequence-stores.html">Deleting
     * HealthOmics reference and sequence stores</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param deleteSequenceStoreRequest
     * @return A Java Future containing the result of the DeleteSequenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSequenceStoreResponse> deleteSequenceStore(
            DeleteSequenceStoreRequest deleteSequenceStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a sequence store and returns a response with no body if the operation is successful. You can only delete
     * a sequence store when it does not contain any read sets.
     * </p>
     * <p>
     * Use the <code>BatchDeleteReadSet</code> API operation to ensure that all read sets in the sequence store are
     * deleted. When a sequence store is deleted, all tags associated with the store are also deleted.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/deleting-reference-and-sequence-stores.html">Deleting
     * HealthOmics reference and sequence stores</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSequenceStoreRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSequenceStoreRequest#builder()}
     * </p>
     *
     * @param deleteSequenceStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.DeleteSequenceStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSequenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSequenceStoreResponse> deleteSequenceStore(
            Consumer<DeleteSequenceStoreRequest.Builder> deleteSequenceStoreRequest) {
        return deleteSequenceStore(DeleteSequenceStoreRequest.builder().applyMutation(deleteSequenceStoreRequest).build());
    }

    /**
     * <p>
     * Deletes a resource share. If you are the resource owner, the subscriber will no longer have access to the shared
     * resource. If you are the subscriber, this operation deletes your access to the share.
     * </p>
     *
     * @param deleteShareRequest
     * @return A Java Future containing the result of the DeleteShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteShareResponse> deleteShare(DeleteShareRequest deleteShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a resource share. If you are the resource owner, the subscriber will no longer have access to the shared
     * resource. If you are the subscriber, this operation deletes your access to the share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteShareRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteShareRequest#builder()}
     * </p>
     *
     * @param deleteShareRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.DeleteShareRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteShareResponse> deleteShare(Consumer<DeleteShareRequest.Builder> deleteShareRequest) {
        return deleteShare(DeleteShareRequest.builder().applyMutation(deleteShareRequest).build());
    }

    /**
     * <p>
     * Deletes a variant store.
     * </p>
     *
     * @param deleteVariantStoreRequest
     * @return A Java Future containing the result of the DeleteVariantStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVariantStoreResponse> deleteVariantStore(DeleteVariantStoreRequest deleteVariantStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a variant store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVariantStoreRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVariantStoreRequest#builder()}
     * </p>
     *
     * @param deleteVariantStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.DeleteVariantStoreRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteVariantStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVariantStoreResponse> deleteVariantStore(
            Consumer<DeleteVariantStoreRequest.Builder> deleteVariantStoreRequest) {
        return deleteVariantStore(DeleteVariantStoreRequest.builder().applyMutation(deleteVariantStoreRequest).build());
    }

    /**
     * <p>
     * Deletes a workflow by specifying its ID. This operation returns a response with no body if the deletion is
     * successful.
     * </p>
     * <p>
     * To verify that the workflow is deleted:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>ListWorkflows</code> to confirm the workflow no longer appears in the list.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>GetWorkflow</code> to verify the workflow cannot be found.
     * </p>
     * </li>
     * </ul>
     *
     * @param deleteWorkflowRequest
     * @return A Java Future containing the result of the DeleteWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWorkflowResponse> deleteWorkflow(DeleteWorkflowRequest deleteWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a workflow by specifying its ID. This operation returns a response with no body if the deletion is
     * successful.
     * </p>
     * <p>
     * To verify that the workflow is deleted:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <code>ListWorkflows</code> to confirm the workflow no longer appears in the list.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <code>GetWorkflow</code> to verify the workflow cannot be found.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWorkflowRequest#builder()}
     * </p>
     *
     * @param deleteWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.DeleteWorkflowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWorkflowResponse> deleteWorkflow(Consumer<DeleteWorkflowRequest.Builder> deleteWorkflowRequest) {
        return deleteWorkflow(DeleteWorkflowRequest.builder().applyMutation(deleteWorkflowRequest).build());
    }

    /**
     * <p>
     * Deletes a workflow version. Deleting a workflow version doesn't affect any ongoing runs that are using the
     * workflow version.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html">Workflow
     * versioning in Amazon Web Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param deleteWorkflowVersionRequest
     * @return A Java Future containing the result of the DeleteWorkflowVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteWorkflowVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteWorkflowVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteWorkflowVersionResponse> deleteWorkflowVersion(
            DeleteWorkflowVersionRequest deleteWorkflowVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a workflow version. Deleting a workflow version doesn't affect any ongoing runs that are using the
     * workflow version.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html">Workflow
     * versioning in Amazon Web Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWorkflowVersionRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteWorkflowVersionRequest#builder()}
     * </p>
     *
     * @param deleteWorkflowVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.DeleteWorkflowVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteWorkflowVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.DeleteWorkflowVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/DeleteWorkflowVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DeleteWorkflowVersionResponse> deleteWorkflowVersion(
            Consumer<DeleteWorkflowVersionRequest.Builder> deleteWorkflowVersionRequest) {
        return deleteWorkflowVersion(DeleteWorkflowVersionRequest.builder().applyMutation(deleteWorkflowVersionRequest).build());
    }

    /**
     * <p>
     * Gets information about an annotation import job.
     * </p>
     *
     * @param getAnnotationImportJobRequest
     * @return A Java Future containing the result of the GetAnnotationImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetAnnotationImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAnnotationImportJobResponse> getAnnotationImportJob(
            GetAnnotationImportJobRequest getAnnotationImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an annotation import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAnnotationImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetAnnotationImportJobRequest#builder()}
     * </p>
     *
     * @param getAnnotationImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetAnnotationImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAnnotationImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetAnnotationImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetAnnotationImportJobResponse> getAnnotationImportJob(
            Consumer<GetAnnotationImportJobRequest.Builder> getAnnotationImportJobRequest) {
        return getAnnotationImportJob(GetAnnotationImportJobRequest.builder().applyMutation(getAnnotationImportJobRequest)
                .build());
    }

    /**
     * <p>
     * Gets information about an annotation store.
     * </p>
     *
     * @param getAnnotationStoreRequest
     * @return A Java Future containing the result of the GetAnnotationStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAnnotationStoreResponse> getAnnotationStore(GetAnnotationStoreRequest getAnnotationStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about an annotation store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAnnotationStoreRequest.Builder} avoiding the
     * need to create one manually via {@link GetAnnotationStoreRequest#builder()}
     * </p>
     *
     * @param getAnnotationStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetAnnotationStoreRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetAnnotationStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetAnnotationStoreResponse> getAnnotationStore(
            Consumer<GetAnnotationStoreRequest.Builder> getAnnotationStoreRequest) {
        return getAnnotationStore(GetAnnotationStoreRequest.builder().applyMutation(getAnnotationStoreRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for an annotation store version.
     * </p>
     *
     * @param getAnnotationStoreVersionRequest
     * @return A Java Future containing the result of the GetAnnotationStoreVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetAnnotationStoreVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationStoreVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAnnotationStoreVersionResponse> getAnnotationStoreVersion(
            GetAnnotationStoreVersionRequest getAnnotationStoreVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for an annotation store version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAnnotationStoreVersionRequest.Builder} avoiding
     * the need to create one manually via {@link GetAnnotationStoreVersionRequest#builder()}
     * </p>
     *
     * @param getAnnotationStoreVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetAnnotationStoreVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetAnnotationStoreVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetAnnotationStoreVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetAnnotationStoreVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAnnotationStoreVersionResponse> getAnnotationStoreVersion(
            Consumer<GetAnnotationStoreVersionRequest.Builder> getAnnotationStoreVersionRequest) {
        return getAnnotationStoreVersion(GetAnnotationStoreVersionRequest.builder()
                .applyMutation(getAnnotationStoreVersionRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information from parts of a read set and returns the read set in the same format that it was
     * uploaded. You must have read sets uploaded to your sequence store in order to run this operation.
     * </p>
     *
     * @param getReadSetRequest
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows '
     *        <p>
     *        The read set file payload.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>RangeNotSatisfiableException The ranges specified in the request are not valid.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSet" target="_top">AWS API
     *      Documentation</a>
     */
    default <ReturnT> CompletableFuture<ReturnT> getReadSet(GetReadSetRequest getReadSetRequest,
            AsyncResponseTransformer<GetReadSetResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information from parts of a read set and returns the read set in the same format that it was
     * uploaded. You must have read sets uploaded to your sequence store in order to run this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReadSetRequest.Builder} avoiding the need to
     * create one manually via {@link GetReadSetRequest#builder()}
     * </p>
     *
     * @param getReadSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetReadSetRequest.Builder} to create a request.
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows '
     *        <p>
     *        The read set file payload.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>RangeNotSatisfiableException The ranges specified in the request are not valid.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSet" target="_top">AWS API
     *      Documentation</a>
     */
    default <ReturnT> CompletableFuture<ReturnT> getReadSet(Consumer<GetReadSetRequest.Builder> getReadSetRequest,
            AsyncResponseTransformer<GetReadSetResponse, ReturnT> asyncResponseTransformer) {
        return getReadSet(GetReadSetRequest.builder().applyMutation(getReadSetRequest).build(), asyncResponseTransformer);
    }

    /**
     * <p>
     * Retrieves detailed information from parts of a read set and returns the read set in the same format that it was
     * uploaded. You must have read sets uploaded to your sequence store in order to run this operation.
     * </p>
     *
     * @param getReadSetRequest
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        The read set file payload.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>RangeNotSatisfiableException The ranges specified in the request are not valid.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReadSetResponse> getReadSet(GetReadSetRequest getReadSetRequest, Path destinationPath) {
        return getReadSet(getReadSetRequest, AsyncResponseTransformer.toFile(destinationPath));
    }

    /**
     * <p>
     * Retrieves detailed information from parts of a read set and returns the read set in the same format that it was
     * uploaded. You must have read sets uploaded to your sequence store in order to run this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReadSetRequest.Builder} avoiding the need to
     * create one manually via {@link GetReadSetRequest#builder()}
     * </p>
     *
     * @param getReadSetRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetReadSetRequest.Builder} to create a request.
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        The read set file payload.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>RangeNotSatisfiableException The ranges specified in the request are not valid.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSet" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReadSetResponse> getReadSet(Consumer<GetReadSetRequest.Builder> getReadSetRequest,
            Path destinationPath) {
        return getReadSet(GetReadSetRequest.builder().applyMutation(getReadSetRequest).build(), destinationPath);
    }

    /**
     * <p>
     * Returns detailed information about the status of a read set activation job in JSON format.
     * </p>
     *
     * @param getReadSetActivationJobRequest
     * @return A Java Future containing the result of the GetReadSetActivationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSetActivationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetActivationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetReadSetActivationJobResponse> getReadSetActivationJob(
            GetReadSetActivationJobRequest getReadSetActivationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns detailed information about the status of a read set activation job in JSON format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReadSetActivationJobRequest.Builder} avoiding
     * the need to create one manually via {@link GetReadSetActivationJobRequest#builder()}
     * </p>
     *
     * @param getReadSetActivationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetReadSetActivationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetReadSetActivationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSetActivationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetActivationJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetReadSetActivationJobResponse> getReadSetActivationJob(
            Consumer<GetReadSetActivationJobRequest.Builder> getReadSetActivationJobRequest) {
        return getReadSetActivationJob(GetReadSetActivationJobRequest.builder().applyMutation(getReadSetActivationJobRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves status information about a read set export job and returns the data in JSON format. Use this operation
     * to actively monitor the progress of an export job.
     * </p>
     *
     * @param getReadSetExportJobRequest
     * @return A Java Future containing the result of the GetReadSetExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReadSetExportJobResponse> getReadSetExportJob(
            GetReadSetExportJobRequest getReadSetExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves status information about a read set export job and returns the data in JSON format. Use this operation
     * to actively monitor the progress of an export job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReadSetExportJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetReadSetExportJobRequest#builder()}
     * </p>
     *
     * @param getReadSetExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetReadSetExportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetReadSetExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetExportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReadSetExportJobResponse> getReadSetExportJob(
            Consumer<GetReadSetExportJobRequest.Builder> getReadSetExportJobRequest) {
        return getReadSetExportJob(GetReadSetExportJobRequest.builder().applyMutation(getReadSetExportJobRequest).build());
    }

    /**
     * <p>
     * Gets detailed and status information about a read set import job and returns the data in JSON format.
     * </p>
     *
     * @param getReadSetImportJobRequest
     * @return A Java Future containing the result of the GetReadSetImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReadSetImportJobResponse> getReadSetImportJob(
            GetReadSetImportJobRequest getReadSetImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets detailed and status information about a read set import job and returns the data in JSON format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReadSetImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetReadSetImportJobRequest#builder()}
     * </p>
     *
     * @param getReadSetImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetReadSetImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetReadSetImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReadSetImportJobResponse> getReadSetImportJob(
            Consumer<GetReadSetImportJobRequest.Builder> getReadSetImportJobRequest) {
        return getReadSetImportJob(GetReadSetImportJobRequest.builder().applyMutation(getReadSetImportJobRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for a read set from a sequence store in JSON format. This operation does not return tags.
     * To retrieve the list of tags for a read set, use the <code>ListTagsForResource</code> API operation.
     * </p>
     *
     * @param getReadSetMetadataRequest
     * @return A Java Future containing the result of the GetReadSetMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSetMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReadSetMetadataResponse> getReadSetMetadata(GetReadSetMetadataRequest getReadSetMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for a read set from a sequence store in JSON format. This operation does not return tags.
     * To retrieve the list of tags for a read set, use the <code>ListTagsForResource</code> API operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReadSetMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link GetReadSetMetadataRequest#builder()}
     * </p>
     *
     * @param getReadSetMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetReadSetMetadataRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetReadSetMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReadSetMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReadSetMetadata" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReadSetMetadataResponse> getReadSetMetadata(
            Consumer<GetReadSetMetadataRequest.Builder> getReadSetMetadataRequest) {
        return getReadSetMetadata(GetReadSetMetadataRequest.builder().applyMutation(getReadSetMetadataRequest).build());
    }

    /**
     * <p>
     * Downloads parts of data from a reference genome and returns the reference file in the same format that it was
     * uploaded.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-reference-store.html">Creating a HealthOmics reference
     * store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param getReferenceRequest
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows '
     *        <p>
     *        The reference file payload.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>RangeNotSatisfiableException The ranges specified in the request are not valid.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReference" target="_top">AWS API
     *      Documentation</a>
     */
    default <ReturnT> CompletableFuture<ReturnT> getReference(GetReferenceRequest getReferenceRequest,
            AsyncResponseTransformer<GetReferenceResponse, ReturnT> asyncResponseTransformer) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Downloads parts of data from a reference genome and returns the reference file in the same format that it was
     * uploaded.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-reference-store.html">Creating a HealthOmics reference
     * store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReferenceRequest.Builder} avoiding the need to
     * create one manually via {@link GetReferenceRequest#builder()}
     * </p>
     *
     * @param getReferenceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetReferenceRequest.Builder} to create a request.
     * @param asyncResponseTransformer
     *        The response transformer for processing the streaming response in a non-blocking manner. See
     *        {@link AsyncResponseTransformer} for details on how this callback should be implemented and for links to
     *        precanned implementations for common scenarios like downloading to a file. The service documentation for
     *        the response content is as follows '
     *        <p>
     *        The reference file payload.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>RangeNotSatisfiableException The ranges specified in the request are not valid.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReference" target="_top">AWS API
     *      Documentation</a>
     */
    default <ReturnT> CompletableFuture<ReturnT> getReference(Consumer<GetReferenceRequest.Builder> getReferenceRequest,
            AsyncResponseTransformer<GetReferenceResponse, ReturnT> asyncResponseTransformer) {
        return getReference(GetReferenceRequest.builder().applyMutation(getReferenceRequest).build(), asyncResponseTransformer);
    }

    /**
     * <p>
     * Downloads parts of data from a reference genome and returns the reference file in the same format that it was
     * uploaded.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-reference-store.html">Creating a HealthOmics reference
     * store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param getReferenceRequest
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        The reference file payload.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>RangeNotSatisfiableException The ranges specified in the request are not valid.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReference" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReferenceResponse> getReference(GetReferenceRequest getReferenceRequest, Path destinationPath) {
        return getReference(getReferenceRequest, AsyncResponseTransformer.toFile(destinationPath));
    }

    /**
     * <p>
     * Downloads parts of data from a reference genome and returns the reference file in the same format that it was
     * uploaded.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-reference-store.html">Creating a HealthOmics reference
     * store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReferenceRequest.Builder} avoiding the need to
     * create one manually via {@link GetReferenceRequest#builder()}
     * </p>
     *
     * @param getReferenceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetReferenceRequest.Builder} to create a request.
     * @param destinationPath
     *        {@link Path} to file that response contents will be written to. The file must not exist or this method
     *        will throw an exception. If the file is not writable by the current user then an exception will be thrown.
     *        The service documentation for the response content is as follows '
     *        <p>
     *        The reference file payload.
     *        </p>
     *        '.
     * @return A future to the transformed result of the AsyncResponseTransformer.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>RangeNotSatisfiableException The ranges specified in the request are not valid.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReference
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReference" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReferenceResponse> getReference(Consumer<GetReferenceRequest.Builder> getReferenceRequest,
            Path destinationPath) {
        return getReference(GetReferenceRequest.builder().applyMutation(getReferenceRequest).build(), destinationPath);
    }

    /**
     * <p>
     * Monitors the status of a reference import job. This operation can be called after calling the
     * <code>StartReferenceImportJob</code> operation.
     * </p>
     *
     * @param getReferenceImportJobRequest
     * @return A Java Future containing the result of the GetReferenceImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReferenceImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetReferenceImportJobResponse> getReferenceImportJob(
            GetReferenceImportJobRequest getReferenceImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Monitors the status of a reference import job. This operation can be called after calling the
     * <code>StartReferenceImportJob</code> operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReferenceImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetReferenceImportJobRequest#builder()}
     * </p>
     *
     * @param getReferenceImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetReferenceImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetReferenceImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReferenceImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetReferenceImportJobResponse> getReferenceImportJob(
            Consumer<GetReferenceImportJobRequest.Builder> getReferenceImportJobRequest) {
        return getReferenceImportJob(GetReferenceImportJobRequest.builder().applyMutation(getReferenceImportJobRequest).build());
    }

    /**
     * <p>
     * Retrieves metadata for a reference genome. This operation returns the number of parts, part size, and MD5 of an
     * entire file. This operation does not return tags. To retrieve the list of tags for a read set, use the
     * <code>ListTagsForResource</code> API operation.
     * </p>
     *
     * @param getReferenceMetadataRequest
     * @return A Java Future containing the result of the GetReferenceMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReferenceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetReferenceMetadataResponse> getReferenceMetadata(
            GetReferenceMetadataRequest getReferenceMetadataRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves metadata for a reference genome. This operation returns the number of parts, part size, and MD5 of an
     * entire file. This operation does not return tags. To retrieve the list of tags for a read set, use the
     * <code>ListTagsForResource</code> API operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReferenceMetadataRequest.Builder} avoiding the
     * need to create one manually via {@link GetReferenceMetadataRequest#builder()}
     * </p>
     *
     * @param getReferenceMetadataRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetReferenceMetadataRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetReferenceMetadata operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReferenceMetadata
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceMetadata" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetReferenceMetadataResponse> getReferenceMetadata(
            Consumer<GetReferenceMetadataRequest.Builder> getReferenceMetadataRequest) {
        return getReferenceMetadata(GetReferenceMetadataRequest.builder().applyMutation(getReferenceMetadataRequest).build());
    }

    /**
     * <p>
     * Gets information about a reference store.
     * </p>
     *
     * @param getReferenceStoreRequest
     * @return A Java Future containing the result of the GetReferenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReferenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReferenceStoreResponse> getReferenceStore(GetReferenceStoreRequest getReferenceStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a reference store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReferenceStoreRequest.Builder} avoiding the need
     * to create one manually via {@link GetReferenceStoreRequest#builder()}
     * </p>
     *
     * @param getReferenceStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetReferenceStoreRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetReferenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetReferenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetReferenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetReferenceStoreResponse> getReferenceStore(
            Consumer<GetReferenceStoreRequest.Builder> getReferenceStoreRequest) {
        return getReferenceStore(GetReferenceStoreRequest.builder().applyMutation(getReferenceStoreRequest).build());
    }

    /**
     * <p>
     * Gets detailed information about a specific run using its ID.
     * </p>
     * <p>
     * Amazon Web Services HealthOmics stores a configurable number of runs, as determined by service limits, that are
     * available to the console and API. If <code>GetRun</code> does not return the requested run, you can find all run
     * logs in the CloudWatch logs. For more information about viewing the run logs, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/monitoring-cloudwatch-logs.html">CloudWatch logs</a> in the
     * <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param getRunRequest
     * @return A Java Future containing the result of the GetRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRunResponse> getRun(GetRunRequest getRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets detailed information about a specific run using its ID.
     * </p>
     * <p>
     * Amazon Web Services HealthOmics stores a configurable number of runs, as determined by service limits, that are
     * available to the console and API. If <code>GetRun</code> does not return the requested run, you can find all run
     * logs in the CloudWatch logs. For more information about viewing the run logs, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/monitoring-cloudwatch-logs.html">CloudWatch logs</a> in the
     * <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRunRequest.Builder} avoiding the need to create
     * one manually via {@link GetRunRequest#builder()}
     * </p>
     *
     * @param getRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetRunRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRunResponse> getRun(Consumer<GetRunRequest.Builder> getRunRequest) {
        return getRun(GetRunRequest.builder().applyMutation(getRunRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed information about the specified run cache using its ID.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflows-call-caching.html">Call
     * caching for Amazon Web Services HealthOmics runs</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param getRunCacheRequest
     * @return A Java Future containing the result of the GetRunCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetRunCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRunCache" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRunCacheResponse> getRunCache(GetRunCacheRequest getRunCacheRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed information about the specified run cache using its ID.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflows-call-caching.html">Call
     * caching for Amazon Web Services HealthOmics runs</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRunCacheRequest.Builder} avoiding the need to
     * create one manually via {@link GetRunCacheRequest#builder()}
     * </p>
     *
     * @param getRunCacheRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetRunCacheRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRunCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetRunCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRunCache" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRunCacheResponse> getRunCache(Consumer<GetRunCacheRequest.Builder> getRunCacheRequest) {
        return getRunCache(GetRunCacheRequest.builder().applyMutation(getRunCacheRequest).build());
    }

    /**
     * <p>
     * Gets information about a run group and returns its metadata.
     * </p>
     *
     * @param getRunGroupRequest
     * @return A Java Future containing the result of the GetRunGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRunGroupResponse> getRunGroup(GetRunGroupRequest getRunGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a run group and returns its metadata.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRunGroupRequest.Builder} avoiding the need to
     * create one manually via {@link GetRunGroupRequest#builder()}
     * </p>
     *
     * @param getRunGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetRunGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRunGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRunGroupResponse> getRunGroup(Consumer<GetRunGroupRequest.Builder> getRunGroupRequest) {
        return getRunGroup(GetRunGroupRequest.builder().applyMutation(getRunGroupRequest).build());
    }

    /**
     * <p>
     * Gets detailed information about a run task using its ID.
     * </p>
     *
     * @param getRunTaskRequest
     * @return A Java Future containing the result of the GetRunTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetRunTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRunTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRunTaskResponse> getRunTask(GetRunTaskRequest getRunTaskRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets detailed information about a run task using its ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetRunTaskRequest.Builder} avoiding the need to
     * create one manually via {@link GetRunTaskRequest#builder()}
     * </p>
     *
     * @param getRunTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetRunTaskRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetRunTask operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetRunTask
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetRunTask" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetRunTaskResponse> getRunTask(Consumer<GetRunTaskRequest.Builder> getRunTaskRequest) {
        return getRunTask(GetRunTaskRequest.builder().applyMutation(getRunTaskRequest).build());
    }

    /**
     * <p>
     * Retrieves details about an access policy on a given store.
     * </p>
     *
     * @param getS3AccessPolicyRequest
     * @return A Java Future containing the result of the GetS3AccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetS3AccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetS3AccessPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetS3AccessPolicyResponse> getS3AccessPolicy(GetS3AccessPolicyRequest getS3AccessPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves details about an access policy on a given store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetS3AccessPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetS3AccessPolicyRequest#builder()}
     * </p>
     *
     * @param getS3AccessPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetS3AccessPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetS3AccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetS3AccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetS3AccessPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetS3AccessPolicyResponse> getS3AccessPolicy(
            Consumer<GetS3AccessPolicyRequest.Builder> getS3AccessPolicyRequest) {
        return getS3AccessPolicy(GetS3AccessPolicyRequest.builder().applyMutation(getS3AccessPolicyRequest).build());
    }

    /**
     * <p>
     * Retrieves metadata for a sequence store using its ID and returns it in JSON format.
     * </p>
     *
     * @param getSequenceStoreRequest
     * @return A Java Future containing the result of the GetSequenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSequenceStoreResponse> getSequenceStore(GetSequenceStoreRequest getSequenceStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves metadata for a sequence store using its ID and returns it in JSON format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSequenceStoreRequest.Builder} avoiding the need
     * to create one manually via {@link GetSequenceStoreRequest#builder()}
     * </p>
     *
     * @param getSequenceStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetSequenceStoreRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetSequenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetSequenceStoreResponse> getSequenceStore(
            Consumer<GetSequenceStoreRequest.Builder> getSequenceStoreRequest) {
        return getSequenceStore(GetSequenceStoreRequest.builder().applyMutation(getSequenceStoreRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata for the specified resource share.
     * </p>
     *
     * @param getShareRequest
     * @return A Java Future containing the result of the GetShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetShareResponse> getShare(GetShareRequest getShareRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata for the specified resource share.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetShareRequest.Builder} avoiding the need to
     * create one manually via {@link GetShareRequest#builder()}
     * </p>
     *
     * @param getShareRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetShareRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetShare operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetShare
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetShare" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetShareResponse> getShare(Consumer<GetShareRequest.Builder> getShareRequest) {
        return getShare(GetShareRequest.builder().applyMutation(getShareRequest).build());
    }

    /**
     * <p>
     * Gets information about a variant import job.
     * </p>
     *
     * @param getVariantImportJobRequest
     * @return A Java Future containing the result of the GetVariantImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetVariantImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetVariantImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVariantImportJobResponse> getVariantImportJob(
            GetVariantImportJobRequest getVariantImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a variant import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVariantImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetVariantImportJobRequest#builder()}
     * </p>
     *
     * @param getVariantImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetVariantImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetVariantImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetVariantImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetVariantImportJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVariantImportJobResponse> getVariantImportJob(
            Consumer<GetVariantImportJobRequest.Builder> getVariantImportJobRequest) {
        return getVariantImportJob(GetVariantImportJobRequest.builder().applyMutation(getVariantImportJobRequest).build());
    }

    /**
     * <p>
     * Gets information about a variant store.
     * </p>
     *
     * @param getVariantStoreRequest
     * @return A Java Future containing the result of the GetVariantStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVariantStoreResponse> getVariantStore(GetVariantStoreRequest getVariantStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a variant store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetVariantStoreRequest.Builder} avoiding the need
     * to create one manually via {@link GetVariantStoreRequest#builder()}
     * </p>
     *
     * @param getVariantStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetVariantStoreRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetVariantStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetVariantStoreResponse> getVariantStore(
            Consumer<GetVariantStoreRequest.Builder> getVariantStoreRequest) {
        return getVariantStore(GetVariantStoreRequest.builder().applyMutation(getVariantStoreRequest).build());
    }

    /**
     * <p>
     * Gets all information about a workflow using its ID.
     * </p>
     * <p>
     * If a workflow is shared with you, you cannot export the workflow.
     * </p>
     * <p>
     * For more information about your workflow status, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/using-get-workflow.html">Verify the workflow status</a> in the
     * <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param getWorkflowRequest
     * @return A Java Future containing the result of the GetWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWorkflowResponse> getWorkflow(GetWorkflowRequest getWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets all information about a workflow using its ID.
     * </p>
     * <p>
     * If a workflow is shared with you, you cannot export the workflow.
     * </p>
     * <p>
     * For more information about your workflow status, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/using-get-workflow.html">Verify the workflow status</a> in the
     * <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link GetWorkflowRequest#builder()}
     * </p>
     *
     * @param getWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetWorkflowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWorkflowResponse> getWorkflow(Consumer<GetWorkflowRequest.Builder> getWorkflowRequest) {
        return getWorkflow(GetWorkflowRequest.builder().applyMutation(getWorkflowRequest).build());
    }

    /**
     * <p>
     * Gets information about a workflow version. For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html">Workflow versioning in Amazon Web
     * Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param getWorkflowVersionRequest
     * @return A Java Future containing the result of the GetWorkflowVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetWorkflowVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetWorkflowVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWorkflowVersionResponse> getWorkflowVersion(GetWorkflowVersionRequest getWorkflowVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets information about a workflow version. For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html">Workflow versioning in Amazon Web
     * Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetWorkflowVersionRequest.Builder} avoiding the
     * need to create one manually via {@link GetWorkflowVersionRequest#builder()}
     * </p>
     *
     * @param getWorkflowVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.GetWorkflowVersionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetWorkflowVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.GetWorkflowVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/GetWorkflowVersion" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetWorkflowVersionResponse> getWorkflowVersion(
            Consumer<GetWorkflowVersionRequest.Builder> getWorkflowVersionRequest) {
        return getWorkflowVersion(GetWorkflowVersionRequest.builder().applyMutation(getWorkflowVersionRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of annotation import jobs.
     * </p>
     *
     * @param listAnnotationImportJobsRequest
     * @return A Java Future containing the result of the ListAnnotationImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListAnnotationImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAnnotationImportJobsResponse> listAnnotationImportJobs(
            ListAnnotationImportJobsRequest listAnnotationImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of annotation import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnnotationImportJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAnnotationImportJobsRequest#builder()}
     * </p>
     *
     * @param listAnnotationImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAnnotationImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListAnnotationImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAnnotationImportJobsResponse> listAnnotationImportJobs(
            Consumer<ListAnnotationImportJobsRequest.Builder> listAnnotationImportJobsRequest) {
        return listAnnotationImportJobs(ListAnnotationImportJobsRequest.builder().applyMutation(listAnnotationImportJobsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnnotationImportJobs(software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListAnnotationImportJobsPublisher publisher = client.listAnnotationImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListAnnotationImportJobsPublisher publisher = client.listAnnotationImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnnotationImportJobs(software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAnnotationImportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListAnnotationImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnnotationImportJobsPublisher listAnnotationImportJobsPaginator(
            ListAnnotationImportJobsRequest listAnnotationImportJobsRequest) {
        return new ListAnnotationImportJobsPublisher(this, listAnnotationImportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnnotationImportJobs(software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListAnnotationImportJobsPublisher publisher = client.listAnnotationImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListAnnotationImportJobsPublisher publisher = client.listAnnotationImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnnotationImportJobs(software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnnotationImportJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListAnnotationImportJobsRequest#builder()}
     * </p>
     *
     * @param listAnnotationImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListAnnotationImportJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListAnnotationImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationImportJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnnotationImportJobsPublisher listAnnotationImportJobsPaginator(
            Consumer<ListAnnotationImportJobsRequest.Builder> listAnnotationImportJobsRequest) {
        return listAnnotationImportJobsPaginator(ListAnnotationImportJobsRequest.builder()
                .applyMutation(listAnnotationImportJobsRequest).build());
    }

    /**
     * <p>
     * Lists the versions of an annotation store.
     * </p>
     *
     * @param listAnnotationStoreVersionsRequest
     * @return A Java Future containing the result of the ListAnnotationStoreVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListAnnotationStoreVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationStoreVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAnnotationStoreVersionsResponse> listAnnotationStoreVersions(
            ListAnnotationStoreVersionsRequest listAnnotationStoreVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the versions of an annotation store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnnotationStoreVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAnnotationStoreVersionsRequest#builder()}
     * </p>
     *
     * @param listAnnotationStoreVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListAnnotationStoreVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAnnotationStoreVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListAnnotationStoreVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationStoreVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAnnotationStoreVersionsResponse> listAnnotationStoreVersions(
            Consumer<ListAnnotationStoreVersionsRequest.Builder> listAnnotationStoreVersionsRequest) {
        return listAnnotationStoreVersions(ListAnnotationStoreVersionsRequest.builder()
                .applyMutation(listAnnotationStoreVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnnotationStoreVersions(software.amazon.awssdk.services.omics.model.ListAnnotationStoreVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListAnnotationStoreVersionsPublisher publisher = client.listAnnotationStoreVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListAnnotationStoreVersionsPublisher publisher = client.listAnnotationStoreVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListAnnotationStoreVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListAnnotationStoreVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnnotationStoreVersions(software.amazon.awssdk.services.omics.model.ListAnnotationStoreVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAnnotationStoreVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListAnnotationStoreVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationStoreVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnnotationStoreVersionsPublisher listAnnotationStoreVersionsPaginator(
            ListAnnotationStoreVersionsRequest listAnnotationStoreVersionsRequest) {
        return new ListAnnotationStoreVersionsPublisher(this, listAnnotationStoreVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnnotationStoreVersions(software.amazon.awssdk.services.omics.model.ListAnnotationStoreVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListAnnotationStoreVersionsPublisher publisher = client.listAnnotationStoreVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListAnnotationStoreVersionsPublisher publisher = client.listAnnotationStoreVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListAnnotationStoreVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListAnnotationStoreVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnnotationStoreVersions(software.amazon.awssdk.services.omics.model.ListAnnotationStoreVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnnotationStoreVersionsRequest.Builder}
     * avoiding the need to create one manually via {@link ListAnnotationStoreVersionsRequest#builder()}
     * </p>
     *
     * @param listAnnotationStoreVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListAnnotationStoreVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListAnnotationStoreVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationStoreVersions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAnnotationStoreVersionsPublisher listAnnotationStoreVersionsPaginator(
            Consumer<ListAnnotationStoreVersionsRequest.Builder> listAnnotationStoreVersionsRequest) {
        return listAnnotationStoreVersionsPaginator(ListAnnotationStoreVersionsRequest.builder()
                .applyMutation(listAnnotationStoreVersionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of annotation stores.
     * </p>
     *
     * @param listAnnotationStoresRequest
     * @return A Java Future containing the result of the ListAnnotationStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListAnnotationStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationStores" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAnnotationStoresResponse> listAnnotationStores(
            ListAnnotationStoresRequest listAnnotationStoresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of annotation stores.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnnotationStoresRequest.Builder} avoiding the
     * need to create one manually via {@link ListAnnotationStoresRequest#builder()}
     * </p>
     *
     * @param listAnnotationStoresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListAnnotationStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListAnnotationStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationStores" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListAnnotationStoresResponse> listAnnotationStores(
            Consumer<ListAnnotationStoresRequest.Builder> listAnnotationStoresRequest) {
        return listAnnotationStores(ListAnnotationStoresRequest.builder().applyMutation(listAnnotationStoresRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnnotationStores(software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListAnnotationStoresPublisher publisher = client.listAnnotationStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListAnnotationStoresPublisher publisher = client.listAnnotationStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListAnnotationStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListAnnotationStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnnotationStores(software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAnnotationStoresRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListAnnotationStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationStores" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAnnotationStoresPublisher listAnnotationStoresPaginator(ListAnnotationStoresRequest listAnnotationStoresRequest) {
        return new ListAnnotationStoresPublisher(this, listAnnotationStoresRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAnnotationStores(software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListAnnotationStoresPublisher publisher = client.listAnnotationStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListAnnotationStoresPublisher publisher = client.listAnnotationStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListAnnotationStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListAnnotationStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnnotationStores(software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAnnotationStoresRequest.Builder} avoiding the
     * need to create one manually via {@link ListAnnotationStoresRequest#builder()}
     * </p>
     *
     * @param listAnnotationStoresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListAnnotationStoresRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListAnnotationStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListAnnotationStores" target="_top">AWS
     *      API Documentation</a>
     */
    default ListAnnotationStoresPublisher listAnnotationStoresPaginator(
            Consumer<ListAnnotationStoresRequest.Builder> listAnnotationStoresRequest) {
        return listAnnotationStoresPaginator(ListAnnotationStoresRequest.builder().applyMutation(listAnnotationStoresRequest)
                .build());
    }

    /**
     * <p>
     * Lists in-progress multipart read set uploads for a sequence store and returns it in a JSON formatted output.
     * Multipart read set uploads are initiated by the <code>CreateMultipartReadSetUploads</code> API operation. This
     * operation returns a response with no body when the upload is complete.
     * </p>
     *
     * @param listMultipartReadSetUploadsRequest
     * @return A Java Future containing the result of the ListMultipartReadSetUploads operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListMultipartReadSetUploads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListMultipartReadSetUploads"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMultipartReadSetUploadsResponse> listMultipartReadSetUploads(
            ListMultipartReadSetUploadsRequest listMultipartReadSetUploadsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists in-progress multipart read set uploads for a sequence store and returns it in a JSON formatted output.
     * Multipart read set uploads are initiated by the <code>CreateMultipartReadSetUploads</code> API operation. This
     * operation returns a response with no body when the upload is complete.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultipartReadSetUploadsRequest.Builder}
     * avoiding the need to create one manually via {@link ListMultipartReadSetUploadsRequest#builder()}
     * </p>
     *
     * @param listMultipartReadSetUploadsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListMultipartReadSetUploads operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListMultipartReadSetUploads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListMultipartReadSetUploads"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListMultipartReadSetUploadsResponse> listMultipartReadSetUploads(
            Consumer<ListMultipartReadSetUploadsRequest.Builder> listMultipartReadSetUploadsRequest) {
        return listMultipartReadSetUploads(ListMultipartReadSetUploadsRequest.builder()
                .applyMutation(listMultipartReadSetUploadsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMultipartReadSetUploads(software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListMultipartReadSetUploadsPublisher publisher = client.listMultipartReadSetUploadsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListMultipartReadSetUploadsPublisher publisher = client.listMultipartReadSetUploadsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultipartReadSetUploads(software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listMultipartReadSetUploadsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListMultipartReadSetUploads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListMultipartReadSetUploads"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMultipartReadSetUploadsPublisher listMultipartReadSetUploadsPaginator(
            ListMultipartReadSetUploadsRequest listMultipartReadSetUploadsRequest) {
        return new ListMultipartReadSetUploadsPublisher(this, listMultipartReadSetUploadsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listMultipartReadSetUploads(software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListMultipartReadSetUploadsPublisher publisher = client.listMultipartReadSetUploadsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListMultipartReadSetUploadsPublisher publisher = client.listMultipartReadSetUploadsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listMultipartReadSetUploads(software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListMultipartReadSetUploadsRequest.Builder}
     * avoiding the need to create one manually via {@link ListMultipartReadSetUploadsRequest#builder()}
     * </p>
     *
     * @param listMultipartReadSetUploadsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListMultipartReadSetUploadsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListMultipartReadSetUploads
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListMultipartReadSetUploads"
     *      target="_top">AWS API Documentation</a>
     */
    default ListMultipartReadSetUploadsPublisher listMultipartReadSetUploadsPaginator(
            Consumer<ListMultipartReadSetUploadsRequest.Builder> listMultipartReadSetUploadsRequest) {
        return listMultipartReadSetUploadsPaginator(ListMultipartReadSetUploadsRequest.builder()
                .applyMutation(listMultipartReadSetUploadsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of read set activation jobs and returns the metadata in a JSON formatted output. To extract
     * metadata from a read set activation job, use the <code>GetReadSetActivationJob</code> API operation.
     * </p>
     *
     * @param listReadSetActivationJobsRequest
     * @return A Java Future containing the result of the ListReadSetActivationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetActivationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetActivationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReadSetActivationJobsResponse> listReadSetActivationJobs(
            ListReadSetActivationJobsRequest listReadSetActivationJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of read set activation jobs and returns the metadata in a JSON formatted output. To extract
     * metadata from a read set activation job, use the <code>GetReadSetActivationJob</code> API operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReadSetActivationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListReadSetActivationJobsRequest#builder()}
     * </p>
     *
     * @param listReadSetActivationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListReadSetActivationJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetActivationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetActivationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListReadSetActivationJobsResponse> listReadSetActivationJobs(
            Consumer<ListReadSetActivationJobsRequest.Builder> listReadSetActivationJobsRequest) {
        return listReadSetActivationJobs(ListReadSetActivationJobsRequest.builder()
                .applyMutation(listReadSetActivationJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReadSetActivationJobs(software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetActivationJobsPublisher publisher = client.listReadSetActivationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetActivationJobsPublisher publisher = client.listReadSetActivationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReadSetActivationJobs(software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReadSetActivationJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetActivationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetActivationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReadSetActivationJobsPublisher listReadSetActivationJobsPaginator(
            ListReadSetActivationJobsRequest listReadSetActivationJobsRequest) {
        return new ListReadSetActivationJobsPublisher(this, listReadSetActivationJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReadSetActivationJobs(software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetActivationJobsPublisher publisher = client.listReadSetActivationJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetActivationJobsPublisher publisher = client.listReadSetActivationJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReadSetActivationJobs(software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReadSetActivationJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListReadSetActivationJobsRequest#builder()}
     * </p>
     *
     * @param listReadSetActivationJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListReadSetActivationJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetActivationJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetActivationJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListReadSetActivationJobsPublisher listReadSetActivationJobsPaginator(
            Consumer<ListReadSetActivationJobsRequest.Builder> listReadSetActivationJobsRequest) {
        return listReadSetActivationJobsPaginator(ListReadSetActivationJobsRequest.builder()
                .applyMutation(listReadSetActivationJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of read set export jobs in a JSON formatted response. This API operation is used to check the
     * status of a read set export job initiated by the <code>StartReadSetExportJob</code> API operation.
     * </p>
     *
     * @param listReadSetExportJobsRequest
     * @return A Java Future containing the result of the ListReadSetExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListReadSetExportJobsResponse> listReadSetExportJobs(
            ListReadSetExportJobsRequest listReadSetExportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of read set export jobs in a JSON formatted response. This API operation is used to check the
     * status of a read set export job initiated by the <code>StartReadSetExportJob</code> API operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReadSetExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListReadSetExportJobsRequest#builder()}
     * </p>
     *
     * @param listReadSetExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListReadSetExportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListReadSetExportJobsResponse> listReadSetExportJobs(
            Consumer<ListReadSetExportJobsRequest.Builder> listReadSetExportJobsRequest) {
        return listReadSetExportJobs(ListReadSetExportJobsRequest.builder().applyMutation(listReadSetExportJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReadSetExportJobs(software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetExportJobsPublisher publisher = client.listReadSetExportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetExportJobsPublisher publisher = client.listReadSetExportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReadSetExportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReadSetExportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReadSetExportJobs(software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReadSetExportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReadSetExportJobsPublisher listReadSetExportJobsPaginator(
            ListReadSetExportJobsRequest listReadSetExportJobsRequest) {
        return new ListReadSetExportJobsPublisher(this, listReadSetExportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReadSetExportJobs(software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetExportJobsPublisher publisher = client.listReadSetExportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetExportJobsPublisher publisher = client.listReadSetExportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReadSetExportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReadSetExportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReadSetExportJobs(software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReadSetExportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListReadSetExportJobsRequest#builder()}
     * </p>
     *
     * @param listReadSetExportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListReadSetExportJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetExportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetExportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReadSetExportJobsPublisher listReadSetExportJobsPaginator(
            Consumer<ListReadSetExportJobsRequest.Builder> listReadSetExportJobsRequest) {
        return listReadSetExportJobsPaginator(ListReadSetExportJobsRequest.builder().applyMutation(listReadSetExportJobsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of read set import jobs and returns the data in JSON format.
     * </p>
     *
     * @param listReadSetImportJobsRequest
     * @return A Java Future containing the result of the ListReadSetImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListReadSetImportJobsResponse> listReadSetImportJobs(
            ListReadSetImportJobsRequest listReadSetImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of read set import jobs and returns the data in JSON format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReadSetImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListReadSetImportJobsRequest#builder()}
     * </p>
     *
     * @param listReadSetImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListReadSetImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListReadSetImportJobsResponse> listReadSetImportJobs(
            Consumer<ListReadSetImportJobsRequest.Builder> listReadSetImportJobsRequest) {
        return listReadSetImportJobs(ListReadSetImportJobsRequest.builder().applyMutation(listReadSetImportJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReadSetImportJobs(software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetImportJobsPublisher publisher = client.listReadSetImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetImportJobsPublisher publisher = client.listReadSetImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReadSetImportJobs(software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReadSetImportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReadSetImportJobsPublisher listReadSetImportJobsPaginator(
            ListReadSetImportJobsRequest listReadSetImportJobsRequest) {
        return new ListReadSetImportJobsPublisher(this, listReadSetImportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReadSetImportJobs(software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetImportJobsPublisher publisher = client.listReadSetImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetImportJobsPublisher publisher = client.listReadSetImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReadSetImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReadSetImportJobs(software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReadSetImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListReadSetImportJobsRequest#builder()}
     * </p>
     *
     * @param listReadSetImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListReadSetImportJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReadSetImportJobsPublisher listReadSetImportJobsPaginator(
            Consumer<ListReadSetImportJobsRequest.Builder> listReadSetImportJobsRequest) {
        return listReadSetImportJobsPaginator(ListReadSetImportJobsRequest.builder().applyMutation(listReadSetImportJobsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all parts in a multipart read set upload for a sequence store and returns the metadata in a JSON formatted
     * output.
     * </p>
     *
     * @param listReadSetUploadPartsRequest
     * @return A Java Future containing the result of the ListReadSetUploadParts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetUploadParts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetUploadParts" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListReadSetUploadPartsResponse> listReadSetUploadParts(
            ListReadSetUploadPartsRequest listReadSetUploadPartsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all parts in a multipart read set upload for a sequence store and returns the metadata in a JSON formatted
     * output.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReadSetUploadPartsRequest.Builder} avoiding the
     * need to create one manually via {@link ListReadSetUploadPartsRequest#builder()}
     * </p>
     *
     * @param listReadSetUploadPartsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListReadSetUploadParts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetUploadParts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetUploadParts" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListReadSetUploadPartsResponse> listReadSetUploadParts(
            Consumer<ListReadSetUploadPartsRequest.Builder> listReadSetUploadPartsRequest) {
        return listReadSetUploadParts(ListReadSetUploadPartsRequest.builder().applyMutation(listReadSetUploadPartsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReadSetUploadParts(software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetUploadPartsPublisher publisher = client.listReadSetUploadPartsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetUploadPartsPublisher publisher = client.listReadSetUploadPartsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReadSetUploadParts(software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReadSetUploadPartsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetUploadParts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetUploadParts" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReadSetUploadPartsPublisher listReadSetUploadPartsPaginator(
            ListReadSetUploadPartsRequest listReadSetUploadPartsRequest) {
        return new ListReadSetUploadPartsPublisher(this, listReadSetUploadPartsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReadSetUploadParts(software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetUploadPartsPublisher publisher = client.listReadSetUploadPartsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetUploadPartsPublisher publisher = client.listReadSetUploadPartsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReadSetUploadParts(software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReadSetUploadPartsRequest.Builder} avoiding the
     * need to create one manually via {@link ListReadSetUploadPartsRequest#builder()}
     * </p>
     *
     * @param listReadSetUploadPartsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListReadSetUploadPartsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSetUploadParts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSetUploadParts" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReadSetUploadPartsPublisher listReadSetUploadPartsPaginator(
            Consumer<ListReadSetUploadPartsRequest.Builder> listReadSetUploadPartsRequest) {
        return listReadSetUploadPartsPaginator(ListReadSetUploadPartsRequest.builder()
                .applyMutation(listReadSetUploadPartsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of read sets from a sequence store ID and returns the metadata in JSON format.
     * </p>
     *
     * @param listReadSetsRequest
     * @return A Java Future containing the result of the ListReadSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReadSetsResponse> listReadSets(ListReadSetsRequest listReadSetsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of read sets from a sequence store ID and returns the metadata in JSON format.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReadSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListReadSetsRequest#builder()}
     * </p>
     *
     * @param listReadSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListReadSetsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListReadSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSets" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReadSetsResponse> listReadSets(Consumer<ListReadSetsRequest.Builder> listReadSetsRequest) {
        return listReadSets(ListReadSetsRequest.builder().applyMutation(listReadSetsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listReadSets(software.amazon.awssdk.services.omics.model.ListReadSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetsPublisher publisher = client.listReadSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetsPublisher publisher = client.listReadSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReadSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReadSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReadSets(software.amazon.awssdk.services.omics.model.ListReadSetsRequest)} operation.</b>
     * </p>
     *
     * @param listReadSetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReadSetsPublisher listReadSetsPaginator(ListReadSetsRequest listReadSetsRequest) {
        return new ListReadSetsPublisher(this, listReadSetsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listReadSets(software.amazon.awssdk.services.omics.model.ListReadSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetsPublisher publisher = client.listReadSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReadSetsPublisher publisher = client.listReadSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReadSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReadSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReadSets(software.amazon.awssdk.services.omics.model.ListReadSetsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReadSetsRequest.Builder} avoiding the need to
     * create one manually via {@link ListReadSetsRequest#builder()}
     * </p>
     *
     * @param listReadSetsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListReadSetsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReadSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReadSets" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReadSetsPublisher listReadSetsPaginator(Consumer<ListReadSetsRequest.Builder> listReadSetsRequest) {
        return listReadSetsPaginator(ListReadSetsRequest.builder().applyMutation(listReadSetsRequest).build());
    }

    /**
     * <p>
     * Retrieves the metadata of one or more reference import jobs for a reference store.
     * </p>
     *
     * @param listReferenceImportJobsRequest
     * @return A Java Future containing the result of the ListReferenceImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferenceImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListReferenceImportJobsResponse> listReferenceImportJobs(
            ListReferenceImportJobsRequest listReferenceImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata of one or more reference import jobs for a reference store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReferenceImportJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListReferenceImportJobsRequest#builder()}
     * </p>
     *
     * @param listReferenceImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListReferenceImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferenceImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListReferenceImportJobsResponse> listReferenceImportJobs(
            Consumer<ListReferenceImportJobsRequest.Builder> listReferenceImportJobsRequest) {
        return listReferenceImportJobs(ListReferenceImportJobsRequest.builder().applyMutation(listReferenceImportJobsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReferenceImportJobs(software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferenceImportJobsPublisher publisher = client.listReferenceImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferenceImportJobsPublisher publisher = client.listReferenceImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReferenceImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReferenceImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReferenceImportJobs(software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReferenceImportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferenceImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReferenceImportJobsPublisher listReferenceImportJobsPaginator(
            ListReferenceImportJobsRequest listReferenceImportJobsRequest) {
        return new ListReferenceImportJobsPublisher(this, listReferenceImportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReferenceImportJobs(software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferenceImportJobsPublisher publisher = client.listReferenceImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferenceImportJobsPublisher publisher = client.listReferenceImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReferenceImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReferenceImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReferenceImportJobs(software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReferenceImportJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListReferenceImportJobsRequest#builder()}
     * </p>
     *
     * @param listReferenceImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListReferenceImportJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferenceImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListReferenceImportJobsPublisher listReferenceImportJobsPaginator(
            Consumer<ListReferenceImportJobsRequest.Builder> listReferenceImportJobsRequest) {
        return listReferenceImportJobsPaginator(ListReferenceImportJobsRequest.builder()
                .applyMutation(listReferenceImportJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of reference stores linked to your account and returns their metadata in JSON format.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-reference-store.html">Creating a reference store</a> in
     * the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param listReferenceStoresRequest
     * @return A Java Future containing the result of the ListReferenceStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferenceStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceStores" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReferenceStoresResponse> listReferenceStores(
            ListReferenceStoresRequest listReferenceStoresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of reference stores linked to your account and returns their metadata in JSON format.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-reference-store.html">Creating a reference store</a> in
     * the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReferenceStoresRequest.Builder} avoiding the
     * need to create one manually via {@link ListReferenceStoresRequest#builder()}
     * </p>
     *
     * @param listReferenceStoresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListReferenceStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferenceStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceStores" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReferenceStoresResponse> listReferenceStores(
            Consumer<ListReferenceStoresRequest.Builder> listReferenceStoresRequest) {
        return listReferenceStores(ListReferenceStoresRequest.builder().applyMutation(listReferenceStoresRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReferenceStores(software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferenceStoresPublisher publisher = client.listReferenceStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferenceStoresPublisher publisher = client.listReferenceStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReferenceStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReferenceStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReferenceStores(software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest)}
     * operation.</b>
     * </p>
     *
     * @param listReferenceStoresRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferenceStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceStores" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReferenceStoresPublisher listReferenceStoresPaginator(ListReferenceStoresRequest listReferenceStoresRequest) {
        return new ListReferenceStoresPublisher(this, listReferenceStoresRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listReferenceStores(software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferenceStoresPublisher publisher = client.listReferenceStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferenceStoresPublisher publisher = client.listReferenceStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReferenceStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReferenceStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReferenceStores(software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReferenceStoresRequest.Builder} avoiding the
     * need to create one manually via {@link ListReferenceStoresRequest#builder()}
     * </p>
     *
     * @param listReferenceStoresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListReferenceStoresRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferenceStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferenceStores" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReferenceStoresPublisher listReferenceStoresPaginator(
            Consumer<ListReferenceStoresRequest.Builder> listReferenceStoresRequest) {
        return listReferenceStoresPaginator(ListReferenceStoresRequest.builder().applyMutation(listReferenceStoresRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the metadata of one or more reference genomes in a reference store.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-reference-store.html">Creating a reference store</a> in
     * the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param listReferencesRequest
     * @return A Java Future containing the result of the ListReferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferences" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReferencesResponse> listReferences(ListReferencesRequest listReferencesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the metadata of one or more reference genomes in a reference store.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-reference-store.html">Creating a reference store</a> in
     * the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReferencesRequest.Builder} avoiding the need to
     * create one manually via {@link ListReferencesRequest#builder()}
     * </p>
     *
     * @param listReferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListReferencesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListReferences operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferences" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListReferencesResponse> listReferences(Consumer<ListReferencesRequest.Builder> listReferencesRequest) {
        return listReferences(ListReferencesRequest.builder().applyMutation(listReferencesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listReferences(software.amazon.awssdk.services.omics.model.ListReferencesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferencesPublisher publisher = client.listReferencesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferencesPublisher publisher = client.listReferencesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReferencesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReferencesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReferences(software.amazon.awssdk.services.omics.model.ListReferencesRequest)} operation.</b>
     * </p>
     *
     * @param listReferencesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferences" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReferencesPublisher listReferencesPaginator(ListReferencesRequest listReferencesRequest) {
        return new ListReferencesPublisher(this, listReferencesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listReferences(software.amazon.awssdk.services.omics.model.ListReferencesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferencesPublisher publisher = client.listReferencesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListReferencesPublisher publisher = client.listReferencesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListReferencesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListReferencesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listReferences(software.amazon.awssdk.services.omics.model.ListReferencesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListReferencesRequest.Builder} avoiding the need to
     * create one manually via {@link ListReferencesRequest#builder()}
     * </p>
     *
     * @param listReferencesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListReferencesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListReferences
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListReferences" target="_top">AWS API
     *      Documentation</a>
     */
    default ListReferencesPublisher listReferencesPaginator(Consumer<ListReferencesRequest.Builder> listReferencesRequest) {
        return listReferencesPaginator(ListReferencesRequest.builder().applyMutation(listReferencesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of your run caches and the metadata for each cache.
     * </p>
     *
     * @param listRunCachesRequest
     * @return A Java Future containing the result of the ListRunCaches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRunCaches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunCaches" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRunCachesResponse> listRunCaches(ListRunCachesRequest listRunCachesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of your run caches and the metadata for each cache.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRunCachesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRunCachesRequest#builder()}
     * </p>
     *
     * @param listRunCachesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListRunCachesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRunCaches operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRunCaches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunCaches" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRunCachesResponse> listRunCaches(Consumer<ListRunCachesRequest.Builder> listRunCachesRequest) {
        return listRunCaches(ListRunCachesRequest.builder().applyMutation(listRunCachesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listRunCaches(software.amazon.awssdk.services.omics.model.ListRunCachesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunCachesPublisher publisher = client.listRunCachesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunCachesPublisher publisher = client.listRunCachesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListRunCachesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListRunCachesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRunCaches(software.amazon.awssdk.services.omics.model.ListRunCachesRequest)} operation.</b>
     * </p>
     *
     * @param listRunCachesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRunCaches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunCaches" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRunCachesPublisher listRunCachesPaginator(ListRunCachesRequest listRunCachesRequest) {
        return new ListRunCachesPublisher(this, listRunCachesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listRunCaches(software.amazon.awssdk.services.omics.model.ListRunCachesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunCachesPublisher publisher = client.listRunCachesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunCachesPublisher publisher = client.listRunCachesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListRunCachesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListRunCachesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRunCaches(software.amazon.awssdk.services.omics.model.ListRunCachesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRunCachesRequest.Builder} avoiding the need to
     * create one manually via {@link ListRunCachesRequest#builder()}
     * </p>
     *
     * @param listRunCachesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListRunCachesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRunCaches
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunCaches" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRunCachesPublisher listRunCachesPaginator(Consumer<ListRunCachesRequest.Builder> listRunCachesRequest) {
        return listRunCachesPaginator(ListRunCachesRequest.builder().applyMutation(listRunCachesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of all run groups and returns the metadata for each run group.
     * </p>
     *
     * @param listRunGroupsRequest
     * @return A Java Future containing the result of the ListRunGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRunGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRunGroupsResponse> listRunGroups(ListRunGroupsRequest listRunGroupsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all run groups and returns the metadata for each run group.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRunGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRunGroupsRequest#builder()}
     * </p>
     *
     * @param listRunGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListRunGroupsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRunGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRunGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRunGroupsResponse> listRunGroups(Consumer<ListRunGroupsRequest.Builder> listRunGroupsRequest) {
        return listRunGroups(ListRunGroupsRequest.builder().applyMutation(listRunGroupsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listRunGroups(software.amazon.awssdk.services.omics.model.ListRunGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunGroupsPublisher publisher = client.listRunGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunGroupsPublisher publisher = client.listRunGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListRunGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListRunGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRunGroups(software.amazon.awssdk.services.omics.model.ListRunGroupsRequest)} operation.</b>
     * </p>
     *
     * @param listRunGroupsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRunGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRunGroupsPublisher listRunGroupsPaginator(ListRunGroupsRequest listRunGroupsRequest) {
        return new ListRunGroupsPublisher(this, listRunGroupsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listRunGroups(software.amazon.awssdk.services.omics.model.ListRunGroupsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunGroupsPublisher publisher = client.listRunGroupsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunGroupsPublisher publisher = client.listRunGroupsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListRunGroupsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListRunGroupsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRunGroups(software.amazon.awssdk.services.omics.model.ListRunGroupsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRunGroupsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRunGroupsRequest#builder()}
     * </p>
     *
     * @param listRunGroupsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListRunGroupsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRunGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunGroups" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRunGroupsPublisher listRunGroupsPaginator(Consumer<ListRunGroupsRequest.Builder> listRunGroupsRequest) {
        return listRunGroupsPaginator(ListRunGroupsRequest.builder().applyMutation(listRunGroupsRequest).build());
    }

    /**
     * <p>
     * Returns a list of tasks and status information within their specified run. Use this operation to monitor runs and
     * to identify which specific tasks have failed.
     * </p>
     *
     * @param listRunTasksRequest
     * @return A Java Future containing the result of the ListRunTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRunTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRunTasksResponse> listRunTasks(ListRunTasksRequest listRunTasksRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tasks and status information within their specified run. Use this operation to monitor runs and
     * to identify which specific tasks have failed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRunTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListRunTasksRequest#builder()}
     * </p>
     *
     * @param listRunTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListRunTasksRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRunTasks operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRunTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRunTasksResponse> listRunTasks(Consumer<ListRunTasksRequest.Builder> listRunTasksRequest) {
        return listRunTasks(ListRunTasksRequest.builder().applyMutation(listRunTasksRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listRunTasks(software.amazon.awssdk.services.omics.model.ListRunTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunTasksPublisher publisher = client.listRunTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunTasksPublisher publisher = client.listRunTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListRunTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListRunTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRunTasks(software.amazon.awssdk.services.omics.model.ListRunTasksRequest)} operation.</b>
     * </p>
     *
     * @param listRunTasksRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRunTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRunTasksPublisher listRunTasksPaginator(ListRunTasksRequest listRunTasksRequest) {
        return new ListRunTasksPublisher(this, listRunTasksRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listRunTasks(software.amazon.awssdk.services.omics.model.ListRunTasksRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunTasksPublisher publisher = client.listRunTasksPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunTasksPublisher publisher = client.listRunTasksPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListRunTasksResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListRunTasksResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRunTasks(software.amazon.awssdk.services.omics.model.ListRunTasksRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRunTasksRequest.Builder} avoiding the need to
     * create one manually via {@link ListRunTasksRequest#builder()}
     * </p>
     *
     * @param listRunTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListRunTasksRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRunTasks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRunTasks" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRunTasksPublisher listRunTasksPaginator(Consumer<ListRunTasksRequest.Builder> listRunTasksRequest) {
        return listRunTasksPaginator(ListRunTasksRequest.builder().applyMutation(listRunTasksRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of runs and returns each run's metadata and status.
     * </p>
     * <p>
     * Amazon Web Services HealthOmics stores a configurable number of runs, as determined by service limits, that are
     * available to the console and API. If the <code>ListRuns</code> response doesn't include specific runs that you
     * expected, you can find all run logs in the CloudWatch logs. For more information about viewing the run logs, see
     * <a href="https://docs.aws.amazon.com/omics/latest/dev/monitoring-cloudwatch-logs.html">CloudWatch logs</a> in the
     * <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param listRunsRequest
     * @return A Java Future containing the result of the ListRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRunsResponse> listRuns(ListRunsRequest listRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of runs and returns each run's metadata and status.
     * </p>
     * <p>
     * Amazon Web Services HealthOmics stores a configurable number of runs, as determined by service limits, that are
     * available to the console and API. If the <code>ListRuns</code> response doesn't include specific runs that you
     * expected, you can find all run logs in the CloudWatch logs. For more information about viewing the run logs, see
     * <a href="https://docs.aws.amazon.com/omics/latest/dev/monitoring-cloudwatch-logs.html">CloudWatch logs</a> in the
     * <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRunsRequest#builder()}
     * </p>
     *
     * @param listRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListRunsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListRunsResponse> listRuns(Consumer<ListRunsRequest.Builder> listRunsRequest) {
        return listRuns(ListRunsRequest.builder().applyMutation(listRunsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listRuns(software.amazon.awssdk.services.omics.model.ListRunsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunsPublisher publisher = client.listRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunsPublisher publisher = client.listRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuns(software.amazon.awssdk.services.omics.model.ListRunsRequest)} operation.</b>
     * </p>
     *
     * @param listRunsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRunsPublisher listRunsPaginator(ListRunsRequest listRunsRequest) {
        return new ListRunsPublisher(this, listRunsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listRuns(software.amazon.awssdk.services.omics.model.ListRunsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunsPublisher publisher = client.listRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListRunsPublisher publisher = client.listRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listRuns(software.amazon.awssdk.services.omics.model.ListRunsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListRunsRequest#builder()}
     * </p>
     *
     * @param listRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListRunsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListRunsPublisher listRunsPaginator(Consumer<ListRunsRequest.Builder> listRunsRequest) {
        return listRunsPaginator(ListRunsRequest.builder().applyMutation(listRunsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of sequence stores and returns each sequence store's metadata.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-sequence-store.html">Creating a HealthOmics sequence
     * store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param listSequenceStoresRequest
     * @return A Java Future containing the result of the ListSequenceStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListSequenceStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListSequenceStores" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSequenceStoresResponse> listSequenceStores(ListSequenceStoresRequest listSequenceStoresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of sequence stores and returns each sequence store's metadata.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/create-sequence-store.html">Creating a HealthOmics sequence
     * store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSequenceStoresRequest.Builder} avoiding the
     * need to create one manually via {@link ListSequenceStoresRequest#builder()}
     * </p>
     *
     * @param listSequenceStoresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListSequenceStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListSequenceStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListSequenceStores" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSequenceStoresResponse> listSequenceStores(
            Consumer<ListSequenceStoresRequest.Builder> listSequenceStoresRequest) {
        return listSequenceStores(ListSequenceStoresRequest.builder().applyMutation(listSequenceStoresRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSequenceStores(software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListSequenceStoresPublisher publisher = client.listSequenceStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListSequenceStoresPublisher publisher = client.listSequenceStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListSequenceStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListSequenceStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSequenceStores(software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest)} operation.</b>
     * </p>
     *
     * @param listSequenceStoresRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListSequenceStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListSequenceStores" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSequenceStoresPublisher listSequenceStoresPaginator(ListSequenceStoresRequest listSequenceStoresRequest) {
        return new ListSequenceStoresPublisher(this, listSequenceStoresRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSequenceStores(software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListSequenceStoresPublisher publisher = client.listSequenceStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListSequenceStoresPublisher publisher = client.listSequenceStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListSequenceStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListSequenceStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSequenceStores(software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSequenceStoresRequest.Builder} avoiding the
     * need to create one manually via {@link ListSequenceStoresRequest#builder()}
     * </p>
     *
     * @param listSequenceStoresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListSequenceStoresRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListSequenceStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListSequenceStores" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSequenceStoresPublisher listSequenceStoresPaginator(
            Consumer<ListSequenceStoresRequest.Builder> listSequenceStoresRequest) {
        return listSequenceStoresPaginator(ListSequenceStoresRequest.builder().applyMutation(listSequenceStoresRequest).build());
    }

    /**
     * <p>
     * Retrieves the resource shares associated with an account. Use the filter parameter to retrieve a specific subset
     * of the shares.
     * </p>
     *
     * @param listSharesRequest
     * @return A Java Future containing the result of the ListShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListShares" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSharesResponse> listShares(ListSharesRequest listSharesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the resource shares associated with an account. Use the filter parameter to retrieve a specific subset
     * of the shares.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSharesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSharesRequest#builder()}
     * </p>
     *
     * @param listSharesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListSharesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListShares operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListShares" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListSharesResponse> listShares(Consumer<ListSharesRequest.Builder> listSharesRequest) {
        return listShares(ListSharesRequest.builder().applyMutation(listSharesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listShares(software.amazon.awssdk.services.omics.model.ListSharesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListSharesPublisher publisher = client.listSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListSharesPublisher publisher = client.listSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listShares(software.amazon.awssdk.services.omics.model.ListSharesRequest)} operation.</b>
     * </p>
     *
     * @param listSharesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListShares" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSharesPublisher listSharesPaginator(ListSharesRequest listSharesRequest) {
        return new ListSharesPublisher(this, listSharesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listShares(software.amazon.awssdk.services.omics.model.ListSharesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListSharesPublisher publisher = client.listSharesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListSharesPublisher publisher = client.listSharesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListSharesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListSharesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listShares(software.amazon.awssdk.services.omics.model.ListSharesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSharesRequest.Builder} avoiding the need to
     * create one manually via {@link ListSharesRequest#builder()}
     * </p>
     *
     * @param listSharesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListSharesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListShares
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListShares" target="_top">AWS API
     *      Documentation</a>
     */
    default ListSharesPublisher listSharesPaginator(Consumer<ListSharesRequest.Builder> listSharesRequest) {
        return listSharesPaginator(ListSharesRequest.builder().applyMutation(listSharesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of variant import jobs.
     * </p>
     *
     * @param listVariantImportJobsRequest
     * @return A Java Future containing the result of the ListVariantImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListVariantImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVariantImportJobsResponse> listVariantImportJobs(
            ListVariantImportJobsRequest listVariantImportJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of variant import jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVariantImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListVariantImportJobsRequest#builder()}
     * </p>
     *
     * @param listVariantImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListVariantImportJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListVariantImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListVariantImportJobsResponse> listVariantImportJobs(
            Consumer<ListVariantImportJobsRequest.Builder> listVariantImportJobsRequest) {
        return listVariantImportJobs(ListVariantImportJobsRequest.builder().applyMutation(listVariantImportJobsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVariantImportJobs(software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListVariantImportJobsPublisher publisher = client.listVariantImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListVariantImportJobsPublisher publisher = client.listVariantImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListVariantImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListVariantImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVariantImportJobs(software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVariantImportJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListVariantImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVariantImportJobsPublisher listVariantImportJobsPaginator(
            ListVariantImportJobsRequest listVariantImportJobsRequest) {
        return new ListVariantImportJobsPublisher(this, listVariantImportJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVariantImportJobs(software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListVariantImportJobsPublisher publisher = client.listVariantImportJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListVariantImportJobsPublisher publisher = client.listVariantImportJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListVariantImportJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListVariantImportJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVariantImportJobs(software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVariantImportJobsRequest.Builder} avoiding the
     * need to create one manually via {@link ListVariantImportJobsRequest#builder()}
     * </p>
     *
     * @param listVariantImportJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListVariantImportJobsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListVariantImportJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantImportJobs" target="_top">AWS
     *      API Documentation</a>
     */
    default ListVariantImportJobsPublisher listVariantImportJobsPaginator(
            Consumer<ListVariantImportJobsRequest.Builder> listVariantImportJobsRequest) {
        return listVariantImportJobsPaginator(ListVariantImportJobsRequest.builder().applyMutation(listVariantImportJobsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of variant stores.
     * </p>
     *
     * @param listVariantStoresRequest
     * @return A Java Future containing the result of the ListVariantStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListVariantStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantStores" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListVariantStoresResponse> listVariantStores(ListVariantStoresRequest listVariantStoresRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of variant stores.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVariantStoresRequest.Builder} avoiding the need
     * to create one manually via {@link ListVariantStoresRequest#builder()}
     * </p>
     *
     * @param listVariantStoresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListVariantStoresRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListVariantStores operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListVariantStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantStores" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListVariantStoresResponse> listVariantStores(
            Consumer<ListVariantStoresRequest.Builder> listVariantStoresRequest) {
        return listVariantStores(ListVariantStoresRequest.builder().applyMutation(listVariantStoresRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVariantStores(software.amazon.awssdk.services.omics.model.ListVariantStoresRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListVariantStoresPublisher publisher = client.listVariantStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListVariantStoresPublisher publisher = client.listVariantStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListVariantStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListVariantStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVariantStores(software.amazon.awssdk.services.omics.model.ListVariantStoresRequest)} operation.</b>
     * </p>
     *
     * @param listVariantStoresRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListVariantStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantStores" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVariantStoresPublisher listVariantStoresPaginator(ListVariantStoresRequest listVariantStoresRequest) {
        return new ListVariantStoresPublisher(this, listVariantStoresRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVariantStores(software.amazon.awssdk.services.omics.model.ListVariantStoresRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListVariantStoresPublisher publisher = client.listVariantStoresPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListVariantStoresPublisher publisher = client.listVariantStoresPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListVariantStoresResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListVariantStoresResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVariantStores(software.amazon.awssdk.services.omics.model.ListVariantStoresRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVariantStoresRequest.Builder} avoiding the need
     * to create one manually via {@link ListVariantStoresRequest#builder()}
     * </p>
     *
     * @param listVariantStoresRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListVariantStoresRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListVariantStores
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListVariantStores" target="_top">AWS API
     *      Documentation</a>
     */
    default ListVariantStoresPublisher listVariantStoresPaginator(
            Consumer<ListVariantStoresRequest.Builder> listVariantStoresRequest) {
        return listVariantStoresPaginator(ListVariantStoresRequest.builder().applyMutation(listVariantStoresRequest).build());
    }

    /**
     * <p>
     * Lists the workflow versions for the specified workflow. For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html">Workflow versioning in Amazon Web
     * Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param listWorkflowVersionsRequest
     * @return A Java Future containing the result of the ListWorkflowVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListWorkflowVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListWorkflowVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListWorkflowVersionsResponse> listWorkflowVersions(
            ListWorkflowVersionsRequest listWorkflowVersionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the workflow versions for the specified workflow. For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html">Workflow versioning in Amazon Web
     * Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkflowVersionsRequest#builder()}
     * </p>
     *
     * @param listWorkflowVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListWorkflowVersionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListWorkflowVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListWorkflowVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListWorkflowVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListWorkflowVersionsResponse> listWorkflowVersions(
            Consumer<ListWorkflowVersionsRequest.Builder> listWorkflowVersionsRequest) {
        return listWorkflowVersions(ListWorkflowVersionsRequest.builder().applyMutation(listWorkflowVersionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkflowVersions(software.amazon.awssdk.services.omics.model.ListWorkflowVersionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListWorkflowVersionsPublisher publisher = client.listWorkflowVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListWorkflowVersionsPublisher publisher = client.listWorkflowVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListWorkflowVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListWorkflowVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflowVersions(software.amazon.awssdk.services.omics.model.ListWorkflowVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listWorkflowVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListWorkflowVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListWorkflowVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorkflowVersionsPublisher listWorkflowVersionsPaginator(ListWorkflowVersionsRequest listWorkflowVersionsRequest) {
        return new ListWorkflowVersionsPublisher(this, listWorkflowVersionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listWorkflowVersions(software.amazon.awssdk.services.omics.model.ListWorkflowVersionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListWorkflowVersionsPublisher publisher = client.listWorkflowVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListWorkflowVersionsPublisher publisher = client.listWorkflowVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListWorkflowVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListWorkflowVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflowVersions(software.amazon.awssdk.services.omics.model.ListWorkflowVersionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowVersionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListWorkflowVersionsRequest#builder()}
     * </p>
     *
     * @param listWorkflowVersionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListWorkflowVersionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListWorkflowVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListWorkflowVersions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListWorkflowVersionsPublisher listWorkflowVersionsPaginator(
            Consumer<ListWorkflowVersionsRequest.Builder> listWorkflowVersionsRequest) {
        return listWorkflowVersionsPaginator(ListWorkflowVersionsRequest.builder().applyMutation(listWorkflowVersionsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of existing workflows. You can filter for specific workflows by their name and type. Using the
     * type parameter, specify <code>PRIVATE</code> to retrieve a list of private workflows or specify
     * <code>READY2RUN</code> for a list of all Ready2Run workflows. If you do not specify the type of workflow, this
     * operation returns a list of existing workflows.
     * </p>
     *
     * @param listWorkflowsRequest
     * @return A Java Future containing the result of the ListWorkflows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWorkflowsResponse> listWorkflows(ListWorkflowsRequest listWorkflowsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of existing workflows. You can filter for specific workflows by their name and type. Using the
     * type parameter, specify <code>PRIVATE</code> to retrieve a list of private workflows or specify
     * <code>READY2RUN</code> for a list of all Ready2Run workflows. If you do not specify the type of workflow, this
     * operation returns a list of existing workflows.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkflowsRequest#builder()}
     * </p>
     *
     * @param listWorkflowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListWorkflowsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListWorkflows operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWorkflowsResponse> listWorkflows(Consumer<ListWorkflowsRequest.Builder> listWorkflowsRequest) {
        return listWorkflows(ListWorkflowsRequest.builder().applyMutation(listWorkflowsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listWorkflows(software.amazon.awssdk.services.omics.model.ListWorkflowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListWorkflowsPublisher publisher = client.listWorkflowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListWorkflowsPublisher publisher = client.listWorkflowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListWorkflowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListWorkflowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflows(software.amazon.awssdk.services.omics.model.ListWorkflowsRequest)} operation.</b>
     * </p>
     *
     * @param listWorkflowsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkflowsPublisher listWorkflowsPaginator(ListWorkflowsRequest listWorkflowsRequest) {
        return new ListWorkflowsPublisher(this, listWorkflowsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listWorkflows(software.amazon.awssdk.services.omics.model.ListWorkflowsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListWorkflowsPublisher publisher = client.listWorkflowsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.omics.paginators.ListWorkflowsPublisher publisher = client.listWorkflowsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.omics.model.ListWorkflowsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.omics.model.ListWorkflowsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWorkflows(software.amazon.awssdk.services.omics.model.ListWorkflowsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWorkflowsRequest.Builder} avoiding the need to
     * create one manually via {@link ListWorkflowsRequest#builder()}
     * </p>
     *
     * @param listWorkflowsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.ListWorkflowsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.ListWorkflows
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/ListWorkflows" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWorkflowsPublisher listWorkflowsPaginator(Consumer<ListWorkflowsRequest.Builder> listWorkflowsRequest) {
        return listWorkflowsPaginator(ListWorkflowsRequest.builder().applyMutation(listWorkflowsRequest).build());
    }

    /**
     * <p>
     * Adds an access policy to the specified store.
     * </p>
     *
     * @param putS3AccessPolicyRequest
     * @return A Java Future containing the result of the PutS3AccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.PutS3AccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/PutS3AccessPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutS3AccessPolicyResponse> putS3AccessPolicy(PutS3AccessPolicyRequest putS3AccessPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds an access policy to the specified store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutS3AccessPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link PutS3AccessPolicyRequest#builder()}
     * </p>
     *
     * @param putS3AccessPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.PutS3AccessPolicyRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutS3AccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.PutS3AccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/PutS3AccessPolicy" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutS3AccessPolicyResponse> putS3AccessPolicy(
            Consumer<PutS3AccessPolicyRequest.Builder> putS3AccessPolicyRequest) {
        return putS3AccessPolicy(PutS3AccessPolicyRequest.builder().applyMutation(putS3AccessPolicyRequest).build());
    }

    /**
     * <p>
     * Starts an annotation import job.
     * </p>
     *
     * @param startAnnotationImportJobRequest
     * @return A Java Future containing the result of the StartAnnotationImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartAnnotationImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartAnnotationImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAnnotationImportJobResponse> startAnnotationImportJob(
            StartAnnotationImportJobRequest startAnnotationImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts an annotation import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartAnnotationImportJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartAnnotationImportJobRequest#builder()}
     * </p>
     *
     * @param startAnnotationImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.StartAnnotationImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartAnnotationImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartAnnotationImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartAnnotationImportJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartAnnotationImportJobResponse> startAnnotationImportJob(
            Consumer<StartAnnotationImportJobRequest.Builder> startAnnotationImportJobRequest) {
        return startAnnotationImportJob(StartAnnotationImportJobRequest.builder().applyMutation(startAnnotationImportJobRequest)
                .build());
    }

    /**
     * <p>
     * Activates an archived read set and returns its metadata in a JSON formatted output. AWS HealthOmics automatically
     * archives unused read sets after 30 days. To monitor the status of your read set activation job, use the
     * <code>GetReadSetActivationJob</code> operation.
     * </p>
     * <p>
     * To learn more, see <a href="https://docs.aws.amazon.com/omics/latest/dev/activating-read-sets.html">Activating
     * read sets</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param startReadSetActivationJobRequest
     * @return A Java Future containing the result of the StartReadSetActivationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartReadSetActivationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetActivationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartReadSetActivationJobResponse> startReadSetActivationJob(
            StartReadSetActivationJobRequest startReadSetActivationJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Activates an archived read set and returns its metadata in a JSON formatted output. AWS HealthOmics automatically
     * archives unused read sets after 30 days. To monitor the status of your read set activation job, use the
     * <code>GetReadSetActivationJob</code> operation.
     * </p>
     * <p>
     * To learn more, see <a href="https://docs.aws.amazon.com/omics/latest/dev/activating-read-sets.html">Activating
     * read sets</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReadSetActivationJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartReadSetActivationJobRequest#builder()}
     * </p>
     *
     * @param startReadSetActivationJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.StartReadSetActivationJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartReadSetActivationJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartReadSetActivationJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetActivationJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<StartReadSetActivationJobResponse> startReadSetActivationJob(
            Consumer<StartReadSetActivationJobRequest.Builder> startReadSetActivationJobRequest) {
        return startReadSetActivationJob(StartReadSetActivationJobRequest.builder()
                .applyMutation(startReadSetActivationJobRequest).build());
    }

    /**
     * <p>
     * Starts a read set export job. When the export job is finished, the read set is exported to an Amazon S3 bucket
     * which can be retrieved using the <code>GetReadSetExportJob</code> API operation.
     * </p>
     * <p>
     * To monitor the status of the export job, use the <code>ListReadSetExportJobs</code> API operation.
     * </p>
     *
     * @param startReadSetExportJobRequest
     * @return A Java Future containing the result of the StartReadSetExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartReadSetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetExportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartReadSetExportJobResponse> startReadSetExportJob(
            StartReadSetExportJobRequest startReadSetExportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a read set export job. When the export job is finished, the read set is exported to an Amazon S3 bucket
     * which can be retrieved using the <code>GetReadSetExportJob</code> API operation.
     * </p>
     * <p>
     * To monitor the status of the export job, use the <code>ListReadSetExportJobs</code> API operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReadSetExportJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartReadSetExportJobRequest#builder()}
     * </p>
     *
     * @param startReadSetExportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.StartReadSetExportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartReadSetExportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartReadSetExportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetExportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartReadSetExportJobResponse> startReadSetExportJob(
            Consumer<StartReadSetExportJobRequest.Builder> startReadSetExportJobRequest) {
        return startReadSetExportJob(StartReadSetExportJobRequest.builder().applyMutation(startReadSetExportJobRequest).build());
    }

    /**
     * <p>
     * Imports a read set from the sequence store. Read set import jobs support a maximum of 100 read sets of different
     * types. Monitor the progress of your read set import job by calling the <code>GetReadSetImportJob</code> API
     * operation.
     * </p>
     *
     * @param startReadSetImportJobRequest
     * @return A Java Future containing the result of the StartReadSetImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartReadSetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartReadSetImportJobResponse> startReadSetImportJob(
            StartReadSetImportJobRequest startReadSetImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports a read set from the sequence store. Read set import jobs support a maximum of 100 read sets of different
     * types. Monitor the progress of your read set import job by calling the <code>GetReadSetImportJob</code> API
     * operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReadSetImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartReadSetImportJobRequest#builder()}
     * </p>
     *
     * @param startReadSetImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.StartReadSetImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartReadSetImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartReadSetImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReadSetImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartReadSetImportJobResponse> startReadSetImportJob(
            Consumer<StartReadSetImportJobRequest.Builder> startReadSetImportJobRequest) {
        return startReadSetImportJob(StartReadSetImportJobRequest.builder().applyMutation(startReadSetImportJobRequest).build());
    }

    /**
     * <p>
     * Imports a reference genome from Amazon S3 into a specified reference store. You can have multiple reference
     * genomes in a reference store. You can only import reference genomes one at a time into each reference store.
     * Monitor the status of your reference import job by using the <code>GetReferenceImportJob</code> API operation.
     * </p>
     *
     * @param startReferenceImportJobRequest
     * @return A Java Future containing the result of the StartReferenceImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartReferenceImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReferenceImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartReferenceImportJobResponse> startReferenceImportJob(
            StartReferenceImportJobRequest startReferenceImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Imports a reference genome from Amazon S3 into a specified reference store. You can have multiple reference
     * genomes in a reference store. You can only import reference genomes one at a time into each reference store.
     * Monitor the status of your reference import job by using the <code>GetReferenceImportJob</code> API operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReferenceImportJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartReferenceImportJobRequest#builder()}
     * </p>
     *
     * @param startReferenceImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.StartReferenceImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartReferenceImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartReferenceImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartReferenceImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartReferenceImportJobResponse> startReferenceImportJob(
            Consumer<StartReferenceImportJobRequest.Builder> startReferenceImportJobRequest) {
        return startReferenceImportJob(StartReferenceImportJobRequest.builder().applyMutation(startReferenceImportJobRequest)
                .build());
    }

    /**
     * <p>
     * Starts a new run and returns details about the run, or duplicates an existing run. A run is a single invocation
     * of a workflow. If you provide request IDs, Amazon Web Services HealthOmics identifies duplicate requests and
     * starts the run only once. Monitor the progress of the run by calling the <code>GetRun</code> API operation.
     * </p>
     * <p>
     * To start a new run, the following inputs are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A service role ARN (<code>roleArn</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * The run's workflow ID (<code>workflowId</code>, not the <code>uuid</code> or <code>runId</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * An Amazon S3 location (<code>outputUri</code>) where the run outputs will be saved.
     * </p>
     * </li>
     * <li>
     * <p>
     * All required workflow parameters (<code>parameter</code>), which can include optional parameters from the
     * parameter template. The run cannot include any parameters that are not defined in the parameter template. To see
     * all possible parameters, use the <code>GetRun</code> API operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * For runs with a <code>STATIC</code> (default) storage type, specify the required storage capacity (in gibibytes).
     * A storage capacity value is not required for runs that use <code>DYNAMIC</code> storage.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>StartRun</code> can also duplicate an existing run using the run's default values. You can modify these
     * default values and/or add other optional inputs. To duplicate a run, the following inputs are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A service role ARN (<code>roleArn</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * The ID of the run to duplicate (<code>runId</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * An Amazon S3 location where the run outputs will be saved (<code>outputUri</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * To learn more about the optional parameters for <code>StartRun</code>, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/starting-a-run.html">Starting a run</a> in the <i>Amazon Web
     * Services HealthOmics User Guide</i>.
     * </p>
     * <p>
     * Use the <code>retentionMode</code> input to control how long the metadata for each run is stored in CloudWatch.
     * There are two retention modes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify <code>REMOVE</code> to automatically remove the oldest runs when you reach the maximum service retention
     * limit for runs. It is recommended that you use the <code>REMOVE</code> mode to initiate major run requests so
     * that your runs do not fail when you reach the limit.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>retentionMode</code> is set to the <code>RETAIN</code> mode by default, which allows you to manually
     * remove runs after reaching the maximum service retention limit. Under this setting, you cannot create additional
     * runs until you remove the excess runs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To learn more about the retention modes, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/run-retention.html">Run retention mode</a> in the <i>Amazon
     * Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param startRunRequest
     * @return A Java Future containing the result of the StartRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartRunResponse> startRun(StartRunRequest startRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a new run and returns details about the run, or duplicates an existing run. A run is a single invocation
     * of a workflow. If you provide request IDs, Amazon Web Services HealthOmics identifies duplicate requests and
     * starts the run only once. Monitor the progress of the run by calling the <code>GetRun</code> API operation.
     * </p>
     * <p>
     * To start a new run, the following inputs are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A service role ARN (<code>roleArn</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * The run's workflow ID (<code>workflowId</code>, not the <code>uuid</code> or <code>runId</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * An Amazon S3 location (<code>outputUri</code>) where the run outputs will be saved.
     * </p>
     * </li>
     * <li>
     * <p>
     * All required workflow parameters (<code>parameter</code>), which can include optional parameters from the
     * parameter template. The run cannot include any parameters that are not defined in the parameter template. To see
     * all possible parameters, use the <code>GetRun</code> API operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * For runs with a <code>STATIC</code> (default) storage type, specify the required storage capacity (in gibibytes).
     * A storage capacity value is not required for runs that use <code>DYNAMIC</code> storage.
     * </p>
     * </li>
     * </ul>
     * <p>
     * <code>StartRun</code> can also duplicate an existing run using the run's default values. You can modify these
     * default values and/or add other optional inputs. To duplicate a run, the following inputs are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * A service role ARN (<code>roleArn</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * The ID of the run to duplicate (<code>runId</code>).
     * </p>
     * </li>
     * <li>
     * <p>
     * An Amazon S3 location where the run outputs will be saved (<code>outputUri</code>).
     * </p>
     * </li>
     * </ul>
     * <p>
     * To learn more about the optional parameters for <code>StartRun</code>, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/starting-a-run.html">Starting a run</a> in the <i>Amazon Web
     * Services HealthOmics User Guide</i>.
     * </p>
     * <p>
     * Use the <code>retentionMode</code> input to control how long the metadata for each run is stored in CloudWatch.
     * There are two retention modes:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Specify <code>REMOVE</code> to automatically remove the oldest runs when you reach the maximum service retention
     * limit for runs. It is recommended that you use the <code>REMOVE</code> mode to initiate major run requests so
     * that your runs do not fail when you reach the limit.
     * </p>
     * </li>
     * <li>
     * <p>
     * The <code>retentionMode</code> is set to the <code>RETAIN</code> mode by default, which allows you to manually
     * remove runs after reaching the maximum service retention limit. Under this setting, you cannot create additional
     * runs until you remove the excess runs.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To learn more about the retention modes, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/run-retention.html">Run retention mode</a> in the <i>Amazon
     * Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartRunRequest.Builder} avoiding the need to
     * create one manually via {@link StartRunRequest#builder()}
     * </p>
     *
     * @param startRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.StartRunRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartRunResponse> startRun(Consumer<StartRunRequest.Builder> startRunRequest) {
        return startRun(StartRunRequest.builder().applyMutation(startRunRequest).build());
    }

    /**
     * <p>
     * Starts a variant import job.
     * </p>
     *
     * @param startVariantImportJobRequest
     * @return A Java Future containing the result of the StartVariantImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartVariantImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartVariantImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartVariantImportJobResponse> startVariantImportJob(
            StartVariantImportJobRequest startVariantImportJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a variant import job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartVariantImportJobRequest.Builder} avoiding the
     * need to create one manually via {@link StartVariantImportJobRequest#builder()}
     * </p>
     *
     * @param startVariantImportJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.StartVariantImportJobRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the StartVariantImportJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.StartVariantImportJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/StartVariantImportJob" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<StartVariantImportJobResponse> startVariantImportJob(
            Consumer<StartVariantImportJobRequest.Builder> startVariantImportJobRequest) {
        return startVariantImportJob(StartVariantImportJobRequest.builder().applyMutation(startVariantImportJobRequest).build());
    }

    /**
     * <p>
     * Tags a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an annotation store.
     * </p>
     *
     * @param updateAnnotationStoreRequest
     * @return A Java Future containing the result of the UpdateAnnotationStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateAnnotationStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateAnnotationStoreResponse> updateAnnotationStore(
            UpdateAnnotationStoreRequest updateAnnotationStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an annotation store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAnnotationStoreRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAnnotationStoreRequest#builder()}
     * </p>
     *
     * @param updateAnnotationStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateAnnotationStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateAnnotationStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateAnnotationStore" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateAnnotationStoreResponse> updateAnnotationStore(
            Consumer<UpdateAnnotationStoreRequest.Builder> updateAnnotationStoreRequest) {
        return updateAnnotationStore(UpdateAnnotationStoreRequest.builder().applyMutation(updateAnnotationStoreRequest).build());
    }

    /**
     * <p>
     * Updates the description of an annotation store version.
     * </p>
     *
     * @param updateAnnotationStoreVersionRequest
     * @return A Java Future containing the result of the UpdateAnnotationStoreVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateAnnotationStoreVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateAnnotationStoreVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAnnotationStoreVersionResponse> updateAnnotationStoreVersion(
            UpdateAnnotationStoreVersionRequest updateAnnotationStoreVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the description of an annotation store version.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAnnotationStoreVersionRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateAnnotationStoreVersionRequest#builder()}
     * </p>
     *
     * @param updateAnnotationStoreVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.UpdateAnnotationStoreVersionRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UpdateAnnotationStoreVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateAnnotationStoreVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateAnnotationStoreVersion"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAnnotationStoreVersionResponse> updateAnnotationStoreVersion(
            Consumer<UpdateAnnotationStoreVersionRequest.Builder> updateAnnotationStoreVersionRequest) {
        return updateAnnotationStoreVersion(UpdateAnnotationStoreVersionRequest.builder()
                .applyMutation(updateAnnotationStoreVersionRequest).build());
    }

    /**
     * <p>
     * Updates a run cache using its ID and returns a response with no body if the operation is successful. You can
     * update the run cache description, name, or the default run cache behavior with <code>CACHE_ON_FAILURE</code> or
     * <code>CACHE_ALWAYS</code>. To confirm that your run cache settings have been properly updated, use the
     * <code>GetRunCache</code> API operation.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/how-run-cache.html">How call
     * caching works</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param updateRunCacheRequest
     * @return A Java Future containing the result of the UpdateRunCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateRunCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateRunCache" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRunCacheResponse> updateRunCache(UpdateRunCacheRequest updateRunCacheRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a run cache using its ID and returns a response with no body if the operation is successful. You can
     * update the run cache description, name, or the default run cache behavior with <code>CACHE_ON_FAILURE</code> or
     * <code>CACHE_ALWAYS</code>. To confirm that your run cache settings have been properly updated, use the
     * <code>GetRunCache</code> API operation.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/how-run-cache.html">How call
     * caching works</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRunCacheRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRunCacheRequest#builder()}
     * </p>
     *
     * @param updateRunCacheRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.UpdateRunCacheRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateRunCache operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateRunCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateRunCache" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRunCacheResponse> updateRunCache(Consumer<UpdateRunCacheRequest.Builder> updateRunCacheRequest) {
        return updateRunCache(UpdateRunCacheRequest.builder().applyMutation(updateRunCacheRequest).build());
    }

    /**
     * <p>
     * Updates the settings of a run group and returns a response with no body if the operation is successful.
     * </p>
     * <p>
     * You can update the following settings with <code>UpdateRunGroup</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of CPUs
     * </p>
     * </li>
     * <li>
     * <p>
     * Run time (measured in minutes)
     * </p>
     * </li>
     * <li>
     * <p>
     * Number of GPUs
     * </p>
     * </li>
     * <li>
     * <p>
     * Number of concurrent runs
     * </p>
     * </li>
     * <li>
     * <p>
     * Group name
     * </p>
     * </li>
     * </ul>
     * <p>
     * To confirm that the settings have been successfully updated, use the <code>ListRunGroups</code> or
     * <code>GetRunGroup</code> API operations to verify that the desired changes have been made.
     * </p>
     *
     * @param updateRunGroupRequest
     * @return A Java Future containing the result of the UpdateRunGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRunGroupResponse> updateRunGroup(UpdateRunGroupRequest updateRunGroupRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the settings of a run group and returns a response with no body if the operation is successful.
     * </p>
     * <p>
     * You can update the following settings with <code>UpdateRunGroup</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Maximum number of CPUs
     * </p>
     * </li>
     * <li>
     * <p>
     * Run time (measured in minutes)
     * </p>
     * </li>
     * <li>
     * <p>
     * Number of GPUs
     * </p>
     * </li>
     * <li>
     * <p>
     * Number of concurrent runs
     * </p>
     * </li>
     * <li>
     * <p>
     * Group name
     * </p>
     * </li>
     * </ul>
     * <p>
     * To confirm that the settings have been successfully updated, use the <code>ListRunGroups</code> or
     * <code>GetRunGroup</code> API operations to verify that the desired changes have been made.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateRunGroupRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateRunGroupRequest#builder()}
     * </p>
     *
     * @param updateRunGroupRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.UpdateRunGroupRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateRunGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateRunGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateRunGroup" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateRunGroupResponse> updateRunGroup(Consumer<UpdateRunGroupRequest.Builder> updateRunGroupRequest) {
        return updateRunGroup(UpdateRunGroupRequest.builder().applyMutation(updateRunGroupRequest).build());
    }

    /**
     * <p>
     * Update one or more parameters for the sequence store.
     * </p>
     *
     * @param updateSequenceStoreRequest
     * @return A Java Future containing the result of the UpdateSequenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSequenceStoreResponse> updateSequenceStore(
            UpdateSequenceStoreRequest updateSequenceStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update one or more parameters for the sequence store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSequenceStoreRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSequenceStoreRequest#builder()}
     * </p>
     *
     * @param updateSequenceStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.UpdateSequenceStoreRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateSequenceStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateSequenceStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateSequenceStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateSequenceStoreResponse> updateSequenceStore(
            Consumer<UpdateSequenceStoreRequest.Builder> updateSequenceStoreRequest) {
        return updateSequenceStore(UpdateSequenceStoreRequest.builder().applyMutation(updateSequenceStoreRequest).build());
    }

    /**
     * <p>
     * Updates a variant store.
     * </p>
     *
     * @param updateVariantStoreRequest
     * @return A Java Future containing the result of the UpdateVariantStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateVariantStoreResponse> updateVariantStore(UpdateVariantStoreRequest updateVariantStoreRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a variant store.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVariantStoreRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateVariantStoreRequest#builder()}
     * </p>
     *
     * @param updateVariantStoreRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.UpdateVariantStoreRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateVariantStore operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateVariantStore
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateVariantStore" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateVariantStoreResponse> updateVariantStore(
            Consumer<UpdateVariantStoreRequest.Builder> updateVariantStoreRequest) {
        return updateVariantStore(UpdateVariantStoreRequest.builder().applyMutation(updateVariantStoreRequest).build());
    }

    /**
     * <p>
     * Updates information about a workflow.
     * </p>
     * <p>
     * You can update the following workflow information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Name
     * </p>
     * </li>
     * <li>
     * <p>
     * Description
     * </p>
     * </li>
     * <li>
     * <p>
     * Default storage type
     * </p>
     * </li>
     * <li>
     * <p>
     * Default storage capacity (with workflow ID)
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation returns a response with no body if the operation is successful. You can check the workflow updates
     * by calling the <code>GetWorkflow</code> API operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/update-private-workflow.html">Update a private workflow</a> in
     * the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param updateWorkflowRequest
     * @return A Java Future containing the result of the UpdateWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateWorkflowResponse> updateWorkflow(UpdateWorkflowRequest updateWorkflowRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates information about a workflow.
     * </p>
     * <p>
     * You can update the following workflow information:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Name
     * </p>
     * </li>
     * <li>
     * <p>
     * Description
     * </p>
     * </li>
     * <li>
     * <p>
     * Default storage type
     * </p>
     * </li>
     * <li>
     * <p>
     * Default storage capacity (with workflow ID)
     * </p>
     * </li>
     * </ul>
     * <p>
     * This operation returns a response with no body if the operation is successful. You can check the workflow updates
     * by calling the <code>GetWorkflow</code> API operation.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/update-private-workflow.html">Update a private workflow</a> in
     * the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkflowRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateWorkflowRequest#builder()}
     * </p>
     *
     * @param updateWorkflowRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.UpdateWorkflowRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateWorkflow operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateWorkflow
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateWorkflow" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateWorkflowResponse> updateWorkflow(Consumer<UpdateWorkflowRequest.Builder> updateWorkflowRequest) {
        return updateWorkflow(UpdateWorkflowRequest.builder().applyMutation(updateWorkflowRequest).build());
    }

    /**
     * <p>
     * Updates information about the workflow version. For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html">Workflow versioning in Amazon Web
     * Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param updateWorkflowVersionRequest
     * @return A Java Future containing the result of the UpdateWorkflowVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateWorkflowVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateWorkflowVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateWorkflowVersionResponse> updateWorkflowVersion(
            UpdateWorkflowVersionRequest updateWorkflowVersionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates information about the workflow version. For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/workflow-versions.html">Workflow versioning in Amazon Web
     * Services HealthOmics</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWorkflowVersionRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateWorkflowVersionRequest#builder()}
     * </p>
     *
     * @param updateWorkflowVersionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.UpdateWorkflowVersionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateWorkflowVersion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ConflictException The request cannot be applied to the target resource in its current state.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UpdateWorkflowVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UpdateWorkflowVersion" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateWorkflowVersionResponse> updateWorkflowVersion(
            Consumer<UpdateWorkflowVersionRequest.Builder> updateWorkflowVersionRequest) {
        return updateWorkflowVersion(UpdateWorkflowVersionRequest.builder().applyMutation(updateWorkflowVersionRequest).build());
    }

    /**
     * <p>
     * Uploads a specific part of a read set into a sequence store. When you a upload a read set part with a part number
     * that already exists, the new part replaces the existing one. This operation returns a JSON formatted response
     * containing a string identifier that is used to confirm that parts are being added to the intended upload.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/synchronous-uploads.html">Direct
     * upload to a sequence store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param uploadReadSetPartRequest
     * @param requestBody
     *        Functional interface that can be implemented to produce the request content in a non-blocking manner. The
     *        size of the content is expected to be known up front. See {@link AsyncRequestBody} for specific details on
     *        implementing this interface as well as links to precanned implementations for common scenarios like
     *        uploading from a file. The service documentation for the request content is as follows '
     *        <p>
     *        The read set data to upload for a part.
     *        </p>
     *        '
     * @return A Java Future containing the result of the UploadReadSetPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UploadReadSetPart
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UploadReadSetPart" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UploadReadSetPartResponse> uploadReadSetPart(UploadReadSetPartRequest uploadReadSetPartRequest,
            AsyncRequestBody requestBody) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Uploads a specific part of a read set into a sequence store. When you a upload a read set part with a part number
     * that already exists, the new part replaces the existing one. This operation returns a JSON formatted response
     * containing a string identifier that is used to confirm that parts are being added to the intended upload.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/synchronous-uploads.html">Direct
     * upload to a sequence store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UploadReadSetPartRequest.Builder} avoiding the need
     * to create one manually via {@link UploadReadSetPartRequest#builder()}
     * </p>
     *
     * @param uploadReadSetPartRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.UploadReadSetPartRequest.Builder} to create a request.
     * @param requestBody
     *        Functional interface that can be implemented to produce the request content in a non-blocking manner. The
     *        size of the content is expected to be known up front. See {@link AsyncRequestBody} for specific details on
     *        implementing this interface as well as links to precanned implementations for common scenarios like
     *        uploading from a file. The service documentation for the request content is as follows '
     *        <p>
     *        The read set data to upload for a part.
     *        </p>
     *        '
     * @return A Java Future containing the result of the UploadReadSetPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UploadReadSetPart
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UploadReadSetPart" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UploadReadSetPartResponse> uploadReadSetPart(
            Consumer<UploadReadSetPartRequest.Builder> uploadReadSetPartRequest, AsyncRequestBody requestBody) {
        return uploadReadSetPart(UploadReadSetPartRequest.builder().applyMutation(uploadReadSetPartRequest).build(), requestBody);
    }

    /**
     * <p>
     * Uploads a specific part of a read set into a sequence store. When you a upload a read set part with a part number
     * that already exists, the new part replaces the existing one. This operation returns a JSON formatted response
     * containing a string identifier that is used to confirm that parts are being added to the intended upload.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/synchronous-uploads.html">Direct
     * upload to a sequence store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     *
     * @param uploadReadSetPartRequest
     * @param sourcePath
     *        {@link Path} to file containing data to send to the service. File will be read entirely and may be read
     *        multiple times in the event of a retry. If the file does not exist or the current user does not have
     *        access to read it then an exception will be thrown. The service documentation for the request content is
     *        as follows '
     *        <p>
     *        The read set data to upload for a part.
     *        </p>
     *        '
     * @return A Java Future containing the result of the UploadReadSetPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UploadReadSetPart
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UploadReadSetPart" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UploadReadSetPartResponse> uploadReadSetPart(UploadReadSetPartRequest uploadReadSetPartRequest,
            Path sourcePath) {
        return uploadReadSetPart(uploadReadSetPartRequest, AsyncRequestBody.fromFile(sourcePath));
    }

    /**
     * <p>
     * Uploads a specific part of a read set into a sequence store. When you a upload a read set part with a part number
     * that already exists, the new part replaces the existing one. This operation returns a JSON formatted response
     * containing a string identifier that is used to confirm that parts are being added to the intended upload.
     * </p>
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/omics/latest/dev/synchronous-uploads.html">Direct
     * upload to a sequence store</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UploadReadSetPartRequest.Builder} avoiding the need
     * to create one manually via {@link UploadReadSetPartRequest#builder()}
     * </p>
     *
     * @param uploadReadSetPartRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.omics.model.UploadReadSetPartRequest.Builder} to create a request.
     * @param sourcePath
     *        {@link Path} to file containing data to send to the service. File will be read entirely and may be read
     *        multiple times in the event of a retry. If the file does not exist or the current user does not have
     *        access to read it then an exception will be thrown. The service documentation for the request content is
     *        as follows '
     *        <p>
     *        The read set data to upload for a part.
     *        </p>
     *        '
     * @return A Java Future containing the result of the UploadReadSetPart operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException An unexpected error occurred. Try the request again.</li>
     *         <li>NotSupportedOperationException The operation is not supported by Amazon Omics, or the API does not
     *         exist.</li>
     *         <li>ServiceQuotaExceededException The request exceeds a service quota.</li>
     *         <li>ThrottlingException The request was denied due to request throttling.</li>
     *         <li>ValidationException The input fails to satisfy the constraints specified by an AWS service.</li>
     *         <li>ResourceNotFoundException The target resource was not found in the current Region.</li>
     *         <li>AccessDeniedException You do not have sufficient access to perform this action.</li>
     *         <li>RequestTimeoutException The request timed out.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OmicsException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample OmicsAsyncClient.UploadReadSetPart
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/omics-2022-11-28/UploadReadSetPart" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UploadReadSetPartResponse> uploadReadSetPart(
            Consumer<UploadReadSetPartRequest.Builder> uploadReadSetPartRequest, Path sourcePath) {
        return uploadReadSetPart(UploadReadSetPartRequest.builder().applyMutation(uploadReadSetPartRequest).build(), sourcePath);
    }

    /**
     * Create an instance of {@link OmicsAsyncWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link OmicsAsyncWaiter}
     */
    default OmicsAsyncWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    @Override
    default OmicsServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link OmicsAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static OmicsAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link OmicsAsyncClient}.
     */
    static OmicsAsyncClientBuilder builder() {
        return new DefaultOmicsAsyncClientBuilder();
    }
}
