/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Use a container registry map to specify mappings between the ECR private repository and one or more upstream
 * registries. For more information, see <a
 * href="https://docs.aws.amazon.com/omics/latest/dev/workflows-ecr.html">Container images</a> in the <i>Amazon Web
 * Services HealthOmics User Guide</i>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContainerRegistryMap implements SdkPojo, Serializable,
        ToCopyableBuilder<ContainerRegistryMap.Builder, ContainerRegistryMap> {
    private static final SdkField<List<RegistryMapping>> REGISTRY_MAPPINGS_FIELD = SdkField
            .<List<RegistryMapping>> builder(MarshallingType.LIST)
            .memberName("registryMappings")
            .getter(getter(ContainerRegistryMap::registryMappings))
            .setter(setter(Builder::registryMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RegistryMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(RegistryMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ImageMapping>> IMAGE_MAPPINGS_FIELD = SdkField
            .<List<ImageMapping>> builder(MarshallingType.LIST)
            .memberName("imageMappings")
            .getter(getter(ContainerRegistryMap::imageMappings))
            .setter(setter(Builder::imageMappings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageMappings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ImageMapping> builder(MarshallingType.SDK_POJO)
                                            .constructor(ImageMapping::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_MAPPINGS_FIELD,
            IMAGE_MAPPINGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<RegistryMapping> registryMappings;

    private final List<ImageMapping> imageMappings;

    private ContainerRegistryMap(BuilderImpl builder) {
        this.registryMappings = builder.registryMappings;
        this.imageMappings = builder.imageMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegistryMappings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRegistryMappings() {
        return registryMappings != null && !(registryMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Mapping that provides the ECR repository path where upstream container images are pulled and synchronized.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegistryMappings} method.
     * </p>
     * 
     * @return Mapping that provides the ECR repository path where upstream container images are pulled and
     *         synchronized.
     */
    public final List<RegistryMapping> registryMappings() {
        return registryMappings;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImageMappings property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImageMappings() {
        return imageMappings != null && !(imageMappings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Image mappings specify path mappings between the ECR private repository and their corresponding external
     * repositories.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImageMappings} method.
     * </p>
     * 
     * @return Image mappings specify path mappings between the ECR private repository and their corresponding external
     *         repositories.
     */
    public final List<ImageMapping> imageMappings() {
        return imageMappings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRegistryMappings() ? registryMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasImageMappings() ? imageMappings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerRegistryMap)) {
            return false;
        }
        ContainerRegistryMap other = (ContainerRegistryMap) obj;
        return hasRegistryMappings() == other.hasRegistryMappings()
                && Objects.equals(registryMappings(), other.registryMappings()) && hasImageMappings() == other.hasImageMappings()
                && Objects.equals(imageMappings(), other.imageMappings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContainerRegistryMap")
                .add("RegistryMappings", hasRegistryMappings() ? registryMappings() : null)
                .add("ImageMappings", hasImageMappings() ? imageMappings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryMappings":
            return Optional.ofNullable(clazz.cast(registryMappings()));
        case "imageMappings":
            return Optional.ofNullable(clazz.cast(imageMappings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("registryMappings", REGISTRY_MAPPINGS_FIELD);
        map.put("imageMappings", IMAGE_MAPPINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContainerRegistryMap, T> g) {
        return obj -> g.apply((ContainerRegistryMap) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContainerRegistryMap> {
        /**
         * <p>
         * Mapping that provides the ECR repository path where upstream container images are pulled and synchronized.
         * </p>
         * 
         * @param registryMappings
         *        Mapping that provides the ECR repository path where upstream container images are pulled and
         *        synchronized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryMappings(Collection<RegistryMapping> registryMappings);

        /**
         * <p>
         * Mapping that provides the ECR repository path where upstream container images are pulled and synchronized.
         * </p>
         * 
         * @param registryMappings
         *        Mapping that provides the ECR repository path where upstream container images are pulled and
         *        synchronized.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryMappings(RegistryMapping... registryMappings);

        /**
         * <p>
         * Mapping that provides the ECR repository path where upstream container images are pulled and synchronized.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.omics.model.RegistryMapping.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.omics.model.RegistryMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.omics.model.RegistryMapping.Builder#build()} is called immediately and
         * its result is passed to {@link #registryMappings(List<RegistryMapping>)}.
         * 
         * @param registryMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.omics.model.RegistryMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #registryMappings(java.util.Collection<RegistryMapping>)
         */
        Builder registryMappings(Consumer<RegistryMapping.Builder>... registryMappings);

        /**
         * <p>
         * Image mappings specify path mappings between the ECR private repository and their corresponding external
         * repositories.
         * </p>
         * 
         * @param imageMappings
         *        Image mappings specify path mappings between the ECR private repository and their corresponding
         *        external repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageMappings(Collection<ImageMapping> imageMappings);

        /**
         * <p>
         * Image mappings specify path mappings between the ECR private repository and their corresponding external
         * repositories.
         * </p>
         * 
         * @param imageMappings
         *        Image mappings specify path mappings between the ECR private repository and their corresponding
         *        external repositories.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageMappings(ImageMapping... imageMappings);

        /**
         * <p>
         * Image mappings specify path mappings between the ECR private repository and their corresponding external
         * repositories.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.omics.model.ImageMapping.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.omics.model.ImageMapping#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.omics.model.ImageMapping.Builder#build()} is called immediately and
         * its result is passed to {@link #imageMappings(List<ImageMapping>)}.
         * 
         * @param imageMappings
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.omics.model.ImageMapping.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageMappings(java.util.Collection<ImageMapping>)
         */
        Builder imageMappings(Consumer<ImageMapping.Builder>... imageMappings);
    }

    static final class BuilderImpl implements Builder {
        private List<RegistryMapping> registryMappings = DefaultSdkAutoConstructList.getInstance();

        private List<ImageMapping> imageMappings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerRegistryMap model) {
            registryMappings(model.registryMappings);
            imageMappings(model.imageMappings);
        }

        public final List<RegistryMapping.Builder> getRegistryMappings() {
            List<RegistryMapping.Builder> result = RegistryMappingsListCopier.copyToBuilder(this.registryMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRegistryMappings(Collection<RegistryMapping.BuilderImpl> registryMappings) {
            this.registryMappings = RegistryMappingsListCopier.copyFromBuilder(registryMappings);
        }

        @Override
        public final Builder registryMappings(Collection<RegistryMapping> registryMappings) {
            this.registryMappings = RegistryMappingsListCopier.copy(registryMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registryMappings(RegistryMapping... registryMappings) {
            registryMappings(Arrays.asList(registryMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder registryMappings(Consumer<RegistryMapping.Builder>... registryMappings) {
            registryMappings(Stream.of(registryMappings).map(c -> RegistryMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ImageMapping.Builder> getImageMappings() {
            List<ImageMapping.Builder> result = ImageMappingsListCopier.copyToBuilder(this.imageMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageMappings(Collection<ImageMapping.BuilderImpl> imageMappings) {
            this.imageMappings = ImageMappingsListCopier.copyFromBuilder(imageMappings);
        }

        @Override
        public final Builder imageMappings(Collection<ImageMapping> imageMappings) {
            this.imageMappings = ImageMappingsListCopier.copy(imageMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageMappings(ImageMapping... imageMappings) {
            imageMappings(Arrays.asList(imageMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageMappings(Consumer<ImageMapping.Builder>... imageMappings) {
            imageMappings(Stream.of(imageMappings).map(c -> ImageMapping.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ContainerRegistryMap build() {
            return new ContainerRegistryMap(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
