/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSequenceStoreResponse extends OmicsResponse implements
        ToCopyableBuilder<CreateSequenceStoreResponse.Builder, CreateSequenceStoreResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(CreateSequenceStoreResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(CreateSequenceStoreResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateSequenceStoreResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateSequenceStoreResponse::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<SseConfig> SSE_CONFIG_FIELD = SdkField.<SseConfig> builder(MarshallingType.SDK_POJO)
            .memberName("sseConfig").getter(getter(CreateSequenceStoreResponse::sseConfig)).setter(setter(Builder::sseConfig))
            .constructor(SseConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sseConfig").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(CreateSequenceStoreResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> FALLBACK_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fallbackLocation").getter(getter(CreateSequenceStoreResponse::fallbackLocation))
            .setter(setter(Builder::fallbackLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fallbackLocation").build()).build();

    private static final SdkField<String> E_TAG_ALGORITHM_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eTagAlgorithmFamily").getter(getter(CreateSequenceStoreResponse::eTagAlgorithmFamilyAsString))
            .setter(setter(Builder::eTagAlgorithmFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eTagAlgorithmFamily").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateSequenceStoreResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(CreateSequenceStoreResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<List<String>> PROPAGATED_SET_LEVEL_TAGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("propagatedSetLevelTags")
            .getter(getter(CreateSequenceStoreResponse::propagatedSetLevelTags))
            .setter(setter(Builder::propagatedSetLevelTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagatedSetLevelTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SequenceStoreS3Access> S3_ACCESS_FIELD = SdkField
            .<SequenceStoreS3Access> builder(MarshallingType.SDK_POJO).memberName("s3Access")
            .getter(getter(CreateSequenceStoreResponse::s3Access)).setter(setter(Builder::s3Access))
            .constructor(SequenceStoreS3Access::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Access").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            NAME_FIELD, DESCRIPTION_FIELD, SSE_CONFIG_FIELD, CREATION_TIME_FIELD, FALLBACK_LOCATION_FIELD,
            E_TAG_ALGORITHM_FAMILY_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, PROPAGATED_SET_LEVEL_TAGS_FIELD, S3_ACCESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String arn;

    private final String name;

    private final String description;

    private final SseConfig sseConfig;

    private final Instant creationTime;

    private final String fallbackLocation;

    private final String eTagAlgorithmFamily;

    private final String status;

    private final String statusMessage;

    private final List<String> propagatedSetLevelTags;

    private final SequenceStoreS3Access s3Access;

    private CreateSequenceStoreResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.name = builder.name;
        this.description = builder.description;
        this.sseConfig = builder.sseConfig;
        this.creationTime = builder.creationTime;
        this.fallbackLocation = builder.fallbackLocation;
        this.eTagAlgorithmFamily = builder.eTagAlgorithmFamily;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.propagatedSetLevelTags = builder.propagatedSetLevelTags;
        this.s3Access = builder.s3Access;
    }

    /**
     * <p>
     * The store's ID.
     * </p>
     * 
     * @return The store's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The store's ARN.
     * </p>
     * 
     * @return The store's ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The store's name.
     * </p>
     * 
     * @return The store's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The store's description.
     * </p>
     * 
     * @return The store's description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Server-side encryption (SSE) settings for the store. This contains the KMS key ARN that is used to encrypt read
     * set objects.
     * </p>
     * 
     * @return Server-side encryption (SSE) settings for the store. This contains the KMS key ARN that is used to
     *         encrypt read set objects.
     */
    public final SseConfig sseConfig() {
        return sseConfig;
    }

    /**
     * <p>
     * When the store was created.
     * </p>
     * 
     * @return When the store was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * An S3 location that is used to store files that have failed a direct upload.
     * </p>
     * 
     * @return An S3 location that is used to store files that have failed a direct upload.
     */
    public final String fallbackLocation() {
        return fallbackLocation;
    }

    /**
     * <p>
     * The algorithm family of the ETag.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #eTagAlgorithmFamily} will return {@link ETagAlgorithmFamily#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #eTagAlgorithmFamilyAsString}.
     * </p>
     * 
     * @return The algorithm family of the ETag.
     * @see ETagAlgorithmFamily
     */
    public final ETagAlgorithmFamily eTagAlgorithmFamily() {
        return ETagAlgorithmFamily.fromValue(eTagAlgorithmFamily);
    }

    /**
     * <p>
     * The algorithm family of the ETag.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #eTagAlgorithmFamily} will return {@link ETagAlgorithmFamily#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #eTagAlgorithmFamilyAsString}.
     * </p>
     * 
     * @return The algorithm family of the ETag.
     * @see ETagAlgorithmFamily
     */
    public final String eTagAlgorithmFamilyAsString() {
        return eTagAlgorithmFamily;
    }

    /**
     * <p>
     * The status of the sequence store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SequenceStoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the sequence store.
     * @see SequenceStoreStatus
     */
    public final SequenceStoreStatus status() {
        return SequenceStoreStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the sequence store.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SequenceStoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the sequence store.
     * @see SequenceStoreStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status message of the sequence store.
     * </p>
     * 
     * @return The status message of the sequence store.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropagatedSetLevelTags property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPropagatedSetLevelTags() {
        return propagatedSetLevelTags != null && !(propagatedSetLevelTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags keys to propagate to the S3 objects associated with read sets in the sequence store.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropagatedSetLevelTags} method.
     * </p>
     * 
     * @return The tags keys to propagate to the S3 objects associated with read sets in the sequence store.
     */
    public final List<String> propagatedSetLevelTags() {
        return propagatedSetLevelTags;
    }

    /**
     * Returns the value of the S3Access property for this object.
     * 
     * @return The value of the S3Access property for this object.
     */
    public final SequenceStoreS3Access s3Access() {
        return s3Access;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(sseConfig());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(fallbackLocation());
        hashCode = 31 * hashCode + Objects.hashCode(eTagAlgorithmFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hasPropagatedSetLevelTags() ? propagatedSetLevelTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(s3Access());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSequenceStoreResponse)) {
            return false;
        }
        CreateSequenceStoreResponse other = (CreateSequenceStoreResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(sseConfig(), other.sseConfig())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(fallbackLocation(), other.fallbackLocation())
                && Objects.equals(eTagAlgorithmFamilyAsString(), other.eTagAlgorithmFamilyAsString())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage())
                && hasPropagatedSetLevelTags() == other.hasPropagatedSetLevelTags()
                && Objects.equals(propagatedSetLevelTags(), other.propagatedSetLevelTags())
                && Objects.equals(s3Access(), other.s3Access());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSequenceStoreResponse").add("Id", id()).add("Arn", arn()).add("Name", name())
                .add("Description", description()).add("SseConfig", sseConfig()).add("CreationTime", creationTime())
                .add("FallbackLocation", fallbackLocation()).add("ETagAlgorithmFamily", eTagAlgorithmFamilyAsString())
                .add("Status", statusAsString()).add("StatusMessage", statusMessage())
                .add("PropagatedSetLevelTags", hasPropagatedSetLevelTags() ? propagatedSetLevelTags() : null)
                .add("S3Access", s3Access()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "sseConfig":
            return Optional.ofNullable(clazz.cast(sseConfig()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "fallbackLocation":
            return Optional.ofNullable(clazz.cast(fallbackLocation()));
        case "eTagAlgorithmFamily":
            return Optional.ofNullable(clazz.cast(eTagAlgorithmFamilyAsString()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "propagatedSetLevelTags":
            return Optional.ofNullable(clazz.cast(propagatedSetLevelTags()));
        case "s3Access":
            return Optional.ofNullable(clazz.cast(s3Access()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("sseConfig", SSE_CONFIG_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("fallbackLocation", FALLBACK_LOCATION_FIELD);
        map.put("eTagAlgorithmFamily", E_TAG_ALGORITHM_FAMILY_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("propagatedSetLevelTags", PROPAGATED_SET_LEVEL_TAGS_FIELD);
        map.put("s3Access", S3_ACCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSequenceStoreResponse, T> g) {
        return obj -> g.apply((CreateSequenceStoreResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OmicsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateSequenceStoreResponse> {
        /**
         * <p>
         * The store's ID.
         * </p>
         * 
         * @param id
         *        The store's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The store's ARN.
         * </p>
         * 
         * @param arn
         *        The store's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The store's name.
         * </p>
         * 
         * @param name
         *        The store's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The store's description.
         * </p>
         * 
         * @param description
         *        The store's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Server-side encryption (SSE) settings for the store. This contains the KMS key ARN that is used to encrypt
         * read set objects.
         * </p>
         * 
         * @param sseConfig
         *        Server-side encryption (SSE) settings for the store. This contains the KMS key ARN that is used to
         *        encrypt read set objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseConfig(SseConfig sseConfig);

        /**
         * <p>
         * Server-side encryption (SSE) settings for the store. This contains the KMS key ARN that is used to encrypt
         * read set objects.
         * </p>
         * This is a convenience method that creates an instance of the {@link SseConfig.Builder} avoiding the need to
         * create one manually via {@link SseConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SseConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #sseConfig(SseConfig)}.
         * 
         * @param sseConfig
         *        a consumer that will call methods on {@link SseConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sseConfig(SseConfig)
         */
        default Builder sseConfig(Consumer<SseConfig.Builder> sseConfig) {
            return sseConfig(SseConfig.builder().applyMutation(sseConfig).build());
        }

        /**
         * <p>
         * When the store was created.
         * </p>
         * 
         * @param creationTime
         *        When the store was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * An S3 location that is used to store files that have failed a direct upload.
         * </p>
         * 
         * @param fallbackLocation
         *        An S3 location that is used to store files that have failed a direct upload.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fallbackLocation(String fallbackLocation);

        /**
         * <p>
         * The algorithm family of the ETag.
         * </p>
         * 
         * @param eTagAlgorithmFamily
         *        The algorithm family of the ETag.
         * @see ETagAlgorithmFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ETagAlgorithmFamily
         */
        Builder eTagAlgorithmFamily(String eTagAlgorithmFamily);

        /**
         * <p>
         * The algorithm family of the ETag.
         * </p>
         * 
         * @param eTagAlgorithmFamily
         *        The algorithm family of the ETag.
         * @see ETagAlgorithmFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ETagAlgorithmFamily
         */
        Builder eTagAlgorithmFamily(ETagAlgorithmFamily eTagAlgorithmFamily);

        /**
         * <p>
         * The status of the sequence store.
         * </p>
         * 
         * @param status
         *        The status of the sequence store.
         * @see SequenceStoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SequenceStoreStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the sequence store.
         * </p>
         * 
         * @param status
         *        The status of the sequence store.
         * @see SequenceStoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SequenceStoreStatus
         */
        Builder status(SequenceStoreStatus status);

        /**
         * <p>
         * The status message of the sequence store.
         * </p>
         * 
         * @param statusMessage
         *        The status message of the sequence store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The tags keys to propagate to the S3 objects associated with read sets in the sequence store.
         * </p>
         * 
         * @param propagatedSetLevelTags
         *        The tags keys to propagate to the S3 objects associated with read sets in the sequence store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagatedSetLevelTags(Collection<String> propagatedSetLevelTags);

        /**
         * <p>
         * The tags keys to propagate to the S3 objects associated with read sets in the sequence store.
         * </p>
         * 
         * @param propagatedSetLevelTags
         *        The tags keys to propagate to the S3 objects associated with read sets in the sequence store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagatedSetLevelTags(String... propagatedSetLevelTags);

        /**
         * Sets the value of the S3Access property for this object.
         *
         * @param s3Access
         *        The new value for the S3Access property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3Access(SequenceStoreS3Access s3Access);

        /**
         * Sets the value of the S3Access property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SequenceStoreS3Access.Builder} avoiding
         * the need to create one manually via {@link SequenceStoreS3Access#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SequenceStoreS3Access.Builder#build()} is called immediately and
         * its result is passed to {@link #s3Access(SequenceStoreS3Access)}.
         * 
         * @param s3Access
         *        a consumer that will call methods on {@link SequenceStoreS3Access.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3Access(SequenceStoreS3Access)
         */
        default Builder s3Access(Consumer<SequenceStoreS3Access.Builder> s3Access) {
            return s3Access(SequenceStoreS3Access.builder().applyMutation(s3Access).build());
        }
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String name;

        private String description;

        private SseConfig sseConfig;

        private Instant creationTime;

        private String fallbackLocation;

        private String eTagAlgorithmFamily;

        private String status;

        private String statusMessage;

        private List<String> propagatedSetLevelTags = DefaultSdkAutoConstructList.getInstance();

        private SequenceStoreS3Access s3Access;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSequenceStoreResponse model) {
            super(model);
            id(model.id);
            arn(model.arn);
            name(model.name);
            description(model.description);
            sseConfig(model.sseConfig);
            creationTime(model.creationTime);
            fallbackLocation(model.fallbackLocation);
            eTagAlgorithmFamily(model.eTagAlgorithmFamily);
            status(model.status);
            statusMessage(model.statusMessage);
            propagatedSetLevelTags(model.propagatedSetLevelTags);
            s3Access(model.s3Access);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SseConfig.Builder getSseConfig() {
            return sseConfig != null ? sseConfig.toBuilder() : null;
        }

        public final void setSseConfig(SseConfig.BuilderImpl sseConfig) {
            this.sseConfig = sseConfig != null ? sseConfig.build() : null;
        }

        @Override
        public final Builder sseConfig(SseConfig sseConfig) {
            this.sseConfig = sseConfig;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getFallbackLocation() {
            return fallbackLocation;
        }

        public final void setFallbackLocation(String fallbackLocation) {
            this.fallbackLocation = fallbackLocation;
        }

        @Override
        public final Builder fallbackLocation(String fallbackLocation) {
            this.fallbackLocation = fallbackLocation;
            return this;
        }

        public final String getETagAlgorithmFamily() {
            return eTagAlgorithmFamily;
        }

        public final void setETagAlgorithmFamily(String eTagAlgorithmFamily) {
            this.eTagAlgorithmFamily = eTagAlgorithmFamily;
        }

        @Override
        public final Builder eTagAlgorithmFamily(String eTagAlgorithmFamily) {
            this.eTagAlgorithmFamily = eTagAlgorithmFamily;
            return this;
        }

        @Override
        public final Builder eTagAlgorithmFamily(ETagAlgorithmFamily eTagAlgorithmFamily) {
            this.eTagAlgorithmFamily(eTagAlgorithmFamily == null ? null : eTagAlgorithmFamily.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SequenceStoreStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Collection<String> getPropagatedSetLevelTags() {
            if (propagatedSetLevelTags instanceof SdkAutoConstructList) {
                return null;
            }
            return propagatedSetLevelTags;
        }

        public final void setPropagatedSetLevelTags(Collection<String> propagatedSetLevelTags) {
            this.propagatedSetLevelTags = PropagatedSetLevelTagsCopier.copy(propagatedSetLevelTags);
        }

        @Override
        public final Builder propagatedSetLevelTags(Collection<String> propagatedSetLevelTags) {
            this.propagatedSetLevelTags = PropagatedSetLevelTagsCopier.copy(propagatedSetLevelTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propagatedSetLevelTags(String... propagatedSetLevelTags) {
            propagatedSetLevelTags(Arrays.asList(propagatedSetLevelTags));
            return this;
        }

        public final SequenceStoreS3Access.Builder getS3Access() {
            return s3Access != null ? s3Access.toBuilder() : null;
        }

        public final void setS3Access(SequenceStoreS3Access.BuilderImpl s3Access) {
            this.s3Access = s3Access != null ? s3Access.build() : null;
        }

        @Override
        public final Builder s3Access(SequenceStoreS3Access s3Access) {
            this.s3Access = s3Access;
            return this;
        }

        @Override
        public CreateSequenceStoreResponse build() {
            return new CreateSequenceStoreResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
