/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateShareResponse extends OmicsResponse implements
        ToCopyableBuilder<CreateShareResponse.Builder, CreateShareResponse> {
    private static final SdkField<String> SHARE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shareId").getter(getter(CreateShareResponse::shareId)).setter(setter(Builder::shareId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(CreateShareResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> SHARE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("shareName").getter(getter(CreateShareResponse::shareName)).setter(setter(Builder::shareName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("shareName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHARE_ID_FIELD, STATUS_FIELD,
            SHARE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String shareId;

    private final String status;

    private final String shareName;

    private CreateShareResponse(BuilderImpl builder) {
        super(builder);
        this.shareId = builder.shareId;
        this.status = builder.status;
        this.shareName = builder.shareName;
    }

    /**
     * <p>
     * The ID that HealthOmics generates for the share.
     * </p>
     * 
     * @return The ID that HealthOmics generates for the share.
     */
    public final String shareId() {
        return shareId;
    }

    /**
     * <p>
     * The status of the share.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the share.
     * @see ShareStatus
     */
    public final ShareStatus status() {
        return ShareStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the share.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ShareStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the share.
     * @see ShareStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The name of the share.
     * </p>
     * 
     * @return The name of the share.
     */
    public final String shareName() {
        return shareName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(shareId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(shareName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateShareResponse)) {
            return false;
        }
        CreateShareResponse other = (CreateShareResponse) obj;
        return Objects.equals(shareId(), other.shareId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(shareName(), other.shareName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateShareResponse").add("ShareId", shareId()).add("Status", statusAsString())
                .add("ShareName", shareName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "shareId":
            return Optional.ofNullable(clazz.cast(shareId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "shareName":
            return Optional.ofNullable(clazz.cast(shareName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("shareId", SHARE_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("shareName", SHARE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateShareResponse, T> g) {
        return obj -> g.apply((CreateShareResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OmicsResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateShareResponse> {
        /**
         * <p>
         * The ID that HealthOmics generates for the share.
         * </p>
         * 
         * @param shareId
         *        The ID that HealthOmics generates for the share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareId(String shareId);

        /**
         * <p>
         * The status of the share.
         * </p>
         * 
         * @param status
         *        The status of the share.
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the share.
         * </p>
         * 
         * @param status
         *        The status of the share.
         * @see ShareStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ShareStatus
         */
        Builder status(ShareStatus status);

        /**
         * <p>
         * The name of the share.
         * </p>
         * 
         * @param shareName
         *        The name of the share.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder shareName(String shareName);
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private String shareId;

        private String status;

        private String shareName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateShareResponse model) {
            super(model);
            shareId(model.shareId);
            status(model.status);
            shareName(model.shareName);
        }

        public final String getShareId() {
            return shareId;
        }

        public final void setShareId(String shareId) {
            this.shareId = shareId;
        }

        @Override
        public final Builder shareId(String shareId) {
            this.shareId = shareId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ShareStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getShareName() {
            return shareName;
        }

        public final void setShareName(String shareName) {
            this.shareName = shareName;
        }

        @Override
        public final Builder shareName(String shareName) {
            this.shareName = shareName;
            return this;
        }

        @Override
        public CreateShareResponse build() {
            return new CreateShareResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
