/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateWorkflowVersionRequest extends OmicsRequest implements
        ToCopyableBuilder<CreateWorkflowVersionRequest.Builder, CreateWorkflowVersionRequest> {
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowId").getter(getter(CreateWorkflowVersionRequest::workflowId))
            .setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowId").build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionName").getter(getter(CreateWorkflowVersionRequest::versionName))
            .setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()).build();

    private static final SdkField<SdkBytes> DEFINITION_ZIP_FIELD = SdkField.<SdkBytes> builder(MarshallingType.SDK_BYTES)
            .memberName("definitionZip").getter(getter(CreateWorkflowVersionRequest::definitionZip))
            .setter(setter(Builder::definitionZip))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definitionZip").build()).build();

    private static final SdkField<String> DEFINITION_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("definitionUri").getter(getter(CreateWorkflowVersionRequest::definitionUri))
            .setter(setter(Builder::definitionUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definitionUri").build()).build();

    private static final SdkField<String> ACCELERATORS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accelerators").getter(getter(CreateWorkflowVersionRequest::acceleratorsAsString))
            .setter(setter(Builder::accelerators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accelerators").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateWorkflowVersionRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("engine")
            .getter(getter(CreateWorkflowVersionRequest::engineAsString)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engine").build()).build();

    private static final SdkField<String> MAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("main")
            .getter(getter(CreateWorkflowVersionRequest::main)).setter(setter(Builder::main))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("main").build()).build();

    private static final SdkField<Map<String, WorkflowParameter>> PARAMETER_TEMPLATE_FIELD = SdkField
            .<Map<String, WorkflowParameter>> builder(MarshallingType.MAP)
            .memberName("parameterTemplate")
            .getter(getter(CreateWorkflowVersionRequest::parameterTemplate))
            .setter(setter(Builder::parameterTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterTemplate").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<WorkflowParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkflowParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("requestId")
            .getter(getter(CreateWorkflowVersionRequest::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageType").getter(getter(CreateWorkflowVersionRequest::storageTypeAsString))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()).build();

    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("storageCapacity").getter(getter(CreateWorkflowVersionRequest::storageCapacity))
            .setter(setter(Builder::storageCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCapacity").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateWorkflowVersionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> WORKFLOW_BUCKET_OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowBucketOwnerId").getter(getter(CreateWorkflowVersionRequest::workflowBucketOwnerId))
            .setter(setter(Builder::workflowBucketOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowBucketOwnerId").build())
            .build();

    private static final SdkField<ContainerRegistryMap> CONTAINER_REGISTRY_MAP_FIELD = SdkField
            .<ContainerRegistryMap> builder(MarshallingType.SDK_POJO).memberName("containerRegistryMap")
            .getter(getter(CreateWorkflowVersionRequest::containerRegistryMap)).setter(setter(Builder::containerRegistryMap))
            .constructor(ContainerRegistryMap::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerRegistryMap").build())
            .build();

    private static final SdkField<String> CONTAINER_REGISTRY_MAP_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("containerRegistryMapUri").getter(getter(CreateWorkflowVersionRequest::containerRegistryMapUri))
            .setter(setter(Builder::containerRegistryMapUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerRegistryMapUri").build())
            .build();

    private static final SdkField<String> README_MARKDOWN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("readmeMarkdown").getter(getter(CreateWorkflowVersionRequest::readmeMarkdown))
            .setter(setter(Builder::readmeMarkdown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readmeMarkdown").build()).build();

    private static final SdkField<String> PARAMETER_TEMPLATE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parameterTemplatePath").getter(getter(CreateWorkflowVersionRequest::parameterTemplatePath))
            .setter(setter(Builder::parameterTemplatePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterTemplatePath").build())
            .build();

    private static final SdkField<String> README_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("readmePath").getter(getter(CreateWorkflowVersionRequest::readmePath))
            .setter(setter(Builder::readmePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readmePath").build()).build();

    private static final SdkField<DefinitionRepository> DEFINITION_REPOSITORY_FIELD = SdkField
            .<DefinitionRepository> builder(MarshallingType.SDK_POJO).memberName("definitionRepository")
            .getter(getter(CreateWorkflowVersionRequest::definitionRepository)).setter(setter(Builder::definitionRepository))
            .constructor(DefinitionRepository::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definitionRepository").build())
            .build();

    private static final SdkField<String> README_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("readmeUri").getter(getter(CreateWorkflowVersionRequest::readmeUri)).setter(setter(Builder::readmeUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readmeUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ID_FIELD,
            VERSION_NAME_FIELD, DEFINITION_ZIP_FIELD, DEFINITION_URI_FIELD, ACCELERATORS_FIELD, DESCRIPTION_FIELD, ENGINE_FIELD,
            MAIN_FIELD, PARAMETER_TEMPLATE_FIELD, REQUEST_ID_FIELD, STORAGE_TYPE_FIELD, STORAGE_CAPACITY_FIELD, TAGS_FIELD,
            WORKFLOW_BUCKET_OWNER_ID_FIELD, CONTAINER_REGISTRY_MAP_FIELD, CONTAINER_REGISTRY_MAP_URI_FIELD,
            README_MARKDOWN_FIELD, PARAMETER_TEMPLATE_PATH_FIELD, README_PATH_FIELD, DEFINITION_REPOSITORY_FIELD,
            README_URI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workflowId;

    private final String versionName;

    private final SdkBytes definitionZip;

    private final String definitionUri;

    private final String accelerators;

    private final String description;

    private final String engine;

    private final String main;

    private final Map<String, WorkflowParameter> parameterTemplate;

    private final String requestIdValue;

    private final String storageType;

    private final Integer storageCapacity;

    private final Map<String, String> tags;

    private final String workflowBucketOwnerId;

    private final ContainerRegistryMap containerRegistryMap;

    private final String containerRegistryMapUri;

    private final String readmeMarkdown;

    private final String parameterTemplatePath;

    private final String readmePath;

    private final DefinitionRepository definitionRepository;

    private final String readmeUri;

    private CreateWorkflowVersionRequest(BuilderImpl builder) {
        super(builder);
        this.workflowId = builder.workflowId;
        this.versionName = builder.versionName;
        this.definitionZip = builder.definitionZip;
        this.definitionUri = builder.definitionUri;
        this.accelerators = builder.accelerators;
        this.description = builder.description;
        this.engine = builder.engine;
        this.main = builder.main;
        this.parameterTemplate = builder.parameterTemplate;
        this.requestIdValue = builder.requestIdValue;
        this.storageType = builder.storageType;
        this.storageCapacity = builder.storageCapacity;
        this.tags = builder.tags;
        this.workflowBucketOwnerId = builder.workflowBucketOwnerId;
        this.containerRegistryMap = builder.containerRegistryMap;
        this.containerRegistryMapUri = builder.containerRegistryMapUri;
        this.readmeMarkdown = builder.readmeMarkdown;
        this.parameterTemplatePath = builder.parameterTemplatePath;
        this.readmePath = builder.readmePath;
        this.definitionRepository = builder.definitionRepository;
        this.readmeUri = builder.readmeUri;
    }

    /**
     * <p>
     * The ID of the workflow where you are creating the new version. The <code>workflowId</code> is not the UUID.
     * </p>
     * 
     * @return The ID of the workflow where you are creating the new version. The <code>workflowId</code> is not the
     *         UUID.
     */
    public final String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * A name for the workflow version. Provide a version name that is unique for this workflow. You cannot change the
     * name after HealthOmics creates the version.
     * </p>
     * <p>
     * The version name must start with a letter or number and it can include upper-case and lower-case letters,
     * numbers, hyphens, periods and underscores. The maximum length is 64 characters. You can use a simple naming
     * scheme, such as version1, version2, version3. You can also match your workflow versions with your own internal
     * versioning conventions, such as 2.7.0, 2.7.1, 2.7.2.
     * </p>
     * 
     * @return A name for the workflow version. Provide a version name that is unique for this workflow. You cannot
     *         change the name after HealthOmics creates the version. </p>
     *         <p>
     *         The version name must start with a letter or number and it can include upper-case and lower-case letters,
     *         numbers, hyphens, periods and underscores. The maximum length is 64 characters. You can use a simple
     *         naming scheme, such as version1, version2, version3. You can also match your workflow versions with your
     *         own internal versioning conventions, such as 2.7.0, 2.7.1, 2.7.2.
     */
    public final String versionName() {
        return versionName;
    }

    /**
     * <p>
     * A ZIP archive containing the main workflow definition file and dependencies that it imports for this workflow
     * version. You can use a file with a ://fileb prefix instead of the Base64 string. For more information, see
     * Workflow definition requirements in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * 
     * @return A ZIP archive containing the main workflow definition file and dependencies that it imports for this
     *         workflow version. You can use a file with a ://fileb prefix instead of the Base64 string. For more
     *         information, see Workflow definition requirements in the <i>Amazon Web Services HealthOmics User
     *         Guide</i>.
     */
    public final SdkBytes definitionZip() {
        return definitionZip;
    }

    /**
     * <p>
     * The S3 URI of a definition for this workflow version. The S3 bucket must be in the same region as this workflow
     * version.
     * </p>
     * 
     * @return The S3 URI of a definition for this workflow version. The S3 bucket must be in the same region as this
     *         workflow version.
     */
    public final String definitionUri() {
        return definitionUri;
    }

    /**
     * <p>
     * The computational accelerator for this workflow version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accelerators} will
     * return {@link Accelerators#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #acceleratorsAsString}.
     * </p>
     * 
     * @return The computational accelerator for this workflow version.
     * @see Accelerators
     */
    public final Accelerators accelerators() {
        return Accelerators.fromValue(accelerators);
    }

    /**
     * <p>
     * The computational accelerator for this workflow version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accelerators} will
     * return {@link Accelerators#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #acceleratorsAsString}.
     * </p>
     * 
     * @return The computational accelerator for this workflow version.
     * @see Accelerators
     */
    public final String acceleratorsAsString() {
        return accelerators;
    }

    /**
     * <p>
     * A description for this workflow version.
     * </p>
     * 
     * @return A description for this workflow version.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The workflow engine for this workflow version. This is only required if you have workflow definition files from
     * more than one engine in your zip file. Otherwise, the service can detect the engine automatically from your
     * workflow definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engine} will
     * return {@link WorkflowEngine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineAsString}.
     * </p>
     * 
     * @return The workflow engine for this workflow version. This is only required if you have workflow definition
     *         files from more than one engine in your zip file. Otherwise, the service can detect the engine
     *         automatically from your workflow definition.
     * @see WorkflowEngine
     */
    public final WorkflowEngine engine() {
        return WorkflowEngine.fromValue(engine);
    }

    /**
     * <p>
     * The workflow engine for this workflow version. This is only required if you have workflow definition files from
     * more than one engine in your zip file. Otherwise, the service can detect the engine automatically from your
     * workflow definition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engine} will
     * return {@link WorkflowEngine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineAsString}.
     * </p>
     * 
     * @return The workflow engine for this workflow version. This is only required if you have workflow definition
     *         files from more than one engine in your zip file. Otherwise, the service can detect the engine
     *         automatically from your workflow definition.
     * @see WorkflowEngine
     */
    public final String engineAsString() {
        return engine;
    }

    /**
     * <p>
     * The path of the main definition file for this workflow version. This parameter is not required if the ZIP archive
     * contains only one workflow definition file, or if the main definition file is named “main”. An example path is:
     * <code>workflow-definition/main-file.wdl</code>.
     * </p>
     * 
     * @return The path of the main definition file for this workflow version. This parameter is not required if the ZIP
     *         archive contains only one workflow definition file, or if the main definition file is named “main”. An
     *         example path is: <code>workflow-definition/main-file.wdl</code>.
     */
    public final String main() {
        return main;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParameterTemplate property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasParameterTemplate() {
        return parameterTemplate != null && !(parameterTemplate instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * A parameter template for this workflow version. If this field is blank, Amazon Web Services HealthOmics will
     * automatically parse the parameter template values from your workflow definition file. To override these service
     * generated default values, provide a parameter template. To view an example of a parameter template, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/parameter-templates.html">Parameter template files</a> in the
     * <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameterTemplate} method.
     * </p>
     * 
     * @return A parameter template for this workflow version. If this field is blank, Amazon Web Services HealthOmics
     *         will automatically parse the parameter template values from your workflow definition file. To override
     *         these service generated default values, provide a parameter template. To view an example of a parameter
     *         template, see <a href="https://docs.aws.amazon.com/omics/latest/dev/parameter-templates.html">Parameter
     *         template files</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     */
    public final Map<String, WorkflowParameter> parameterTemplate() {
        return parameterTemplate;
    }

    /**
     * <p>
     * An idempotency token to ensure that duplicate workflows are not created when Amazon Web Services HealthOmics
     * submits retry requests.
     * </p>
     * 
     * @return An idempotency token to ensure that duplicate workflows are not created when Amazon Web Services
     *         HealthOmics submits retry requests.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * <p>
     * The default storage type for runs that use this workflow version. The <code>storageType</code> can be overridden
     * at run time. <code>DYNAMIC</code> storage dynamically scales the storage up or down, based on file system
     * utilization. STATIC storage allocates a fixed amount of storage. For more information about dynamic and static
     * storage types, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflows-run-types.html">Run storage
     * types</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The default storage type for runs that use this workflow version. The <code>storageType</code> can be
     *         overridden at run time. <code>DYNAMIC</code> storage dynamically scales the storage up or down, based on
     *         file system utilization. STATIC storage allocates a fixed amount of storage. For more information about
     *         dynamic and static storage types, see <a
     *         href="https://docs.aws.amazon.com/omics/latest/dev/workflows-run-types.html">Run storage types</a> in the
     *         <i>Amazon Web Services HealthOmics User Guide</i>.
     * @see StorageType
     */
    public final StorageType storageType() {
        return StorageType.fromValue(storageType);
    }

    /**
     * <p>
     * The default storage type for runs that use this workflow version. The <code>storageType</code> can be overridden
     * at run time. <code>DYNAMIC</code> storage dynamically scales the storage up or down, based on file system
     * utilization. STATIC storage allocates a fixed amount of storage. For more information about dynamic and static
     * storage types, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflows-run-types.html">Run storage
     * types</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The default storage type for runs that use this workflow version. The <code>storageType</code> can be
     *         overridden at run time. <code>DYNAMIC</code> storage dynamically scales the storage up or down, based on
     *         file system utilization. STATIC storage allocates a fixed amount of storage. For more information about
     *         dynamic and static storage types, see <a
     *         href="https://docs.aws.amazon.com/omics/latest/dev/workflows-run-types.html">Run storage types</a> in the
     *         <i>Amazon Web Services HealthOmics User Guide</i>.
     * @see StorageType
     */
    public final String storageTypeAsString() {
        return storageType;
    }

    /**
     * <p>
     * The default static storage capacity (in gibibytes) for runs that use this workflow version. The
     * <code>storageCapacity</code> can be overwritten at run time. The storage capacity is not required for runs with a
     * <code>DYNAMIC</code> storage type.
     * </p>
     * 
     * @return The default static storage capacity (in gibibytes) for runs that use this workflow version. The
     *         <code>storageCapacity</code> can be overwritten at run time. The storage capacity is not required for
     *         runs with a <code>DYNAMIC</code> storage type.
     */
    public final Integer storageCapacity() {
        return storageCapacity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags for this workflow version. You can define up to 50 tags for the workflow. For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/add-a-tag.html">Adding a tag</a> in the <i>Amazon Web Services
     * HealthOmics User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags for this workflow version. You can define up to 50 tags for the workflow. For more information, see
     *         <a href="https://docs.aws.amazon.com/omics/latest/dev/add-a-tag.html">Adding a tag</a> in the <i>Amazon
     *         Web Services HealthOmics User Guide</i>.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * Amazon Web Services Id of the owner of the S3 bucket that contains the workflow definition. You need to specify
     * this parameter if your account is not the bucket owner.
     * </p>
     * 
     * @return Amazon Web Services Id of the owner of the S3 bucket that contains the workflow definition. You need to
     *         specify this parameter if your account is not the bucket owner.
     */
    public final String workflowBucketOwnerId() {
        return workflowBucketOwnerId;
    }

    /**
     * <p>
     * (Optional) Use a container registry map to specify mappings between the ECR private repository and one or more
     * upstream registries. For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/workflows-ecr.html">Container images</a> in the <i>Amazon Web
     * Services HealthOmics User Guide</i>.
     * </p>
     * 
     * @return (Optional) Use a container registry map to specify mappings between the ECR private repository and one or
     *         more upstream registries. For more information, see <a
     *         href="https://docs.aws.amazon.com/omics/latest/dev/workflows-ecr.html">Container images</a> in the
     *         <i>Amazon Web Services HealthOmics User Guide</i>.
     */
    public final ContainerRegistryMap containerRegistryMap() {
        return containerRegistryMap;
    }

    /**
     * <p>
     * (Optional) URI of the S3 location for the registry mapping file.
     * </p>
     * 
     * @return (Optional) URI of the S3 location for the registry mapping file.
     */
    public final String containerRegistryMapUri() {
        return containerRegistryMapUri;
    }

    /**
     * <p>
     * The markdown content for the workflow version's README file. This provides documentation and usage information
     * for users of this specific workflow version.
     * </p>
     * 
     * @return The markdown content for the workflow version's README file. This provides documentation and usage
     *         information for users of this specific workflow version.
     */
    public final String readmeMarkdown() {
        return readmeMarkdown;
    }

    /**
     * <p>
     * The path to the workflow version parameter template JSON file within the repository. This file defines the input
     * parameters for runs that use this workflow version. If not specified, the workflow version will be created
     * without a parameter template.
     * </p>
     * 
     * @return The path to the workflow version parameter template JSON file within the repository. This file defines
     *         the input parameters for runs that use this workflow version. If not specified, the workflow version will
     *         be created without a parameter template.
     */
    public final String parameterTemplatePath() {
        return parameterTemplatePath;
    }

    /**
     * <p>
     * The path to the workflow version README markdown file within the repository. This file provides documentation and
     * usage information for the workflow. If not specified, the <code>README.md</code> file from the root directory of
     * the repository will be used.
     * </p>
     * 
     * @return The path to the workflow version README markdown file within the repository. This file provides
     *         documentation and usage information for the workflow. If not specified, the <code>README.md</code> file
     *         from the root directory of the repository will be used.
     */
    public final String readmePath() {
        return readmePath;
    }

    /**
     * <p>
     * The repository information for the workflow version definition. This allows you to source your workflow version
     * definition directly from a code repository.
     * </p>
     * 
     * @return The repository information for the workflow version definition. This allows you to source your workflow
     *         version definition directly from a code repository.
     */
    public final DefinitionRepository definitionRepository() {
        return definitionRepository;
    }

    /**
     * <p>
     * The S3 URI of the README file for the workflow version. This file provides documentation and usage information
     * for the workflow version. Requirements include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The S3 URI must begin with <code>s3://USER-OWNED-BUCKET/</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * The requester must have access to the S3 bucket and object.
     * </p>
     * </li>
     * <li>
     * <p>
     * The max README content length is 500 KiB.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The S3 URI of the README file for the workflow version. This file provides documentation and usage
     *         information for the workflow version. Requirements include:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         The S3 URI must begin with <code>s3://USER-OWNED-BUCKET/</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The requester must have access to the S3 bucket and object.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         The max README content length is 500 KiB.
     *         </p>
     *         </li>
     */
    public final String readmeUri() {
        return readmeUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(definitionZip());
        hashCode = 31 * hashCode + Objects.hashCode(definitionUri());
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(engineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(main());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameterTemplate() ? parameterTemplate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workflowBucketOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(containerRegistryMap());
        hashCode = 31 * hashCode + Objects.hashCode(containerRegistryMapUri());
        hashCode = 31 * hashCode + Objects.hashCode(readmeMarkdown());
        hashCode = 31 * hashCode + Objects.hashCode(parameterTemplatePath());
        hashCode = 31 * hashCode + Objects.hashCode(readmePath());
        hashCode = 31 * hashCode + Objects.hashCode(definitionRepository());
        hashCode = 31 * hashCode + Objects.hashCode(readmeUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateWorkflowVersionRequest)) {
            return false;
        }
        CreateWorkflowVersionRequest other = (CreateWorkflowVersionRequest) obj;
        return Objects.equals(workflowId(), other.workflowId()) && Objects.equals(versionName(), other.versionName())
                && Objects.equals(definitionZip(), other.definitionZip())
                && Objects.equals(definitionUri(), other.definitionUri())
                && Objects.equals(acceleratorsAsString(), other.acceleratorsAsString())
                && Objects.equals(description(), other.description()) && Objects.equals(engineAsString(), other.engineAsString())
                && Objects.equals(main(), other.main()) && hasParameterTemplate() == other.hasParameterTemplate()
                && Objects.equals(parameterTemplate(), other.parameterTemplate())
                && Objects.equals(requestId(), other.requestId())
                && Objects.equals(storageTypeAsString(), other.storageTypeAsString())
                && Objects.equals(storageCapacity(), other.storageCapacity()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(workflowBucketOwnerId(), other.workflowBucketOwnerId())
                && Objects.equals(containerRegistryMap(), other.containerRegistryMap())
                && Objects.equals(containerRegistryMapUri(), other.containerRegistryMapUri())
                && Objects.equals(readmeMarkdown(), other.readmeMarkdown())
                && Objects.equals(parameterTemplatePath(), other.parameterTemplatePath())
                && Objects.equals(readmePath(), other.readmePath())
                && Objects.equals(definitionRepository(), other.definitionRepository())
                && Objects.equals(readmeUri(), other.readmeUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateWorkflowVersionRequest").add("WorkflowId", workflowId()).add("VersionName", versionName())
                .add("DefinitionZip", definitionZip()).add("DefinitionUri", definitionUri())
                .add("Accelerators", acceleratorsAsString()).add("Description", description()).add("Engine", engineAsString())
                .add("Main", main()).add("ParameterTemplate", hasParameterTemplate() ? parameterTemplate() : null)
                .add("RequestId", requestId()).add("StorageType", storageTypeAsString())
                .add("StorageCapacity", storageCapacity()).add("Tags", hasTags() ? tags() : null)
                .add("WorkflowBucketOwnerId", workflowBucketOwnerId()).add("ContainerRegistryMap", containerRegistryMap())
                .add("ContainerRegistryMapUri", containerRegistryMapUri()).add("ReadmeMarkdown", readmeMarkdown())
                .add("ParameterTemplatePath", parameterTemplatePath()).add("ReadmePath", readmePath())
                .add("DefinitionRepository", definitionRepository()).add("ReadmeUri", readmeUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        case "versionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "definitionZip":
            return Optional.ofNullable(clazz.cast(definitionZip()));
        case "definitionUri":
            return Optional.ofNullable(clazz.cast(definitionUri()));
        case "accelerators":
            return Optional.ofNullable(clazz.cast(acceleratorsAsString()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "engine":
            return Optional.ofNullable(clazz.cast(engineAsString()));
        case "main":
            return Optional.ofNullable(clazz.cast(main()));
        case "parameterTemplate":
            return Optional.ofNullable(clazz.cast(parameterTemplate()));
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "storageType":
            return Optional.ofNullable(clazz.cast(storageTypeAsString()));
        case "storageCapacity":
            return Optional.ofNullable(clazz.cast(storageCapacity()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "workflowBucketOwnerId":
            return Optional.ofNullable(clazz.cast(workflowBucketOwnerId()));
        case "containerRegistryMap":
            return Optional.ofNullable(clazz.cast(containerRegistryMap()));
        case "containerRegistryMapUri":
            return Optional.ofNullable(clazz.cast(containerRegistryMapUri()));
        case "readmeMarkdown":
            return Optional.ofNullable(clazz.cast(readmeMarkdown()));
        case "parameterTemplatePath":
            return Optional.ofNullable(clazz.cast(parameterTemplatePath()));
        case "readmePath":
            return Optional.ofNullable(clazz.cast(readmePath()));
        case "definitionRepository":
            return Optional.ofNullable(clazz.cast(definitionRepository()));
        case "readmeUri":
            return Optional.ofNullable(clazz.cast(readmeUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workflowId", WORKFLOW_ID_FIELD);
        map.put("versionName", VERSION_NAME_FIELD);
        map.put("definitionZip", DEFINITION_ZIP_FIELD);
        map.put("definitionUri", DEFINITION_URI_FIELD);
        map.put("accelerators", ACCELERATORS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("engine", ENGINE_FIELD);
        map.put("main", MAIN_FIELD);
        map.put("parameterTemplate", PARAMETER_TEMPLATE_FIELD);
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("storageType", STORAGE_TYPE_FIELD);
        map.put("storageCapacity", STORAGE_CAPACITY_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("workflowBucketOwnerId", WORKFLOW_BUCKET_OWNER_ID_FIELD);
        map.put("containerRegistryMap", CONTAINER_REGISTRY_MAP_FIELD);
        map.put("containerRegistryMapUri", CONTAINER_REGISTRY_MAP_URI_FIELD);
        map.put("readmeMarkdown", README_MARKDOWN_FIELD);
        map.put("parameterTemplatePath", PARAMETER_TEMPLATE_PATH_FIELD);
        map.put("readmePath", README_PATH_FIELD);
        map.put("definitionRepository", DEFINITION_REPOSITORY_FIELD);
        map.put("readmeUri", README_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateWorkflowVersionRequest, T> g) {
        return obj -> g.apply((CreateWorkflowVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateWorkflowVersionRequest> {
        /**
         * <p>
         * The ID of the workflow where you are creating the new version. The <code>workflowId</code> is not the UUID.
         * </p>
         * 
         * @param workflowId
         *        The ID of the workflow where you are creating the new version. The <code>workflowId</code> is not the
         *        UUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * A name for the workflow version. Provide a version name that is unique for this workflow. You cannot change
         * the name after HealthOmics creates the version.
         * </p>
         * <p>
         * The version name must start with a letter or number and it can include upper-case and lower-case letters,
         * numbers, hyphens, periods and underscores. The maximum length is 64 characters. You can use a simple naming
         * scheme, such as version1, version2, version3. You can also match your workflow versions with your own
         * internal versioning conventions, such as 2.7.0, 2.7.1, 2.7.2.
         * </p>
         * 
         * @param versionName
         *        A name for the workflow version. Provide a version name that is unique for this workflow. You cannot
         *        change the name after HealthOmics creates the version. </p>
         *        <p>
         *        The version name must start with a letter or number and it can include upper-case and lower-case
         *        letters, numbers, hyphens, periods and underscores. The maximum length is 64 characters. You can use a
         *        simple naming scheme, such as version1, version2, version3. You can also match your workflow versions
         *        with your own internal versioning conventions, such as 2.7.0, 2.7.1, 2.7.2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * <p>
         * A ZIP archive containing the main workflow definition file and dependencies that it imports for this workflow
         * version. You can use a file with a ://fileb prefix instead of the Base64 string. For more information, see
         * Workflow definition requirements in the <i>Amazon Web Services HealthOmics User Guide</i>.
         * </p>
         * 
         * @param definitionZip
         *        A ZIP archive containing the main workflow definition file and dependencies that it imports for this
         *        workflow version. You can use a file with a ://fileb prefix instead of the Base64 string. For more
         *        information, see Workflow definition requirements in the <i>Amazon Web Services HealthOmics User
         *        Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definitionZip(SdkBytes definitionZip);

        /**
         * <p>
         * The S3 URI of a definition for this workflow version. The S3 bucket must be in the same region as this
         * workflow version.
         * </p>
         * 
         * @param definitionUri
         *        The S3 URI of a definition for this workflow version. The S3 bucket must be in the same region as this
         *        workflow version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definitionUri(String definitionUri);

        /**
         * <p>
         * The computational accelerator for this workflow version.
         * </p>
         * 
         * @param accelerators
         *        The computational accelerator for this workflow version.
         * @see Accelerators
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Accelerators
         */
        Builder accelerators(String accelerators);

        /**
         * <p>
         * The computational accelerator for this workflow version.
         * </p>
         * 
         * @param accelerators
         *        The computational accelerator for this workflow version.
         * @see Accelerators
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Accelerators
         */
        Builder accelerators(Accelerators accelerators);

        /**
         * <p>
         * A description for this workflow version.
         * </p>
         * 
         * @param description
         *        A description for this workflow version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The workflow engine for this workflow version. This is only required if you have workflow definition files
         * from more than one engine in your zip file. Otherwise, the service can detect the engine automatically from
         * your workflow definition.
         * </p>
         * 
         * @param engine
         *        The workflow engine for this workflow version. This is only required if you have workflow definition
         *        files from more than one engine in your zip file. Otherwise, the service can detect the engine
         *        automatically from your workflow definition.
         * @see WorkflowEngine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowEngine
         */
        Builder engine(String engine);

        /**
         * <p>
         * The workflow engine for this workflow version. This is only required if you have workflow definition files
         * from more than one engine in your zip file. Otherwise, the service can detect the engine automatically from
         * your workflow definition.
         * </p>
         * 
         * @param engine
         *        The workflow engine for this workflow version. This is only required if you have workflow definition
         *        files from more than one engine in your zip file. Otherwise, the service can detect the engine
         *        automatically from your workflow definition.
         * @see WorkflowEngine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowEngine
         */
        Builder engine(WorkflowEngine engine);

        /**
         * <p>
         * The path of the main definition file for this workflow version. This parameter is not required if the ZIP
         * archive contains only one workflow definition file, or if the main definition file is named “main”. An
         * example path is: <code>workflow-definition/main-file.wdl</code>.
         * </p>
         * 
         * @param main
         *        The path of the main definition file for this workflow version. This parameter is not required if the
         *        ZIP archive contains only one workflow definition file, or if the main definition file is named
         *        “main”. An example path is: <code>workflow-definition/main-file.wdl</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder main(String main);

        /**
         * <p>
         * A parameter template for this workflow version. If this field is blank, Amazon Web Services HealthOmics will
         * automatically parse the parameter template values from your workflow definition file. To override these
         * service generated default values, provide a parameter template. To view an example of a parameter template,
         * see <a href="https://docs.aws.amazon.com/omics/latest/dev/parameter-templates.html">Parameter template
         * files</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
         * </p>
         * 
         * @param parameterTemplate
         *        A parameter template for this workflow version. If this field is blank, Amazon Web Services
         *        HealthOmics will automatically parse the parameter template values from your workflow definition file.
         *        To override these service generated default values, provide a parameter template. To view an example
         *        of a parameter template, see <a
         *        href="https://docs.aws.amazon.com/omics/latest/dev/parameter-templates.html">Parameter template
         *        files</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterTemplate(Map<String, WorkflowParameter> parameterTemplate);

        /**
         * <p>
         * An idempotency token to ensure that duplicate workflows are not created when Amazon Web Services HealthOmics
         * submits retry requests.
         * </p>
         * 
         * @param requestIdValue
         *        An idempotency token to ensure that duplicate workflows are not created when Amazon Web Services
         *        HealthOmics submits retry requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * The default storage type for runs that use this workflow version. The <code>storageType</code> can be
         * overridden at run time. <code>DYNAMIC</code> storage dynamically scales the storage up or down, based on file
         * system utilization. STATIC storage allocates a fixed amount of storage. For more information about dynamic
         * and static storage types, see <a
         * href="https://docs.aws.amazon.com/omics/latest/dev/workflows-run-types.html">Run storage types</a> in the
         * <i>Amazon Web Services HealthOmics User Guide</i>.
         * </p>
         * 
         * @param storageType
         *        The default storage type for runs that use this workflow version. The <code>storageType</code> can be
         *        overridden at run time. <code>DYNAMIC</code> storage dynamically scales the storage up or down, based
         *        on file system utilization. STATIC storage allocates a fixed amount of storage. For more information
         *        about dynamic and static storage types, see <a
         *        href="https://docs.aws.amazon.com/omics/latest/dev/workflows-run-types.html">Run storage types</a> in
         *        the <i>Amazon Web Services HealthOmics User Guide</i>.
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The default storage type for runs that use this workflow version. The <code>storageType</code> can be
         * overridden at run time. <code>DYNAMIC</code> storage dynamically scales the storage up or down, based on file
         * system utilization. STATIC storage allocates a fixed amount of storage. For more information about dynamic
         * and static storage types, see <a
         * href="https://docs.aws.amazon.com/omics/latest/dev/workflows-run-types.html">Run storage types</a> in the
         * <i>Amazon Web Services HealthOmics User Guide</i>.
         * </p>
         * 
         * @param storageType
         *        The default storage type for runs that use this workflow version. The <code>storageType</code> can be
         *        overridden at run time. <code>DYNAMIC</code> storage dynamically scales the storage up or down, based
         *        on file system utilization. STATIC storage allocates a fixed amount of storage. For more information
         *        about dynamic and static storage types, see <a
         *        href="https://docs.aws.amazon.com/omics/latest/dev/workflows-run-types.html">Run storage types</a> in
         *        the <i>Amazon Web Services HealthOmics User Guide</i>.
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(StorageType storageType);

        /**
         * <p>
         * The default static storage capacity (in gibibytes) for runs that use this workflow version. The
         * <code>storageCapacity</code> can be overwritten at run time. The storage capacity is not required for runs
         * with a <code>DYNAMIC</code> storage type.
         * </p>
         * 
         * @param storageCapacity
         *        The default static storage capacity (in gibibytes) for runs that use this workflow version. The
         *        <code>storageCapacity</code> can be overwritten at run time. The storage capacity is not required for
         *        runs with a <code>DYNAMIC</code> storage type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCapacity(Integer storageCapacity);

        /**
         * <p>
         * Tags for this workflow version. You can define up to 50 tags for the workflow. For more information, see <a
         * href="https://docs.aws.amazon.com/omics/latest/dev/add-a-tag.html">Adding a tag</a> in the <i>Amazon Web
         * Services HealthOmics User Guide</i>.
         * </p>
         * 
         * @param tags
         *        Tags for this workflow version. You can define up to 50 tags for the workflow. For more information,
         *        see <a href="https://docs.aws.amazon.com/omics/latest/dev/add-a-tag.html">Adding a tag</a> in the
         *        <i>Amazon Web Services HealthOmics User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Amazon Web Services Id of the owner of the S3 bucket that contains the workflow definition. You need to
         * specify this parameter if your account is not the bucket owner.
         * </p>
         * 
         * @param workflowBucketOwnerId
         *        Amazon Web Services Id of the owner of the S3 bucket that contains the workflow definition. You need
         *        to specify this parameter if your account is not the bucket owner.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowBucketOwnerId(String workflowBucketOwnerId);

        /**
         * <p>
         * (Optional) Use a container registry map to specify mappings between the ECR private repository and one or
         * more upstream registries. For more information, see <a
         * href="https://docs.aws.amazon.com/omics/latest/dev/workflows-ecr.html">Container images</a> in the <i>Amazon
         * Web Services HealthOmics User Guide</i>.
         * </p>
         * 
         * @param containerRegistryMap
         *        (Optional) Use a container registry map to specify mappings between the ECR private repository and one
         *        or more upstream registries. For more information, see <a
         *        href="https://docs.aws.amazon.com/omics/latest/dev/workflows-ecr.html">Container images</a> in the
         *        <i>Amazon Web Services HealthOmics User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerRegistryMap(ContainerRegistryMap containerRegistryMap);

        /**
         * <p>
         * (Optional) Use a container registry map to specify mappings between the ECR private repository and one or
         * more upstream registries. For more information, see <a
         * href="https://docs.aws.amazon.com/omics/latest/dev/workflows-ecr.html">Container images</a> in the <i>Amazon
         * Web Services HealthOmics User Guide</i>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContainerRegistryMap.Builder} avoiding
         * the need to create one manually via {@link ContainerRegistryMap#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerRegistryMap.Builder#build()} is called immediately and
         * its result is passed to {@link #containerRegistryMap(ContainerRegistryMap)}.
         * 
         * @param containerRegistryMap
         *        a consumer that will call methods on {@link ContainerRegistryMap.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerRegistryMap(ContainerRegistryMap)
         */
        default Builder containerRegistryMap(Consumer<ContainerRegistryMap.Builder> containerRegistryMap) {
            return containerRegistryMap(ContainerRegistryMap.builder().applyMutation(containerRegistryMap).build());
        }

        /**
         * <p>
         * (Optional) URI of the S3 location for the registry mapping file.
         * </p>
         * 
         * @param containerRegistryMapUri
         *        (Optional) URI of the S3 location for the registry mapping file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerRegistryMapUri(String containerRegistryMapUri);

        /**
         * <p>
         * The markdown content for the workflow version's README file. This provides documentation and usage
         * information for users of this specific workflow version.
         * </p>
         * 
         * @param readmeMarkdown
         *        The markdown content for the workflow version's README file. This provides documentation and usage
         *        information for users of this specific workflow version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readmeMarkdown(String readmeMarkdown);

        /**
         * <p>
         * The path to the workflow version parameter template JSON file within the repository. This file defines the
         * input parameters for runs that use this workflow version. If not specified, the workflow version will be
         * created without a parameter template.
         * </p>
         * 
         * @param parameterTemplatePath
         *        The path to the workflow version parameter template JSON file within the repository. This file defines
         *        the input parameters for runs that use this workflow version. If not specified, the workflow version
         *        will be created without a parameter template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterTemplatePath(String parameterTemplatePath);

        /**
         * <p>
         * The path to the workflow version README markdown file within the repository. This file provides documentation
         * and usage information for the workflow. If not specified, the <code>README.md</code> file from the root
         * directory of the repository will be used.
         * </p>
         * 
         * @param readmePath
         *        The path to the workflow version README markdown file within the repository. This file provides
         *        documentation and usage information for the workflow. If not specified, the <code>README.md</code>
         *        file from the root directory of the repository will be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readmePath(String readmePath);

        /**
         * <p>
         * The repository information for the workflow version definition. This allows you to source your workflow
         * version definition directly from a code repository.
         * </p>
         * 
         * @param definitionRepository
         *        The repository information for the workflow version definition. This allows you to source your
         *        workflow version definition directly from a code repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definitionRepository(DefinitionRepository definitionRepository);

        /**
         * <p>
         * The repository information for the workflow version definition. This allows you to source your workflow
         * version definition directly from a code repository.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefinitionRepository.Builder} avoiding
         * the need to create one manually via {@link DefinitionRepository#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefinitionRepository.Builder#build()} is called immediately and
         * its result is passed to {@link #definitionRepository(DefinitionRepository)}.
         * 
         * @param definitionRepository
         *        a consumer that will call methods on {@link DefinitionRepository.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definitionRepository(DefinitionRepository)
         */
        default Builder definitionRepository(Consumer<DefinitionRepository.Builder> definitionRepository) {
            return definitionRepository(DefinitionRepository.builder().applyMutation(definitionRepository).build());
        }

        /**
         * <p>
         * The S3 URI of the README file for the workflow version. This file provides documentation and usage
         * information for the workflow version. Requirements include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * The S3 URI must begin with <code>s3://USER-OWNED-BUCKET/</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * The requester must have access to the S3 bucket and object.
         * </p>
         * </li>
         * <li>
         * <p>
         * The max README content length is 500 KiB.
         * </p>
         * </li>
         * </ul>
         * 
         * @param readmeUri
         *        The S3 URI of the README file for the workflow version. This file provides documentation and usage
         *        information for the workflow version. Requirements include:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        The S3 URI must begin with <code>s3://USER-OWNED-BUCKET/</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The requester must have access to the S3 bucket and object.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        The max README content length is 500 KiB.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readmeUri(String readmeUri);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String workflowId;

        private String versionName;

        private SdkBytes definitionZip;

        private String definitionUri;

        private String accelerators;

        private String description;

        private String engine;

        private String main;

        private Map<String, WorkflowParameter> parameterTemplate = DefaultSdkAutoConstructMap.getInstance();

        private String requestIdValue;

        private String storageType;

        private Integer storageCapacity;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String workflowBucketOwnerId;

        private ContainerRegistryMap containerRegistryMap;

        private String containerRegistryMapUri;

        private String readmeMarkdown;

        private String parameterTemplatePath;

        private String readmePath;

        private DefinitionRepository definitionRepository;

        private String readmeUri;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateWorkflowVersionRequest model) {
            super(model);
            workflowId(model.workflowId);
            versionName(model.versionName);
            definitionZip(model.definitionZip);
            definitionUri(model.definitionUri);
            accelerators(model.accelerators);
            description(model.description);
            engine(model.engine);
            main(model.main);
            parameterTemplate(model.parameterTemplate);
            requestId(model.requestIdValue);
            storageType(model.storageType);
            storageCapacity(model.storageCapacity);
            tags(model.tags);
            workflowBucketOwnerId(model.workflowBucketOwnerId);
            containerRegistryMap(model.containerRegistryMap);
            containerRegistryMapUri(model.containerRegistryMapUri);
            readmeMarkdown(model.readmeMarkdown);
            parameterTemplatePath(model.parameterTemplatePath);
            readmePath(model.readmePath);
            definitionRepository(model.definitionRepository);
            readmeUri(model.readmeUri);
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getVersionName() {
            return versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final ByteBuffer getDefinitionZip() {
            return definitionZip == null ? null : definitionZip.asByteBuffer();
        }

        public final void setDefinitionZip(ByteBuffer definitionZip) {
            definitionZip(definitionZip == null ? null : SdkBytes.fromByteBuffer(definitionZip));
        }

        @Override
        public final Builder definitionZip(SdkBytes definitionZip) {
            this.definitionZip = definitionZip;
            return this;
        }

        public final String getDefinitionUri() {
            return definitionUri;
        }

        public final void setDefinitionUri(String definitionUri) {
            this.definitionUri = definitionUri;
        }

        @Override
        public final Builder definitionUri(String definitionUri) {
            this.definitionUri = definitionUri;
            return this;
        }

        public final String getAccelerators() {
            return accelerators;
        }

        public final void setAccelerators(String accelerators) {
            this.accelerators = accelerators;
        }

        @Override
        public final Builder accelerators(String accelerators) {
            this.accelerators = accelerators;
            return this;
        }

        @Override
        public final Builder accelerators(Accelerators accelerators) {
            this.accelerators(accelerators == null ? null : accelerators.toString());
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        @Override
        public final Builder engine(WorkflowEngine engine) {
            this.engine(engine == null ? null : engine.toString());
            return this;
        }

        public final String getMain() {
            return main;
        }

        public final void setMain(String main) {
            this.main = main;
        }

        @Override
        public final Builder main(String main) {
            this.main = main;
            return this;
        }

        public final Map<String, WorkflowParameter.Builder> getParameterTemplate() {
            Map<String, WorkflowParameter.Builder> result = WorkflowParameterTemplateCopier.copyToBuilder(this.parameterTemplate);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameterTemplate(Map<String, WorkflowParameter.BuilderImpl> parameterTemplate) {
            this.parameterTemplate = WorkflowParameterTemplateCopier.copyFromBuilder(parameterTemplate);
        }

        @Override
        public final Builder parameterTemplate(Map<String, WorkflowParameter> parameterTemplate) {
            this.parameterTemplate = WorkflowParameterTemplateCopier.copy(parameterTemplate);
            return this;
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final Integer getStorageCapacity() {
            return storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getWorkflowBucketOwnerId() {
            return workflowBucketOwnerId;
        }

        public final void setWorkflowBucketOwnerId(String workflowBucketOwnerId) {
            this.workflowBucketOwnerId = workflowBucketOwnerId;
        }

        @Override
        public final Builder workflowBucketOwnerId(String workflowBucketOwnerId) {
            this.workflowBucketOwnerId = workflowBucketOwnerId;
            return this;
        }

        public final ContainerRegistryMap.Builder getContainerRegistryMap() {
            return containerRegistryMap != null ? containerRegistryMap.toBuilder() : null;
        }

        public final void setContainerRegistryMap(ContainerRegistryMap.BuilderImpl containerRegistryMap) {
            this.containerRegistryMap = containerRegistryMap != null ? containerRegistryMap.build() : null;
        }

        @Override
        public final Builder containerRegistryMap(ContainerRegistryMap containerRegistryMap) {
            this.containerRegistryMap = containerRegistryMap;
            return this;
        }

        public final String getContainerRegistryMapUri() {
            return containerRegistryMapUri;
        }

        public final void setContainerRegistryMapUri(String containerRegistryMapUri) {
            this.containerRegistryMapUri = containerRegistryMapUri;
        }

        @Override
        public final Builder containerRegistryMapUri(String containerRegistryMapUri) {
            this.containerRegistryMapUri = containerRegistryMapUri;
            return this;
        }

        public final String getReadmeMarkdown() {
            return readmeMarkdown;
        }

        public final void setReadmeMarkdown(String readmeMarkdown) {
            this.readmeMarkdown = readmeMarkdown;
        }

        @Override
        public final Builder readmeMarkdown(String readmeMarkdown) {
            this.readmeMarkdown = readmeMarkdown;
            return this;
        }

        public final String getParameterTemplatePath() {
            return parameterTemplatePath;
        }

        public final void setParameterTemplatePath(String parameterTemplatePath) {
            this.parameterTemplatePath = parameterTemplatePath;
        }

        @Override
        public final Builder parameterTemplatePath(String parameterTemplatePath) {
            this.parameterTemplatePath = parameterTemplatePath;
            return this;
        }

        public final String getReadmePath() {
            return readmePath;
        }

        public final void setReadmePath(String readmePath) {
            this.readmePath = readmePath;
        }

        @Override
        public final Builder readmePath(String readmePath) {
            this.readmePath = readmePath;
            return this;
        }

        public final DefinitionRepository.Builder getDefinitionRepository() {
            return definitionRepository != null ? definitionRepository.toBuilder() : null;
        }

        public final void setDefinitionRepository(DefinitionRepository.BuilderImpl definitionRepository) {
            this.definitionRepository = definitionRepository != null ? definitionRepository.build() : null;
        }

        @Override
        public final Builder definitionRepository(DefinitionRepository definitionRepository) {
            this.definitionRepository = definitionRepository;
            return this;
        }

        public final String getReadmeUri() {
            return readmeUri;
        }

        public final void setReadmeUri(String readmeUri) {
            this.readmeUri = readmeUri;
        }

        @Override
        public final Builder readmeUri(String readmeUri) {
            this.readmeUri = readmeUri;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateWorkflowVersionRequest build() {
            return new CreateWorkflowVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
