/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a source code repository that hosts the workflow definition files.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefinitionRepository implements SdkPojo, Serializable,
        ToCopyableBuilder<DefinitionRepository.Builder, DefinitionRepository> {
    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionArn").getter(getter(DefinitionRepository::connectionArn))
            .setter(setter(Builder::connectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionArn").build()).build();

    private static final SdkField<String> FULL_REPOSITORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fullRepositoryId").getter(getter(DefinitionRepository::fullRepositoryId))
            .setter(setter(Builder::fullRepositoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fullRepositoryId").build()).build();

    private static final SdkField<SourceReference> SOURCE_REFERENCE_FIELD = SdkField
            .<SourceReference> builder(MarshallingType.SDK_POJO).memberName("sourceReference")
            .getter(getter(DefinitionRepository::sourceReference)).setter(setter(Builder::sourceReference))
            .constructor(SourceReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceReference").build()).build();

    private static final SdkField<List<String>> EXCLUDE_FILE_PATTERNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("excludeFilePatterns")
            .getter(getter(DefinitionRepository::excludeFilePatterns))
            .setter(setter(Builder::excludeFilePatterns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludeFilePatterns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ARN_FIELD,
            FULL_REPOSITORY_ID_FIELD, SOURCE_REFERENCE_FIELD, EXCLUDE_FILE_PATTERNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectionArn;

    private final String fullRepositoryId;

    private final SourceReference sourceReference;

    private final List<String> excludeFilePatterns;

    private DefinitionRepository(BuilderImpl builder) {
        this.connectionArn = builder.connectionArn;
        this.fullRepositoryId = builder.fullRepositoryId;
        this.sourceReference = builder.sourceReference;
        this.excludeFilePatterns = builder.excludeFilePatterns;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the connection to the source code repository.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the connection to the source code repository.
     */
    public final String connectionArn() {
        return connectionArn;
    }

    /**
     * <p>
     * The full repository identifier, including the repository owner and name. For example,
     * 'repository-owner/repository-name'.
     * </p>
     * 
     * @return The full repository identifier, including the repository owner and name. For example,
     *         'repository-owner/repository-name'.
     */
    public final String fullRepositoryId() {
        return fullRepositoryId;
    }

    /**
     * <p>
     * The source reference for the repository, such as a branch name, tag, or commit ID.
     * </p>
     * 
     * @return The source reference for the repository, such as a branch name, tag, or commit ID.
     */
    public final SourceReference sourceReference() {
        return sourceReference;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludeFilePatterns property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExcludeFilePatterns() {
        return excludeFilePatterns != null && !(excludeFilePatterns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of file patterns to exclude when retrieving the workflow definition from the repository.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludeFilePatterns} method.
     * </p>
     * 
     * @return A list of file patterns to exclude when retrieving the workflow definition from the repository.
     */
    public final List<String> excludeFilePatterns() {
        return excludeFilePatterns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(fullRepositoryId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceReference());
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludeFilePatterns() ? excludeFilePatterns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefinitionRepository)) {
            return false;
        }
        DefinitionRepository other = (DefinitionRepository) obj;
        return Objects.equals(connectionArn(), other.connectionArn())
                && Objects.equals(fullRepositoryId(), other.fullRepositoryId())
                && Objects.equals(sourceReference(), other.sourceReference())
                && hasExcludeFilePatterns() == other.hasExcludeFilePatterns()
                && Objects.equals(excludeFilePatterns(), other.excludeFilePatterns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefinitionRepository").add("ConnectionArn", connectionArn())
                .add("FullRepositoryId", fullRepositoryId()).add("SourceReference", sourceReference())
                .add("ExcludeFilePatterns", hasExcludeFilePatterns() ? excludeFilePatterns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectionArn":
            return Optional.ofNullable(clazz.cast(connectionArn()));
        case "fullRepositoryId":
            return Optional.ofNullable(clazz.cast(fullRepositoryId()));
        case "sourceReference":
            return Optional.ofNullable(clazz.cast(sourceReference()));
        case "excludeFilePatterns":
            return Optional.ofNullable(clazz.cast(excludeFilePatterns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connectionArn", CONNECTION_ARN_FIELD);
        map.put("fullRepositoryId", FULL_REPOSITORY_ID_FIELD);
        map.put("sourceReference", SOURCE_REFERENCE_FIELD);
        map.put("excludeFilePatterns", EXCLUDE_FILE_PATTERNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefinitionRepository, T> g) {
        return obj -> g.apply((DefinitionRepository) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefinitionRepository> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the connection to the source code repository.
         * </p>
         * 
         * @param connectionArn
         *        The Amazon Resource Name (ARN) of the connection to the source code repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionArn(String connectionArn);

        /**
         * <p>
         * The full repository identifier, including the repository owner and name. For example,
         * 'repository-owner/repository-name'.
         * </p>
         * 
         * @param fullRepositoryId
         *        The full repository identifier, including the repository owner and name. For example,
         *        'repository-owner/repository-name'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullRepositoryId(String fullRepositoryId);

        /**
         * <p>
         * The source reference for the repository, such as a branch name, tag, or commit ID.
         * </p>
         * 
         * @param sourceReference
         *        The source reference for the repository, such as a branch name, tag, or commit ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceReference(SourceReference sourceReference);

        /**
         * <p>
         * The source reference for the repository, such as a branch name, tag, or commit ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceReference.Builder} avoiding the
         * need to create one manually via {@link SourceReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceReference.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceReference(SourceReference)}.
         * 
         * @param sourceReference
         *        a consumer that will call methods on {@link SourceReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceReference(SourceReference)
         */
        default Builder sourceReference(Consumer<SourceReference.Builder> sourceReference) {
            return sourceReference(SourceReference.builder().applyMutation(sourceReference).build());
        }

        /**
         * <p>
         * A list of file patterns to exclude when retrieving the workflow definition from the repository.
         * </p>
         * 
         * @param excludeFilePatterns
         *        A list of file patterns to exclude when retrieving the workflow definition from the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeFilePatterns(Collection<String> excludeFilePatterns);

        /**
         * <p>
         * A list of file patterns to exclude when retrieving the workflow definition from the repository.
         * </p>
         * 
         * @param excludeFilePatterns
         *        A list of file patterns to exclude when retrieving the workflow definition from the repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeFilePatterns(String... excludeFilePatterns);
    }

    static final class BuilderImpl implements Builder {
        private String connectionArn;

        private String fullRepositoryId;

        private SourceReference sourceReference;

        private List<String> excludeFilePatterns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DefinitionRepository model) {
            connectionArn(model.connectionArn);
            fullRepositoryId(model.fullRepositoryId);
            sourceReference(model.sourceReference);
            excludeFilePatterns(model.excludeFilePatterns);
        }

        public final String getConnectionArn() {
            return connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final String getFullRepositoryId() {
            return fullRepositoryId;
        }

        public final void setFullRepositoryId(String fullRepositoryId) {
            this.fullRepositoryId = fullRepositoryId;
        }

        @Override
        public final Builder fullRepositoryId(String fullRepositoryId) {
            this.fullRepositoryId = fullRepositoryId;
            return this;
        }

        public final SourceReference.Builder getSourceReference() {
            return sourceReference != null ? sourceReference.toBuilder() : null;
        }

        public final void setSourceReference(SourceReference.BuilderImpl sourceReference) {
            this.sourceReference = sourceReference != null ? sourceReference.build() : null;
        }

        @Override
        public final Builder sourceReference(SourceReference sourceReference) {
            this.sourceReference = sourceReference;
            return this;
        }

        public final Collection<String> getExcludeFilePatterns() {
            if (excludeFilePatterns instanceof SdkAutoConstructList) {
                return null;
            }
            return excludeFilePatterns;
        }

        public final void setExcludeFilePatterns(Collection<String> excludeFilePatterns) {
            this.excludeFilePatterns = ExcludeFilePatternListCopier.copy(excludeFilePatterns);
        }

        @Override
        public final Builder excludeFilePatterns(Collection<String> excludeFilePatterns) {
            this.excludeFilePatterns = ExcludeFilePatternListCopier.copy(excludeFilePatterns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeFilePatterns(String... excludeFilePatterns) {
            excludeFilePatterns(Arrays.asList(excludeFilePatterns));
            return this;
        }

        @Override
        public DefinitionRepository build() {
            return new DefinitionRepository(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
