/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAnnotationStoreVersionsResponse extends OmicsResponse implements
        ToCopyableBuilder<DeleteAnnotationStoreVersionsResponse.Builder, DeleteAnnotationStoreVersionsResponse> {
    private static final SdkField<List<VersionDeleteError>> ERRORS_FIELD = SdkField
            .<List<VersionDeleteError>> builder(MarshallingType.LIST)
            .memberName("errors")
            .getter(getter(DeleteAnnotationStoreVersionsResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VersionDeleteError> builder(MarshallingType.SDK_POJO)
                                            .constructor(VersionDeleteError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<VersionDeleteError> errors;

    private DeleteAnnotationStoreVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
    }

    /**
     * For responses, this returns true if the service returned a value for the Errors property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasErrors() {
        return errors != null && !(errors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any errors that occur when attempting to delete an annotation store version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrors} method.
     * </p>
     * 
     * @return Any errors that occur when attempting to delete an annotation store version.
     */
    public final List<VersionDeleteError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasErrors() ? errors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAnnotationStoreVersionsResponse)) {
            return false;
        }
        DeleteAnnotationStoreVersionsResponse other = (DeleteAnnotationStoreVersionsResponse) obj;
        return hasErrors() == other.hasErrors() && Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteAnnotationStoreVersionsResponse").add("Errors", hasErrors() ? errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteAnnotationStoreVersionsResponse, T> g) {
        return obj -> g.apply((DeleteAnnotationStoreVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OmicsResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteAnnotationStoreVersionsResponse> {
        /**
         * <p>
         * Any errors that occur when attempting to delete an annotation store version.
         * </p>
         * 
         * @param errors
         *        Any errors that occur when attempting to delete an annotation store version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<VersionDeleteError> errors);

        /**
         * <p>
         * Any errors that occur when attempting to delete an annotation store version.
         * </p>
         * 
         * @param errors
         *        Any errors that occur when attempting to delete an annotation store version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(VersionDeleteError... errors);

        /**
         * <p>
         * Any errors that occur when attempting to delete an annotation store version.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.omics.model.VersionDeleteError.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.omics.model.VersionDeleteError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.omics.model.VersionDeleteError.Builder#build()} is called immediately
         * and its result is passed to {@link #errors(List<VersionDeleteError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.omics.model.VersionDeleteError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(java.util.Collection<VersionDeleteError>)
         */
        Builder errors(Consumer<VersionDeleteError.Builder>... errors);
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private List<VersionDeleteError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAnnotationStoreVersionsResponse model) {
            super(model);
            errors(model.errors);
        }

        public final List<VersionDeleteError.Builder> getErrors() {
            List<VersionDeleteError.Builder> result = VersionDeleteErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<VersionDeleteError.BuilderImpl> errors) {
            this.errors = VersionDeleteErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<VersionDeleteError> errors) {
            this.errors = VersionDeleteErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(VersionDeleteError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<VersionDeleteError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> VersionDeleteError.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DeleteAnnotationStoreVersionsResponse build() {
            return new DeleteAnnotationStoreVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
