/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Use filters to return a subset of resources. You can define filters for specific parameters, such as the resource
 * status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Filter implements SdkPojo, Serializable, ToCopyableBuilder<Filter.Builder, Filter> {
    private static final SdkField<List<String>> RESOURCE_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("resourceArns")
            .getter(getter(Filter::resourceArns))
            .setter(setter(Builder::resourceArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("status")
            .getter(getter(Filter::statusAsStrings))
            .setter(setter(Builder::statusWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TYPE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("type")
            .getter(getter(Filter::typeAsStrings))
            .setter(setter(Builder::typeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARNS_FIELD,
            STATUS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> resourceArns;

    private final List<String> status;

    private final List<String> type;

    private Filter(BuilderImpl builder) {
        this.resourceArns = builder.resourceArns;
        this.status = builder.status;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceArns property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasResourceArns() {
        return resourceArns != null && !(resourceArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter based on the Amazon Resource Number (ARN) of the resource. You can specify up to 10 values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceArns} method.
     * </p>
     * 
     * @return Filter based on the Amazon Resource Number (ARN) of the resource. You can specify up to 10 values.
     */
    public final List<String> resourceArns() {
        return resourceArns;
    }

    /**
     * <p>
     * Filter based on the resource status. You can specify up to 10 values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatus} method.
     * </p>
     * 
     * @return Filter based on the resource status. You can specify up to 10 values.
     */
    public final List<ShareStatus> status() {
        return StatusListCopier.copyStringToEnum(status);
    }

    /**
     * For responses, this returns true if the service returned a value for the Status property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatus() {
        return status != null && !(status instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filter based on the resource status. You can specify up to 10 values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatus} method.
     * </p>
     * 
     * @return Filter based on the resource status. You can specify up to 10 values.
     */
    public final List<String> statusAsStrings() {
        return status;
    }

    /**
     * <p>
     * The type of resources to be filtered. You can specify one or more of the resource types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasType} method.
     * </p>
     * 
     * @return The type of resources to be filtered. You can specify one or more of the resource types.
     */
    public final List<ShareResourceType> type() {
        return TypeListCopier.copyStringToEnum(type);
    }

    /**
     * For responses, this returns true if the service returned a value for the Type property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasType() {
        return type != null && !(type instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The type of resources to be filtered. You can specify one or more of the resource types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasType} method.
     * </p>
     * 
     * @return The type of resources to be filtered. You can specify one or more of the resource types.
     */
    public final List<String> typeAsStrings() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceArns() ? resourceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatus() ? statusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasType() ? typeAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Filter)) {
            return false;
        }
        Filter other = (Filter) obj;
        return hasResourceArns() == other.hasResourceArns() && Objects.equals(resourceArns(), other.resourceArns())
                && hasStatus() == other.hasStatus() && Objects.equals(statusAsStrings(), other.statusAsStrings())
                && hasType() == other.hasType() && Objects.equals(typeAsStrings(), other.typeAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Filter").add("ResourceArns", hasResourceArns() ? resourceArns() : null)
                .add("Status", hasStatus() ? statusAsStrings() : null).add("Type", hasType() ? typeAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceArns":
            return Optional.ofNullable(clazz.cast(resourceArns()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsStrings()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceArns", RESOURCE_ARNS_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Filter, T> g) {
        return obj -> g.apply((Filter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Filter> {
        /**
         * <p>
         * Filter based on the Amazon Resource Number (ARN) of the resource. You can specify up to 10 values.
         * </p>
         * 
         * @param resourceArns
         *        Filter based on the Amazon Resource Number (ARN) of the resource. You can specify up to 10 values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(Collection<String> resourceArns);

        /**
         * <p>
         * Filter based on the Amazon Resource Number (ARN) of the resource. You can specify up to 10 values.
         * </p>
         * 
         * @param resourceArns
         *        Filter based on the Amazon Resource Number (ARN) of the resource. You can specify up to 10 values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArns(String... resourceArns);

        /**
         * <p>
         * Filter based on the resource status. You can specify up to 10 values.
         * </p>
         * 
         * @param status
         *        Filter based on the resource status. You can specify up to 10 values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusWithStrings(Collection<String> status);

        /**
         * <p>
         * Filter based on the resource status. You can specify up to 10 values.
         * </p>
         * 
         * @param status
         *        Filter based on the resource status. You can specify up to 10 values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusWithStrings(String... status);

        /**
         * <p>
         * Filter based on the resource status. You can specify up to 10 values.
         * </p>
         * 
         * @param status
         *        Filter based on the resource status. You can specify up to 10 values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Collection<ShareStatus> status);

        /**
         * <p>
         * Filter based on the resource status. You can specify up to 10 values.
         * </p>
         * 
         * @param status
         *        Filter based on the resource status. You can specify up to 10 values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(ShareStatus... status);

        /**
         * <p>
         * The type of resources to be filtered. You can specify one or more of the resource types.
         * </p>
         * 
         * @param type
         *        The type of resources to be filtered. You can specify one or more of the resource types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeWithStrings(Collection<String> type);

        /**
         * <p>
         * The type of resources to be filtered. You can specify one or more of the resource types.
         * </p>
         * 
         * @param type
         *        The type of resources to be filtered. You can specify one or more of the resource types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeWithStrings(String... type);

        /**
         * <p>
         * The type of resources to be filtered. You can specify one or more of the resource types.
         * </p>
         * 
         * @param type
         *        The type of resources to be filtered. You can specify one or more of the resource types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(Collection<ShareResourceType> type);

        /**
         * <p>
         * The type of resources to be filtered. You can specify one or more of the resource types.
         * </p>
         * 
         * @param type
         *        The type of resources to be filtered. You can specify one or more of the resource types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(ShareResourceType... type);
    }

    static final class BuilderImpl implements Builder {
        private List<String> resourceArns = DefaultSdkAutoConstructList.getInstance();

        private List<String> status = DefaultSdkAutoConstructList.getInstance();

        private List<String> type = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Filter model) {
            resourceArns(model.resourceArns);
            statusWithStrings(model.status);
            typeWithStrings(model.type);
        }

        public final Collection<String> getResourceArns() {
            if (resourceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceArns;
        }

        public final void setResourceArns(Collection<String> resourceArns) {
            this.resourceArns = ArnListCopier.copy(resourceArns);
        }

        @Override
        public final Builder resourceArns(Collection<String> resourceArns) {
            this.resourceArns = ArnListCopier.copy(resourceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceArns(String... resourceArns) {
            resourceArns(Arrays.asList(resourceArns));
            return this;
        }

        public final Collection<String> getStatus() {
            if (status instanceof SdkAutoConstructList) {
                return null;
            }
            return status;
        }

        public final void setStatus(Collection<String> status) {
            this.status = StatusListCopier.copy(status);
        }

        @Override
        public final Builder statusWithStrings(Collection<String> status) {
            this.status = StatusListCopier.copy(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusWithStrings(String... status) {
            statusWithStrings(Arrays.asList(status));
            return this;
        }

        @Override
        public final Builder status(Collection<ShareStatus> status) {
            this.status = StatusListCopier.copyEnumToString(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder status(ShareStatus... status) {
            status(Arrays.asList(status));
            return this;
        }

        public final Collection<String> getType() {
            if (type instanceof SdkAutoConstructList) {
                return null;
            }
            return type;
        }

        public final void setType(Collection<String> type) {
            this.type = TypeListCopier.copy(type);
        }

        @Override
        public final Builder typeWithStrings(Collection<String> type) {
            this.type = TypeListCopier.copy(type);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder typeWithStrings(String... type) {
            typeWithStrings(Arrays.asList(type));
            return this;
        }

        @Override
        public final Builder type(Collection<ShareResourceType> type) {
            this.type = TypeListCopier.copyEnumToString(type);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder type(ShareResourceType... type) {
            type(Arrays.asList(type));
            return this;
        }

        @Override
        public Filter build() {
            return new Filter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
