/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReadSetMetadataRequest extends OmicsRequest implements
        ToCopyableBuilder<GetReadSetMetadataRequest.Builder, GetReadSetMetadataRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetReadSetMetadataRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<String> SEQUENCE_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sequenceStoreId").getter(getter(GetReadSetMetadataRequest::sequenceStoreId))
            .setter(setter(Builder::sequenceStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sequenceStoreId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            SEQUENCE_STORE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String sequenceStoreId;

    private GetReadSetMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.sequenceStoreId = builder.sequenceStoreId;
    }

    /**
     * <p>
     * The read set's ID.
     * </p>
     * 
     * @return The read set's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The read set's sequence store ID.
     * </p>
     * 
     * @return The read set's sequence store ID.
     */
    public final String sequenceStoreId() {
        return sequenceStoreId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(sequenceStoreId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReadSetMetadataRequest)) {
            return false;
        }
        GetReadSetMetadataRequest other = (GetReadSetMetadataRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(sequenceStoreId(), other.sequenceStoreId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetReadSetMetadataRequest").add("Id", id()).add("SequenceStoreId", sequenceStoreId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "sequenceStoreId":
            return Optional.ofNullable(clazz.cast(sequenceStoreId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("sequenceStoreId", SEQUENCE_STORE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetReadSetMetadataRequest, T> g) {
        return obj -> g.apply((GetReadSetMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetReadSetMetadataRequest> {
        /**
         * <p>
         * The read set's ID.
         * </p>
         * 
         * @param id
         *        The read set's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The read set's sequence store ID.
         * </p>
         * 
         * @param sequenceStoreId
         *        The read set's sequence store ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sequenceStoreId(String sequenceStoreId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String id;

        private String sequenceStoreId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReadSetMetadataRequest model) {
            super(model);
            id(model.id);
            sequenceStoreId(model.sequenceStoreId);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getSequenceStoreId() {
            return sequenceStoreId;
        }

        public final void setSequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
        }

        @Override
        public final Builder sequenceStoreId(String sequenceStoreId) {
            this.sequenceStoreId = sequenceStoreId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetReadSetMetadataRequest build() {
            return new GetReadSetMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
