/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetReferenceRequest extends OmicsRequest implements
        ToCopyableBuilder<GetReferenceRequest.Builder, GetReferenceRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetReferenceRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<String> REFERENCE_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("referenceStoreId").getter(getter(GetReferenceRequest::referenceStoreId))
            .setter(setter(Builder::referenceStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("referenceStoreId").build()).build();

    private static final SdkField<String> RANGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("range")
            .getter(getter(GetReferenceRequest::range)).setter(setter(Builder::range))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("Range").build()).build();

    private static final SdkField<Integer> PART_NUMBER_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("partNumber").getter(getter(GetReferenceRequest::partNumber)).setter(setter(Builder::partNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("partNumber").build()).build();

    private static final SdkField<String> FILE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("file")
            .getter(getter(GetReferenceRequest::fileAsString)).setter(setter(Builder::file))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("file").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD,
            REFERENCE_STORE_ID_FIELD, RANGE_FIELD, PART_NUMBER_FIELD, FILE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String referenceStoreId;

    private final String range;

    private final Integer partNumber;

    private final String file;

    private GetReferenceRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.referenceStoreId = builder.referenceStoreId;
        this.range = builder.range;
        this.partNumber = builder.partNumber;
        this.file = builder.file;
    }

    /**
     * <p>
     * The reference's ID.
     * </p>
     * 
     * @return The reference's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The reference's store ID.
     * </p>
     * 
     * @return The reference's store ID.
     */
    public final String referenceStoreId() {
        return referenceStoreId;
    }

    /**
     * <p>
     * The range to retrieve.
     * </p>
     * 
     * @return The range to retrieve.
     */
    public final String range() {
        return range;
    }

    /**
     * <p>
     * The part number to retrieve.
     * </p>
     * 
     * @return The part number to retrieve.
     */
    public final Integer partNumber() {
        return partNumber;
    }

    /**
     * <p>
     * The file to retrieve.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #file} will return
     * {@link ReferenceFile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileAsString}.
     * </p>
     * 
     * @return The file to retrieve.
     * @see ReferenceFile
     */
    public final ReferenceFile file() {
        return ReferenceFile.fromValue(file);
    }

    /**
     * <p>
     * The file to retrieve.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #file} will return
     * {@link ReferenceFile#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fileAsString}.
     * </p>
     * 
     * @return The file to retrieve.
     * @see ReferenceFile
     */
    public final String fileAsString() {
        return file;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(referenceStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(range());
        hashCode = 31 * hashCode + Objects.hashCode(partNumber());
        hashCode = 31 * hashCode + Objects.hashCode(fileAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetReferenceRequest)) {
            return false;
        }
        GetReferenceRequest other = (GetReferenceRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(referenceStoreId(), other.referenceStoreId())
                && Objects.equals(range(), other.range()) && Objects.equals(partNumber(), other.partNumber())
                && Objects.equals(fileAsString(), other.fileAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetReferenceRequest").add("Id", id()).add("ReferenceStoreId", referenceStoreId())
                .add("Range", range()).add("PartNumber", partNumber()).add("File", fileAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "referenceStoreId":
            return Optional.ofNullable(clazz.cast(referenceStoreId()));
        case "range":
            return Optional.ofNullable(clazz.cast(range()));
        case "partNumber":
            return Optional.ofNullable(clazz.cast(partNumber()));
        case "file":
            return Optional.ofNullable(clazz.cast(fileAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("referenceStoreId", REFERENCE_STORE_ID_FIELD);
        map.put("Range", RANGE_FIELD);
        map.put("partNumber", PART_NUMBER_FIELD);
        map.put("file", FILE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetReferenceRequest, T> g) {
        return obj -> g.apply((GetReferenceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetReferenceRequest> {
        /**
         * <p>
         * The reference's ID.
         * </p>
         * 
         * @param id
         *        The reference's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The reference's store ID.
         * </p>
         * 
         * @param referenceStoreId
         *        The reference's store ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder referenceStoreId(String referenceStoreId);

        /**
         * <p>
         * The range to retrieve.
         * </p>
         * 
         * @param range
         *        The range to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder range(String range);

        /**
         * <p>
         * The part number to retrieve.
         * </p>
         * 
         * @param partNumber
         *        The part number to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partNumber(Integer partNumber);

        /**
         * <p>
         * The file to retrieve.
         * </p>
         * 
         * @param file
         *        The file to retrieve.
         * @see ReferenceFile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceFile
         */
        Builder file(String file);

        /**
         * <p>
         * The file to retrieve.
         * </p>
         * 
         * @param file
         *        The file to retrieve.
         * @see ReferenceFile
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReferenceFile
         */
        Builder file(ReferenceFile file);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String id;

        private String referenceStoreId;

        private String range;

        private Integer partNumber;

        private String file;

        private BuilderImpl() {
        }

        private BuilderImpl(GetReferenceRequest model) {
            super(model);
            id(model.id);
            referenceStoreId(model.referenceStoreId);
            range(model.range);
            partNumber(model.partNumber);
            file(model.file);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getReferenceStoreId() {
            return referenceStoreId;
        }

        public final void setReferenceStoreId(String referenceStoreId) {
            this.referenceStoreId = referenceStoreId;
        }

        @Override
        public final Builder referenceStoreId(String referenceStoreId) {
            this.referenceStoreId = referenceStoreId;
            return this;
        }

        public final String getRange() {
            return range;
        }

        public final void setRange(String range) {
            this.range = range;
        }

        @Override
        public final Builder range(String range) {
            this.range = range;
            return this;
        }

        public final Integer getPartNumber() {
            return partNumber;
        }

        public final void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        @Override
        public final Builder partNumber(Integer partNumber) {
            this.partNumber = partNumber;
            return this;
        }

        public final String getFile() {
            return file;
        }

        public final void setFile(String file) {
            this.file = file;
        }

        @Override
        public final Builder file(String file) {
            this.file = file;
            return this;
        }

        @Override
        public final Builder file(ReferenceFile file) {
            this.file(file == null ? null : file.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetReferenceRequest build() {
            return new GetReferenceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
