/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the container image used for a task.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageDetails implements SdkPojo, Serializable, ToCopyableBuilder<ImageDetails.Builder, ImageDetails> {
    private static final SdkField<String> IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("image")
            .getter(getter(ImageDetails::image)).setter(setter(Builder::image))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()).build();

    private static final SdkField<String> IMAGE_DIGEST_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("imageDigest").getter(getter(ImageDetails::imageDigest)).setter(setter(Builder::imageDigest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDigest").build()).build();

    private static final SdkField<String> SOURCE_IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceImage").getter(getter(ImageDetails::sourceImage)).setter(setter(Builder::sourceImage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceImage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_FIELD,
            IMAGE_DIGEST_FIELD, SOURCE_IMAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String image;

    private final String imageDigest;

    private final String sourceImage;

    private ImageDetails(BuilderImpl builder) {
        this.image = builder.image;
        this.imageDigest = builder.imageDigest;
        this.sourceImage = builder.sourceImage;
    }

    /**
     * <p>
     * The URI of the container image.
     * </p>
     * 
     * @return The URI of the container image.
     */
    public final String image() {
        return image;
    }

    /**
     * <p>
     * The container image digest. If the image URI was transformed, this will be the digest of the container image
     * referenced by the transformed URI.
     * </p>
     * 
     * @return The container image digest. If the image URI was transformed, this will be the digest of the container
     *         image referenced by the transformed URI.
     */
    public final String imageDigest() {
        return imageDigest;
    }

    /**
     * <p>
     * URI of the source registry. If the URI is from a third-party registry, Amazon Web Services HealthOmics transforms
     * the URI to the corresponding ECR path, using the pull-through cache mapping rules.
     * </p>
     * 
     * @return URI of the source registry. If the URI is from a third-party registry, Amazon Web Services HealthOmics
     *         transforms the URI to the corresponding ECR path, using the pull-through cache mapping rules.
     */
    public final String sourceImage() {
        return sourceImage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(imageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(sourceImage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageDetails)) {
            return false;
        }
        ImageDetails other = (ImageDetails) obj;
        return Objects.equals(image(), other.image()) && Objects.equals(imageDigest(), other.imageDigest())
                && Objects.equals(sourceImage(), other.sourceImage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageDetails").add("Image", image()).add("ImageDigest", imageDigest())
                .add("SourceImage", sourceImage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "image":
            return Optional.ofNullable(clazz.cast(image()));
        case "imageDigest":
            return Optional.ofNullable(clazz.cast(imageDigest()));
        case "sourceImage":
            return Optional.ofNullable(clazz.cast(sourceImage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("image", IMAGE_FIELD);
        map.put("imageDigest", IMAGE_DIGEST_FIELD);
        map.put("sourceImage", SOURCE_IMAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageDetails, T> g) {
        return obj -> g.apply((ImageDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageDetails> {
        /**
         * <p>
         * The URI of the container image.
         * </p>
         * 
         * @param image
         *        The URI of the container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(String image);

        /**
         * <p>
         * The container image digest. If the image URI was transformed, this will be the digest of the container image
         * referenced by the transformed URI.
         * </p>
         * 
         * @param imageDigest
         *        The container image digest. If the image URI was transformed, this will be the digest of the container
         *        image referenced by the transformed URI.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageDigest(String imageDigest);

        /**
         * <p>
         * URI of the source registry. If the URI is from a third-party registry, Amazon Web Services HealthOmics
         * transforms the URI to the corresponding ECR path, using the pull-through cache mapping rules.
         * </p>
         * 
         * @param sourceImage
         *        URI of the source registry. If the URI is from a third-party registry, Amazon Web Services HealthOmics
         *        transforms the URI to the corresponding ECR path, using the pull-through cache mapping rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceImage(String sourceImage);
    }

    static final class BuilderImpl implements Builder {
        private String image;

        private String imageDigest;

        private String sourceImage;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageDetails model) {
            image(model.image);
            imageDigest(model.imageDigest);
            sourceImage(model.sourceImage);
        }

        public final String getImage() {
            return image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final String getImageDigest() {
            return imageDigest;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final String getSourceImage() {
            return sourceImage;
        }

        public final void setSourceImage(String sourceImage) {
            this.sourceImage = sourceImage;
        }

        @Override
        public final Builder sourceImage(String sourceImage) {
            this.sourceImage = sourceImage;
            return this;
        }

        @Override
        public ImageDetails build() {
            return new ImageDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
