/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * If you are using the ECR pull through cache feature, the registry mapping maps between the ECR repository and the
 * upstream registry where container images are pulled and synchronized.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegistryMapping implements SdkPojo, Serializable, ToCopyableBuilder<RegistryMapping.Builder, RegistryMapping> {
    private static final SdkField<String> UPSTREAM_REGISTRY_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("upstreamRegistryUrl").getter(getter(RegistryMapping::upstreamRegistryUrl))
            .setter(setter(Builder::upstreamRegistryUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreamRegistryUrl").build())
            .build();

    private static final SdkField<String> ECR_REPOSITORY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ecrRepositoryPrefix").getter(getter(RegistryMapping::ecrRepositoryPrefix))
            .setter(setter(Builder::ecrRepositoryPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrRepositoryPrefix").build())
            .build();

    private static final SdkField<String> UPSTREAM_REPOSITORY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("upstreamRepositoryPrefix").getter(getter(RegistryMapping::upstreamRepositoryPrefix))
            .setter(setter(Builder::upstreamRepositoryPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreamRepositoryPrefix").build())
            .build();

    private static final SdkField<String> ECR_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ecrAccountId").getter(getter(RegistryMapping::ecrAccountId)).setter(setter(Builder::ecrAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrAccountId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPSTREAM_REGISTRY_URL_FIELD,
            ECR_REPOSITORY_PREFIX_FIELD, UPSTREAM_REPOSITORY_PREFIX_FIELD, ECR_ACCOUNT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String upstreamRegistryUrl;

    private final String ecrRepositoryPrefix;

    private final String upstreamRepositoryPrefix;

    private final String ecrAccountId;

    private RegistryMapping(BuilderImpl builder) {
        this.upstreamRegistryUrl = builder.upstreamRegistryUrl;
        this.ecrRepositoryPrefix = builder.ecrRepositoryPrefix;
        this.upstreamRepositoryPrefix = builder.upstreamRepositoryPrefix;
        this.ecrAccountId = builder.ecrAccountId;
    }

    /**
     * <p>
     * The URI of the upstream registry.
     * </p>
     * 
     * @return The URI of the upstream registry.
     */
    public final String upstreamRegistryUrl() {
        return upstreamRegistryUrl;
    }

    /**
     * <p>
     * The repository prefix to use in the ECR private repository.
     * </p>
     * 
     * @return The repository prefix to use in the ECR private repository.
     */
    public final String ecrRepositoryPrefix() {
        return ecrRepositoryPrefix;
    }

    /**
     * <p>
     * The repository prefix of the corresponding repository in the upstream registry.
     * </p>
     * 
     * @return The repository prefix of the corresponding repository in the upstream registry.
     */
    public final String upstreamRepositoryPrefix() {
        return upstreamRepositoryPrefix;
    }

    /**
     * <p>
     * Account ID of the account that owns the upstream container image.
     * </p>
     * 
     * @return Account ID of the account that owns the upstream container image.
     */
    public final String ecrAccountId() {
        return ecrAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(upstreamRegistryUrl());
        hashCode = 31 * hashCode + Objects.hashCode(ecrRepositoryPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(upstreamRepositoryPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(ecrAccountId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegistryMapping)) {
            return false;
        }
        RegistryMapping other = (RegistryMapping) obj;
        return Objects.equals(upstreamRegistryUrl(), other.upstreamRegistryUrl())
                && Objects.equals(ecrRepositoryPrefix(), other.ecrRepositoryPrefix())
                && Objects.equals(upstreamRepositoryPrefix(), other.upstreamRepositoryPrefix())
                && Objects.equals(ecrAccountId(), other.ecrAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegistryMapping").add("UpstreamRegistryUrl", upstreamRegistryUrl())
                .add("EcrRepositoryPrefix", ecrRepositoryPrefix()).add("UpstreamRepositoryPrefix", upstreamRepositoryPrefix())
                .add("EcrAccountId", ecrAccountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "upstreamRegistryUrl":
            return Optional.ofNullable(clazz.cast(upstreamRegistryUrl()));
        case "ecrRepositoryPrefix":
            return Optional.ofNullable(clazz.cast(ecrRepositoryPrefix()));
        case "upstreamRepositoryPrefix":
            return Optional.ofNullable(clazz.cast(upstreamRepositoryPrefix()));
        case "ecrAccountId":
            return Optional.ofNullable(clazz.cast(ecrAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("upstreamRegistryUrl", UPSTREAM_REGISTRY_URL_FIELD);
        map.put("ecrRepositoryPrefix", ECR_REPOSITORY_PREFIX_FIELD);
        map.put("upstreamRepositoryPrefix", UPSTREAM_REPOSITORY_PREFIX_FIELD);
        map.put("ecrAccountId", ECR_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RegistryMapping, T> g) {
        return obj -> g.apply((RegistryMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegistryMapping> {
        /**
         * <p>
         * The URI of the upstream registry.
         * </p>
         * 
         * @param upstreamRegistryUrl
         *        The URI of the upstream registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upstreamRegistryUrl(String upstreamRegistryUrl);

        /**
         * <p>
         * The repository prefix to use in the ECR private repository.
         * </p>
         * 
         * @param ecrRepositoryPrefix
         *        The repository prefix to use in the ECR private repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrRepositoryPrefix(String ecrRepositoryPrefix);

        /**
         * <p>
         * The repository prefix of the corresponding repository in the upstream registry.
         * </p>
         * 
         * @param upstreamRepositoryPrefix
         *        The repository prefix of the corresponding repository in the upstream registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upstreamRepositoryPrefix(String upstreamRepositoryPrefix);

        /**
         * <p>
         * Account ID of the account that owns the upstream container image.
         * </p>
         * 
         * @param ecrAccountId
         *        Account ID of the account that owns the upstream container image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrAccountId(String ecrAccountId);
    }

    static final class BuilderImpl implements Builder {
        private String upstreamRegistryUrl;

        private String ecrRepositoryPrefix;

        private String upstreamRepositoryPrefix;

        private String ecrAccountId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegistryMapping model) {
            upstreamRegistryUrl(model.upstreamRegistryUrl);
            ecrRepositoryPrefix(model.ecrRepositoryPrefix);
            upstreamRepositoryPrefix(model.upstreamRepositoryPrefix);
            ecrAccountId(model.ecrAccountId);
        }

        public final String getUpstreamRegistryUrl() {
            return upstreamRegistryUrl;
        }

        public final void setUpstreamRegistryUrl(String upstreamRegistryUrl) {
            this.upstreamRegistryUrl = upstreamRegistryUrl;
        }

        @Override
        public final Builder upstreamRegistryUrl(String upstreamRegistryUrl) {
            this.upstreamRegistryUrl = upstreamRegistryUrl;
            return this;
        }

        public final String getEcrRepositoryPrefix() {
            return ecrRepositoryPrefix;
        }

        public final void setEcrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
        }

        @Override
        public final Builder ecrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
            return this;
        }

        public final String getUpstreamRepositoryPrefix() {
            return upstreamRepositoryPrefix;
        }

        public final void setUpstreamRepositoryPrefix(String upstreamRepositoryPrefix) {
            this.upstreamRepositoryPrefix = upstreamRepositoryPrefix;
        }

        @Override
        public final Builder upstreamRepositoryPrefix(String upstreamRepositoryPrefix) {
            this.upstreamRepositoryPrefix = upstreamRepositoryPrefix;
            return this;
        }

        public final String getEcrAccountId() {
            return ecrAccountId;
        }

        public final void setEcrAccountId(String ecrAccountId) {
            this.ecrAccountId = ecrAccountId;
        }

        @Override
        public final Builder ecrAccountId(String ecrAccountId) {
            this.ecrAccountId = ecrAccountId;
            return this;
        }

        @Override
        public RegistryMapping build() {
            return new RegistryMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
