/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The URI for the run log.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RunLogLocation implements SdkPojo, Serializable, ToCopyableBuilder<RunLogLocation.Builder, RunLogLocation> {
    private static final SdkField<String> ENGINE_LOG_STREAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("engineLogStream").getter(getter(RunLogLocation::engineLogStream))
            .setter(setter(Builder::engineLogStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engineLogStream").build()).build();

    private static final SdkField<String> RUN_LOG_STREAM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runLogStream").getter(getter(RunLogLocation::runLogStream)).setter(setter(Builder::runLogStream))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runLogStream").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGINE_LOG_STREAM_FIELD,
            RUN_LOG_STREAM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String engineLogStream;

    private final String runLogStream;

    private RunLogLocation(BuilderImpl builder) {
        this.engineLogStream = builder.engineLogStream;
        this.runLogStream = builder.runLogStream;
    }

    /**
     * <p>
     * The log stream ARN for the engine log.
     * </p>
     * 
     * @return The log stream ARN for the engine log.
     */
    public final String engineLogStream() {
        return engineLogStream;
    }

    /**
     * <p>
     * The log stream ARN for the run log.
     * </p>
     * 
     * @return The log stream ARN for the run log.
     */
    public final String runLogStream() {
        return runLogStream;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(engineLogStream());
        hashCode = 31 * hashCode + Objects.hashCode(runLogStream());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RunLogLocation)) {
            return false;
        }
        RunLogLocation other = (RunLogLocation) obj;
        return Objects.equals(engineLogStream(), other.engineLogStream()) && Objects.equals(runLogStream(), other.runLogStream());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RunLogLocation").add("EngineLogStream", engineLogStream()).add("RunLogStream", runLogStream())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "engineLogStream":
            return Optional.ofNullable(clazz.cast(engineLogStream()));
        case "runLogStream":
            return Optional.ofNullable(clazz.cast(runLogStream()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("engineLogStream", ENGINE_LOG_STREAM_FIELD);
        map.put("runLogStream", RUN_LOG_STREAM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RunLogLocation, T> g) {
        return obj -> g.apply((RunLogLocation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RunLogLocation> {
        /**
         * <p>
         * The log stream ARN for the engine log.
         * </p>
         * 
         * @param engineLogStream
         *        The log stream ARN for the engine log.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineLogStream(String engineLogStream);

        /**
         * <p>
         * The log stream ARN for the run log.
         * </p>
         * 
         * @param runLogStream
         *        The log stream ARN for the run log.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runLogStream(String runLogStream);
    }

    static final class BuilderImpl implements Builder {
        private String engineLogStream;

        private String runLogStream;

        private BuilderImpl() {
        }

        private BuilderImpl(RunLogLocation model) {
            engineLogStream(model.engineLogStream);
            runLogStream(model.runLogStream);
        }

        public final String getEngineLogStream() {
            return engineLogStream;
        }

        public final void setEngineLogStream(String engineLogStream) {
            this.engineLogStream = engineLogStream;
        }

        @Override
        public final Builder engineLogStream(String engineLogStream) {
            this.engineLogStream = engineLogStream;
            return this;
        }

        public final String getRunLogStream() {
            return runLogStream;
        }

        public final void setRunLogStream(String runLogStream) {
            this.runLogStream = runLogStream;
        }

        @Override
        public final Builder runLogStream(String runLogStream) {
            this.runLogStream = runLogStream;
            return this;
        }

        @Override
        public RunLogLocation build() {
            return new RunLogLocation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
