/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A filter for a sequence store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SequenceStoreFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<SequenceStoreFilter.Builder, SequenceStoreFilter> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SequenceStoreFilter::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAfter")
            .getter(getter(SequenceStoreFilter::createdAfter))
            .setter(setter(Builder::createdAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAfter").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdBefore")
            .getter(getter(SequenceStoreFilter::createdBefore))
            .setter(setter(Builder::createdBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBefore").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(SequenceStoreFilter::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATED_AFTER_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAfter")
            .getter(getter(SequenceStoreFilter::updatedAfter))
            .setter(setter(Builder::updatedAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAfter").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_BEFORE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedBefore")
            .getter(getter(SequenceStoreFilter::updatedBefore))
            .setter(setter(Builder::updatedBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBefore").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            CREATED_AFTER_FIELD, CREATED_BEFORE_FIELD, STATUS_FIELD, UPDATED_AFTER_FIELD, UPDATED_BEFORE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final Instant createdAfter;

    private final Instant createdBefore;

    private final String status;

    private final Instant updatedAfter;

    private final Instant updatedBefore;

    private SequenceStoreFilter(BuilderImpl builder) {
        this.name = builder.name;
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.status = builder.status;
        this.updatedAfter = builder.updatedAfter;
        this.updatedBefore = builder.updatedBefore;
    }

    /**
     * <p>
     * A name to filter on.
     * </p>
     * 
     * @return A name to filter on.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The filter's start date.
     * </p>
     * 
     * @return The filter's start date.
     */
    public final Instant createdAfter() {
        return createdAfter;
    }

    /**
     * <p>
     * The filter's end date.
     * </p>
     * 
     * @return The filter's end date.
     */
    public final Instant createdBefore() {
        return createdBefore;
    }

    /**
     * <p>
     * Filter results based on status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SequenceStoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Filter results based on status.
     * @see SequenceStoreStatus
     */
    public final SequenceStoreStatus status() {
        return SequenceStoreStatus.fromValue(status);
    }

    /**
     * <p>
     * Filter results based on status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SequenceStoreStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return Filter results based on status.
     * @see SequenceStoreStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Filter results based on stores updated after the specified time.
     * </p>
     * 
     * @return Filter results based on stores updated after the specified time.
     */
    public final Instant updatedAfter() {
        return updatedAfter;
    }

    /**
     * <p>
     * Filter results based on stores updated before the specified time.
     * </p>
     * 
     * @return Filter results based on stores updated before the specified time.
     */
    public final Instant updatedBefore() {
        return updatedBefore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAfter());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBefore());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SequenceStoreFilter)) {
            return false;
        }
        SequenceStoreFilter other = (SequenceStoreFilter) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(createdAfter(), other.createdAfter())
                && Objects.equals(createdBefore(), other.createdBefore())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(updatedAfter(), other.updatedAfter()) && Objects.equals(updatedBefore(), other.updatedBefore());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SequenceStoreFilter").add("Name", name()).add("CreatedAfter", createdAfter())
                .add("CreatedBefore", createdBefore()).add("Status", statusAsString()).add("UpdatedAfter", updatedAfter())
                .add("UpdatedBefore", updatedBefore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "createdAfter":
            return Optional.ofNullable(clazz.cast(createdAfter()));
        case "createdBefore":
            return Optional.ofNullable(clazz.cast(createdBefore()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "updatedAfter":
            return Optional.ofNullable(clazz.cast(updatedAfter()));
        case "updatedBefore":
            return Optional.ofNullable(clazz.cast(updatedBefore()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("createdAfter", CREATED_AFTER_FIELD);
        map.put("createdBefore", CREATED_BEFORE_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("updatedAfter", UPDATED_AFTER_FIELD);
        map.put("updatedBefore", UPDATED_BEFORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SequenceStoreFilter, T> g) {
        return obj -> g.apply((SequenceStoreFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SequenceStoreFilter> {
        /**
         * <p>
         * A name to filter on.
         * </p>
         * 
         * @param name
         *        A name to filter on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The filter's start date.
         * </p>
         * 
         * @param createdAfter
         *        The filter's start date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAfter(Instant createdAfter);

        /**
         * <p>
         * The filter's end date.
         * </p>
         * 
         * @param createdBefore
         *        The filter's end date.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBefore(Instant createdBefore);

        /**
         * <p>
         * Filter results based on status.
         * </p>
         * 
         * @param status
         *        Filter results based on status.
         * @see SequenceStoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SequenceStoreStatus
         */
        Builder status(String status);

        /**
         * <p>
         * Filter results based on status.
         * </p>
         * 
         * @param status
         *        Filter results based on status.
         * @see SequenceStoreStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SequenceStoreStatus
         */
        Builder status(SequenceStoreStatus status);

        /**
         * <p>
         * Filter results based on stores updated after the specified time.
         * </p>
         * 
         * @param updatedAfter
         *        Filter results based on stores updated after the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAfter(Instant updatedAfter);

        /**
         * <p>
         * Filter results based on stores updated before the specified time.
         * </p>
         * 
         * @param updatedBefore
         *        Filter results based on stores updated before the specified time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBefore(Instant updatedBefore);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private Instant createdAfter;

        private Instant createdBefore;

        private String status;

        private Instant updatedAfter;

        private Instant updatedBefore;

        private BuilderImpl() {
        }

        private BuilderImpl(SequenceStoreFilter model) {
            name(model.name);
            createdAfter(model.createdAfter);
            createdBefore(model.createdBefore);
            status(model.status);
            updatedAfter(model.updatedAfter);
            updatedBefore(model.updatedBefore);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Instant getCreatedAfter() {
            return createdAfter;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final Instant getCreatedBefore() {
            return createdBefore;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SequenceStoreStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getUpdatedAfter() {
            return updatedAfter;
        }

        public final void setUpdatedAfter(Instant updatedAfter) {
            this.updatedAfter = updatedAfter;
        }

        @Override
        public final Builder updatedAfter(Instant updatedAfter) {
            this.updatedAfter = updatedAfter;
            return this;
        }

        public final Instant getUpdatedBefore() {
            return updatedBefore;
        }

        public final void setUpdatedBefore(Instant updatedBefore) {
            this.updatedBefore = updatedBefore;
        }

        @Override
        public final Builder updatedBefore(Instant updatedBefore) {
            this.updatedBefore = updatedBefore;
            return this;
        }

        @Override
        public SequenceStoreFilter build() {
            return new SequenceStoreFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
