/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartRunResponse extends OmicsResponse implements
        ToCopyableBuilder<StartRunResponse.Builder, StartRunResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(StartRunResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(StartRunResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(StartRunResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(StartRunResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> UUID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("uuid")
            .getter(getter(StartRunResponse::uuid)).setter(setter(Builder::uuid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uuid").build()).build();

    private static final SdkField<String> RUN_OUTPUT_URI_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("runOutputUri").getter(getter(StartRunResponse::runOutputUri)).setter(setter(Builder::runOutputUri))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runOutputUri").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            STATUS_FIELD, TAGS_FIELD, UUID_FIELD, RUN_OUTPUT_URI_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String id;

    private final String status;

    private final Map<String, String> tags;

    private final String uuid;

    private final String runOutputUri;

    private StartRunResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.status = builder.status;
        this.tags = builder.tags;
        this.uuid = builder.uuid;
        this.runOutputUri = builder.runOutputUri;
    }

    /**
     * <p>
     * Unique resource identifier for the run.
     * </p>
     * 
     * @return Unique resource identifier for the run.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The run's ID.
     * </p>
     * 
     * @return The run's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The run's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The run's status.
     * @see RunStatus
     */
    public final RunStatus status() {
        return RunStatus.fromValue(status);
    }

    /**
     * <p>
     * The run's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link RunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The run's status.
     * @see RunStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The run's tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The run's tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The universally unique identifier for a run.
     * </p>
     * 
     * @return The universally unique identifier for a run.
     */
    public final String uuid() {
        return uuid;
    }

    /**
     * <p>
     * The destination for workflow outputs.
     * </p>
     * 
     * @return The destination for workflow outputs.
     */
    public final String runOutputUri() {
        return runOutputUri;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(uuid());
        hashCode = 31 * hashCode + Objects.hashCode(runOutputUri());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartRunResponse)) {
            return false;
        }
        StartRunResponse other = (StartRunResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(statusAsString(), other.statusAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(uuid(), other.uuid())
                && Objects.equals(runOutputUri(), other.runOutputUri());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartRunResponse").add("Arn", arn()).add("Id", id()).add("Status", statusAsString())
                .add("Tags", hasTags() ? tags() : null).add("Uuid", uuid()).add("RunOutputUri", runOutputUri()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "uuid":
            return Optional.ofNullable(clazz.cast(uuid()));
        case "runOutputUri":
            return Optional.ofNullable(clazz.cast(runOutputUri()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("uuid", UUID_FIELD);
        map.put("runOutputUri", RUN_OUTPUT_URI_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartRunResponse, T> g) {
        return obj -> g.apply((StartRunResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OmicsResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartRunResponse> {
        /**
         * <p>
         * Unique resource identifier for the run.
         * </p>
         * 
         * @param arn
         *        Unique resource identifier for the run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The run's ID.
         * </p>
         * 
         * @param id
         *        The run's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The run's status.
         * </p>
         * 
         * @param status
         *        The run's status.
         * @see RunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The run's status.
         * </p>
         * 
         * @param status
         *        The run's status.
         * @see RunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunStatus
         */
        Builder status(RunStatus status);

        /**
         * <p>
         * The run's tags.
         * </p>
         * 
         * @param tags
         *        The run's tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The universally unique identifier for a run.
         * </p>
         * 
         * @param uuid
         *        The universally unique identifier for a run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uuid(String uuid);

        /**
         * <p>
         * The destination for workflow outputs.
         * </p>
         * 
         * @param runOutputUri
         *        The destination for workflow outputs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runOutputUri(String runOutputUri);
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String status;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String uuid;

        private String runOutputUri;

        private BuilderImpl() {
        }

        private BuilderImpl(StartRunResponse model) {
            super(model);
            arn(model.arn);
            id(model.id);
            status(model.status);
            tags(model.tags);
            uuid(model.uuid);
            runOutputUri(model.runOutputUri);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getUuid() {
            return uuid;
        }

        public final void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public final String getRunOutputUri() {
            return runOutputUri;
        }

        public final void setRunOutputUri(String runOutputUri) {
            this.runOutputUri = runOutputUri;
        }

        @Override
        public final Builder runOutputUri(String runOutputUri) {
            this.runOutputUri = runOutputUri;
            return this;
        }

        @Override
        public StartRunResponse build() {
            return new StartRunResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
