/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Formatting options for a TSV file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TsvOptions implements SdkPojo, Serializable, ToCopyableBuilder<TsvOptions.Builder, TsvOptions> {
    private static final SdkField<ReadOptions> READ_OPTIONS_FIELD = SdkField.<ReadOptions> builder(MarshallingType.SDK_POJO)
            .memberName("readOptions").getter(getter(TsvOptions::readOptions)).setter(setter(Builder::readOptions))
            .constructor(ReadOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(READ_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ReadOptions readOptions;

    private TsvOptions(BuilderImpl builder) {
        this.readOptions = builder.readOptions;
    }

    /**
     * <p>
     * The file's read options.
     * </p>
     * 
     * @return The file's read options.
     */
    public final ReadOptions readOptions() {
        return readOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(readOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TsvOptions)) {
            return false;
        }
        TsvOptions other = (TsvOptions) obj;
        return Objects.equals(readOptions(), other.readOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TsvOptions").add("ReadOptions", readOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "readOptions":
            return Optional.ofNullable(clazz.cast(readOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("readOptions", READ_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TsvOptions, T> g) {
        return obj -> g.apply((TsvOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TsvOptions> {
        /**
         * <p>
         * The file's read options.
         * </p>
         * 
         * @param readOptions
         *        The file's read options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readOptions(ReadOptions readOptions);

        /**
         * <p>
         * The file's read options.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReadOptions.Builder} avoiding the need to
         * create one manually via {@link ReadOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReadOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #readOptions(ReadOptions)}.
         * 
         * @param readOptions
         *        a consumer that will call methods on {@link ReadOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #readOptions(ReadOptions)
         */
        default Builder readOptions(Consumer<ReadOptions.Builder> readOptions) {
            return readOptions(ReadOptions.builder().applyMutation(readOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ReadOptions readOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(TsvOptions model) {
            readOptions(model.readOptions);
        }

        public final ReadOptions.Builder getReadOptions() {
            return readOptions != null ? readOptions.toBuilder() : null;
        }

        public final void setReadOptions(ReadOptions.BuilderImpl readOptions) {
            this.readOptions = readOptions != null ? readOptions.build() : null;
        }

        @Override
        public final Builder readOptions(ReadOptions readOptions) {
            this.readOptions = readOptions;
            return this;
        }

        @Override
        public TsvOptions build() {
            return new TsvOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
