/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The options for a TSV file.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TsvVersionOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<TsvVersionOptions.Builder, TsvVersionOptions> {
    private static final SdkField<String> ANNOTATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("annotationType").getter(getter(TsvVersionOptions::annotationTypeAsString))
            .setter(setter(Builder::annotationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("annotationType").build()).build();

    private static final SdkField<Map<String, String>> FORMAT_TO_HEADER_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("formatToHeader")
            .getter(getter(TsvVersionOptions::formatToHeaderAsStrings))
            .setter(setter(Builder::formatToHeaderWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formatToHeader").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Map<String, String>>> SCHEMA_FIELD = SdkField
            .<List<Map<String, String>>> builder(MarshallingType.LIST)
            .memberName("schema")
            .getter(getter(TsvVersionOptions::schemaAsStrings))
            .setter(setter(Builder::schemaWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Map<String, String>> builder(MarshallingType.MAP)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build(),
                                                    MapTrait.builder()
                                                            .keyLocationName("key")
                                                            .valueLocationName("value")
                                                            .valueFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("value").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANNOTATION_TYPE_FIELD,
            FORMAT_TO_HEADER_FIELD, SCHEMA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String annotationType;

    private final Map<String, String> formatToHeader;

    private final List<Map<String, String>> schema;

    private TsvVersionOptions(BuilderImpl builder) {
        this.annotationType = builder.annotationType;
        this.formatToHeader = builder.formatToHeader;
        this.schema = builder.schema;
    }

    /**
     * <p>
     * The store version's annotation type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #annotationType}
     * will return {@link AnnotationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #annotationTypeAsString}.
     * </p>
     * 
     * @return The store version's annotation type.
     * @see AnnotationType
     */
    public final AnnotationType annotationType() {
        return AnnotationType.fromValue(annotationType);
    }

    /**
     * <p>
     * The store version's annotation type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #annotationType}
     * will return {@link AnnotationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #annotationTypeAsString}.
     * </p>
     * 
     * @return The store version's annotation type.
     * @see AnnotationType
     */
    public final String annotationTypeAsString() {
        return annotationType;
    }

    /**
     * <p>
     * The annotation store version's header key to column name mapping.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFormatToHeader} method.
     * </p>
     * 
     * @return The annotation store version's header key to column name mapping.
     */
    public final Map<FormatToHeaderKey, String> formatToHeader() {
        return FormatToHeaderCopier.copyStringToEnum(formatToHeader);
    }

    /**
     * For responses, this returns true if the service returned a value for the FormatToHeader property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFormatToHeader() {
        return formatToHeader != null && !(formatToHeader instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The annotation store version's header key to column name mapping.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFormatToHeader} method.
     * </p>
     * 
     * @return The annotation store version's header key to column name mapping.
     */
    public final Map<String, String> formatToHeaderAsStrings() {
        return formatToHeader;
    }

    /**
     * <p>
     * The TSV schema for an annotation store version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSchema} method.
     * </p>
     * 
     * @return The TSV schema for an annotation store version.
     */
    public final List<Map<String, SchemaValueType>> schema() {
        return TsvVersionOptionsSchemaListCopier.copyStringToEnum(schema);
    }

    /**
     * For responses, this returns true if the service returned a value for the Schema property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSchema() {
        return schema != null && !(schema instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The TSV schema for an annotation store version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSchema} method.
     * </p>
     * 
     * @return The TSV schema for an annotation store version.
     */
    public final List<Map<String, String>> schemaAsStrings() {
        return schema;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(annotationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasFormatToHeader() ? formatToHeaderAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSchema() ? schemaAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TsvVersionOptions)) {
            return false;
        }
        TsvVersionOptions other = (TsvVersionOptions) obj;
        return Objects.equals(annotationTypeAsString(), other.annotationTypeAsString())
                && hasFormatToHeader() == other.hasFormatToHeader()
                && Objects.equals(formatToHeaderAsStrings(), other.formatToHeaderAsStrings()) && hasSchema() == other.hasSchema()
                && Objects.equals(schemaAsStrings(), other.schemaAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TsvVersionOptions").add("AnnotationType", annotationTypeAsString())
                .add("FormatToHeader", hasFormatToHeader() ? formatToHeaderAsStrings() : null)
                .add("Schema", hasSchema() ? schemaAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "annotationType":
            return Optional.ofNullable(clazz.cast(annotationTypeAsString()));
        case "formatToHeader":
            return Optional.ofNullable(clazz.cast(formatToHeaderAsStrings()));
        case "schema":
            return Optional.ofNullable(clazz.cast(schemaAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("annotationType", ANNOTATION_TYPE_FIELD);
        map.put("formatToHeader", FORMAT_TO_HEADER_FIELD);
        map.put("schema", SCHEMA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TsvVersionOptions, T> g) {
        return obj -> g.apply((TsvVersionOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TsvVersionOptions> {
        /**
         * <p>
         * The store version's annotation type.
         * </p>
         * 
         * @param annotationType
         *        The store version's annotation type.
         * @see AnnotationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnnotationType
         */
        Builder annotationType(String annotationType);

        /**
         * <p>
         * The store version's annotation type.
         * </p>
         * 
         * @param annotationType
         *        The store version's annotation type.
         * @see AnnotationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AnnotationType
         */
        Builder annotationType(AnnotationType annotationType);

        /**
         * <p>
         * The annotation store version's header key to column name mapping.
         * </p>
         * 
         * @param formatToHeader
         *        The annotation store version's header key to column name mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatToHeaderWithStrings(Map<String, String> formatToHeader);

        /**
         * <p>
         * The annotation store version's header key to column name mapping.
         * </p>
         * 
         * @param formatToHeader
         *        The annotation store version's header key to column name mapping.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder formatToHeader(Map<FormatToHeaderKey, String> formatToHeader);

        /**
         * <p>
         * The TSV schema for an annotation store version.
         * </p>
         * 
         * @param schema
         *        The TSV schema for an annotation store version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaWithStrings(Collection<? extends Map<String, String>> schema);

        /**
         * <p>
         * The TSV schema for an annotation store version.
         * </p>
         * 
         * @param schema
         *        The TSV schema for an annotation store version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaWithStrings(Map<String, String>... schema);
    }

    static final class BuilderImpl implements Builder {
        private String annotationType;

        private Map<String, String> formatToHeader = DefaultSdkAutoConstructMap.getInstance();

        private List<Map<String, String>> schema = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TsvVersionOptions model) {
            annotationType(model.annotationType);
            formatToHeaderWithStrings(model.formatToHeader);
            schemaWithStrings(model.schema);
        }

        public final String getAnnotationType() {
            return annotationType;
        }

        public final void setAnnotationType(String annotationType) {
            this.annotationType = annotationType;
        }

        @Override
        public final Builder annotationType(String annotationType) {
            this.annotationType = annotationType;
            return this;
        }

        @Override
        public final Builder annotationType(AnnotationType annotationType) {
            this.annotationType(annotationType == null ? null : annotationType.toString());
            return this;
        }

        public final Map<String, String> getFormatToHeader() {
            if (formatToHeader instanceof SdkAutoConstructMap) {
                return null;
            }
            return formatToHeader;
        }

        public final void setFormatToHeader(Map<String, String> formatToHeader) {
            this.formatToHeader = FormatToHeaderCopier.copy(formatToHeader);
        }

        @Override
        public final Builder formatToHeaderWithStrings(Map<String, String> formatToHeader) {
            this.formatToHeader = FormatToHeaderCopier.copy(formatToHeader);
            return this;
        }

        @Override
        public final Builder formatToHeader(Map<FormatToHeaderKey, String> formatToHeader) {
            this.formatToHeader = FormatToHeaderCopier.copyEnumToString(formatToHeader);
            return this;
        }

        public final Collection<? extends Map<String, String>> getSchema() {
            if (schema instanceof SdkAutoConstructList) {
                return null;
            }
            return schema;
        }

        public final void setSchema(Collection<? extends Map<String, String>> schema) {
            this.schema = TsvVersionOptionsSchemaListCopier.copy(schema);
        }

        @Override
        public final Builder schemaWithStrings(Collection<? extends Map<String, String>> schema) {
            this.schema = TsvVersionOptionsSchemaListCopier.copy(schema);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder schemaWithStrings(Map<String, String>... schema) {
            schemaWithStrings(Arrays.asList(schema));
            return this;
        }

        @Override
        public TsvVersionOptions build() {
            return new TsvVersionOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
