/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkflowRequest extends OmicsRequest implements
        ToCopyableBuilder<UpdateWorkflowRequest.Builder, UpdateWorkflowRequest> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateWorkflowRequest::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateWorkflowRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateWorkflowRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageType").getter(getter(UpdateWorkflowRequest::storageTypeAsString))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()).build();

    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("storageCapacity").getter(getter(UpdateWorkflowRequest::storageCapacity))
            .setter(setter(Builder::storageCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCapacity").build()).build();

    private static final SdkField<String> README_MARKDOWN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("readmeMarkdown").getter(getter(UpdateWorkflowRequest::readmeMarkdown))
            .setter(setter(Builder::readmeMarkdown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readmeMarkdown").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, STORAGE_TYPE_FIELD, STORAGE_CAPACITY_FIELD, README_MARKDOWN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String name;

    private final String description;

    private final String storageType;

    private final Integer storageCapacity;

    private final String readmeMarkdown;

    private UpdateWorkflowRequest(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.storageType = builder.storageType;
        this.storageCapacity = builder.storageCapacity;
        this.readmeMarkdown = builder.readmeMarkdown;
    }

    /**
     * <p>
     * The workflow's ID.
     * </p>
     * 
     * @return The workflow's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * A name for the workflow.
     * </p>
     * 
     * @return A name for the workflow.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description for the workflow.
     * </p>
     * 
     * @return A description for the workflow.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The default storage type for runs that use this workflow. STATIC storage allocates a fixed amount of storage.
     * DYNAMIC storage dynamically scales the storage up or down, based on file system utilization. For more information
     * about static and dynamic storage, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/Using-workflows.html">Running workflows</a> in the <i>Amazon
     * Web Services HealthOmics User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The default storage type for runs that use this workflow. STATIC storage allocates a fixed amount of
     *         storage. DYNAMIC storage dynamically scales the storage up or down, based on file system utilization. For
     *         more information about static and dynamic storage, see <a
     *         href="https://docs.aws.amazon.com/omics/latest/dev/Using-workflows.html">Running workflows</a> in the
     *         <i>Amazon Web Services HealthOmics User Guide</i>.
     * @see StorageType
     */
    public final StorageType storageType() {
        return StorageType.fromValue(storageType);
    }

    /**
     * <p>
     * The default storage type for runs that use this workflow. STATIC storage allocates a fixed amount of storage.
     * DYNAMIC storage dynamically scales the storage up or down, based on file system utilization. For more information
     * about static and dynamic storage, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/Using-workflows.html">Running workflows</a> in the <i>Amazon
     * Web Services HealthOmics User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The default storage type for runs that use this workflow. STATIC storage allocates a fixed amount of
     *         storage. DYNAMIC storage dynamically scales the storage up or down, based on file system utilization. For
     *         more information about static and dynamic storage, see <a
     *         href="https://docs.aws.amazon.com/omics/latest/dev/Using-workflows.html">Running workflows</a> in the
     *         <i>Amazon Web Services HealthOmics User Guide</i>.
     * @see StorageType
     */
    public final String storageTypeAsString() {
        return storageType;
    }

    /**
     * <p>
     * The default static storage capacity (in gibibytes) for runs that use this workflow or workflow version.
     * </p>
     * 
     * @return The default static storage capacity (in gibibytes) for runs that use this workflow or workflow version.
     */
    public final Integer storageCapacity() {
        return storageCapacity;
    }

    /**
     * <p>
     * The markdown content for the workflow's README file. This provides documentation and usage information for users
     * of the workflow.
     * </p>
     * 
     * @return The markdown content for the workflow's README file. This provides documentation and usage information
     *         for users of the workflow.
     */
    public final String readmeMarkdown() {
        return readmeMarkdown;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(readmeMarkdown());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkflowRequest)) {
            return false;
        }
        UpdateWorkflowRequest other = (UpdateWorkflowRequest) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description())
                && Objects.equals(storageTypeAsString(), other.storageTypeAsString())
                && Objects.equals(storageCapacity(), other.storageCapacity())
                && Objects.equals(readmeMarkdown(), other.readmeMarkdown());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkflowRequest").add("Id", id()).add("Name", name()).add("Description", description())
                .add("StorageType", storageTypeAsString()).add("StorageCapacity", storageCapacity())
                .add("ReadmeMarkdown", readmeMarkdown()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "storageType":
            return Optional.ofNullable(clazz.cast(storageTypeAsString()));
        case "storageCapacity":
            return Optional.ofNullable(clazz.cast(storageCapacity()));
        case "readmeMarkdown":
            return Optional.ofNullable(clazz.cast(readmeMarkdown()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("storageType", STORAGE_TYPE_FIELD);
        map.put("storageCapacity", STORAGE_CAPACITY_FIELD);
        map.put("readmeMarkdown", README_MARKDOWN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkflowRequest, T> g) {
        return obj -> g.apply((UpdateWorkflowRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWorkflowRequest> {
        /**
         * <p>
         * The workflow's ID.
         * </p>
         * 
         * @param id
         *        The workflow's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * A name for the workflow.
         * </p>
         * 
         * @param name
         *        A name for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description for the workflow.
         * </p>
         * 
         * @param description
         *        A description for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The default storage type for runs that use this workflow. STATIC storage allocates a fixed amount of storage.
         * DYNAMIC storage dynamically scales the storage up or down, based on file system utilization. For more
         * information about static and dynamic storage, see <a
         * href="https://docs.aws.amazon.com/omics/latest/dev/Using-workflows.html">Running workflows</a> in the
         * <i>Amazon Web Services HealthOmics User Guide</i>.
         * </p>
         * 
         * @param storageType
         *        The default storage type for runs that use this workflow. STATIC storage allocates a fixed amount of
         *        storage. DYNAMIC storage dynamically scales the storage up or down, based on file system utilization.
         *        For more information about static and dynamic storage, see <a
         *        href="https://docs.aws.amazon.com/omics/latest/dev/Using-workflows.html">Running workflows</a> in the
         *        <i>Amazon Web Services HealthOmics User Guide</i>.
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The default storage type for runs that use this workflow. STATIC storage allocates a fixed amount of storage.
         * DYNAMIC storage dynamically scales the storage up or down, based on file system utilization. For more
         * information about static and dynamic storage, see <a
         * href="https://docs.aws.amazon.com/omics/latest/dev/Using-workflows.html">Running workflows</a> in the
         * <i>Amazon Web Services HealthOmics User Guide</i>.
         * </p>
         * 
         * @param storageType
         *        The default storage type for runs that use this workflow. STATIC storage allocates a fixed amount of
         *        storage. DYNAMIC storage dynamically scales the storage up or down, based on file system utilization.
         *        For more information about static and dynamic storage, see <a
         *        href="https://docs.aws.amazon.com/omics/latest/dev/Using-workflows.html">Running workflows</a> in the
         *        <i>Amazon Web Services HealthOmics User Guide</i>.
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(StorageType storageType);

        /**
         * <p>
         * The default static storage capacity (in gibibytes) for runs that use this workflow or workflow version.
         * </p>
         * 
         * @param storageCapacity
         *        The default static storage capacity (in gibibytes) for runs that use this workflow or workflow
         *        version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCapacity(Integer storageCapacity);

        /**
         * <p>
         * The markdown content for the workflow's README file. This provides documentation and usage information for
         * users of the workflow.
         * </p>
         * 
         * @param readmeMarkdown
         *        The markdown content for the workflow's README file. This provides documentation and usage information
         *        for users of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readmeMarkdown(String readmeMarkdown);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private String storageType;

        private Integer storageCapacity;

        private String readmeMarkdown;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkflowRequest model) {
            super(model);
            id(model.id);
            name(model.name);
            description(model.description);
            storageType(model.storageType);
            storageCapacity(model.storageCapacity);
            readmeMarkdown(model.readmeMarkdown);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final Integer getStorageCapacity() {
            return storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final String getReadmeMarkdown() {
            return readmeMarkdown;
        }

        public final void setReadmeMarkdown(String readmeMarkdown) {
            this.readmeMarkdown = readmeMarkdown;
        }

        @Override
        public final Builder readmeMarkdown(String readmeMarkdown) {
            this.readmeMarkdown = readmeMarkdown;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkflowRequest build() {
            return new UpdateWorkflowRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
