/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkflowVersionRequest extends OmicsRequest implements
        ToCopyableBuilder<UpdateWorkflowVersionRequest.Builder, UpdateWorkflowVersionRequest> {
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowId").getter(getter(UpdateWorkflowVersionRequest::workflowId))
            .setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowId").build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionName").getter(getter(UpdateWorkflowVersionRequest::versionName))
            .setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("versionName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateWorkflowVersionRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageType").getter(getter(UpdateWorkflowVersionRequest::storageTypeAsString))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()).build();

    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("storageCapacity").getter(getter(UpdateWorkflowVersionRequest::storageCapacity))
            .setter(setter(Builder::storageCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCapacity").build()).build();

    private static final SdkField<String> README_MARKDOWN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("readmeMarkdown").getter(getter(UpdateWorkflowVersionRequest::readmeMarkdown))
            .setter(setter(Builder::readmeMarkdown))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readmeMarkdown").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ID_FIELD,
            VERSION_NAME_FIELD, DESCRIPTION_FIELD, STORAGE_TYPE_FIELD, STORAGE_CAPACITY_FIELD, README_MARKDOWN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workflowId;

    private final String versionName;

    private final String description;

    private final String storageType;

    private final Integer storageCapacity;

    private final String readmeMarkdown;

    private UpdateWorkflowVersionRequest(BuilderImpl builder) {
        super(builder);
        this.workflowId = builder.workflowId;
        this.versionName = builder.versionName;
        this.description = builder.description;
        this.storageType = builder.storageType;
        this.storageCapacity = builder.storageCapacity;
        this.readmeMarkdown = builder.readmeMarkdown;
    }

    /**
     * <p>
     * The workflow's ID. The <code>workflowId</code> is not the UUID.
     * </p>
     * 
     * @return The workflow's ID. The <code>workflowId</code> is not the UUID.
     */
    public final String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * The name of the workflow version.
     * </p>
     * 
     * @return The name of the workflow version.
     */
    public final String versionName() {
        return versionName;
    }

    /**
     * <p>
     * Description of the workflow version.
     * </p>
     * 
     * @return Description of the workflow version.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The default storage type for runs that use this workflow version. The <code>storageType</code> can be overridden
     * at run time. <code>DYNAMIC</code> storage dynamically scales the storage up or down, based on file system
     * utilization. STATIC storage allocates a fixed amount of storage. For more information about dynamic and static
     * storage types, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflows-run-types.html">Run storage
     * types</a> in the <i>in the <i>Amazon Web Services HealthOmics User Guide</i> </i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The default storage type for runs that use this workflow version. The <code>storageType</code> can be
     *         overridden at run time. <code>DYNAMIC</code> storage dynamically scales the storage up or down, based on
     *         file system utilization. STATIC storage allocates a fixed amount of storage. For more information about
     *         dynamic and static storage types, see <a
     *         href="https://docs.aws.amazon.com/omics/latest/dev/workflows-run-types.html">Run storage types</a> in the
     *         <i>in the <i>Amazon Web Services HealthOmics User Guide</i> </i>.
     * @see StorageType
     */
    public final StorageType storageType() {
        return StorageType.fromValue(storageType);
    }

    /**
     * <p>
     * The default storage type for runs that use this workflow version. The <code>storageType</code> can be overridden
     * at run time. <code>DYNAMIC</code> storage dynamically scales the storage up or down, based on file system
     * utilization. STATIC storage allocates a fixed amount of storage. For more information about dynamic and static
     * storage types, see <a href="https://docs.aws.amazon.com/omics/latest/dev/workflows-run-types.html">Run storage
     * types</a> in the <i>in the <i>Amazon Web Services HealthOmics User Guide</i> </i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The default storage type for runs that use this workflow version. The <code>storageType</code> can be
     *         overridden at run time. <code>DYNAMIC</code> storage dynamically scales the storage up or down, based on
     *         file system utilization. STATIC storage allocates a fixed amount of storage. For more information about
     *         dynamic and static storage types, see <a
     *         href="https://docs.aws.amazon.com/omics/latest/dev/workflows-run-types.html">Run storage types</a> in the
     *         <i>in the <i>Amazon Web Services HealthOmics User Guide</i> </i>.
     * @see StorageType
     */
    public final String storageTypeAsString() {
        return storageType;
    }

    /**
     * <p>
     * The default static storage capacity (in gibibytes) for runs that use this workflow version. The
     * <code>storageCapacity</code> can be overwritten at run time. The storage capacity is not required for runs with a
     * <code>DYNAMIC</code> storage type.
     * </p>
     * 
     * @return The default static storage capacity (in gibibytes) for runs that use this workflow version. The
     *         <code>storageCapacity</code> can be overwritten at run time. The storage capacity is not required for
     *         runs with a <code>DYNAMIC</code> storage type.
     */
    public final Integer storageCapacity() {
        return storageCapacity;
    }

    /**
     * <p>
     * The markdown content for the workflow version's README file. This provides documentation and usage information
     * for users of this specific workflow version.
     * </p>
     * 
     * @return The markdown content for the workflow version's README file. This provides documentation and usage
     *         information for users of this specific workflow version.
     */
    public final String readmeMarkdown() {
        return readmeMarkdown;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(readmeMarkdown());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkflowVersionRequest)) {
            return false;
        }
        UpdateWorkflowVersionRequest other = (UpdateWorkflowVersionRequest) obj;
        return Objects.equals(workflowId(), other.workflowId()) && Objects.equals(versionName(), other.versionName())
                && Objects.equals(description(), other.description())
                && Objects.equals(storageTypeAsString(), other.storageTypeAsString())
                && Objects.equals(storageCapacity(), other.storageCapacity())
                && Objects.equals(readmeMarkdown(), other.readmeMarkdown());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkflowVersionRequest").add("WorkflowId", workflowId()).add("VersionName", versionName())
                .add("Description", description()).add("StorageType", storageTypeAsString())
                .add("StorageCapacity", storageCapacity()).add("ReadmeMarkdown", readmeMarkdown()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        case "versionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "storageType":
            return Optional.ofNullable(clazz.cast(storageTypeAsString()));
        case "storageCapacity":
            return Optional.ofNullable(clazz.cast(storageCapacity()));
        case "readmeMarkdown":
            return Optional.ofNullable(clazz.cast(readmeMarkdown()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workflowId", WORKFLOW_ID_FIELD);
        map.put("versionName", VERSION_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("storageType", STORAGE_TYPE_FIELD);
        map.put("storageCapacity", STORAGE_CAPACITY_FIELD);
        map.put("readmeMarkdown", README_MARKDOWN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkflowVersionRequest, T> g) {
        return obj -> g.apply((UpdateWorkflowVersionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWorkflowVersionRequest> {
        /**
         * <p>
         * The workflow's ID. The <code>workflowId</code> is not the UUID.
         * </p>
         * 
         * @param workflowId
         *        The workflow's ID. The <code>workflowId</code> is not the UUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * The name of the workflow version.
         * </p>
         * 
         * @param versionName
         *        The name of the workflow version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * <p>
         * Description of the workflow version.
         * </p>
         * 
         * @param description
         *        Description of the workflow version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The default storage type for runs that use this workflow version. The <code>storageType</code> can be
         * overridden at run time. <code>DYNAMIC</code> storage dynamically scales the storage up or down, based on file
         * system utilization. STATIC storage allocates a fixed amount of storage. For more information about dynamic
         * and static storage types, see <a
         * href="https://docs.aws.amazon.com/omics/latest/dev/workflows-run-types.html">Run storage types</a> in the
         * <i>in the <i>Amazon Web Services HealthOmics User Guide</i> </i>.
         * </p>
         * 
         * @param storageType
         *        The default storage type for runs that use this workflow version. The <code>storageType</code> can be
         *        overridden at run time. <code>DYNAMIC</code> storage dynamically scales the storage up or down, based
         *        on file system utilization. STATIC storage allocates a fixed amount of storage. For more information
         *        about dynamic and static storage types, see <a
         *        href="https://docs.aws.amazon.com/omics/latest/dev/workflows-run-types.html">Run storage types</a> in
         *        the <i>in the <i>Amazon Web Services HealthOmics User Guide</i> </i>.
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The default storage type for runs that use this workflow version. The <code>storageType</code> can be
         * overridden at run time. <code>DYNAMIC</code> storage dynamically scales the storage up or down, based on file
         * system utilization. STATIC storage allocates a fixed amount of storage. For more information about dynamic
         * and static storage types, see <a
         * href="https://docs.aws.amazon.com/omics/latest/dev/workflows-run-types.html">Run storage types</a> in the
         * <i>in the <i>Amazon Web Services HealthOmics User Guide</i> </i>.
         * </p>
         * 
         * @param storageType
         *        The default storage type for runs that use this workflow version. The <code>storageType</code> can be
         *        overridden at run time. <code>DYNAMIC</code> storage dynamically scales the storage up or down, based
         *        on file system utilization. STATIC storage allocates a fixed amount of storage. For more information
         *        about dynamic and static storage types, see <a
         *        href="https://docs.aws.amazon.com/omics/latest/dev/workflows-run-types.html">Run storage types</a> in
         *        the <i>in the <i>Amazon Web Services HealthOmics User Guide</i> </i>.
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(StorageType storageType);

        /**
         * <p>
         * The default static storage capacity (in gibibytes) for runs that use this workflow version. The
         * <code>storageCapacity</code> can be overwritten at run time. The storage capacity is not required for runs
         * with a <code>DYNAMIC</code> storage type.
         * </p>
         * 
         * @param storageCapacity
         *        The default static storage capacity (in gibibytes) for runs that use this workflow version. The
         *        <code>storageCapacity</code> can be overwritten at run time. The storage capacity is not required for
         *        runs with a <code>DYNAMIC</code> storage type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCapacity(Integer storageCapacity);

        /**
         * <p>
         * The markdown content for the workflow version's README file. This provides documentation and usage
         * information for users of this specific workflow version.
         * </p>
         * 
         * @param readmeMarkdown
         *        The markdown content for the workflow version's README file. This provides documentation and usage
         *        information for users of this specific workflow version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readmeMarkdown(String readmeMarkdown);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String workflowId;

        private String versionName;

        private String description;

        private String storageType;

        private Integer storageCapacity;

        private String readmeMarkdown;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkflowVersionRequest model) {
            super(model);
            workflowId(model.workflowId);
            versionName(model.versionName);
            description(model.description);
            storageType(model.storageType);
            storageCapacity(model.storageCapacity);
            readmeMarkdown(model.readmeMarkdown);
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getVersionName() {
            return versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final Integer getStorageCapacity() {
            return storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final String getReadmeMarkdown() {
            return readmeMarkdown;
        }

        public final void setReadmeMarkdown(String readmeMarkdown) {
            this.readmeMarkdown = readmeMarkdown;
        }

        @Override
        public final Builder readmeMarkdown(String readmeMarkdown) {
            this.readmeMarkdown = readmeMarkdown;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkflowVersionRequest build() {
            return new UpdateWorkflowVersionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
