/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageMapping
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageMapping> {
    private static final SdkField<String> SOURCE_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceImage").getter(ImageMapping.getter(ImageMapping::sourceImage)).setter(ImageMapping.setter(Builder::sourceImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceImage").build()}).build();
    private static final SdkField<String> DESTINATION_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("destinationImage").getter(ImageMapping.getter(ImageMapping::destinationImage)).setter(ImageMapping.setter(Builder::destinationImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationImage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_IMAGE_FIELD, DESTINATION_IMAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageMapping.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String sourceImage;
    private final String destinationImage;

    private ImageMapping(BuilderImpl builder) {
        this.sourceImage = builder.sourceImage;
        this.destinationImage = builder.destinationImage;
    }

    public final String sourceImage() {
        return this.sourceImage;
    }

    public final String destinationImage() {
        return this.destinationImage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationImage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageMapping)) {
            return false;
        }
        ImageMapping other = (ImageMapping)obj;
        return Objects.equals(this.sourceImage(), other.sourceImage()) && Objects.equals(this.destinationImage(), other.destinationImage());
    }

    public final String toString() {
        return ToString.builder((String)"ImageMapping").add("SourceImage", (Object)this.sourceImage()).add("DestinationImage", (Object)this.destinationImage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceImage": {
                return Optional.ofNullable(clazz.cast(this.sourceImage()));
            }
            case "destinationImage": {
                return Optional.ofNullable(clazz.cast(this.destinationImage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("sourceImage", SOURCE_IMAGE_FIELD);
        map.put("destinationImage", DESTINATION_IMAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageMapping, T> g) {
        return obj -> g.apply((ImageMapping)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceImage;
        private String destinationImage;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageMapping model) {
            this.sourceImage(model.sourceImage);
            this.destinationImage(model.destinationImage);
        }

        public final String getSourceImage() {
            return this.sourceImage;
        }

        public final void setSourceImage(String sourceImage) {
            this.sourceImage = sourceImage;
        }

        @Override
        public final Builder sourceImage(String sourceImage) {
            this.sourceImage = sourceImage;
            return this;
        }

        public final String getDestinationImage() {
            return this.destinationImage;
        }

        public final void setDestinationImage(String destinationImage) {
            this.destinationImage = destinationImage;
        }

        @Override
        public final Builder destinationImage(String destinationImage) {
            this.destinationImage = destinationImage;
            return this;
        }

        public ImageMapping build() {
            return new ImageMapping(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageMapping> {
        public Builder sourceImage(String var1);

        public Builder destinationImage(String var1);
    }
}

