/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Annotation store versions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnnotationStoreVersionItem implements SdkPojo, Serializable,
        ToCopyableBuilder<AnnotationStoreVersionItem.Builder, AnnotationStoreVersionItem> {
    private static final SdkField<String> STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storeId").getter(getter(AnnotationStoreVersionItem::storeId)).setter(setter(Builder::storeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(AnnotationStoreVersionItem::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AnnotationStoreVersionItem::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> VERSION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionArn").getter(getter(AnnotationStoreVersionItem::versionArn)).setter(setter(Builder::versionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AnnotationStoreVersionItem::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> VERSION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("versionName").getter(getter(AnnotationStoreVersionItem::versionName))
            .setter(setter(Builder::versionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AnnotationStoreVersionItem::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(AnnotationStoreVersionItem::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(AnnotationStoreVersionItem::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(AnnotationStoreVersionItem::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<Long> VERSION_SIZE_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("versionSizeBytes").getter(getter(AnnotationStoreVersionItem::versionSizeBytes))
            .setter(setter(Builder::versionSizeBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("versionSizeBytes").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORE_ID_FIELD, ID_FIELD,
            STATUS_FIELD, VERSION_ARN_FIELD, NAME_FIELD, VERSION_NAME_FIELD, DESCRIPTION_FIELD, CREATION_TIME_FIELD,
            UPDATE_TIME_FIELD, STATUS_MESSAGE_FIELD, VERSION_SIZE_BYTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String storeId;

    private final String id;

    private final String status;

    private final String versionArn;

    private final String name;

    private final String versionName;

    private final String description;

    private final Instant creationTime;

    private final Instant updateTime;

    private final String statusMessage;

    private final Long versionSizeBytes;

    private AnnotationStoreVersionItem(BuilderImpl builder) {
        this.storeId = builder.storeId;
        this.id = builder.id;
        this.status = builder.status;
        this.versionArn = builder.versionArn;
        this.name = builder.name;
        this.versionName = builder.versionName;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
        this.updateTime = builder.updateTime;
        this.statusMessage = builder.statusMessage;
        this.versionSizeBytes = builder.versionSizeBytes;
    }

    /**
     * <p>
     * The store ID for an annotation store version.
     * </p>
     * 
     * @return The store ID for an annotation store version.
     */
    public final String storeId() {
        return storeId;
    }

    /**
     * <p>
     * The annotation store version ID.
     * </p>
     * 
     * @return The annotation store version ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The status of an annotation store version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of an annotation store version.
     * @see VersionStatus
     */
    public final VersionStatus status() {
        return VersionStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of an annotation store version.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link VersionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of an annotation store version.
     * @see VersionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The Arn for an annotation store version.
     * </p>
     * 
     * @return The Arn for an annotation store version.
     */
    public final String versionArn() {
        return versionArn;
    }

    /**
     * <p>
     * A name given to an annotation store version to distinguish it from others.
     * </p>
     * 
     * @return A name given to an annotation store version to distinguish it from others.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The name of an annotation store version.
     * </p>
     * 
     * @return The name of an annotation store version.
     */
    public final String versionName() {
        return versionName;
    }

    /**
     * <p>
     * The description of an annotation store version.
     * </p>
     * 
     * @return The description of an annotation store version.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The time stamp for when an annotation store version was created.
     * </p>
     * 
     * @return The time stamp for when an annotation store version was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The time stamp for when an annotation store version was updated.
     * </p>
     * 
     * @return The time stamp for when an annotation store version was updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The status of an annotation store version.
     * </p>
     * 
     * @return The status of an annotation store version.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The size of an annotation store version in Bytes.
     * </p>
     * 
     * @return The size of an annotation store version in Bytes.
     */
    public final Long versionSizeBytes() {
        return versionSizeBytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storeId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(versionArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(versionName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(versionSizeBytes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnnotationStoreVersionItem)) {
            return false;
        }
        AnnotationStoreVersionItem other = (AnnotationStoreVersionItem) obj;
        return Objects.equals(storeId(), other.storeId()) && Objects.equals(id(), other.id())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(versionArn(), other.versionArn())
                && Objects.equals(name(), other.name()) && Objects.equals(versionName(), other.versionName())
                && Objects.equals(description(), other.description()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(updateTime(), other.updateTime()) && Objects.equals(statusMessage(), other.statusMessage())
                && Objects.equals(versionSizeBytes(), other.versionSizeBytes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnnotationStoreVersionItem").add("StoreId", storeId()).add("Id", id())
                .add("Status", statusAsString()).add("VersionArn", versionArn()).add("Name", name())
                .add("VersionName", versionName()).add("Description", description()).add("CreationTime", creationTime())
                .add("UpdateTime", updateTime()).add("StatusMessage", statusMessage())
                .add("VersionSizeBytes", versionSizeBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "storeId":
            return Optional.ofNullable(clazz.cast(storeId()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "versionArn":
            return Optional.ofNullable(clazz.cast(versionArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "versionName":
            return Optional.ofNullable(clazz.cast(versionName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "versionSizeBytes":
            return Optional.ofNullable(clazz.cast(versionSizeBytes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("storeId", STORE_ID_FIELD);
        map.put("id", ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("versionArn", VERSION_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("versionName", VERSION_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("versionSizeBytes", VERSION_SIZE_BYTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AnnotationStoreVersionItem, T> g) {
        return obj -> g.apply((AnnotationStoreVersionItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnnotationStoreVersionItem> {
        /**
         * <p>
         * The store ID for an annotation store version.
         * </p>
         * 
         * @param storeId
         *        The store ID for an annotation store version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storeId(String storeId);

        /**
         * <p>
         * The annotation store version ID.
         * </p>
         * 
         * @param id
         *        The annotation store version ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The status of an annotation store version.
         * </p>
         * 
         * @param status
         *        The status of an annotation store version.
         * @see VersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VersionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of an annotation store version.
         * </p>
         * 
         * @param status
         *        The status of an annotation store version.
         * @see VersionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VersionStatus
         */
        Builder status(VersionStatus status);

        /**
         * <p>
         * The Arn for an annotation store version.
         * </p>
         * 
         * @param versionArn
         *        The Arn for an annotation store version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionArn(String versionArn);

        /**
         * <p>
         * A name given to an annotation store version to distinguish it from others.
         * </p>
         * 
         * @param name
         *        A name given to an annotation store version to distinguish it from others.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of an annotation store version.
         * </p>
         * 
         * @param versionName
         *        The name of an annotation store version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionName(String versionName);

        /**
         * <p>
         * The description of an annotation store version.
         * </p>
         * 
         * @param description
         *        The description of an annotation store version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The time stamp for when an annotation store version was created.
         * </p>
         * 
         * @param creationTime
         *        The time stamp for when an annotation store version was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The time stamp for when an annotation store version was updated.
         * </p>
         * 
         * @param updateTime
         *        The time stamp for when an annotation store version was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The status of an annotation store version.
         * </p>
         * 
         * @param statusMessage
         *        The status of an annotation store version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The size of an annotation store version in Bytes.
         * </p>
         * 
         * @param versionSizeBytes
         *        The size of an annotation store version in Bytes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionSizeBytes(Long versionSizeBytes);
    }

    static final class BuilderImpl implements Builder {
        private String storeId;

        private String id;

        private String status;

        private String versionArn;

        private String name;

        private String versionName;

        private String description;

        private Instant creationTime;

        private Instant updateTime;

        private String statusMessage;

        private Long versionSizeBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(AnnotationStoreVersionItem model) {
            storeId(model.storeId);
            id(model.id);
            status(model.status);
            versionArn(model.versionArn);
            name(model.name);
            versionName(model.versionName);
            description(model.description);
            creationTime(model.creationTime);
            updateTime(model.updateTime);
            statusMessage(model.statusMessage);
            versionSizeBytes(model.versionSizeBytes);
        }

        public final String getStoreId() {
            return storeId;
        }

        public final void setStoreId(String storeId) {
            this.storeId = storeId;
        }

        @Override
        public final Builder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(VersionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getVersionArn() {
            return versionArn;
        }

        public final void setVersionArn(String versionArn) {
            this.versionArn = versionArn;
        }

        @Override
        public final Builder versionArn(String versionArn) {
            this.versionArn = versionArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getVersionName() {
            return versionName;
        }

        public final void setVersionName(String versionName) {
            this.versionName = versionName;
        }

        @Override
        public final Builder versionName(String versionName) {
            this.versionName = versionName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Long getVersionSizeBytes() {
            return versionSizeBytes;
        }

        public final void setVersionSizeBytes(Long versionSizeBytes) {
            this.versionSizeBytes = versionSizeBytes;
        }

        @Override
        public final Builder versionSizeBytes(Long versionSizeBytes) {
            this.versionSizeBytes = versionSizeBytes;
            return this;
        }

        @Override
        public AnnotationStoreVersionItem build() {
            return new AnnotationStoreVersionItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
