/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateRunCacheRequest extends OmicsRequest implements
        ToCopyableBuilder<CreateRunCacheRequest.Builder, CreateRunCacheRequest> {
    private static final SdkField<String> CACHE_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cacheBehavior").getter(getter(CreateRunCacheRequest::cacheBehaviorAsString))
            .setter(setter(Builder::cacheBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBehavior").build()).build();

    private static final SdkField<String> CACHE_S3_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cacheS3Location").getter(getter(CreateRunCacheRequest::cacheS3Location))
            .setter(setter(Builder::cacheS3Location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheS3Location").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateRunCacheRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateRunCacheRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("requestId")
            .getter(getter(CreateRunCacheRequest::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateRunCacheRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CACHE_BUCKET_OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cacheBucketOwnerId").getter(getter(CreateRunCacheRequest::cacheBucketOwnerId))
            .setter(setter(Builder::cacheBucketOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cacheBucketOwnerId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CACHE_BEHAVIOR_FIELD,
            CACHE_S3_LOCATION_FIELD, DESCRIPTION_FIELD, NAME_FIELD, REQUEST_ID_FIELD, TAGS_FIELD, CACHE_BUCKET_OWNER_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String cacheBehavior;

    private final String cacheS3Location;

    private final String description;

    private final String name;

    private final String requestIdValue;

    private final Map<String, String> tags;

    private final String cacheBucketOwnerId;

    private CreateRunCacheRequest(BuilderImpl builder) {
        super(builder);
        this.cacheBehavior = builder.cacheBehavior;
        this.cacheS3Location = builder.cacheS3Location;
        this.description = builder.description;
        this.name = builder.name;
        this.requestIdValue = builder.requestIdValue;
        this.tags = builder.tags;
        this.cacheBucketOwnerId = builder.cacheBucketOwnerId;
    }

    /**
     * <p>
     * Default cache behavior for runs that use this cache. Supported values are:
     * </p>
     * <p>
     * <code>CACHE_ON_FAILURE</code>: Caches task outputs from completed tasks for runs that fail. This setting is
     * useful if you're debugging a workflow that fails after several tasks completed successfully. The subsequent run
     * uses the cache outputs for previously-completed tasks if the task definition, inputs, and container in ECR are
     * identical to the prior run.
     * </p>
     * <p>
     * <code>CACHE_ALWAYS</code>: Caches task outputs from completed tasks for all runs. This setting is useful in
     * development mode, but do not use it in a production setting.
     * </p>
     * <p>
     * If you don't specify a value, the default behavior is CACHE_ON_FAILURE. When you start a run that uses this
     * cache, you can override the default cache behavior.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/how-run-cache.html#run-cache-behavior">Run cache behavior</a>
     * in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cacheBehavior}
     * will return {@link CacheBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cacheBehaviorAsString}.
     * </p>
     * 
     * @return Default cache behavior for runs that use this cache. Supported values are:</p>
     *         <p>
     *         <code>CACHE_ON_FAILURE</code>: Caches task outputs from completed tasks for runs that fail. This setting
     *         is useful if you're debugging a workflow that fails after several tasks completed successfully. The
     *         subsequent run uses the cache outputs for previously-completed tasks if the task definition, inputs, and
     *         container in ECR are identical to the prior run.
     *         </p>
     *         <p>
     *         <code>CACHE_ALWAYS</code>: Caches task outputs from completed tasks for all runs. This setting is useful
     *         in development mode, but do not use it in a production setting.
     *         </p>
     *         <p>
     *         If you don't specify a value, the default behavior is CACHE_ON_FAILURE. When you start a run that uses
     *         this cache, you can override the default cache behavior.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/omics/latest/dev/how-run-cache.html#run-cache-behavior">Run cache
     *         behavior</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * @see CacheBehavior
     */
    public final CacheBehavior cacheBehavior() {
        return CacheBehavior.fromValue(cacheBehavior);
    }

    /**
     * <p>
     * Default cache behavior for runs that use this cache. Supported values are:
     * </p>
     * <p>
     * <code>CACHE_ON_FAILURE</code>: Caches task outputs from completed tasks for runs that fail. This setting is
     * useful if you're debugging a workflow that fails after several tasks completed successfully. The subsequent run
     * uses the cache outputs for previously-completed tasks if the task definition, inputs, and container in ECR are
     * identical to the prior run.
     * </p>
     * <p>
     * <code>CACHE_ALWAYS</code>: Caches task outputs from completed tasks for all runs. This setting is useful in
     * development mode, but do not use it in a production setting.
     * </p>
     * <p>
     * If you don't specify a value, the default behavior is CACHE_ON_FAILURE. When you start a run that uses this
     * cache, you can override the default cache behavior.
     * </p>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/omics/latest/dev/how-run-cache.html#run-cache-behavior">Run cache behavior</a>
     * in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #cacheBehavior}
     * will return {@link CacheBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #cacheBehaviorAsString}.
     * </p>
     * 
     * @return Default cache behavior for runs that use this cache. Supported values are:</p>
     *         <p>
     *         <code>CACHE_ON_FAILURE</code>: Caches task outputs from completed tasks for runs that fail. This setting
     *         is useful if you're debugging a workflow that fails after several tasks completed successfully. The
     *         subsequent run uses the cache outputs for previously-completed tasks if the task definition, inputs, and
     *         container in ECR are identical to the prior run.
     *         </p>
     *         <p>
     *         <code>CACHE_ALWAYS</code>: Caches task outputs from completed tasks for all runs. This setting is useful
     *         in development mode, but do not use it in a production setting.
     *         </p>
     *         <p>
     *         If you don't specify a value, the default behavior is CACHE_ON_FAILURE. When you start a run that uses
     *         this cache, you can override the default cache behavior.
     *         </p>
     *         <p>
     *         For more information, see <a
     *         href="https://docs.aws.amazon.com/omics/latest/dev/how-run-cache.html#run-cache-behavior">Run cache
     *         behavior</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * @see CacheBehavior
     */
    public final String cacheBehaviorAsString() {
        return cacheBehavior;
    }

    /**
     * <p>
     * Specify the S3 location for storing the cached task outputs. This data must be immediately accessible (not in an
     * archived state).
     * </p>
     * 
     * @return Specify the S3 location for storing the cached task outputs. This data must be immediately accessible
     *         (not in an archived state).
     */
    public final String cacheS3Location() {
        return cacheS3Location;
    }

    /**
     * <p>
     * Enter a description of the run cache.
     * </p>
     * 
     * @return Enter a description of the run cache.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Enter a user-friendly name for the run cache.
     * </p>
     * 
     * @return Enter a user-friendly name for the run cache.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A unique request token, to ensure idempotency. If you don't specify a token, Amazon Web Services HealthOmics
     * automatically generates a universally unique identifier (UUID) for the request.
     * </p>
     * 
     * @return A unique request token, to ensure idempotency. If you don't specify a token, Amazon Web Services
     *         HealthOmics automatically generates a universally unique identifier (UUID) for the request.
     */
    public final String requestId() {
        return requestIdValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Specify one or more tags to associate with this run cache.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Specify one or more tags to associate with this run cache.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the expected owner of the S3 bucket for the run cache. If not provided,
     * your account ID is set as the owner of the bucket.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the expected owner of the S3 bucket for the run cache. If not
     *         provided, your account ID is set as the owner of the bucket.
     */
    public final String cacheBucketOwnerId() {
        return cacheBucketOwnerId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(cacheBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cacheS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(cacheBucketOwnerId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRunCacheRequest)) {
            return false;
        }
        CreateRunCacheRequest other = (CreateRunCacheRequest) obj;
        return Objects.equals(cacheBehaviorAsString(), other.cacheBehaviorAsString())
                && Objects.equals(cacheS3Location(), other.cacheS3Location())
                && Objects.equals(description(), other.description()) && Objects.equals(name(), other.name())
                && Objects.equals(requestId(), other.requestId()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(cacheBucketOwnerId(), other.cacheBucketOwnerId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateRunCacheRequest").add("CacheBehavior", cacheBehaviorAsString())
                .add("CacheS3Location", cacheS3Location()).add("Description", description()).add("Name", name())
                .add("RequestId", requestId()).add("Tags", hasTags() ? tags() : null)
                .add("CacheBucketOwnerId", cacheBucketOwnerId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cacheBehavior":
            return Optional.ofNullable(clazz.cast(cacheBehaviorAsString()));
        case "cacheS3Location":
            return Optional.ofNullable(clazz.cast(cacheS3Location()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "requestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "cacheBucketOwnerId":
            return Optional.ofNullable(clazz.cast(cacheBucketOwnerId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cacheBehavior", CACHE_BEHAVIOR_FIELD);
        map.put("cacheS3Location", CACHE_S3_LOCATION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("requestId", REQUEST_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("cacheBucketOwnerId", CACHE_BUCKET_OWNER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateRunCacheRequest, T> g) {
        return obj -> g.apply((CreateRunCacheRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateRunCacheRequest> {
        /**
         * <p>
         * Default cache behavior for runs that use this cache. Supported values are:
         * </p>
         * <p>
         * <code>CACHE_ON_FAILURE</code>: Caches task outputs from completed tasks for runs that fail. This setting is
         * useful if you're debugging a workflow that fails after several tasks completed successfully. The subsequent
         * run uses the cache outputs for previously-completed tasks if the task definition, inputs, and container in
         * ECR are identical to the prior run.
         * </p>
         * <p>
         * <code>CACHE_ALWAYS</code>: Caches task outputs from completed tasks for all runs. This setting is useful in
         * development mode, but do not use it in a production setting.
         * </p>
         * <p>
         * If you don't specify a value, the default behavior is CACHE_ON_FAILURE. When you start a run that uses this
         * cache, you can override the default cache behavior.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/omics/latest/dev/how-run-cache.html#run-cache-behavior">Run cache
         * behavior</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
         * </p>
         * 
         * @param cacheBehavior
         *        Default cache behavior for runs that use this cache. Supported values are:</p>
         *        <p>
         *        <code>CACHE_ON_FAILURE</code>: Caches task outputs from completed tasks for runs that fail. This
         *        setting is useful if you're debugging a workflow that fails after several tasks completed
         *        successfully. The subsequent run uses the cache outputs for previously-completed tasks if the task
         *        definition, inputs, and container in ECR are identical to the prior run.
         *        </p>
         *        <p>
         *        <code>CACHE_ALWAYS</code>: Caches task outputs from completed tasks for all runs. This setting is
         *        useful in development mode, but do not use it in a production setting.
         *        </p>
         *        <p>
         *        If you don't specify a value, the default behavior is CACHE_ON_FAILURE. When you start a run that uses
         *        this cache, you can override the default cache behavior.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/omics/latest/dev/how-run-cache.html#run-cache-behavior">Run cache
         *        behavior</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
         * @see CacheBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CacheBehavior
         */
        Builder cacheBehavior(String cacheBehavior);

        /**
         * <p>
         * Default cache behavior for runs that use this cache. Supported values are:
         * </p>
         * <p>
         * <code>CACHE_ON_FAILURE</code>: Caches task outputs from completed tasks for runs that fail. This setting is
         * useful if you're debugging a workflow that fails after several tasks completed successfully. The subsequent
         * run uses the cache outputs for previously-completed tasks if the task definition, inputs, and container in
         * ECR are identical to the prior run.
         * </p>
         * <p>
         * <code>CACHE_ALWAYS</code>: Caches task outputs from completed tasks for all runs. This setting is useful in
         * development mode, but do not use it in a production setting.
         * </p>
         * <p>
         * If you don't specify a value, the default behavior is CACHE_ON_FAILURE. When you start a run that uses this
         * cache, you can override the default cache behavior.
         * </p>
         * <p>
         * For more information, see <a
         * href="https://docs.aws.amazon.com/omics/latest/dev/how-run-cache.html#run-cache-behavior">Run cache
         * behavior</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
         * </p>
         * 
         * @param cacheBehavior
         *        Default cache behavior for runs that use this cache. Supported values are:</p>
         *        <p>
         *        <code>CACHE_ON_FAILURE</code>: Caches task outputs from completed tasks for runs that fail. This
         *        setting is useful if you're debugging a workflow that fails after several tasks completed
         *        successfully. The subsequent run uses the cache outputs for previously-completed tasks if the task
         *        definition, inputs, and container in ECR are identical to the prior run.
         *        </p>
         *        <p>
         *        <code>CACHE_ALWAYS</code>: Caches task outputs from completed tasks for all runs. This setting is
         *        useful in development mode, but do not use it in a production setting.
         *        </p>
         *        <p>
         *        If you don't specify a value, the default behavior is CACHE_ON_FAILURE. When you start a run that uses
         *        this cache, you can override the default cache behavior.
         *        </p>
         *        <p>
         *        For more information, see <a
         *        href="https://docs.aws.amazon.com/omics/latest/dev/how-run-cache.html#run-cache-behavior">Run cache
         *        behavior</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
         * @see CacheBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CacheBehavior
         */
        Builder cacheBehavior(CacheBehavior cacheBehavior);

        /**
         * <p>
         * Specify the S3 location for storing the cached task outputs. This data must be immediately accessible (not in
         * an archived state).
         * </p>
         * 
         * @param cacheS3Location
         *        Specify the S3 location for storing the cached task outputs. This data must be immediately accessible
         *        (not in an archived state).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheS3Location(String cacheS3Location);

        /**
         * <p>
         * Enter a description of the run cache.
         * </p>
         * 
         * @param description
         *        Enter a description of the run cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Enter a user-friendly name for the run cache.
         * </p>
         * 
         * @param name
         *        Enter a user-friendly name for the run cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A unique request token, to ensure idempotency. If you don't specify a token, Amazon Web Services HealthOmics
         * automatically generates a universally unique identifier (UUID) for the request.
         * </p>
         * 
         * @param requestIdValue
         *        A unique request token, to ensure idempotency. If you don't specify a token, Amazon Web Services
         *        HealthOmics automatically generates a universally unique identifier (UUID) for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestIdValue);

        /**
         * <p>
         * Specify one or more tags to associate with this run cache.
         * </p>
         * 
         * @param tags
         *        Specify one or more tags to associate with this run cache.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The Amazon Web Services account ID of the expected owner of the S3 bucket for the run cache. If not provided,
         * your account ID is set as the owner of the bucket.
         * </p>
         * 
         * @param cacheBucketOwnerId
         *        The Amazon Web Services account ID of the expected owner of the S3 bucket for the run cache. If not
         *        provided, your account ID is set as the owner of the bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cacheBucketOwnerId(String cacheBucketOwnerId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String cacheBehavior;

        private String cacheS3Location;

        private String description;

        private String name;

        private String requestIdValue;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String cacheBucketOwnerId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRunCacheRequest model) {
            super(model);
            cacheBehavior(model.cacheBehavior);
            cacheS3Location(model.cacheS3Location);
            description(model.description);
            name(model.name);
            requestId(model.requestIdValue);
            tags(model.tags);
            cacheBucketOwnerId(model.cacheBucketOwnerId);
        }

        public final String getCacheBehavior() {
            return cacheBehavior;
        }

        public final void setCacheBehavior(String cacheBehavior) {
            this.cacheBehavior = cacheBehavior;
        }

        @Override
        public final Builder cacheBehavior(String cacheBehavior) {
            this.cacheBehavior = cacheBehavior;
            return this;
        }

        @Override
        public final Builder cacheBehavior(CacheBehavior cacheBehavior) {
            this.cacheBehavior(cacheBehavior == null ? null : cacheBehavior.toString());
            return this;
        }

        public final String getCacheS3Location() {
            return cacheS3Location;
        }

        public final void setCacheS3Location(String cacheS3Location) {
            this.cacheS3Location = cacheS3Location;
        }

        @Override
        public final Builder cacheS3Location(String cacheS3Location) {
            this.cacheS3Location = cacheS3Location;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRequestId() {
            return requestIdValue;
        }

        public final void setRequestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
        }

        @Override
        public final Builder requestId(String requestIdValue) {
            this.requestIdValue = requestIdValue;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getCacheBucketOwnerId() {
            return cacheBucketOwnerId;
        }

        public final void setCacheBucketOwnerId(String cacheBucketOwnerId) {
            this.cacheBucketOwnerId = cacheBucketOwnerId;
        }

        @Override
        public final Builder cacheBucketOwnerId(String cacheBucketOwnerId) {
            this.cacheBucketOwnerId = cacheBucketOwnerId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateRunCacheRequest build() {
            return new CreateRunCacheRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
