/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSequenceStoreRequest extends OmicsRequest implements
        ToCopyableBuilder<CreateSequenceStoreRequest.Builder, CreateSequenceStoreRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateSequenceStoreRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateSequenceStoreRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<SseConfig> SSE_CONFIG_FIELD = SdkField.<SseConfig> builder(MarshallingType.SDK_POJO)
            .memberName("sseConfig").getter(getter(CreateSequenceStoreRequest::sseConfig)).setter(setter(Builder::sseConfig))
            .constructor(SseConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sseConfig").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateSequenceStoreRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateSequenceStoreRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> FALLBACK_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fallbackLocation").getter(getter(CreateSequenceStoreRequest::fallbackLocation))
            .setter(setter(Builder::fallbackLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fallbackLocation").build()).build();

    private static final SdkField<String> E_TAG_ALGORITHM_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eTagAlgorithmFamily").getter(getter(CreateSequenceStoreRequest::eTagAlgorithmFamilyAsString))
            .setter(setter(Builder::eTagAlgorithmFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eTagAlgorithmFamily").build())
            .build();

    private static final SdkField<List<String>> PROPAGATED_SET_LEVEL_TAGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("propagatedSetLevelTags")
            .getter(getter(CreateSequenceStoreRequest::propagatedSetLevelTags))
            .setter(setter(Builder::propagatedSetLevelTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propagatedSetLevelTags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<S3AccessConfig> S3_ACCESS_CONFIG_FIELD = SdkField
            .<S3AccessConfig> builder(MarshallingType.SDK_POJO).memberName("s3AccessConfig")
            .getter(getter(CreateSequenceStoreRequest::s3AccessConfig)).setter(setter(Builder::s3AccessConfig))
            .constructor(S3AccessConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3AccessConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            SSE_CONFIG_FIELD, TAGS_FIELD, CLIENT_TOKEN_FIELD, FALLBACK_LOCATION_FIELD, E_TAG_ALGORITHM_FAMILY_FIELD,
            PROPAGATED_SET_LEVEL_TAGS_FIELD, S3_ACCESS_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String description;

    private final SseConfig sseConfig;

    private final Map<String, String> tags;

    private final String clientToken;

    private final String fallbackLocation;

    private final String eTagAlgorithmFamily;

    private final List<String> propagatedSetLevelTags;

    private final S3AccessConfig s3AccessConfig;

    private CreateSequenceStoreRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.sseConfig = builder.sseConfig;
        this.tags = builder.tags;
        this.clientToken = builder.clientToken;
        this.fallbackLocation = builder.fallbackLocation;
        this.eTagAlgorithmFamily = builder.eTagAlgorithmFamily;
        this.propagatedSetLevelTags = builder.propagatedSetLevelTags;
        this.s3AccessConfig = builder.s3AccessConfig;
    }

    /**
     * <p>
     * A name for the store.
     * </p>
     * 
     * @return A name for the store.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description for the store.
     * </p>
     * 
     * @return A description for the store.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Server-side encryption (SSE) settings for the store.
     * </p>
     * 
     * @return Server-side encryption (SSE) settings for the store.
     */
    public final SseConfig sseConfig() {
        return sseConfig;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags for the store. You can configure up to 50 tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Tags for the store. You can configure up to 50 tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * An idempotency token used to dedupe retry requests so that duplicate runs are not created.
     * </p>
     * 
     * @return An idempotency token used to dedupe retry requests so that duplicate runs are not created.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * An S3 location that is used to store files that have failed a direct upload. You can add or change the
     * <code>fallbackLocation</code> after creating a sequence store. This is not required if you are uploading files
     * from a different S3 bucket.
     * </p>
     * 
     * @return An S3 location that is used to store files that have failed a direct upload. You can add or change the
     *         <code>fallbackLocation</code> after creating a sequence store. This is not required if you are uploading
     *         files from a different S3 bucket.
     */
    public final String fallbackLocation() {
        return fallbackLocation;
    }

    /**
     * <p>
     * The ETag algorithm family to use for ingested read sets. The default value is MD5up. For more information on
     * ETags, see <a href="https://docs.aws.amazon.com/omics/latest/dev/etags-and-provenance.html">ETags and data
     * provenance</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #eTagAlgorithmFamily} will return {@link ETagAlgorithmFamily#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #eTagAlgorithmFamilyAsString}.
     * </p>
     * 
     * @return The ETag algorithm family to use for ingested read sets. The default value is MD5up. For more information
     *         on ETags, see <a href="https://docs.aws.amazon.com/omics/latest/dev/etags-and-provenance.html">ETags and
     *         data provenance</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * @see ETagAlgorithmFamily
     */
    public final ETagAlgorithmFamily eTagAlgorithmFamily() {
        return ETagAlgorithmFamily.fromValue(eTagAlgorithmFamily);
    }

    /**
     * <p>
     * The ETag algorithm family to use for ingested read sets. The default value is MD5up. For more information on
     * ETags, see <a href="https://docs.aws.amazon.com/omics/latest/dev/etags-and-provenance.html">ETags and data
     * provenance</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #eTagAlgorithmFamily} will return {@link ETagAlgorithmFamily#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #eTagAlgorithmFamilyAsString}.
     * </p>
     * 
     * @return The ETag algorithm family to use for ingested read sets. The default value is MD5up. For more information
     *         on ETags, see <a href="https://docs.aws.amazon.com/omics/latest/dev/etags-and-provenance.html">ETags and
     *         data provenance</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
     * @see ETagAlgorithmFamily
     */
    public final String eTagAlgorithmFamilyAsString() {
        return eTagAlgorithmFamily;
    }

    /**
     * For responses, this returns true if the service returned a value for the PropagatedSetLevelTags property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPropagatedSetLevelTags() {
        return propagatedSetLevelTags != null && !(propagatedSetLevelTags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The tags keys to propagate to the S3 objects associated with read sets in the sequence store. These tags can be
     * used as input to add metadata to your read sets.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPropagatedSetLevelTags} method.
     * </p>
     * 
     * @return The tags keys to propagate to the S3 objects associated with read sets in the sequence store. These tags
     *         can be used as input to add metadata to your read sets.
     */
    public final List<String> propagatedSetLevelTags() {
        return propagatedSetLevelTags;
    }

    /**
     * <p>
     * S3 access configuration parameters. This specifies the parameters needed to access logs stored in S3 buckets. The
     * S3 bucket must be in the same region and account as the sequence store.
     * </p>
     * 
     * @return S3 access configuration parameters. This specifies the parameters needed to access logs stored in S3
     *         buckets. The S3 bucket must be in the same region and account as the sequence store.
     */
    public final S3AccessConfig s3AccessConfig() {
        return s3AccessConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(sseConfig());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(fallbackLocation());
        hashCode = 31 * hashCode + Objects.hashCode(eTagAlgorithmFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPropagatedSetLevelTags() ? propagatedSetLevelTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(s3AccessConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSequenceStoreRequest)) {
            return false;
        }
        CreateSequenceStoreRequest other = (CreateSequenceStoreRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(sseConfig(), other.sseConfig()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(clientToken(), other.clientToken())
                && Objects.equals(fallbackLocation(), other.fallbackLocation())
                && Objects.equals(eTagAlgorithmFamilyAsString(), other.eTagAlgorithmFamilyAsString())
                && hasPropagatedSetLevelTags() == other.hasPropagatedSetLevelTags()
                && Objects.equals(propagatedSetLevelTags(), other.propagatedSetLevelTags())
                && Objects.equals(s3AccessConfig(), other.s3AccessConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSequenceStoreRequest").add("Name", name()).add("Description", description())
                .add("SseConfig", sseConfig()).add("Tags", hasTags() ? tags() : null).add("ClientToken", clientToken())
                .add("FallbackLocation", fallbackLocation()).add("ETagAlgorithmFamily", eTagAlgorithmFamilyAsString())
                .add("PropagatedSetLevelTags", hasPropagatedSetLevelTags() ? propagatedSetLevelTags() : null)
                .add("S3AccessConfig", s3AccessConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "sseConfig":
            return Optional.ofNullable(clazz.cast(sseConfig()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "fallbackLocation":
            return Optional.ofNullable(clazz.cast(fallbackLocation()));
        case "eTagAlgorithmFamily":
            return Optional.ofNullable(clazz.cast(eTagAlgorithmFamilyAsString()));
        case "propagatedSetLevelTags":
            return Optional.ofNullable(clazz.cast(propagatedSetLevelTags()));
        case "s3AccessConfig":
            return Optional.ofNullable(clazz.cast(s3AccessConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("sseConfig", SSE_CONFIG_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("fallbackLocation", FALLBACK_LOCATION_FIELD);
        map.put("eTagAlgorithmFamily", E_TAG_ALGORITHM_FAMILY_FIELD);
        map.put("propagatedSetLevelTags", PROPAGATED_SET_LEVEL_TAGS_FIELD);
        map.put("s3AccessConfig", S3_ACCESS_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSequenceStoreRequest, T> g) {
        return obj -> g.apply((CreateSequenceStoreRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateSequenceStoreRequest> {
        /**
         * <p>
         * A name for the store.
         * </p>
         * 
         * @param name
         *        A name for the store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description for the store.
         * </p>
         * 
         * @param description
         *        A description for the store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Server-side encryption (SSE) settings for the store.
         * </p>
         * 
         * @param sseConfig
         *        Server-side encryption (SSE) settings for the store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sseConfig(SseConfig sseConfig);

        /**
         * <p>
         * Server-side encryption (SSE) settings for the store.
         * </p>
         * This is a convenience method that creates an instance of the {@link SseConfig.Builder} avoiding the need to
         * create one manually via {@link SseConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SseConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #sseConfig(SseConfig)}.
         * 
         * @param sseConfig
         *        a consumer that will call methods on {@link SseConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sseConfig(SseConfig)
         */
        default Builder sseConfig(Consumer<SseConfig.Builder> sseConfig) {
            return sseConfig(SseConfig.builder().applyMutation(sseConfig).build());
        }

        /**
         * <p>
         * Tags for the store. You can configure up to 50 tags.
         * </p>
         * 
         * @param tags
         *        Tags for the store. You can configure up to 50 tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * An idempotency token used to dedupe retry requests so that duplicate runs are not created.
         * </p>
         * 
         * @param clientToken
         *        An idempotency token used to dedupe retry requests so that duplicate runs are not created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * An S3 location that is used to store files that have failed a direct upload. You can add or change the
         * <code>fallbackLocation</code> after creating a sequence store. This is not required if you are uploading
         * files from a different S3 bucket.
         * </p>
         * 
         * @param fallbackLocation
         *        An S3 location that is used to store files that have failed a direct upload. You can add or change the
         *        <code>fallbackLocation</code> after creating a sequence store. This is not required if you are
         *        uploading files from a different S3 bucket.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fallbackLocation(String fallbackLocation);

        /**
         * <p>
         * The ETag algorithm family to use for ingested read sets. The default value is MD5up. For more information on
         * ETags, see <a href="https://docs.aws.amazon.com/omics/latest/dev/etags-and-provenance.html">ETags and data
         * provenance</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
         * </p>
         * 
         * @param eTagAlgorithmFamily
         *        The ETag algorithm family to use for ingested read sets. The default value is MD5up. For more
         *        information on ETags, see <a
         *        href="https://docs.aws.amazon.com/omics/latest/dev/etags-and-provenance.html">ETags and data
         *        provenance</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
         * @see ETagAlgorithmFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ETagAlgorithmFamily
         */
        Builder eTagAlgorithmFamily(String eTagAlgorithmFamily);

        /**
         * <p>
         * The ETag algorithm family to use for ingested read sets. The default value is MD5up. For more information on
         * ETags, see <a href="https://docs.aws.amazon.com/omics/latest/dev/etags-and-provenance.html">ETags and data
         * provenance</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
         * </p>
         * 
         * @param eTagAlgorithmFamily
         *        The ETag algorithm family to use for ingested read sets. The default value is MD5up. For more
         *        information on ETags, see <a
         *        href="https://docs.aws.amazon.com/omics/latest/dev/etags-and-provenance.html">ETags and data
         *        provenance</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
         * @see ETagAlgorithmFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ETagAlgorithmFamily
         */
        Builder eTagAlgorithmFamily(ETagAlgorithmFamily eTagAlgorithmFamily);

        /**
         * <p>
         * The tags keys to propagate to the S3 objects associated with read sets in the sequence store. These tags can
         * be used as input to add metadata to your read sets.
         * </p>
         * 
         * @param propagatedSetLevelTags
         *        The tags keys to propagate to the S3 objects associated with read sets in the sequence store. These
         *        tags can be used as input to add metadata to your read sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagatedSetLevelTags(Collection<String> propagatedSetLevelTags);

        /**
         * <p>
         * The tags keys to propagate to the S3 objects associated with read sets in the sequence store. These tags can
         * be used as input to add metadata to your read sets.
         * </p>
         * 
         * @param propagatedSetLevelTags
         *        The tags keys to propagate to the S3 objects associated with read sets in the sequence store. These
         *        tags can be used as input to add metadata to your read sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder propagatedSetLevelTags(String... propagatedSetLevelTags);

        /**
         * <p>
         * S3 access configuration parameters. This specifies the parameters needed to access logs stored in S3 buckets.
         * The S3 bucket must be in the same region and account as the sequence store.
         * </p>
         * 
         * @param s3AccessConfig
         *        S3 access configuration parameters. This specifies the parameters needed to access logs stored in S3
         *        buckets. The S3 bucket must be in the same region and account as the sequence store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3AccessConfig(S3AccessConfig s3AccessConfig);

        /**
         * <p>
         * S3 access configuration parameters. This specifies the parameters needed to access logs stored in S3 buckets.
         * The S3 bucket must be in the same region and account as the sequence store.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3AccessConfig.Builder} avoiding the need
         * to create one manually via {@link S3AccessConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3AccessConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #s3AccessConfig(S3AccessConfig)}.
         * 
         * @param s3AccessConfig
         *        a consumer that will call methods on {@link S3AccessConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #s3AccessConfig(S3AccessConfig)
         */
        default Builder s3AccessConfig(Consumer<S3AccessConfig.Builder> s3AccessConfig) {
            return s3AccessConfig(S3AccessConfig.builder().applyMutation(s3AccessConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String name;

        private String description;

        private SseConfig sseConfig;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String clientToken;

        private String fallbackLocation;

        private String eTagAlgorithmFamily;

        private List<String> propagatedSetLevelTags = DefaultSdkAutoConstructList.getInstance();

        private S3AccessConfig s3AccessConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSequenceStoreRequest model) {
            super(model);
            name(model.name);
            description(model.description);
            sseConfig(model.sseConfig);
            tags(model.tags);
            clientToken(model.clientToken);
            fallbackLocation(model.fallbackLocation);
            eTagAlgorithmFamily(model.eTagAlgorithmFamily);
            propagatedSetLevelTags(model.propagatedSetLevelTags);
            s3AccessConfig(model.s3AccessConfig);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SseConfig.Builder getSseConfig() {
            return sseConfig != null ? sseConfig.toBuilder() : null;
        }

        public final void setSseConfig(SseConfig.BuilderImpl sseConfig) {
            this.sseConfig = sseConfig != null ? sseConfig.build() : null;
        }

        @Override
        public final Builder sseConfig(SseConfig sseConfig) {
            this.sseConfig = sseConfig;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFallbackLocation() {
            return fallbackLocation;
        }

        public final void setFallbackLocation(String fallbackLocation) {
            this.fallbackLocation = fallbackLocation;
        }

        @Override
        public final Builder fallbackLocation(String fallbackLocation) {
            this.fallbackLocation = fallbackLocation;
            return this;
        }

        public final String getETagAlgorithmFamily() {
            return eTagAlgorithmFamily;
        }

        public final void setETagAlgorithmFamily(String eTagAlgorithmFamily) {
            this.eTagAlgorithmFamily = eTagAlgorithmFamily;
        }

        @Override
        public final Builder eTagAlgorithmFamily(String eTagAlgorithmFamily) {
            this.eTagAlgorithmFamily = eTagAlgorithmFamily;
            return this;
        }

        @Override
        public final Builder eTagAlgorithmFamily(ETagAlgorithmFamily eTagAlgorithmFamily) {
            this.eTagAlgorithmFamily(eTagAlgorithmFamily == null ? null : eTagAlgorithmFamily.toString());
            return this;
        }

        public final Collection<String> getPropagatedSetLevelTags() {
            if (propagatedSetLevelTags instanceof SdkAutoConstructList) {
                return null;
            }
            return propagatedSetLevelTags;
        }

        public final void setPropagatedSetLevelTags(Collection<String> propagatedSetLevelTags) {
            this.propagatedSetLevelTags = PropagatedSetLevelTagsCopier.copy(propagatedSetLevelTags);
        }

        @Override
        public final Builder propagatedSetLevelTags(Collection<String> propagatedSetLevelTags) {
            this.propagatedSetLevelTags = PropagatedSetLevelTagsCopier.copy(propagatedSetLevelTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propagatedSetLevelTags(String... propagatedSetLevelTags) {
            propagatedSetLevelTags(Arrays.asList(propagatedSetLevelTags));
            return this;
        }

        public final S3AccessConfig.Builder getS3AccessConfig() {
            return s3AccessConfig != null ? s3AccessConfig.toBuilder() : null;
        }

        public final void setS3AccessConfig(S3AccessConfig.BuilderImpl s3AccessConfig) {
            this.s3AccessConfig = s3AccessConfig != null ? s3AccessConfig.build() : null;
        }

        @Override
        public final Builder s3AccessConfig(S3AccessConfig s3AccessConfig) {
            this.s3AccessConfig = s3AccessConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSequenceStoreRequest build() {
            return new CreateSequenceStoreRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
