/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains detailed information about the source code repository that hosts the workflow definition files.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DefinitionRepositoryDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<DefinitionRepositoryDetails.Builder, DefinitionRepositoryDetails> {
    private static final SdkField<String> CONNECTION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("connectionArn").getter(getter(DefinitionRepositoryDetails::connectionArn))
            .setter(setter(Builder::connectionArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionArn").build()).build();

    private static final SdkField<String> FULL_REPOSITORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fullRepositoryId").getter(getter(DefinitionRepositoryDetails::fullRepositoryId))
            .setter(setter(Builder::fullRepositoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fullRepositoryId").build()).build();

    private static final SdkField<SourceReference> SOURCE_REFERENCE_FIELD = SdkField
            .<SourceReference> builder(MarshallingType.SDK_POJO).memberName("sourceReference")
            .getter(getter(DefinitionRepositoryDetails::sourceReference)).setter(setter(Builder::sourceReference))
            .constructor(SourceReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceReference").build()).build();

    private static final SdkField<String> PROVIDER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerType").getter(getter(DefinitionRepositoryDetails::providerType))
            .setter(setter(Builder::providerType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerType").build()).build();

    private static final SdkField<String> PROVIDER_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("providerEndpoint").getter(getter(DefinitionRepositoryDetails::providerEndpoint))
            .setter(setter(Builder::providerEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("providerEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_ARN_FIELD,
            FULL_REPOSITORY_ID_FIELD, SOURCE_REFERENCE_FIELD, PROVIDER_TYPE_FIELD, PROVIDER_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String connectionArn;

    private final String fullRepositoryId;

    private final SourceReference sourceReference;

    private final String providerType;

    private final String providerEndpoint;

    private DefinitionRepositoryDetails(BuilderImpl builder) {
        this.connectionArn = builder.connectionArn;
        this.fullRepositoryId = builder.fullRepositoryId;
        this.sourceReference = builder.sourceReference;
        this.providerType = builder.providerType;
        this.providerEndpoint = builder.providerEndpoint;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the connection to the source code repository.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the connection to the source code repository.
     */
    public final String connectionArn() {
        return connectionArn;
    }

    /**
     * <p>
     * The full repository identifier, including the repository owner and name. For example,
     * 'repository-owner/repository-name'.
     * </p>
     * 
     * @return The full repository identifier, including the repository owner and name. For example,
     *         'repository-owner/repository-name'.
     */
    public final String fullRepositoryId() {
        return fullRepositoryId;
    }

    /**
     * <p>
     * The source reference for the repository, such as a branch name, tag, or commit ID.
     * </p>
     * 
     * @return The source reference for the repository, such as a branch name, tag, or commit ID.
     */
    public final SourceReference sourceReference() {
        return sourceReference;
    }

    /**
     * <p>
     * The provider type of the source code repository, such as Bitbucket, GitHub, GitHubEnterpriseServer, GitLab, and
     * GitLabSelfManaged.
     * </p>
     * 
     * @return The provider type of the source code repository, such as Bitbucket, GitHub, GitHubEnterpriseServer,
     *         GitLab, and GitLabSelfManaged.
     */
    public final String providerType() {
        return providerType;
    }

    /**
     * <p>
     * The endpoint URL of the source code repository provider.
     * </p>
     * 
     * @return The endpoint URL of the source code repository provider.
     */
    public final String providerEndpoint() {
        return providerEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(connectionArn());
        hashCode = 31 * hashCode + Objects.hashCode(fullRepositoryId());
        hashCode = 31 * hashCode + Objects.hashCode(sourceReference());
        hashCode = 31 * hashCode + Objects.hashCode(providerType());
        hashCode = 31 * hashCode + Objects.hashCode(providerEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefinitionRepositoryDetails)) {
            return false;
        }
        DefinitionRepositoryDetails other = (DefinitionRepositoryDetails) obj;
        return Objects.equals(connectionArn(), other.connectionArn())
                && Objects.equals(fullRepositoryId(), other.fullRepositoryId())
                && Objects.equals(sourceReference(), other.sourceReference())
                && Objects.equals(providerType(), other.providerType())
                && Objects.equals(providerEndpoint(), other.providerEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DefinitionRepositoryDetails").add("ConnectionArn", connectionArn())
                .add("FullRepositoryId", fullRepositoryId()).add("SourceReference", sourceReference())
                .add("ProviderType", providerType()).add("ProviderEndpoint", providerEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "connectionArn":
            return Optional.ofNullable(clazz.cast(connectionArn()));
        case "fullRepositoryId":
            return Optional.ofNullable(clazz.cast(fullRepositoryId()));
        case "sourceReference":
            return Optional.ofNullable(clazz.cast(sourceReference()));
        case "providerType":
            return Optional.ofNullable(clazz.cast(providerType()));
        case "providerEndpoint":
            return Optional.ofNullable(clazz.cast(providerEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("connectionArn", CONNECTION_ARN_FIELD);
        map.put("fullRepositoryId", FULL_REPOSITORY_ID_FIELD);
        map.put("sourceReference", SOURCE_REFERENCE_FIELD);
        map.put("providerType", PROVIDER_TYPE_FIELD);
        map.put("providerEndpoint", PROVIDER_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DefinitionRepositoryDetails, T> g) {
        return obj -> g.apply((DefinitionRepositoryDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DefinitionRepositoryDetails> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the connection to the source code repository.
         * </p>
         * 
         * @param connectionArn
         *        The Amazon Resource Name (ARN) of the connection to the source code repository.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder connectionArn(String connectionArn);

        /**
         * <p>
         * The full repository identifier, including the repository owner and name. For example,
         * 'repository-owner/repository-name'.
         * </p>
         * 
         * @param fullRepositoryId
         *        The full repository identifier, including the repository owner and name. For example,
         *        'repository-owner/repository-name'.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fullRepositoryId(String fullRepositoryId);

        /**
         * <p>
         * The source reference for the repository, such as a branch name, tag, or commit ID.
         * </p>
         * 
         * @param sourceReference
         *        The source reference for the repository, such as a branch name, tag, or commit ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceReference(SourceReference sourceReference);

        /**
         * <p>
         * The source reference for the repository, such as a branch name, tag, or commit ID.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceReference.Builder} avoiding the
         * need to create one manually via {@link SourceReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceReference.Builder#build()} is called immediately and its
         * result is passed to {@link #sourceReference(SourceReference)}.
         * 
         * @param sourceReference
         *        a consumer that will call methods on {@link SourceReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceReference(SourceReference)
         */
        default Builder sourceReference(Consumer<SourceReference.Builder> sourceReference) {
            return sourceReference(SourceReference.builder().applyMutation(sourceReference).build());
        }

        /**
         * <p>
         * The provider type of the source code repository, such as Bitbucket, GitHub, GitHubEnterpriseServer, GitLab,
         * and GitLabSelfManaged.
         * </p>
         * 
         * @param providerType
         *        The provider type of the source code repository, such as Bitbucket, GitHub, GitHubEnterpriseServer,
         *        GitLab, and GitLabSelfManaged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerType(String providerType);

        /**
         * <p>
         * The endpoint URL of the source code repository provider.
         * </p>
         * 
         * @param providerEndpoint
         *        The endpoint URL of the source code repository provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder providerEndpoint(String providerEndpoint);
    }

    static final class BuilderImpl implements Builder {
        private String connectionArn;

        private String fullRepositoryId;

        private SourceReference sourceReference;

        private String providerType;

        private String providerEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(DefinitionRepositoryDetails model) {
            connectionArn(model.connectionArn);
            fullRepositoryId(model.fullRepositoryId);
            sourceReference(model.sourceReference);
            providerType(model.providerType);
            providerEndpoint(model.providerEndpoint);
        }

        public final String getConnectionArn() {
            return connectionArn;
        }

        public final void setConnectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
        }

        @Override
        public final Builder connectionArn(String connectionArn) {
            this.connectionArn = connectionArn;
            return this;
        }

        public final String getFullRepositoryId() {
            return fullRepositoryId;
        }

        public final void setFullRepositoryId(String fullRepositoryId) {
            this.fullRepositoryId = fullRepositoryId;
        }

        @Override
        public final Builder fullRepositoryId(String fullRepositoryId) {
            this.fullRepositoryId = fullRepositoryId;
            return this;
        }

        public final SourceReference.Builder getSourceReference() {
            return sourceReference != null ? sourceReference.toBuilder() : null;
        }

        public final void setSourceReference(SourceReference.BuilderImpl sourceReference) {
            this.sourceReference = sourceReference != null ? sourceReference.build() : null;
        }

        @Override
        public final Builder sourceReference(SourceReference sourceReference) {
            this.sourceReference = sourceReference;
            return this;
        }

        public final String getProviderType() {
            return providerType;
        }

        public final void setProviderType(String providerType) {
            this.providerType = providerType;
        }

        @Override
        public final Builder providerType(String providerType) {
            this.providerType = providerType;
            return this;
        }

        public final String getProviderEndpoint() {
            return providerEndpoint;
        }

        public final void setProviderEndpoint(String providerEndpoint) {
            this.providerEndpoint = providerEndpoint;
        }

        @Override
        public final Builder providerEndpoint(String providerEndpoint) {
            this.providerEndpoint = providerEndpoint;
            return this;
        }

        @Override
        public DefinitionRepositoryDetails build() {
            return new DefinitionRepositoryDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
