/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.JsonValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetS3AccessPolicyResponse extends OmicsResponse implements
        ToCopyableBuilder<GetS3AccessPolicyResponse.Builder, GetS3AccessPolicyResponse> {
    private static final SdkField<String> S3_ACCESS_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("s3AccessPointArn").getter(getter(GetS3AccessPolicyResponse::s3AccessPointArn))
            .setter(setter(Builder::s3AccessPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3AccessPointArn").build()).build();

    private static final SdkField<String> STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storeId").getter(getter(GetS3AccessPolicyResponse::storeId)).setter(setter(Builder::storeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeId").build()).build();

    private static final SdkField<String> STORE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storeType").getter(getter(GetS3AccessPolicyResponse::storeTypeAsString))
            .setter(setter(Builder::storeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storeType").build()).build();

    private static final SdkField<Instant> UPDATE_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updateTime")
            .getter(getter(GetS3AccessPolicyResponse::updateTime))
            .setter(setter(Builder::updateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> S3_ACCESS_POLICY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("s3AccessPolicy")
            .getter(getter(GetS3AccessPolicyResponse::s3AccessPolicy))
            .setter(setter(Builder::s3AccessPolicy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3AccessPolicy").build(),
                    JsonValueTrait.create()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(S3_ACCESS_POINT_ARN_FIELD,
            STORE_ID_FIELD, STORE_TYPE_FIELD, UPDATE_TIME_FIELD, S3_ACCESS_POLICY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String s3AccessPointArn;

    private final String storeId;

    private final String storeType;

    private final Instant updateTime;

    private final String s3AccessPolicy;

    private GetS3AccessPolicyResponse(BuilderImpl builder) {
        super(builder);
        this.s3AccessPointArn = builder.s3AccessPointArn;
        this.storeId = builder.storeId;
        this.storeType = builder.storeType;
        this.updateTime = builder.updateTime;
        this.s3AccessPolicy = builder.s3AccessPolicy;
    }

    /**
     * <p>
     * The S3 access point ARN that has the access policy.
     * </p>
     * 
     * @return The S3 access point ARN that has the access policy.
     */
    public final String s3AccessPointArn() {
        return s3AccessPointArn;
    }

    /**
     * <p>
     * The Amazon Web Services-generated Sequence Store or Reference Store ID.
     * </p>
     * 
     * @return The Amazon Web Services-generated Sequence Store or Reference Store ID.
     */
    public final String storeId() {
        return storeId;
    }

    /**
     * <p>
     * The type of store associated with the access point.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storeType} will
     * return {@link StoreType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storeTypeAsString}.
     * </p>
     * 
     * @return The type of store associated with the access point.
     * @see StoreType
     */
    public final StoreType storeType() {
        return StoreType.fromValue(storeType);
    }

    /**
     * <p>
     * The type of store associated with the access point.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storeType} will
     * return {@link StoreType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storeTypeAsString}.
     * </p>
     * 
     * @return The type of store associated with the access point.
     * @see StoreType
     */
    public final String storeTypeAsString() {
        return storeType;
    }

    /**
     * <p>
     * The time when the policy was last updated.
     * </p>
     * 
     * @return The time when the policy was last updated.
     */
    public final Instant updateTime() {
        return updateTime;
    }

    /**
     * <p>
     * The current resource policy that controls S3 access on the store.
     * </p>
     * 
     * @return The current resource policy that controls S3 access on the store.
     */
    public final String s3AccessPolicy() {
        return s3AccessPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(s3AccessPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(storeId());
        hashCode = 31 * hashCode + Objects.hashCode(storeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updateTime());
        hashCode = 31 * hashCode + Objects.hashCode(s3AccessPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetS3AccessPolicyResponse)) {
            return false;
        }
        GetS3AccessPolicyResponse other = (GetS3AccessPolicyResponse) obj;
        return Objects.equals(s3AccessPointArn(), other.s3AccessPointArn()) && Objects.equals(storeId(), other.storeId())
                && Objects.equals(storeTypeAsString(), other.storeTypeAsString())
                && Objects.equals(updateTime(), other.updateTime()) && Objects.equals(s3AccessPolicy(), other.s3AccessPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetS3AccessPolicyResponse").add("S3AccessPointArn", s3AccessPointArn())
                .add("StoreId", storeId()).add("StoreType", storeTypeAsString()).add("UpdateTime", updateTime())
                .add("S3AccessPolicy", s3AccessPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "s3AccessPointArn":
            return Optional.ofNullable(clazz.cast(s3AccessPointArn()));
        case "storeId":
            return Optional.ofNullable(clazz.cast(storeId()));
        case "storeType":
            return Optional.ofNullable(clazz.cast(storeTypeAsString()));
        case "updateTime":
            return Optional.ofNullable(clazz.cast(updateTime()));
        case "s3AccessPolicy":
            return Optional.ofNullable(clazz.cast(s3AccessPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("s3AccessPointArn", S3_ACCESS_POINT_ARN_FIELD);
        map.put("storeId", STORE_ID_FIELD);
        map.put("storeType", STORE_TYPE_FIELD);
        map.put("updateTime", UPDATE_TIME_FIELD);
        map.put("s3AccessPolicy", S3_ACCESS_POLICY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetS3AccessPolicyResponse, T> g) {
        return obj -> g.apply((GetS3AccessPolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OmicsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetS3AccessPolicyResponse> {
        /**
         * <p>
         * The S3 access point ARN that has the access policy.
         * </p>
         * 
         * @param s3AccessPointArn
         *        The S3 access point ARN that has the access policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3AccessPointArn(String s3AccessPointArn);

        /**
         * <p>
         * The Amazon Web Services-generated Sequence Store or Reference Store ID.
         * </p>
         * 
         * @param storeId
         *        The Amazon Web Services-generated Sequence Store or Reference Store ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storeId(String storeId);

        /**
         * <p>
         * The type of store associated with the access point.
         * </p>
         * 
         * @param storeType
         *        The type of store associated with the access point.
         * @see StoreType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StoreType
         */
        Builder storeType(String storeType);

        /**
         * <p>
         * The type of store associated with the access point.
         * </p>
         * 
         * @param storeType
         *        The type of store associated with the access point.
         * @see StoreType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StoreType
         */
        Builder storeType(StoreType storeType);

        /**
         * <p>
         * The time when the policy was last updated.
         * </p>
         * 
         * @param updateTime
         *        The time when the policy was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTime(Instant updateTime);

        /**
         * <p>
         * The current resource policy that controls S3 access on the store.
         * </p>
         * 
         * @param s3AccessPolicy
         *        The current resource policy that controls S3 access on the store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder s3AccessPolicy(String s3AccessPolicy);
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private String s3AccessPointArn;

        private String storeId;

        private String storeType;

        private Instant updateTime;

        private String s3AccessPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(GetS3AccessPolicyResponse model) {
            super(model);
            s3AccessPointArn(model.s3AccessPointArn);
            storeId(model.storeId);
            storeType(model.storeType);
            updateTime(model.updateTime);
            s3AccessPolicy(model.s3AccessPolicy);
        }

        public final String getS3AccessPointArn() {
            return s3AccessPointArn;
        }

        public final void setS3AccessPointArn(String s3AccessPointArn) {
            this.s3AccessPointArn = s3AccessPointArn;
        }

        @Override
        public final Builder s3AccessPointArn(String s3AccessPointArn) {
            this.s3AccessPointArn = s3AccessPointArn;
            return this;
        }

        public final String getStoreId() {
            return storeId;
        }

        public final void setStoreId(String storeId) {
            this.storeId = storeId;
        }

        @Override
        public final Builder storeId(String storeId) {
            this.storeId = storeId;
            return this;
        }

        public final String getStoreType() {
            return storeType;
        }

        public final void setStoreType(String storeType) {
            this.storeType = storeType;
        }

        @Override
        public final Builder storeType(String storeType) {
            this.storeType = storeType;
            return this;
        }

        @Override
        public final Builder storeType(StoreType storeType) {
            this.storeType(storeType == null ? null : storeType.toString());
            return this;
        }

        public final Instant getUpdateTime() {
            return updateTime;
        }

        public final void setUpdateTime(Instant updateTime) {
            this.updateTime = updateTime;
        }

        @Override
        public final Builder updateTime(Instant updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        public final String getS3AccessPolicy() {
            return s3AccessPolicy;
        }

        public final void setS3AccessPolicy(String s3AccessPolicy) {
            this.s3AccessPolicy = s3AccessPolicy;
        }

        @Override
        public final Builder s3AccessPolicy(String s3AccessPolicy) {
            this.s3AccessPolicy = s3AccessPolicy;
            return this;
        }

        @Override
        public GetS3AccessPolicyResponse build() {
            return new GetS3AccessPolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
