/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetWorkflowResponse extends OmicsResponse implements
        ToCopyableBuilder<GetWorkflowResponse.Builder, GetWorkflowResponse> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GetWorkflowResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(GetWorkflowResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetWorkflowResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(GetWorkflowResponse::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetWorkflowResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetWorkflowResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ENGINE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("engine")
            .getter(getter(GetWorkflowResponse::engineAsString)).setter(setter(Builder::engine))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("engine").build()).build();

    private static final SdkField<String> DEFINITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("definition").getter(getter(GetWorkflowResponse::definition)).setter(setter(Builder::definition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definition").build()).build();

    private static final SdkField<String> MAIN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("main")
            .getter(getter(GetWorkflowResponse::main)).setter(setter(Builder::main))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("main").build()).build();

    private static final SdkField<String> DIGEST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("digest")
            .getter(getter(GetWorkflowResponse::digest)).setter(setter(Builder::digest))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("digest").build()).build();

    private static final SdkField<Map<String, WorkflowParameter>> PARAMETER_TEMPLATE_FIELD = SdkField
            .<Map<String, WorkflowParameter>> builder(MarshallingType.MAP)
            .memberName("parameterTemplate")
            .getter(getter(GetWorkflowResponse::parameterTemplate))
            .setter(setter(Builder::parameterTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterTemplate").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<WorkflowParameter> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkflowParameter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Integer> STORAGE_CAPACITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("storageCapacity").getter(getter(GetWorkflowResponse::storageCapacity))
            .setter(setter(Builder::storageCapacity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageCapacity").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime")
            .getter(getter(GetWorkflowResponse::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(GetWorkflowResponse::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetWorkflowResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("metadata")
            .getter(getter(GetWorkflowResponse::metadata))
            .setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> ACCELERATORS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accelerators").getter(getter(GetWorkflowResponse::acceleratorsAsString))
            .setter(setter(Builder::accelerators))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accelerators").build()).build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageType").getter(getter(GetWorkflowResponse::storageTypeAsString))
            .setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageType").build()).build();

    private static final SdkField<String> UUID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("uuid")
            .getter(getter(GetWorkflowResponse::uuid)).setter(setter(Builder::uuid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uuid").build()).build();

    private static final SdkField<ContainerRegistryMap> CONTAINER_REGISTRY_MAP_FIELD = SdkField
            .<ContainerRegistryMap> builder(MarshallingType.SDK_POJO).memberName("containerRegistryMap")
            .getter(getter(GetWorkflowResponse::containerRegistryMap)).setter(setter(Builder::containerRegistryMap))
            .constructor(ContainerRegistryMap::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("containerRegistryMap").build())
            .build();

    private static final SdkField<String> README_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("readme")
            .getter(getter(GetWorkflowResponse::readme)).setter(setter(Builder::readme))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readme").build()).build();

    private static final SdkField<DefinitionRepositoryDetails> DEFINITION_REPOSITORY_DETAILS_FIELD = SdkField
            .<DefinitionRepositoryDetails> builder(MarshallingType.SDK_POJO)
            .memberName("definitionRepositoryDetails")
            .getter(getter(GetWorkflowResponse::definitionRepositoryDetails))
            .setter(setter(Builder::definitionRepositoryDetails))
            .constructor(DefinitionRepositoryDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("definitionRepositoryDetails")
                    .build()).build();

    private static final SdkField<String> README_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("readmePath").getter(getter(GetWorkflowResponse::readmePath)).setter(setter(Builder::readmePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readmePath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, ID_FIELD,
            STATUS_FIELD, TYPE_FIELD, NAME_FIELD, DESCRIPTION_FIELD, ENGINE_FIELD, DEFINITION_FIELD, MAIN_FIELD, DIGEST_FIELD,
            PARAMETER_TEMPLATE_FIELD, STORAGE_CAPACITY_FIELD, CREATION_TIME_FIELD, STATUS_MESSAGE_FIELD, TAGS_FIELD,
            METADATA_FIELD, ACCELERATORS_FIELD, STORAGE_TYPE_FIELD, UUID_FIELD, CONTAINER_REGISTRY_MAP_FIELD, README_FIELD,
            DEFINITION_REPOSITORY_DETAILS_FIELD, README_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String arn;

    private final String id;

    private final String status;

    private final String type;

    private final String name;

    private final String description;

    private final String engine;

    private final String definition;

    private final String main;

    private final String digest;

    private final Map<String, WorkflowParameter> parameterTemplate;

    private final Integer storageCapacity;

    private final Instant creationTime;

    private final String statusMessage;

    private final Map<String, String> tags;

    private final Map<String, String> metadata;

    private final String accelerators;

    private final String storageType;

    private final String uuid;

    private final ContainerRegistryMap containerRegistryMap;

    private final String readme;

    private final DefinitionRepositoryDetails definitionRepositoryDetails;

    private final String readmePath;

    private GetWorkflowResponse(BuilderImpl builder) {
        super(builder);
        this.arn = builder.arn;
        this.id = builder.id;
        this.status = builder.status;
        this.type = builder.type;
        this.name = builder.name;
        this.description = builder.description;
        this.engine = builder.engine;
        this.definition = builder.definition;
        this.main = builder.main;
        this.digest = builder.digest;
        this.parameterTemplate = builder.parameterTemplate;
        this.storageCapacity = builder.storageCapacity;
        this.creationTime = builder.creationTime;
        this.statusMessage = builder.statusMessage;
        this.tags = builder.tags;
        this.metadata = builder.metadata;
        this.accelerators = builder.accelerators;
        this.storageType = builder.storageType;
        this.uuid = builder.uuid;
        this.containerRegistryMap = builder.containerRegistryMap;
        this.readme = builder.readme;
        this.definitionRepositoryDetails = builder.definitionRepositoryDetails;
        this.readmePath = builder.readmePath;
    }

    /**
     * <p>
     * The workflow's ARN.
     * </p>
     * 
     * @return The workflow's ARN.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The workflow's ID.
     * </p>
     * 
     * @return The workflow's ID.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The workflow's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The workflow's status.
     * @see WorkflowStatus
     */
    public final WorkflowStatus status() {
        return WorkflowStatus.fromValue(status);
    }

    /**
     * <p>
     * The workflow's status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link WorkflowStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The workflow's status.
     * @see WorkflowStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The workflow's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The workflow's type.
     * @see WorkflowType
     */
    public final WorkflowType type() {
        return WorkflowType.fromValue(type);
    }

    /**
     * <p>
     * The workflow's type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The workflow's type.
     * @see WorkflowType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The workflow's name.
     * </p>
     * 
     * @return The workflow's name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The workflow's description.
     * </p>
     * 
     * @return The workflow's description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The workflow's engine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engine} will
     * return {@link WorkflowEngine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineAsString}.
     * </p>
     * 
     * @return The workflow's engine.
     * @see WorkflowEngine
     */
    public final WorkflowEngine engine() {
        return WorkflowEngine.fromValue(engine);
    }

    /**
     * <p>
     * The workflow's engine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engine} will
     * return {@link WorkflowEngine#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineAsString}.
     * </p>
     * 
     * @return The workflow's engine.
     * @see WorkflowEngine
     */
    public final String engineAsString() {
        return engine;
    }

    /**
     * <p>
     * The workflow's definition.
     * </p>
     * 
     * @return The workflow's definition.
     */
    public final String definition() {
        return definition;
    }

    /**
     * <p>
     * The path of the main definition file for the workflow.
     * </p>
     * 
     * @return The path of the main definition file for the workflow.
     */
    public final String main() {
        return main;
    }

    /**
     * <p>
     * The workflow's digest.
     * </p>
     * 
     * @return The workflow's digest.
     */
    public final String digest() {
        return digest;
    }

    /**
     * For responses, this returns true if the service returned a value for the ParameterTemplate property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasParameterTemplate() {
        return parameterTemplate != null && !(parameterTemplate instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The workflow's parameter template.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasParameterTemplate} method.
     * </p>
     * 
     * @return The workflow's parameter template.
     */
    public final Map<String, WorkflowParameter> parameterTemplate() {
        return parameterTemplate;
    }

    /**
     * <p>
     * The default static storage capacity (in gibibytes) for runs that use this workflow or workflow version.
     * </p>
     * 
     * @return The default static storage capacity (in gibibytes) for runs that use this workflow or workflow version.
     */
    public final Integer storageCapacity() {
        return storageCapacity;
    }

    /**
     * <p>
     * When the workflow was created.
     * </p>
     * 
     * @return When the workflow was created.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The workflow's status message.
     * </p>
     * 
     * @return The workflow's status message.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The workflow's tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The workflow's tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the Metadata property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMetadata() {
        return metadata != null && !(metadata instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Gets metadata for the workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadata} method.
     * </p>
     * 
     * @return Gets metadata for the workflow.
     */
    public final Map<String, String> metadata() {
        return metadata;
    }

    /**
     * <p>
     * The computational accelerator specified to run the workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accelerators} will
     * return {@link Accelerators#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #acceleratorsAsString}.
     * </p>
     * 
     * @return The computational accelerator specified to run the workflow.
     * @see Accelerators
     */
    public final Accelerators accelerators() {
        return Accelerators.fromValue(accelerators);
    }

    /**
     * <p>
     * The computational accelerator specified to run the workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #accelerators} will
     * return {@link Accelerators#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #acceleratorsAsString}.
     * </p>
     * 
     * @return The computational accelerator specified to run the workflow.
     * @see Accelerators
     */
    public final String acceleratorsAsString() {
        return accelerators;
    }

    /**
     * <p>
     * The default storage type for runs using this workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The default storage type for runs using this workflow.
     * @see StorageType
     */
    public final StorageType storageType() {
        return StorageType.fromValue(storageType);
    }

    /**
     * <p>
     * The default storage type for runs using this workflow.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageType} will
     * return {@link StorageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageTypeAsString}.
     * </p>
     * 
     * @return The default storage type for runs using this workflow.
     * @see StorageType
     */
    public final String storageTypeAsString() {
        return storageType;
    }

    /**
     * <p>
     * The universally unique identifier (UUID) value for this workflow.
     * </p>
     * 
     * @return The universally unique identifier (UUID) value for this workflow.
     */
    public final String uuid() {
        return uuid;
    }

    /**
     * <p>
     * The registry map that this workflow is using.
     * </p>
     * 
     * @return The registry map that this workflow is using.
     */
    public final ContainerRegistryMap containerRegistryMap() {
        return containerRegistryMap;
    }

    /**
     * <p>
     * The README content for the workflow, providing documentation and usage information.
     * </p>
     * 
     * @return The README content for the workflow, providing documentation and usage information.
     */
    public final String readme() {
        return readme;
    }

    /**
     * <p>
     * Details about the source code repository that hosts the workflow definition files.
     * </p>
     * 
     * @return Details about the source code repository that hosts the workflow definition files.
     */
    public final DefinitionRepositoryDetails definitionRepositoryDetails() {
        return definitionRepositoryDetails;
    }

    /**
     * <p>
     * The path to the workflow README markdown file within the repository. This file provides documentation and usage
     * information for the workflow. If not specified, the <code>README.md</code> file from the root directory of the
     * repository will be used.
     * </p>
     * 
     * @return The path to the workflow README markdown file within the repository. This file provides documentation and
     *         usage information for the workflow. If not specified, the <code>README.md</code> file from the root
     *         directory of the repository will be used.
     */
    public final String readmePath() {
        return readmePath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(engineAsString());
        hashCode = 31 * hashCode + Objects.hashCode(definition());
        hashCode = 31 * hashCode + Objects.hashCode(main());
        hashCode = 31 * hashCode + Objects.hashCode(digest());
        hashCode = 31 * hashCode + Objects.hashCode(hasParameterTemplate() ? parameterTemplate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(storageCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadata() ? metadata() : null);
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorsAsString());
        hashCode = 31 * hashCode + Objects.hashCode(storageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(uuid());
        hashCode = 31 * hashCode + Objects.hashCode(containerRegistryMap());
        hashCode = 31 * hashCode + Objects.hashCode(readme());
        hashCode = 31 * hashCode + Objects.hashCode(definitionRepositoryDetails());
        hashCode = 31 * hashCode + Objects.hashCode(readmePath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetWorkflowResponse)) {
            return false;
        }
        GetWorkflowResponse other = (GetWorkflowResponse) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(id(), other.id())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(engineAsString(), other.engineAsString())
                && Objects.equals(definition(), other.definition()) && Objects.equals(main(), other.main())
                && Objects.equals(digest(), other.digest()) && hasParameterTemplate() == other.hasParameterTemplate()
                && Objects.equals(parameterTemplate(), other.parameterTemplate())
                && Objects.equals(storageCapacity(), other.storageCapacity())
                && Objects.equals(creationTime(), other.creationTime()) && Objects.equals(statusMessage(), other.statusMessage())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags()) && hasMetadata() == other.hasMetadata()
                && Objects.equals(metadata(), other.metadata())
                && Objects.equals(acceleratorsAsString(), other.acceleratorsAsString())
                && Objects.equals(storageTypeAsString(), other.storageTypeAsString()) && Objects.equals(uuid(), other.uuid())
                && Objects.equals(containerRegistryMap(), other.containerRegistryMap())
                && Objects.equals(readme(), other.readme())
                && Objects.equals(definitionRepositoryDetails(), other.definitionRepositoryDetails())
                && Objects.equals(readmePath(), other.readmePath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetWorkflowResponse").add("Arn", arn()).add("Id", id()).add("Status", statusAsString())
                .add("Type", typeAsString()).add("Name", name()).add("Description", description())
                .add("Engine", engineAsString()).add("Definition", definition()).add("Main", main()).add("Digest", digest())
                .add("ParameterTemplate", hasParameterTemplate() ? parameterTemplate() : null)
                .add("StorageCapacity", storageCapacity()).add("CreationTime", creationTime())
                .add("StatusMessage", statusMessage()).add("Tags", hasTags() ? tags() : null)
                .add("Metadata", hasMetadata() ? metadata() : null).add("Accelerators", acceleratorsAsString())
                .add("StorageType", storageTypeAsString()).add("Uuid", uuid())
                .add("ContainerRegistryMap", containerRegistryMap()).add("Readme", readme())
                .add("DefinitionRepositoryDetails", definitionRepositoryDetails()).add("ReadmePath", readmePath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "engine":
            return Optional.ofNullable(clazz.cast(engineAsString()));
        case "definition":
            return Optional.ofNullable(clazz.cast(definition()));
        case "main":
            return Optional.ofNullable(clazz.cast(main()));
        case "digest":
            return Optional.ofNullable(clazz.cast(digest()));
        case "parameterTemplate":
            return Optional.ofNullable(clazz.cast(parameterTemplate()));
        case "storageCapacity":
            return Optional.ofNullable(clazz.cast(storageCapacity()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "accelerators":
            return Optional.ofNullable(clazz.cast(acceleratorsAsString()));
        case "storageType":
            return Optional.ofNullable(clazz.cast(storageTypeAsString()));
        case "uuid":
            return Optional.ofNullable(clazz.cast(uuid()));
        case "containerRegistryMap":
            return Optional.ofNullable(clazz.cast(containerRegistryMap()));
        case "readme":
            return Optional.ofNullable(clazz.cast(readme()));
        case "definitionRepositoryDetails":
            return Optional.ofNullable(clazz.cast(definitionRepositoryDetails()));
        case "readmePath":
            return Optional.ofNullable(clazz.cast(readmePath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("id", ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("engine", ENGINE_FIELD);
        map.put("definition", DEFINITION_FIELD);
        map.put("main", MAIN_FIELD);
        map.put("digest", DIGEST_FIELD);
        map.put("parameterTemplate", PARAMETER_TEMPLATE_FIELD);
        map.put("storageCapacity", STORAGE_CAPACITY_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("metadata", METADATA_FIELD);
        map.put("accelerators", ACCELERATORS_FIELD);
        map.put("storageType", STORAGE_TYPE_FIELD);
        map.put("uuid", UUID_FIELD);
        map.put("containerRegistryMap", CONTAINER_REGISTRY_MAP_FIELD);
        map.put("readme", README_FIELD);
        map.put("definitionRepositoryDetails", DEFINITION_REPOSITORY_DETAILS_FIELD);
        map.put("readmePath", README_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetWorkflowResponse, T> g) {
        return obj -> g.apply((GetWorkflowResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OmicsResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetWorkflowResponse> {
        /**
         * <p>
         * The workflow's ARN.
         * </p>
         * 
         * @param arn
         *        The workflow's ARN.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The workflow's ID.
         * </p>
         * 
         * @param id
         *        The workflow's ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The workflow's status.
         * </p>
         * 
         * @param status
         *        The workflow's status.
         * @see WorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The workflow's status.
         * </p>
         * 
         * @param status
         *        The workflow's status.
         * @see WorkflowStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowStatus
         */
        Builder status(WorkflowStatus status);

        /**
         * <p>
         * The workflow's type.
         * </p>
         * 
         * @param type
         *        The workflow's type.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder type(String type);

        /**
         * <p>
         * The workflow's type.
         * </p>
         * 
         * @param type
         *        The workflow's type.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder type(WorkflowType type);

        /**
         * <p>
         * The workflow's name.
         * </p>
         * 
         * @param name
         *        The workflow's name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The workflow's description.
         * </p>
         * 
         * @param description
         *        The workflow's description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The workflow's engine.
         * </p>
         * 
         * @param engine
         *        The workflow's engine.
         * @see WorkflowEngine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowEngine
         */
        Builder engine(String engine);

        /**
         * <p>
         * The workflow's engine.
         * </p>
         * 
         * @param engine
         *        The workflow's engine.
         * @see WorkflowEngine
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowEngine
         */
        Builder engine(WorkflowEngine engine);

        /**
         * <p>
         * The workflow's definition.
         * </p>
         * 
         * @param definition
         *        The workflow's definition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definition(String definition);

        /**
         * <p>
         * The path of the main definition file for the workflow.
         * </p>
         * 
         * @param main
         *        The path of the main definition file for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder main(String main);

        /**
         * <p>
         * The workflow's digest.
         * </p>
         * 
         * @param digest
         *        The workflow's digest.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder digest(String digest);

        /**
         * <p>
         * The workflow's parameter template.
         * </p>
         * 
         * @param parameterTemplate
         *        The workflow's parameter template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterTemplate(Map<String, WorkflowParameter> parameterTemplate);

        /**
         * <p>
         * The default static storage capacity (in gibibytes) for runs that use this workflow or workflow version.
         * </p>
         * 
         * @param storageCapacity
         *        The default static storage capacity (in gibibytes) for runs that use this workflow or workflow
         *        version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageCapacity(Integer storageCapacity);

        /**
         * <p>
         * When the workflow was created.
         * </p>
         * 
         * @param creationTime
         *        When the workflow was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The workflow's status message.
         * </p>
         * 
         * @param statusMessage
         *        The workflow's status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The workflow's tags.
         * </p>
         * 
         * @param tags
         *        The workflow's tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * Gets metadata for the workflow.
         * </p>
         * 
         * @param metadata
         *        Gets metadata for the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Map<String, String> metadata);

        /**
         * <p>
         * The computational accelerator specified to run the workflow.
         * </p>
         * 
         * @param accelerators
         *        The computational accelerator specified to run the workflow.
         * @see Accelerators
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Accelerators
         */
        Builder accelerators(String accelerators);

        /**
         * <p>
         * The computational accelerator specified to run the workflow.
         * </p>
         * 
         * @param accelerators
         *        The computational accelerator specified to run the workflow.
         * @see Accelerators
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Accelerators
         */
        Builder accelerators(Accelerators accelerators);

        /**
         * <p>
         * The default storage type for runs using this workflow.
         * </p>
         * 
         * @param storageType
         *        The default storage type for runs using this workflow.
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * The default storage type for runs using this workflow.
         * </p>
         * 
         * @param storageType
         *        The default storage type for runs using this workflow.
         * @see StorageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageType
         */
        Builder storageType(StorageType storageType);

        /**
         * <p>
         * The universally unique identifier (UUID) value for this workflow.
         * </p>
         * 
         * @param uuid
         *        The universally unique identifier (UUID) value for this workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uuid(String uuid);

        /**
         * <p>
         * The registry map that this workflow is using.
         * </p>
         * 
         * @param containerRegistryMap
         *        The registry map that this workflow is using.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containerRegistryMap(ContainerRegistryMap containerRegistryMap);

        /**
         * <p>
         * The registry map that this workflow is using.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContainerRegistryMap.Builder} avoiding
         * the need to create one manually via {@link ContainerRegistryMap#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContainerRegistryMap.Builder#build()} is called immediately and
         * its result is passed to {@link #containerRegistryMap(ContainerRegistryMap)}.
         * 
         * @param containerRegistryMap
         *        a consumer that will call methods on {@link ContainerRegistryMap.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #containerRegistryMap(ContainerRegistryMap)
         */
        default Builder containerRegistryMap(Consumer<ContainerRegistryMap.Builder> containerRegistryMap) {
            return containerRegistryMap(ContainerRegistryMap.builder().applyMutation(containerRegistryMap).build());
        }

        /**
         * <p>
         * The README content for the workflow, providing documentation and usage information.
         * </p>
         * 
         * @param readme
         *        The README content for the workflow, providing documentation and usage information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readme(String readme);

        /**
         * <p>
         * Details about the source code repository that hosts the workflow definition files.
         * </p>
         * 
         * @param definitionRepositoryDetails
         *        Details about the source code repository that hosts the workflow definition files.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder definitionRepositoryDetails(DefinitionRepositoryDetails definitionRepositoryDetails);

        /**
         * <p>
         * Details about the source code repository that hosts the workflow definition files.
         * </p>
         * This is a convenience method that creates an instance of the {@link DefinitionRepositoryDetails.Builder}
         * avoiding the need to create one manually via {@link DefinitionRepositoryDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DefinitionRepositoryDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #definitionRepositoryDetails(DefinitionRepositoryDetails)}.
         * 
         * @param definitionRepositoryDetails
         *        a consumer that will call methods on {@link DefinitionRepositoryDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #definitionRepositoryDetails(DefinitionRepositoryDetails)
         */
        default Builder definitionRepositoryDetails(Consumer<DefinitionRepositoryDetails.Builder> definitionRepositoryDetails) {
            return definitionRepositoryDetails(DefinitionRepositoryDetails.builder().applyMutation(definitionRepositoryDetails)
                    .build());
        }

        /**
         * <p>
         * The path to the workflow README markdown file within the repository. This file provides documentation and
         * usage information for the workflow. If not specified, the <code>README.md</code> file from the root directory
         * of the repository will be used.
         * </p>
         * 
         * @param readmePath
         *        The path to the workflow README markdown file within the repository. This file provides documentation
         *        and usage information for the workflow. If not specified, the <code>README.md</code> file from the
         *        root directory of the repository will be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readmePath(String readmePath);
    }

    static final class BuilderImpl extends OmicsResponse.BuilderImpl implements Builder {
        private String arn;

        private String id;

        private String status;

        private String type;

        private String name;

        private String description;

        private String engine;

        private String definition;

        private String main;

        private String digest;

        private Map<String, WorkflowParameter> parameterTemplate = DefaultSdkAutoConstructMap.getInstance();

        private Integer storageCapacity;

        private Instant creationTime;

        private String statusMessage;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();

        private String accelerators;

        private String storageType;

        private String uuid;

        private ContainerRegistryMap containerRegistryMap;

        private String readme;

        private DefinitionRepositoryDetails definitionRepositoryDetails;

        private String readmePath;

        private BuilderImpl() {
        }

        private BuilderImpl(GetWorkflowResponse model) {
            super(model);
            arn(model.arn);
            id(model.id);
            status(model.status);
            type(model.type);
            name(model.name);
            description(model.description);
            engine(model.engine);
            definition(model.definition);
            main(model.main);
            digest(model.digest);
            parameterTemplate(model.parameterTemplate);
            storageCapacity(model.storageCapacity);
            creationTime(model.creationTime);
            statusMessage(model.statusMessage);
            tags(model.tags);
            metadata(model.metadata);
            accelerators(model.accelerators);
            storageType(model.storageType);
            uuid(model.uuid);
            containerRegistryMap(model.containerRegistryMap);
            readme(model.readme);
            definitionRepositoryDetails(model.definitionRepositoryDetails);
            readmePath(model.readmePath);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkflowStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WorkflowType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngine() {
            return engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        @Override
        public final Builder engine(WorkflowEngine engine) {
            this.engine(engine == null ? null : engine.toString());
            return this;
        }

        public final String getDefinition() {
            return definition;
        }

        public final void setDefinition(String definition) {
            this.definition = definition;
        }

        @Override
        public final Builder definition(String definition) {
            this.definition = definition;
            return this;
        }

        public final String getMain() {
            return main;
        }

        public final void setMain(String main) {
            this.main = main;
        }

        @Override
        public final Builder main(String main) {
            this.main = main;
            return this;
        }

        public final String getDigest() {
            return digest;
        }

        public final void setDigest(String digest) {
            this.digest = digest;
        }

        @Override
        public final Builder digest(String digest) {
            this.digest = digest;
            return this;
        }

        public final Map<String, WorkflowParameter.Builder> getParameterTemplate() {
            Map<String, WorkflowParameter.Builder> result = WorkflowParameterTemplateCopier.copyToBuilder(this.parameterTemplate);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameterTemplate(Map<String, WorkflowParameter.BuilderImpl> parameterTemplate) {
            this.parameterTemplate = WorkflowParameterTemplateCopier.copyFromBuilder(parameterTemplate);
        }

        @Override
        public final Builder parameterTemplate(Map<String, WorkflowParameter> parameterTemplate) {
            this.parameterTemplate = WorkflowParameterTemplateCopier.copy(parameterTemplate);
            return this;
        }

        public final Integer getStorageCapacity() {
            return storageCapacity;
        }

        public final void setStorageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
        }

        @Override
        public final Builder storageCapacity(Integer storageCapacity) {
            this.storageCapacity = storageCapacity;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final Map<String, String> getMetadata() {
            if (metadata instanceof SdkAutoConstructMap) {
                return null;
            }
            return metadata;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = WorkflowMetadataCopier.copy(metadata);
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = WorkflowMetadataCopier.copy(metadata);
            return this;
        }

        public final String getAccelerators() {
            return accelerators;
        }

        public final void setAccelerators(String accelerators) {
            this.accelerators = accelerators;
        }

        @Override
        public final Builder accelerators(String accelerators) {
            this.accelerators = accelerators;
            return this;
        }

        @Override
        public final Builder accelerators(Accelerators accelerators) {
            this.accelerators(accelerators == null ? null : accelerators.toString());
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        @Override
        public final Builder storageType(StorageType storageType) {
            this.storageType(storageType == null ? null : storageType.toString());
            return this;
        }

        public final String getUuid() {
            return uuid;
        }

        public final void setUuid(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public final Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public final ContainerRegistryMap.Builder getContainerRegistryMap() {
            return containerRegistryMap != null ? containerRegistryMap.toBuilder() : null;
        }

        public final void setContainerRegistryMap(ContainerRegistryMap.BuilderImpl containerRegistryMap) {
            this.containerRegistryMap = containerRegistryMap != null ? containerRegistryMap.build() : null;
        }

        @Override
        public final Builder containerRegistryMap(ContainerRegistryMap containerRegistryMap) {
            this.containerRegistryMap = containerRegistryMap;
            return this;
        }

        public final String getReadme() {
            return readme;
        }

        public final void setReadme(String readme) {
            this.readme = readme;
        }

        @Override
        public final Builder readme(String readme) {
            this.readme = readme;
            return this;
        }

        public final DefinitionRepositoryDetails.Builder getDefinitionRepositoryDetails() {
            return definitionRepositoryDetails != null ? definitionRepositoryDetails.toBuilder() : null;
        }

        public final void setDefinitionRepositoryDetails(DefinitionRepositoryDetails.BuilderImpl definitionRepositoryDetails) {
            this.definitionRepositoryDetails = definitionRepositoryDetails != null ? definitionRepositoryDetails.build() : null;
        }

        @Override
        public final Builder definitionRepositoryDetails(DefinitionRepositoryDetails definitionRepositoryDetails) {
            this.definitionRepositoryDetails = definitionRepositoryDetails;
            return this;
        }

        public final String getReadmePath() {
            return readmePath;
        }

        public final void setReadmePath(String readmePath) {
            this.readmePath = readmePath;
        }

        @Override
        public final Builder readmePath(String readmePath) {
            this.readmePath = readmePath;
            return this;
        }

        @Override
        public GetWorkflowResponse build() {
            return new GetWorkflowResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
