/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies image mappings that workflow tasks can use. For example, you can replace all the task references of a
 * public image to use an equivalent image in your private ECR repository. You can use image mappings with upstream
 * registries that don't support pull through cache. You need to manually synchronize the upstream registry with your
 * private repository.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageMapping implements SdkPojo, Serializable, ToCopyableBuilder<ImageMapping.Builder, ImageMapping> {
    private static final SdkField<String> SOURCE_IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceImage").getter(getter(ImageMapping::sourceImage)).setter(setter(Builder::sourceImage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceImage").build()).build();

    private static final SdkField<String> DESTINATION_IMAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationImage").getter(getter(ImageMapping::destinationImage))
            .setter(setter(Builder::destinationImage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationImage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_IMAGE_FIELD,
            DESTINATION_IMAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceImage;

    private final String destinationImage;

    private ImageMapping(BuilderImpl builder) {
        this.sourceImage = builder.sourceImage;
        this.destinationImage = builder.destinationImage;
    }

    /**
     * <p>
     * Specifies the URI of the source image in the upstream registry.
     * </p>
     * 
     * @return Specifies the URI of the source image in the upstream registry.
     */
    public final String sourceImage() {
        return sourceImage;
    }

    /**
     * <p>
     * Specifies the URI of the corresponding image in the private ECR registry.
     * </p>
     * 
     * @return Specifies the URI of the corresponding image in the private ECR registry.
     */
    public final String destinationImage() {
        return destinationImage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceImage());
        hashCode = 31 * hashCode + Objects.hashCode(destinationImage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageMapping)) {
            return false;
        }
        ImageMapping other = (ImageMapping) obj;
        return Objects.equals(sourceImage(), other.sourceImage()) && Objects.equals(destinationImage(), other.destinationImage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageMapping").add("SourceImage", sourceImage()).add("DestinationImage", destinationImage())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceImage":
            return Optional.ofNullable(clazz.cast(sourceImage()));
        case "destinationImage":
            return Optional.ofNullable(clazz.cast(destinationImage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceImage", SOURCE_IMAGE_FIELD);
        map.put("destinationImage", DESTINATION_IMAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageMapping, T> g) {
        return obj -> g.apply((ImageMapping) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageMapping> {
        /**
         * <p>
         * Specifies the URI of the source image in the upstream registry.
         * </p>
         * 
         * @param sourceImage
         *        Specifies the URI of the source image in the upstream registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceImage(String sourceImage);

        /**
         * <p>
         * Specifies the URI of the corresponding image in the private ECR registry.
         * </p>
         * 
         * @param destinationImage
         *        Specifies the URI of the corresponding image in the private ECR registry.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationImage(String destinationImage);
    }

    static final class BuilderImpl implements Builder {
        private String sourceImage;

        private String destinationImage;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageMapping model) {
            sourceImage(model.sourceImage);
            destinationImage(model.destinationImage);
        }

        public final String getSourceImage() {
            return sourceImage;
        }

        public final void setSourceImage(String sourceImage) {
            this.sourceImage = sourceImage;
        }

        @Override
        public final Builder sourceImage(String sourceImage) {
            this.sourceImage = sourceImage;
            return this;
        }

        public final String getDestinationImage() {
            return destinationImage;
        }

        public final void setDestinationImage(String destinationImage) {
            this.destinationImage = destinationImage;
        }

        @Override
        public final Builder destinationImage(String destinationImage) {
            this.destinationImage = destinationImage;
            return this;
        }

        @Override
        public ImageMapping build() {
            return new ImageMapping(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
