/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class ImageMappingsListCopier {
    static List<ImageMapping> copy(Collection<? extends ImageMapping> imageMappingsListParam) {
        List<ImageMapping> list;
        if (imageMappingsListParam == null || imageMappingsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ImageMapping> modifiableList = new ArrayList<>(imageMappingsListParam.size());
            imageMappingsListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ImageMapping> copyFromBuilder(Collection<? extends ImageMapping.Builder> imageMappingsListParam) {
        List<ImageMapping> list;
        if (imageMappingsListParam == null || imageMappingsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ImageMapping> modifiableList = new ArrayList<>(imageMappingsListParam.size());
            imageMappingsListParam.forEach(entry -> {
                ImageMapping member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<ImageMapping.Builder> copyToBuilder(Collection<? extends ImageMapping> imageMappingsListParam) {
        List<ImageMapping.Builder> list;
        if (imageMappingsListParam == null || imageMappingsListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<ImageMapping.Builder> modifiableList = new ArrayList<>(imageMappingsListParam.size());
            imageMappingsListParam.forEach(entry -> {
                ImageMapping.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
