/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVariantImportJobsRequest extends OmicsRequest implements
        ToCopyableBuilder<ListVariantImportJobsRequest.Builder, ListVariantImportJobsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListVariantImportJobsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<List<String>> IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ids")
            .getter(getter(ListVariantImportJobsRequest::ids))
            .setter(setter(Builder::ids))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ids").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListVariantImportJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<ListVariantImportJobsFilter> FILTER_FIELD = SdkField
            .<ListVariantImportJobsFilter> builder(MarshallingType.SDK_POJO).memberName("filter")
            .getter(getter(ListVariantImportJobsRequest::filter)).setter(setter(Builder::filter))
            .constructor(ListVariantImportJobsFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, IDS_FIELD,
            NEXT_TOKEN_FIELD, FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Integer maxResults;

    private final List<String> ids;

    private final String nextToken;

    private final ListVariantImportJobsFilter filter;

    private ListVariantImportJobsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.ids = builder.ids;
        this.nextToken = builder.nextToken;
        this.filter = builder.filter;
    }

    /**
     * <p>
     * The maximum number of import jobs to return in one page of results.
     * </p>
     * 
     * @return The maximum number of import jobs to return in one page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * For responses, this returns true if the service returned a value for the Ids property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasIds() {
        return ids != null && !(ids instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of job IDs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIds} method.
     * </p>
     * 
     * @return A list of job IDs.
     */
    public final List<String> ids() {
        return ids;
    }

    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token from a previous request to retrieve the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A filter to apply to the list.
     * </p>
     * 
     * @return A filter to apply to the list.
     */
    public final ListVariantImportJobsFilter filter() {
        return filter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(hasIds() ? ids() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVariantImportJobsRequest)) {
            return false;
        }
        ListVariantImportJobsRequest other = (ListVariantImportJobsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && hasIds() == other.hasIds()
                && Objects.equals(ids(), other.ids()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(filter(), other.filter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVariantImportJobsRequest").add("MaxResults", maxResults())
                .add("Ids", hasIds() ? ids() : null).add("NextToken", nextToken()).add("Filter", filter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "ids":
            return Optional.ofNullable(clazz.cast(ids()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("ids", IDS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("filter", FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVariantImportJobsRequest, T> g) {
        return obj -> g.apply((ListVariantImportJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListVariantImportJobsRequest> {
        /**
         * <p>
         * The maximum number of import jobs to return in one page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of import jobs to return in one page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A list of job IDs.
         * </p>
         * 
         * @param ids
         *        A list of job IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ids(Collection<String> ids);

        /**
         * <p>
         * A list of job IDs.
         * </p>
         * 
         * @param ids
         *        A list of job IDs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ids(String... ids);

        /**
         * <p>
         * Specify the pagination token from a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specify the pagination token from a previous request to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A filter to apply to the list.
         * </p>
         * 
         * @param filter
         *        A filter to apply to the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(ListVariantImportJobsFilter filter);

        /**
         * <p>
         * A filter to apply to the list.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListVariantImportJobsFilter.Builder}
         * avoiding the need to create one manually via {@link ListVariantImportJobsFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListVariantImportJobsFilter.Builder#build()} is called
         * immediately and its result is passed to {@link #filter(ListVariantImportJobsFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link ListVariantImportJobsFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(ListVariantImportJobsFilter)
         */
        default Builder filter(Consumer<ListVariantImportJobsFilter.Builder> filter) {
            return filter(ListVariantImportJobsFilter.builder().applyMutation(filter).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private List<String> ids = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private ListVariantImportJobsFilter filter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListVariantImportJobsRequest model) {
            super(model);
            maxResults(model.maxResults);
            ids(model.ids);
            nextToken(model.nextToken);
            filter(model.filter);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final Collection<String> getIds() {
            if (ids instanceof SdkAutoConstructList) {
                return null;
            }
            return ids;
        }

        public final void setIds(Collection<String> ids) {
            this.ids = ListVariantImportJobsRequestIdsListCopier.copy(ids);
        }

        @Override
        public final Builder ids(Collection<String> ids) {
            this.ids = ListVariantImportJobsRequestIdsListCopier.copy(ids);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ids(String... ids) {
            ids(Arrays.asList(ids));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final ListVariantImportJobsFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(ListVariantImportJobsFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(ListVariantImportJobsFilter filter) {
            this.filter = filter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListVariantImportJobsRequest build() {
            return new ListVariantImportJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
