/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListWorkflowVersionsRequest extends OmicsRequest implements
        ToCopyableBuilder<ListWorkflowVersionsRequest.Builder, ListWorkflowVersionsRequest> {
    private static final SdkField<String> WORKFLOW_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowId").getter(getter(ListWorkflowVersionsRequest::workflowId)).setter(setter(Builder::workflowId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workflowId").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ListWorkflowVersionsRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").build()).build();

    private static final SdkField<String> WORKFLOW_OWNER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowOwnerId").getter(getter(ListWorkflowVersionsRequest::workflowOwnerId))
            .setter(setter(Builder::workflowOwnerId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("workflowOwnerId").build())
            .build();

    private static final SdkField<String> STARTING_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("startingToken").getter(getter(ListWorkflowVersionsRequest::startingToken))
            .setter(setter(Builder::startingToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("startingToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListWorkflowVersionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_ID_FIELD, TYPE_FIELD,
            WORKFLOW_OWNER_ID_FIELD, STARTING_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String workflowId;

    private final String type;

    private final String workflowOwnerId;

    private final String startingToken;

    private final Integer maxResults;

    private ListWorkflowVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.workflowId = builder.workflowId;
        this.type = builder.type;
        this.workflowOwnerId = builder.workflowOwnerId;
        this.startingToken = builder.startingToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The workflow's ID. The <code>workflowId</code> is not the UUID.
     * </p>
     * 
     * @return The workflow's ID. The <code>workflowId</code> is not the UUID.
     */
    public final String workflowId() {
        return workflowId;
    }

    /**
     * <p>
     * The workflow type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The workflow type.
     * @see WorkflowType
     */
    public final WorkflowType type() {
        return WorkflowType.fromValue(type);
    }

    /**
     * <p>
     * The workflow type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link WorkflowType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The workflow type.
     * @see WorkflowType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The 12-digit account ID of the workflow owner. The workflow owner ID can be retrieved using the
     * <code>GetShare</code> API operation. If you are the workflow owner, you do not need to include this ID.
     * </p>
     * 
     * @return The 12-digit account ID of the workflow owner. The workflow owner ID can be retrieved using the
     *         <code>GetShare</code> API operation. If you are the workflow owner, you do not need to include this ID.
     */
    public final String workflowOwnerId() {
        return workflowOwnerId;
    }

    /**
     * <p>
     * Specify the pagination token from a previous request to retrieve the next page of results.
     * </p>
     * 
     * @return Specify the pagination token from a previous request to retrieve the next page of results.
     */
    public final String startingToken() {
        return startingToken;
    }

    /**
     * <p>
     * The maximum number of workflows to return in one page of results.
     * </p>
     * 
     * @return The maximum number of workflows to return in one page of results.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(workflowId());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workflowOwnerId());
        hashCode = 31 * hashCode + Objects.hashCode(startingToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListWorkflowVersionsRequest)) {
            return false;
        }
        ListWorkflowVersionsRequest other = (ListWorkflowVersionsRequest) obj;
        return Objects.equals(workflowId(), other.workflowId()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(workflowOwnerId(), other.workflowOwnerId())
                && Objects.equals(startingToken(), other.startingToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListWorkflowVersionsRequest").add("WorkflowId", workflowId()).add("Type", typeAsString())
                .add("WorkflowOwnerId", workflowOwnerId()).add("StartingToken", startingToken()).add("MaxResults", maxResults())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "workflowId":
            return Optional.ofNullable(clazz.cast(workflowId()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "workflowOwnerId":
            return Optional.ofNullable(clazz.cast(workflowOwnerId()));
        case "startingToken":
            return Optional.ofNullable(clazz.cast(startingToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("workflowId", WORKFLOW_ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("workflowOwnerId", WORKFLOW_OWNER_ID_FIELD);
        map.put("startingToken", STARTING_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListWorkflowVersionsRequest, T> g) {
        return obj -> g.apply((ListWorkflowVersionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OmicsRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListWorkflowVersionsRequest> {
        /**
         * <p>
         * The workflow's ID. The <code>workflowId</code> is not the UUID.
         * </p>
         * 
         * @param workflowId
         *        The workflow's ID. The <code>workflowId</code> is not the UUID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowId(String workflowId);

        /**
         * <p>
         * The workflow type.
         * </p>
         * 
         * @param type
         *        The workflow type.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder type(String type);

        /**
         * <p>
         * The workflow type.
         * </p>
         * 
         * @param type
         *        The workflow type.
         * @see WorkflowType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowType
         */
        Builder type(WorkflowType type);

        /**
         * <p>
         * The 12-digit account ID of the workflow owner. The workflow owner ID can be retrieved using the
         * <code>GetShare</code> API operation. If you are the workflow owner, you do not need to include this ID.
         * </p>
         * 
         * @param workflowOwnerId
         *        The 12-digit account ID of the workflow owner. The workflow owner ID can be retrieved using the
         *        <code>GetShare</code> API operation. If you are the workflow owner, you do not need to include this
         *        ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowOwnerId(String workflowOwnerId);

        /**
         * <p>
         * Specify the pagination token from a previous request to retrieve the next page of results.
         * </p>
         * 
         * @param startingToken
         *        Specify the pagination token from a previous request to retrieve the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startingToken(String startingToken);

        /**
         * <p>
         * The maximum number of workflows to return in one page of results.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of workflows to return in one page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OmicsRequest.BuilderImpl implements Builder {
        private String workflowId;

        private String type;

        private String workflowOwnerId;

        private String startingToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListWorkflowVersionsRequest model) {
            super(model);
            workflowId(model.workflowId);
            type(model.type);
            workflowOwnerId(model.workflowOwnerId);
            startingToken(model.startingToken);
            maxResults(model.maxResults);
        }

        public final String getWorkflowId() {
            return workflowId;
        }

        public final void setWorkflowId(String workflowId) {
            this.workflowId = workflowId;
        }

        @Override
        public final Builder workflowId(String workflowId) {
            this.workflowId = workflowId;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(WorkflowType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getWorkflowOwnerId() {
            return workflowOwnerId;
        }

        public final void setWorkflowOwnerId(String workflowOwnerId) {
            this.workflowOwnerId = workflowOwnerId;
        }

        @Override
        public final Builder workflowOwnerId(String workflowOwnerId) {
            this.workflowOwnerId = workflowOwnerId;
            return this;
        }

        public final String getStartingToken() {
            return startingToken;
        }

        public final void setStartingToken(String startingToken) {
            this.startingToken = startingToken;
        }

        @Override
        public final Builder startingToken(String startingToken) {
            this.startingToken = startingToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListWorkflowVersionsRequest build() {
            return new ListWorkflowVersionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
