/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Settings for a store.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StoreOptions implements SdkPojo, Serializable, ToCopyableBuilder<StoreOptions.Builder, StoreOptions> {
    private static final SdkField<TsvStoreOptions> TSV_STORE_OPTIONS_FIELD = SdkField
            .<TsvStoreOptions> builder(MarshallingType.SDK_POJO).memberName("tsvStoreOptions")
            .getter(getter(StoreOptions::tsvStoreOptions)).setter(setter(Builder::tsvStoreOptions))
            .constructor(TsvStoreOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tsvStoreOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TSV_STORE_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TsvStoreOptions tsvStoreOptions;

    private final Type type;

    private StoreOptions(BuilderImpl builder) {
        this.tsvStoreOptions = builder.tsvStoreOptions;
        this.type = builder.type;
    }

    /**
     * <p>
     * File settings for a TSV store.
     * </p>
     * 
     * @return File settings for a TSV store.
     */
    public final TsvStoreOptions tsvStoreOptions() {
        return tsvStoreOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tsvStoreOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StoreOptions)) {
            return false;
        }
        StoreOptions other = (StoreOptions) obj;
        return Objects.equals(tsvStoreOptions(), other.tsvStoreOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StoreOptions").add("TsvStoreOptions", tsvStoreOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tsvStoreOptions":
            return Optional.ofNullable(clazz.cast(tsvStoreOptions()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #tsvStoreOptions()} initialized to the given value.
     *
     * <p>
     * File settings for a TSV store.
     * </p>
     * 
     * @param tsvStoreOptions
     *        File settings for a TSV store.
     */
    public static StoreOptions fromTsvStoreOptions(TsvStoreOptions tsvStoreOptions) {
        return builder().tsvStoreOptions(tsvStoreOptions).build();
    }

    /**
     * Create an instance of this class with {@link #tsvStoreOptions()} initialized to the given value.
     *
     * <p>
     * File settings for a TSV store.
     * </p>
     * 
     * @param tsvStoreOptions
     *        File settings for a TSV store.
     */
    public static StoreOptions fromTsvStoreOptions(Consumer<TsvStoreOptions.Builder> tsvStoreOptions) {
        TsvStoreOptions.Builder builder = TsvStoreOptions.builder();
        tsvStoreOptions.accept(builder);
        return fromTsvStoreOptions(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tsvStoreOptions", TSV_STORE_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StoreOptions, T> g) {
        return obj -> g.apply((StoreOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StoreOptions> {
        /**
         * <p>
         * File settings for a TSV store.
         * </p>
         * 
         * @param tsvStoreOptions
         *        File settings for a TSV store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tsvStoreOptions(TsvStoreOptions tsvStoreOptions);

        /**
         * <p>
         * File settings for a TSV store.
         * </p>
         * This is a convenience method that creates an instance of the {@link TsvStoreOptions.Builder} avoiding the
         * need to create one manually via {@link TsvStoreOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TsvStoreOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #tsvStoreOptions(TsvStoreOptions)}.
         * 
         * @param tsvStoreOptions
         *        a consumer that will call methods on {@link TsvStoreOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tsvStoreOptions(TsvStoreOptions)
         */
        default Builder tsvStoreOptions(Consumer<TsvStoreOptions.Builder> tsvStoreOptions) {
            return tsvStoreOptions(TsvStoreOptions.builder().applyMutation(tsvStoreOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private TsvStoreOptions tsvStoreOptions;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(StoreOptions model) {
            tsvStoreOptions(model.tsvStoreOptions);
        }

        public final TsvStoreOptions.Builder getTsvStoreOptions() {
            return tsvStoreOptions != null ? tsvStoreOptions.toBuilder() : null;
        }

        public final void setTsvStoreOptions(TsvStoreOptions.BuilderImpl tsvStoreOptions) {
            Object oldValue = this.tsvStoreOptions;
            this.tsvStoreOptions = tsvStoreOptions != null ? tsvStoreOptions.build() : null;
            handleUnionValueChange(Type.TSV_STORE_OPTIONS, oldValue, this.tsvStoreOptions);
        }

        @Override
        public final Builder tsvStoreOptions(TsvStoreOptions tsvStoreOptions) {
            Object oldValue = this.tsvStoreOptions;
            this.tsvStoreOptions = tsvStoreOptions;
            handleUnionValueChange(Type.TSV_STORE_OPTIONS, oldValue, this.tsvStoreOptions);
            return this;
        }

        @Override
        public StoreOptions build() {
            return new StoreOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see StoreOptions#type()
     */
    public enum Type {
        TSV_STORE_OPTIONS,

        UNKNOWN_TO_SDK_VERSION
    }
}
