/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <p>
 * Amazon Web Services HealthOmics is a service that helps users such as bioinformaticians, researchers, and scientists
 * to store, query, analyze, and generate insights from genomics and other biological data. It simplifies and
 * accelerates the process of storing and analyzing genomic information for Amazon Web Services.
 * </p>
 * <p>
 * For an introduction to the service, see <a
 * href="https://docs.aws.amazon.com/omics/latest/dev/what-is-healthomics.html">What is Amazon Web Services
 * HealthOmics?</a> in the <i>Amazon Web Services HealthOmics User Guide</i>.
 * </p>
 */
package software.amazon.awssdk.services.omics;