/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.omics.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.omics.OmicsClient;
import software.amazon.awssdk.services.omics.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.omics.model.GetAnnotationImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreResponse;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreVersionRequest;
import software.amazon.awssdk.services.omics.model.GetAnnotationStoreVersionResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetActivationJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetActivationJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetExportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetExportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReadSetImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReadSetImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetReferenceImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetReferenceImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetRunRequest;
import software.amazon.awssdk.services.omics.model.GetRunResponse;
import software.amazon.awssdk.services.omics.model.GetRunTaskRequest;
import software.amazon.awssdk.services.omics.model.GetRunTaskResponse;
import software.amazon.awssdk.services.omics.model.GetVariantImportJobRequest;
import software.amazon.awssdk.services.omics.model.GetVariantImportJobResponse;
import software.amazon.awssdk.services.omics.model.GetVariantStoreRequest;
import software.amazon.awssdk.services.omics.model.GetVariantStoreResponse;
import software.amazon.awssdk.services.omics.model.GetWorkflowRequest;
import software.amazon.awssdk.services.omics.model.GetWorkflowResponse;
import software.amazon.awssdk.services.omics.model.GetWorkflowVersionRequest;
import software.amazon.awssdk.services.omics.model.GetWorkflowVersionResponse;
import software.amazon.awssdk.services.omics.model.OmicsRequest;
import software.amazon.awssdk.services.omics.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
@ThreadSafe
final class DefaultOmicsWaiter implements OmicsWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute<>(SdkAutoCloseable.class);

    private final OmicsClient client;

    private final AttributeMap managedResources;

    private final Waiter<GetAnnotationImportJobResponse> annotationImportJobCreatedWaiter;

    private final Waiter<GetAnnotationStoreResponse> annotationStoreCreatedWaiter;

    private final Waiter<GetAnnotationStoreResponse> annotationStoreDeletedWaiter;

    private final Waiter<GetAnnotationStoreVersionResponse> annotationStoreVersionCreatedWaiter;

    private final Waiter<GetAnnotationStoreVersionResponse> annotationStoreVersionDeletedWaiter;

    private final Waiter<GetReadSetActivationJobResponse> readSetActivationJobCompletedWaiter;

    private final Waiter<GetReadSetExportJobResponse> readSetExportJobCompletedWaiter;

    private final Waiter<GetReadSetImportJobResponse> readSetImportJobCompletedWaiter;

    private final Waiter<GetReferenceImportJobResponse> referenceImportJobCompletedWaiter;

    private final Waiter<GetRunResponse> runCompletedWaiter;

    private final Waiter<GetRunResponse> runRunningWaiter;

    private final Waiter<GetRunTaskResponse> taskCompletedWaiter;

    private final Waiter<GetRunTaskResponse> taskRunningWaiter;

    private final Waiter<GetVariantImportJobResponse> variantImportJobCreatedWaiter;

    private final Waiter<GetVariantStoreResponse> variantStoreCreatedWaiter;

    private final Waiter<GetVariantStoreResponse> variantStoreDeletedWaiter;

    private final Waiter<GetWorkflowResponse> workflowActiveWaiter;

    private final Waiter<GetWorkflowVersionResponse> workflowVersionActiveWaiter;

    private DefaultOmicsWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = OmicsClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, this.client);
        } else {
            this.client = builder.client;
        }
        managedResources = attributeMapBuilder.build();
        this.annotationImportJobCreatedWaiter = Waiter.builder(GetAnnotationImportJobResponse.class)
                .acceptors(annotationImportJobCreatedWaiterAcceptors())
                .overrideConfiguration(annotationImportJobCreatedWaiterConfig(builder.overrideConfiguration)).build();
        this.annotationStoreCreatedWaiter = Waiter.builder(GetAnnotationStoreResponse.class)
                .acceptors(annotationStoreCreatedWaiterAcceptors())
                .overrideConfiguration(annotationStoreCreatedWaiterConfig(builder.overrideConfiguration)).build();
        this.annotationStoreDeletedWaiter = Waiter.builder(GetAnnotationStoreResponse.class)
                .acceptors(annotationStoreDeletedWaiterAcceptors())
                .overrideConfiguration(annotationStoreDeletedWaiterConfig(builder.overrideConfiguration)).build();
        this.annotationStoreVersionCreatedWaiter = Waiter.builder(GetAnnotationStoreVersionResponse.class)
                .acceptors(annotationStoreVersionCreatedWaiterAcceptors())
                .overrideConfiguration(annotationStoreVersionCreatedWaiterConfig(builder.overrideConfiguration)).build();
        this.annotationStoreVersionDeletedWaiter = Waiter.builder(GetAnnotationStoreVersionResponse.class)
                .acceptors(annotationStoreVersionDeletedWaiterAcceptors())
                .overrideConfiguration(annotationStoreVersionDeletedWaiterConfig(builder.overrideConfiguration)).build();
        this.readSetActivationJobCompletedWaiter = Waiter.builder(GetReadSetActivationJobResponse.class)
                .acceptors(readSetActivationJobCompletedWaiterAcceptors())
                .overrideConfiguration(readSetActivationJobCompletedWaiterConfig(builder.overrideConfiguration)).build();
        this.readSetExportJobCompletedWaiter = Waiter.builder(GetReadSetExportJobResponse.class)
                .acceptors(readSetExportJobCompletedWaiterAcceptors())
                .overrideConfiguration(readSetExportJobCompletedWaiterConfig(builder.overrideConfiguration)).build();
        this.readSetImportJobCompletedWaiter = Waiter.builder(GetReadSetImportJobResponse.class)
                .acceptors(readSetImportJobCompletedWaiterAcceptors())
                .overrideConfiguration(readSetImportJobCompletedWaiterConfig(builder.overrideConfiguration)).build();
        this.referenceImportJobCompletedWaiter = Waiter.builder(GetReferenceImportJobResponse.class)
                .acceptors(referenceImportJobCompletedWaiterAcceptors())
                .overrideConfiguration(referenceImportJobCompletedWaiterConfig(builder.overrideConfiguration)).build();
        this.runCompletedWaiter = Waiter.builder(GetRunResponse.class).acceptors(runCompletedWaiterAcceptors())
                .overrideConfiguration(runCompletedWaiterConfig(builder.overrideConfiguration)).build();
        this.runRunningWaiter = Waiter.builder(GetRunResponse.class).acceptors(runRunningWaiterAcceptors())
                .overrideConfiguration(runRunningWaiterConfig(builder.overrideConfiguration)).build();
        this.taskCompletedWaiter = Waiter.builder(GetRunTaskResponse.class).acceptors(taskCompletedWaiterAcceptors())
                .overrideConfiguration(taskCompletedWaiterConfig(builder.overrideConfiguration)).build();
        this.taskRunningWaiter = Waiter.builder(GetRunTaskResponse.class).acceptors(taskRunningWaiterAcceptors())
                .overrideConfiguration(taskRunningWaiterConfig(builder.overrideConfiguration)).build();
        this.variantImportJobCreatedWaiter = Waiter.builder(GetVariantImportJobResponse.class)
                .acceptors(variantImportJobCreatedWaiterAcceptors())
                .overrideConfiguration(variantImportJobCreatedWaiterConfig(builder.overrideConfiguration)).build();
        this.variantStoreCreatedWaiter = Waiter.builder(GetVariantStoreResponse.class)
                .acceptors(variantStoreCreatedWaiterAcceptors())
                .overrideConfiguration(variantStoreCreatedWaiterConfig(builder.overrideConfiguration)).build();
        this.variantStoreDeletedWaiter = Waiter.builder(GetVariantStoreResponse.class)
                .acceptors(variantStoreDeletedWaiterAcceptors())
                .overrideConfiguration(variantStoreDeletedWaiterConfig(builder.overrideConfiguration)).build();
        this.workflowActiveWaiter = Waiter.builder(GetWorkflowResponse.class).acceptors(workflowActiveWaiterAcceptors())
                .overrideConfiguration(workflowActiveWaiterConfig(builder.overrideConfiguration)).build();
        this.workflowVersionActiveWaiter = Waiter.builder(GetWorkflowVersionResponse.class)
                .acceptors(workflowVersionActiveWaiterAcceptors())
                .overrideConfiguration(workflowVersionActiveWaiterConfig(builder.overrideConfiguration)).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException) error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<GetAnnotationImportJobResponse> waitUntilAnnotationImportJobCreated(
            GetAnnotationImportJobRequest getAnnotationImportJobRequest) {
        return annotationImportJobCreatedWaiter.run(() -> client
                .getAnnotationImportJob(applyWaitersUserAgent(getAnnotationImportJobRequest)));
    }

    @Override
    public WaiterResponse<GetAnnotationImportJobResponse> waitUntilAnnotationImportJobCreated(
            GetAnnotationImportJobRequest getAnnotationImportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return annotationImportJobCreatedWaiter.run(
                () -> client.getAnnotationImportJob(applyWaitersUserAgent(getAnnotationImportJobRequest)),
                annotationImportJobCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetAnnotationStoreResponse> waitUntilAnnotationStoreCreated(
            GetAnnotationStoreRequest getAnnotationStoreRequest) {
        return annotationStoreCreatedWaiter
                .run(() -> client.getAnnotationStore(applyWaitersUserAgent(getAnnotationStoreRequest)));
    }

    @Override
    public WaiterResponse<GetAnnotationStoreResponse> waitUntilAnnotationStoreCreated(
            GetAnnotationStoreRequest getAnnotationStoreRequest, WaiterOverrideConfiguration overrideConfig) {
        return annotationStoreCreatedWaiter.run(
                () -> client.getAnnotationStore(applyWaitersUserAgent(getAnnotationStoreRequest)),
                annotationStoreCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetAnnotationStoreResponse> waitUntilAnnotationStoreDeleted(
            GetAnnotationStoreRequest getAnnotationStoreRequest) {
        return annotationStoreDeletedWaiter
                .run(() -> client.getAnnotationStore(applyWaitersUserAgent(getAnnotationStoreRequest)));
    }

    @Override
    public WaiterResponse<GetAnnotationStoreResponse> waitUntilAnnotationStoreDeleted(
            GetAnnotationStoreRequest getAnnotationStoreRequest, WaiterOverrideConfiguration overrideConfig) {
        return annotationStoreDeletedWaiter.run(
                () -> client.getAnnotationStore(applyWaitersUserAgent(getAnnotationStoreRequest)),
                annotationStoreDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetAnnotationStoreVersionResponse> waitUntilAnnotationStoreVersionCreated(
            GetAnnotationStoreVersionRequest getAnnotationStoreVersionRequest) {
        return annotationStoreVersionCreatedWaiter.run(() -> client
                .getAnnotationStoreVersion(applyWaitersUserAgent(getAnnotationStoreVersionRequest)));
    }

    @Override
    public WaiterResponse<GetAnnotationStoreVersionResponse> waitUntilAnnotationStoreVersionCreated(
            GetAnnotationStoreVersionRequest getAnnotationStoreVersionRequest, WaiterOverrideConfiguration overrideConfig) {
        return annotationStoreVersionCreatedWaiter.run(
                () -> client.getAnnotationStoreVersion(applyWaitersUserAgent(getAnnotationStoreVersionRequest)),
                annotationStoreVersionCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetAnnotationStoreVersionResponse> waitUntilAnnotationStoreVersionDeleted(
            GetAnnotationStoreVersionRequest getAnnotationStoreVersionRequest) {
        return annotationStoreVersionDeletedWaiter.run(() -> client
                .getAnnotationStoreVersion(applyWaitersUserAgent(getAnnotationStoreVersionRequest)));
    }

    @Override
    public WaiterResponse<GetAnnotationStoreVersionResponse> waitUntilAnnotationStoreVersionDeleted(
            GetAnnotationStoreVersionRequest getAnnotationStoreVersionRequest, WaiterOverrideConfiguration overrideConfig) {
        return annotationStoreVersionDeletedWaiter.run(
                () -> client.getAnnotationStoreVersion(applyWaitersUserAgent(getAnnotationStoreVersionRequest)),
                annotationStoreVersionDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetReadSetActivationJobResponse> waitUntilReadSetActivationJobCompleted(
            GetReadSetActivationJobRequest getReadSetActivationJobRequest) {
        return readSetActivationJobCompletedWaiter.run(() -> client
                .getReadSetActivationJob(applyWaitersUserAgent(getReadSetActivationJobRequest)));
    }

    @Override
    public WaiterResponse<GetReadSetActivationJobResponse> waitUntilReadSetActivationJobCompleted(
            GetReadSetActivationJobRequest getReadSetActivationJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return readSetActivationJobCompletedWaiter.run(
                () -> client.getReadSetActivationJob(applyWaitersUserAgent(getReadSetActivationJobRequest)),
                readSetActivationJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetReadSetExportJobResponse> waitUntilReadSetExportJobCompleted(
            GetReadSetExportJobRequest getReadSetExportJobRequest) {
        return readSetExportJobCompletedWaiter.run(() -> client
                .getReadSetExportJob(applyWaitersUserAgent(getReadSetExportJobRequest)));
    }

    @Override
    public WaiterResponse<GetReadSetExportJobResponse> waitUntilReadSetExportJobCompleted(
            GetReadSetExportJobRequest getReadSetExportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return readSetExportJobCompletedWaiter.run(
                () -> client.getReadSetExportJob(applyWaitersUserAgent(getReadSetExportJobRequest)),
                readSetExportJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetReadSetImportJobResponse> waitUntilReadSetImportJobCompleted(
            GetReadSetImportJobRequest getReadSetImportJobRequest) {
        return readSetImportJobCompletedWaiter.run(() -> client
                .getReadSetImportJob(applyWaitersUserAgent(getReadSetImportJobRequest)));
    }

    @Override
    public WaiterResponse<GetReadSetImportJobResponse> waitUntilReadSetImportJobCompleted(
            GetReadSetImportJobRequest getReadSetImportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return readSetImportJobCompletedWaiter.run(
                () -> client.getReadSetImportJob(applyWaitersUserAgent(getReadSetImportJobRequest)),
                readSetImportJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetReferenceImportJobResponse> waitUntilReferenceImportJobCompleted(
            GetReferenceImportJobRequest getReferenceImportJobRequest) {
        return referenceImportJobCompletedWaiter.run(() -> client
                .getReferenceImportJob(applyWaitersUserAgent(getReferenceImportJobRequest)));
    }

    @Override
    public WaiterResponse<GetReferenceImportJobResponse> waitUntilReferenceImportJobCompleted(
            GetReferenceImportJobRequest getReferenceImportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return referenceImportJobCompletedWaiter.run(
                () -> client.getReferenceImportJob(applyWaitersUserAgent(getReferenceImportJobRequest)),
                referenceImportJobCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetRunResponse> waitUntilRunCompleted(GetRunRequest getRunRequest) {
        return runCompletedWaiter.run(() -> client.getRun(applyWaitersUserAgent(getRunRequest)));
    }

    @Override
    public WaiterResponse<GetRunResponse> waitUntilRunCompleted(GetRunRequest getRunRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return runCompletedWaiter.run(() -> client.getRun(applyWaitersUserAgent(getRunRequest)),
                runCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetRunResponse> waitUntilRunRunning(GetRunRequest getRunRequest) {
        return runRunningWaiter.run(() -> client.getRun(applyWaitersUserAgent(getRunRequest)));
    }

    @Override
    public WaiterResponse<GetRunResponse> waitUntilRunRunning(GetRunRequest getRunRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return runRunningWaiter.run(() -> client.getRun(applyWaitersUserAgent(getRunRequest)),
                runRunningWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetRunTaskResponse> waitUntilTaskCompleted(GetRunTaskRequest getRunTaskRequest) {
        return taskCompletedWaiter.run(() -> client.getRunTask(applyWaitersUserAgent(getRunTaskRequest)));
    }

    @Override
    public WaiterResponse<GetRunTaskResponse> waitUntilTaskCompleted(GetRunTaskRequest getRunTaskRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return taskCompletedWaiter.run(() -> client.getRunTask(applyWaitersUserAgent(getRunTaskRequest)),
                taskCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetRunTaskResponse> waitUntilTaskRunning(GetRunTaskRequest getRunTaskRequest) {
        return taskRunningWaiter.run(() -> client.getRunTask(applyWaitersUserAgent(getRunTaskRequest)));
    }

    @Override
    public WaiterResponse<GetRunTaskResponse> waitUntilTaskRunning(GetRunTaskRequest getRunTaskRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return taskRunningWaiter.run(() -> client.getRunTask(applyWaitersUserAgent(getRunTaskRequest)),
                taskRunningWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetVariantImportJobResponse> waitUntilVariantImportJobCreated(
            GetVariantImportJobRequest getVariantImportJobRequest) {
        return variantImportJobCreatedWaiter.run(() -> client
                .getVariantImportJob(applyWaitersUserAgent(getVariantImportJobRequest)));
    }

    @Override
    public WaiterResponse<GetVariantImportJobResponse> waitUntilVariantImportJobCreated(
            GetVariantImportJobRequest getVariantImportJobRequest, WaiterOverrideConfiguration overrideConfig) {
        return variantImportJobCreatedWaiter.run(
                () -> client.getVariantImportJob(applyWaitersUserAgent(getVariantImportJobRequest)),
                variantImportJobCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetVariantStoreResponse> waitUntilVariantStoreCreated(GetVariantStoreRequest getVariantStoreRequest) {
        return variantStoreCreatedWaiter.run(() -> client.getVariantStore(applyWaitersUserAgent(getVariantStoreRequest)));
    }

    @Override
    public WaiterResponse<GetVariantStoreResponse> waitUntilVariantStoreCreated(GetVariantStoreRequest getVariantStoreRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return variantStoreCreatedWaiter.run(() -> client.getVariantStore(applyWaitersUserAgent(getVariantStoreRequest)),
                variantStoreCreatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetVariantStoreResponse> waitUntilVariantStoreDeleted(GetVariantStoreRequest getVariantStoreRequest) {
        return variantStoreDeletedWaiter.run(() -> client.getVariantStore(applyWaitersUserAgent(getVariantStoreRequest)));
    }

    @Override
    public WaiterResponse<GetVariantStoreResponse> waitUntilVariantStoreDeleted(GetVariantStoreRequest getVariantStoreRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return variantStoreDeletedWaiter.run(() -> client.getVariantStore(applyWaitersUserAgent(getVariantStoreRequest)),
                variantStoreDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetWorkflowResponse> waitUntilWorkflowActive(GetWorkflowRequest getWorkflowRequest) {
        return workflowActiveWaiter.run(() -> client.getWorkflow(applyWaitersUserAgent(getWorkflowRequest)));
    }

    @Override
    public WaiterResponse<GetWorkflowResponse> waitUntilWorkflowActive(GetWorkflowRequest getWorkflowRequest,
            WaiterOverrideConfiguration overrideConfig) {
        return workflowActiveWaiter.run(() -> client.getWorkflow(applyWaitersUserAgent(getWorkflowRequest)),
                workflowActiveWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetWorkflowVersionResponse> waitUntilWorkflowVersionActive(
            GetWorkflowVersionRequest getWorkflowVersionRequest) {
        return workflowVersionActiveWaiter.run(() -> client.getWorkflowVersion(applyWaitersUserAgent(getWorkflowVersionRequest)));
    }

    @Override
    public WaiterResponse<GetWorkflowVersionResponse> waitUntilWorkflowVersionActive(
            GetWorkflowVersionRequest getWorkflowVersionRequest, WaiterOverrideConfiguration overrideConfig) {
        return workflowVersionActiveWaiter.run(() -> client.getWorkflowVersion(applyWaitersUserAgent(getWorkflowVersionRequest)),
                workflowVersionActiveWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetAnnotationImportJobResponse>> annotationImportJobCreatedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetAnnotationImportJobResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetAnnotationStoreResponse>> annotationStoreCreatedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetAnnotationStoreResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetAnnotationStoreResponse>> annotationStoreDeletedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetAnnotationStoreResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(errorCode(error),
                "ResourceNotFoundException")));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETING");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetAnnotationStoreVersionResponse>> annotationStoreVersionCreatedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetAnnotationStoreVersionResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetAnnotationStoreVersionResponse>> annotationStoreVersionDeletedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetAnnotationStoreVersionResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(errorCode(error),
                "ResourceNotFoundException")));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETING");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetReadSetActivationJobResponse>> readSetActivationJobCompletedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetReadSetActivationJobResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "CANCELLED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=CANCELLED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "COMPLETED_WITH_FAILURES");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=COMPLETED_WITH_FAILURES) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetReadSetExportJobResponse>> readSetExportJobCompletedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetReadSetExportJobResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "CANCELLED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=CANCELLED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "COMPLETED_WITH_FAILURES");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=COMPLETED_WITH_FAILURES) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetReadSetImportJobResponse>> readSetImportJobCompletedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetReadSetImportJobResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "CANCELLED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=CANCELLED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "COMPLETED_WITH_FAILURES");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=COMPLETED_WITH_FAILURES) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetReferenceImportJobResponse>> referenceImportJobCompletedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetReferenceImportJobResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "CANCELLED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=CANCELLED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "COMPLETED_WITH_FAILURES");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=COMPLETED_WITH_FAILURES) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRunResponse>> runCompletedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetRunResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "PENDING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STARTING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "RUNNING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STOPPING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRunResponse>> runRunningWaiterAcceptors() {
        List<WaiterAcceptor<? super GetRunResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "RUNNING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "PENDING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STARTING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "CANCELLED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=CANCELLED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRunTaskResponse>> taskCompletedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetRunTaskResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "PENDING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STARTING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "RUNNING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STOPPING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetRunTaskResponse>> taskRunningWaiterAcceptors() {
        List<WaiterAcceptor<? super GetRunTaskResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "RUNNING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "PENDING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "STARTING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(
                response -> {
                    JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
                    return Objects.equals(input.field("status").value(), "CANCELLED");
                },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=CANCELLED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetVariantImportJobResponse>> variantImportJobCreatedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetVariantImportJobResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "SUBMITTED");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "IN_PROGRESS");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CANCELLED");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetVariantStoreResponse>> variantStoreCreatedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetVariantStoreResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetVariantStoreResponse>> variantStoreDeletedWaiterAcceptors() {
        List<WaiterAcceptor<? super GetVariantStoreResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETED");
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(errorCode(error),
                "ResourceNotFoundException")));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "DELETING");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetWorkflowResponse>> workflowActiveWaiterAcceptors() {
        List<WaiterAcceptor<? super GetWorkflowResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetWorkflowVersionResponse>> workflowVersionActiveWaiterAcceptors() {
        List<WaiterAcceptor<? super GetWorkflowVersionResponse>> result = new ArrayList<>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "CREATING");
        }));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "UPDATING");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        },
                "A waiter acceptor with the matcher (path) was matched on parameter (status=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration annotationImportJobCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration annotationStoreCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration annotationStoreDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration annotationStoreVersionCreatedWaiterConfig(
            WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration annotationStoreVersionDeletedWaiterConfig(
            WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration readSetActivationJobCompletedWaiterConfig(
            WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration readSetExportJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration readSetImportJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration referenceImportJobCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration runCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration runRunningWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration taskCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration taskRunningWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration variantImportJobCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration variantStoreCreatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration variantStoreDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(30)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration workflowActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(10);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(3)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration workflowVersionActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(10);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(
                BackoffStrategy.fixedDelayWithoutJitter(Duration.ofSeconds(3)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(maxAttempts).backoffStrategyV2(backoffStrategy)
                .waitTimeout(waitTimeout).build();
    }

    @Override
    public void close() {
        managedResources.close();
    }

    public static OmicsWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends OmicsRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    public static final class DefaultBuilder implements OmicsWaiter.Builder {
        private OmicsClient client;

        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public OmicsWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public OmicsWaiter.Builder client(OmicsClient client) {
            this.client = client;
            return this;
        }

        public OmicsWaiter build() {
            return new DefaultOmicsWaiter(this);
        }
    }
}
